/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.GenericTreeInfo;
import net.sf.saxon.om.Genre;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.NamespaceNode;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.PrependAxisIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.tree.tiny.AncestorIterator;
import net.sf.saxon.tree.tiny.TinyAttributeImpl;
import net.sf.saxon.tree.tiny.TinyDocumentImpl;
import net.sf.saxon.tree.tiny.TinyParentNodeImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.tree.tiny.a;
import net.sf.saxon.tree.tiny.b;
import net.sf.saxon.tree.tiny.c;
import net.sf.saxon.tree.tiny.d;
import net.sf.saxon.tree.tiny.e;
import net.sf.saxon.tree.tiny.f;
import net.sf.saxon.tree.tiny.g;
import net.sf.saxon.tree.tiny.h;
import net.sf.saxon.tree.tiny.i;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.UType;

public abstract class TinyNodeImpl
implements NodeInfo {
    protected TinyTree tree;
    protected int nodeNr;
    protected TinyNodeImpl parent = null;
    public static final char[] NODE_LETTER = new char[]{'x', 'e', 'a', 't', 'x', 'x', 'x', 'p', 'c', 'r', 'x', 'x', 'x', 'n'};

    @Override
    public Genre getGenre() {
        return Genre.NODE;
    }

    @Override
    public TreeInfo getTreeInfo() {
        return this.tree;
    }

    @Override
    public NodeInfo head() {
        return this;
    }

    @Override
    public UnfailingIterator<NodeInfo> iterate() {
        return SingletonIterator.makeIterator(this);
    }

    @Override
    public CharSequence getStringValueCS() {
        return this.getStringValue();
    }

    @Override
    public SchemaType getSchemaType() {
        return null;
    }

    @Override
    public int getColumnNumber() {
        return this.tree.getColumnNumber(this.nodeNr);
    }

    @Override
    public void setSystemId(String string) {
        this.tree.a(this.nodeNr, string);
    }

    protected void setParentNode(TinyNodeImpl tinyNodeImpl) {
        this.parent = tinyNodeImpl;
    }

    @Override
    public boolean isSameNodeInfo(NodeInfo nodeInfo) {
        return this == nodeInfo || nodeInfo instanceof TinyNodeImpl && this.tree == ((TinyNodeImpl)nodeInfo).tree && this.nodeNr == ((TinyNodeImpl)nodeInfo).nodeNr && this.getNodeKind() == nodeInfo.getNodeKind();
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof NodeInfo && this.isSameNodeInfo((NodeInfo)object);
    }

    @Override
    public int hashCode() {
        return (int)(this.tree.getDocumentNumber() & 0x3FFL) << 20 ^ this.nodeNr ^ this.getNodeKind() << 14;
    }

    @Override
    public String getSystemId() {
        return this.tree.getSystemId(this.nodeNr);
    }

    @Override
    public String getBaseURI() {
        return this.getParent().getBaseURI();
    }

    @Override
    public int getLineNumber() {
        return this.tree.getLineNumber(this.nodeNr);
    }

    @Override
    public Location saveLocation() {
        return this;
    }

    protected long getSequenceNumber() {
        return (long)this.nodeNr << 32;
    }

    @Override
    public final int compareOrder(NodeInfo nodeInfo) {
        long l2 = this.getSequenceNumber();
        if (nodeInfo instanceof TinyNodeImpl) {
            long l3 = ((TinyNodeImpl)nodeInfo).getSequenceNumber();
            return Long.compare(l2, l3);
        }
        return 0 - nodeInfo.compareOrder(this);
    }

    @Override
    public final boolean hasFingerprint() {
        return true;
    }

    @Override
    public int getFingerprint() {
        int n2 = this.tree.nameCode[this.nodeNr];
        if (n2 == -1) {
            return -1;
        }
        return n2 & 0xFFFFF;
    }

    @Override
    public String getPrefix() {
        int n2 = this.tree.nameCode[this.nodeNr];
        if (n2 < 0) {
            return "";
        }
        if (!NamePool.isPrefixed(n2)) {
            return "";
        }
        return this.tree.prefixPool.getPrefix(n2 >> 20);
    }

    @Override
    public String getURI() {
        int n2 = this.tree.nameCode[this.nodeNr];
        if (n2 < 0) {
            return "";
        }
        return this.tree.getNamePool().getURI(n2 & 0xFFFFF);
    }

    @Override
    public String getDisplayName() {
        int n2 = this.tree.nameCode[this.nodeNr];
        if (n2 < 0) {
            return "";
        }
        if (NamePool.isPrefixed(n2)) {
            return this.getPrefix() + ":" + this.getLocalPart();
        }
        return this.getLocalPart();
    }

    @Override
    public String getLocalPart() {
        int n2 = this.tree.nameCode[this.nodeNr];
        if (n2 < 0) {
            return "";
        }
        return this.tree.getNamePool().getLocalName(n2);
    }

    @Override
    public AxisIterator iterateAxis(byte by) {
        if (by == 3) {
            if (this.hasChildNodes()) {
                return new i(this.tree, this, null, true);
            }
            return EmptyIterator.OfNodes.THE_INSTANCE;
        }
        return this.iterateAxis(by, AnyNodeTest.getInstance());
    }

    @Override
    public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
        int n2 = this.getNodeKind();
        switch (by) {
            case 0: {
                return new AncestorIterator(this, nodeTest);
            }
            case 1: {
                AncestorIterator ancestorIterator = new AncestorIterator(this, nodeTest);
                if (nodeTest.matchesNode(this)) {
                    return new PrependAxisIterator(this, ancestorIterator);
                }
                return ancestorIterator;
            }
            case 2: {
                if (n2 != 1) {
                    return EmptyIterator.OfNodes.THE_INSTANCE;
                }
                if (this.tree.alpha[this.nodeNr] < 0) {
                    return EmptyIterator.OfNodes.THE_INSTANCE;
                }
                return new a(this.tree, this.nodeNr, nodeTest);
            }
            case 3: {
                if (this.hasChildNodes()) {
                    if (nodeTest instanceof NameTest && ((NameTest)nodeTest).getNodeKind() == 1) {
                        return new f(this.tree, this, nodeTest.getFingerprint());
                    }
                    return new i(this.tree, this, nodeTest, true);
                }
                return EmptyIterator.OfNodes.THE_INSTANCE;
            }
            case 4: {
                if (n2 == 9 && nodeTest instanceof NameTest && nodeTest.getPrimitiveType() == 1) {
                    return ((TinyDocumentImpl)this).a(nodeTest.getFingerprint());
                }
                if (this.hasChildNodes()) {
                    if (this.tree.externalNodes != null) {
                        return new e(this.tree, this, nodeTest);
                    }
                    if (nodeTest.getUType().overlaps(UType.TEXT)) {
                        return new b(this.tree, this, nodeTest);
                    }
                    return new c(this.tree, this, nodeTest);
                }
                return EmptyIterator.OfNodes.THE_INSTANCE;
            }
            case 5: {
                AxisIterator axisIterator = this.iterateAxis((byte)4, nodeTest);
                if (nodeTest.matchesNode(this)) {
                    return new PrependAxisIterator(this, axisIterator);
                }
                return axisIterator;
            }
            case 6: {
                if (n2 == 2 || n2 == 13) {
                    return new d(this.tree, this.getParent(), nodeTest, true);
                }
                if (this.tree.depth[this.nodeNr] == 0) {
                    return EmptyIterator.OfNodes.THE_INSTANCE;
                }
                return new d(this.tree, this, nodeTest, false);
            }
            case 7: {
                if (n2 == 2 || n2 == 13 || this.tree.depth[this.nodeNr] == 0) {
                    return EmptyIterator.OfNodes.THE_INSTANCE;
                }
                return new i(this.tree, this, nodeTest, false);
            }
            case 8: {
                if (n2 != 1) {
                    return EmptyIterator.OfNodes.THE_INSTANCE;
                }
                return NamespaceNode.makeIterator(this, nodeTest);
            }
            case 9: {
                TinyNodeImpl tinyNodeImpl = this.getParent();
                return Navigator.filteredSingleton(tinyNodeImpl, nodeTest);
            }
            case 10: {
                if (n2 == 2 || n2 == 13) {
                    return new g(this.tree, this.getParent(), nodeTest, false);
                }
                if (this.tree.depth[this.nodeNr] == 0) {
                    return EmptyIterator.OfNodes.THE_INSTANCE;
                }
                return new g(this.tree, this, nodeTest, false);
            }
            case 11: {
                if (n2 == 2 || n2 == 13 || this.tree.depth[this.nodeNr] == 0) {
                    return EmptyIterator.OfNodes.THE_INSTANCE;
                }
                return new h(this.tree, this, nodeTest);
            }
            case 12: {
                return Navigator.filteredSingleton(this, nodeTest);
            }
            case 13: {
                if (n2 == 9) {
                    return EmptyIterator.OfNodes.THE_INSTANCE;
                }
                if (n2 == 2 || n2 == 13) {
                    TinyNodeImpl tinyNodeImpl = this.getParent();
                    return new PrependAxisIterator(tinyNodeImpl, new g(this.tree, tinyNodeImpl, nodeTest, true));
                }
                return new g(this.tree, this, nodeTest, true);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + by);
    }

    @Override
    public TinyNodeImpl getParent() {
        if (this.parent != null) {
            return this.parent;
        }
        int n2 = TinyNodeImpl.a(this.tree, this.nodeNr);
        if (n2 == -1) {
            return null;
        }
        this.parent = this.tree.getNode(n2);
        return this.parent;
    }

    static int a(TinyTree tinyTree, int n2) {
        if (tinyTree.depth[n2] == 0) {
            return -1;
        }
        int n3 = tinyTree.next[n2];
        while (n3 > n2) {
            if (tinyTree.nodeKind[n3] == 12) {
                return tinyTree.alpha[n3];
            }
            n3 = tinyTree.next[n3];
        }
        return n3;
    }

    @Override
    public boolean hasChildNodes() {
        return false;
    }

    @Override
    public String getAttributeValue(String string, String string2) {
        return null;
    }

    @Override
    public NodeInfo getRoot() {
        if (this.nodeNr == 0) {
            return this;
        }
        return ((GenericTreeInfo)this.tree).getRootNode();
    }

    @Override
    public Configuration getConfiguration() {
        return this.tree.getConfiguration();
    }

    public NamePool getNamePool() {
        return this.tree.getNamePool();
    }

    @Override
    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] namespaceBindingArray) {
        return null;
    }

    @Override
    public void generateId(FastStringBuffer fastStringBuffer) {
        fastStringBuffer.append("d");
        fastStringBuffer.append(Long.toString(this.tree.getDocumentNumber()));
        fastStringBuffer.append(NODE_LETTER[this.getNodeKind()]);
        fastStringBuffer.append(Integer.toString(this.nodeNr));
    }

    public boolean isAncestorOrSelf(TinyNodeImpl tinyNodeImpl) {
        if (this.tree != tinyNodeImpl.tree) {
            return false;
        }
        int n2 = tinyNodeImpl.nodeNr;
        if (tinyNodeImpl instanceof TinyAttributeImpl) {
            if (this instanceof TinyAttributeImpl) {
                return this.nodeNr == n2;
            }
            n2 = this.tree.attParent[n2];
        }
        if (this instanceof TinyAttributeImpl) {
            return false;
        }
        if (this.nodeNr > n2) {
            return false;
        }
        if (this.nodeNr == n2) {
            return true;
        }
        if (!(this instanceof TinyParentNodeImpl)) {
            return false;
        }
        if (this.tree.depth[this.nodeNr] >= this.tree.depth[n2]) {
            return false;
        }
        int n3 = this.nodeNr;
        while (true) {
            int n4;
            if ((n4 = this.tree.next[n3]) < 0 || n4 > n2) {
                return true;
            }
            if (this.tree.depth[n4] == 0) {
                return true;
            }
            if (n4 >= n3) break;
            n3 = n4;
        }
        return false;
    }

    @Override
    public boolean isId() {
        return false;
    }

    @Override
    public boolean isIdref() {
        return false;
    }

    @Override
    public boolean isNilled() {
        return this.tree.isNilled(this.nodeNr);
    }

    @Override
    public boolean isStreamed() {
        return false;
    }

    public TinyTree getTree() {
        return this.tree;
    }

    public int getNodeNumber() {
        return this.nodeNr;
    }
}

