/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import net.sf.saxon.tree.tiny.GraftedElement;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyTextImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.tree.tiny.WhitespaceTextImpl;
import net.sf.saxon.tree.util.FastStringBuffer;

public abstract class TinyParentNodeImpl
extends TinyNodeImpl {
    @Override
    public boolean hasChildNodes() {
        return this.nodeNr + 1 < this.tree.numberOfNodes && this.tree.depth[this.nodeNr + 1] > this.tree.depth[this.nodeNr];
    }

    @Override
    public String getStringValue() {
        return TinyParentNodeImpl.getStringValueCS(this.tree, this.nodeNr).toString();
    }

    @Override
    public CharSequence getStringValueCS() {
        return TinyParentNodeImpl.getStringValueCS(this.tree, this.nodeNr);
    }

    public static CharSequence getStringValueCS(TinyTree tinyTree, int n2) {
        short s2 = tinyTree.depth[n2];
        int n3 = n2 + 1;
        if (tinyTree.nodeKind[n2] == 17) {
            return TinyTextImpl.getStringValue(tinyTree, n2);
        }
        if (tinyTree.nodeKind[n2] == 33) {
            GraftedElement graftedElement = tinyTree.externalNodes.get(tinyTree.alpha[n2]);
            return ((TinyNodeImpl)graftedElement).getStringValueCS();
        }
        if (n3 < tinyTree.numberOfNodes) {
            if (tinyTree.depth[n3] <= s2) {
                return "";
            }
            if (tinyTree.nodeKind[n3] == 3 && (n3 + 1 >= tinyTree.numberOfNodes || tinyTree.depth[n3 + 1] <= s2)) {
                return TinyTextImpl.getStringValue(tinyTree, n3);
            }
        }
        FastStringBuffer fastStringBuffer = null;
        while (n3 < tinyTree.numberOfNodes && tinyTree.depth[n3] > s2) {
            byte by = tinyTree.nodeKind[n3];
            if (by == 3 || by == 17) {
                if (fastStringBuffer == null) {
                    fastStringBuffer = new FastStringBuffer(256);
                }
                fastStringBuffer.append(TinyTextImpl.getStringValue(tinyTree, n3));
            } else if (by == 4) {
                if (fastStringBuffer == null) {
                    fastStringBuffer = new FastStringBuffer(256);
                }
                WhitespaceTextImpl.appendStringValue(tinyTree, n3, fastStringBuffer);
            } else if (by == 33) {
                GraftedElement graftedElement = (GraftedElement)tinyTree.getNode(n3);
                if (fastStringBuffer == null) {
                    fastStringBuffer = new FastStringBuffer(256);
                }
                fastStringBuffer.append(((TinyNodeImpl)graftedElement).getStringValueCS());
            }
            ++n3;
        }
        if (fastStringBuffer == null) {
            return "";
        }
        return fastStringBuffer.condense();
    }
}

