/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.event.CopyInformee;
import net.sf.saxon.event.CopyNamespaceSensitiveException;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.CopyOptions;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.iter.PrependAxisIterator;
import net.sf.saxon.tree.iter.SingleNodeIterator;
import net.sf.saxon.tree.tiny.TinyElementImpl;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyTextImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.NamespaceIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.z.IntValuePredicate;

public class TinyTextualElement
extends TinyElementImpl {
    private TinyTextualElementText a = null;

    public TinyTextualElement(TinyTree tinyTree, int n2) {
        super(tinyTree, n2);
    }

    @Override
    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] namespaceBindingArray) {
        return NamespaceBinding.EMPTY_ARRAY;
    }

    @Override
    public String getAttributeValue(String string, String string2) {
        return null;
    }

    @Override
    public String getAttributeValue(int n2) {
        return null;
    }

    @Override
    public void copy(Receiver receiver, int n2, Location location) {
        Object t2;
        CopyInformee copyInformee;
        boolean bl2 = CopyOptions.includes(n2, 4);
        SchemaType schemaType = bl2 ? ((TinyNodeImpl)this).getSchemaType() : Untyped.getInstance();
        boolean bl3 = (n2 & 4) != 0 && (n2 & 3) == 0;
        if (bl3) {
            try {
                this.checkNotNamespaceSensitiveElement(schemaType, this.nodeNr);
            }
            catch (CopyNamespaceSensitiveException copyNamespaceSensitiveException) {
                int n3 = receiver.getPipelineConfiguration().getHostLanguage();
                copyNamespaceSensitiveException.setErrorCode(n3 == 50 ? "XTTE0950" : "XQTY0086");
                throw copyNamespaceSensitiveException;
            }
        }
        if ((copyInformee = (CopyInformee)receiver.getPipelineConfiguration().getComponent(CopyInformee.class.getName())) != null && (t2 = copyInformee.notifyElementNode(this)) instanceof Location) {
            location = (Location)t2;
        }
        receiver.startElement(NameOfNode.makeName(this), schemaType, location, 0);
        if ((n2 & 2) != 0) {
            NamespaceIterator.sendNamespaces(this, receiver);
        }
        receiver.startContent();
        receiver.characters(((TinyNodeImpl)this).getStringValueCS(), location, 0);
        receiver.endElement();
    }

    @Override
    public boolean hasChildNodes() {
        return true;
    }

    @Override
    public CharSequence getStringValueCS() {
        return TinyTextImpl.getStringValue(this.tree, this.nodeNr);
    }

    @Override
    public String getStringValue() {
        return TinyTextImpl.getStringValue(this.tree, this.nodeNr).toString();
    }

    @Override
    public AxisIterator iterateAxis(byte by) {
        switch (by) {
            case 2: {
                return EmptyIterator.OfNodes.THE_INSTANCE;
            }
            case 3: 
            case 4: {
                return SingleNodeIterator.makeIterator(this.getTextNode());
            }
            case 5: {
                ArrayList<NodeInfo> arrayList = new ArrayList<NodeInfo>(2);
                arrayList.add(this);
                arrayList.add(this.getTextNode());
                return new ListIterator.OfNodes((List<NodeInfo>)arrayList);
            }
        }
        return super.iterateAxis(by);
    }

    @Override
    public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
        switch (by) {
            case 2: {
                return EmptyIterator.OfNodes.THE_INSTANCE;
            }
            case 3: 
            case 4: {
                return Navigator.filteredSingleton(this.getTextNode(), nodeTest);
            }
            case 5: {
                ArrayList<NodeInfo> arrayList = new ArrayList<NodeInfo>(2);
                if (nodeTest.matchesNode(this)) {
                    arrayList.add(this);
                }
                if (nodeTest.matchesNode(this.getTextNode())) {
                    arrayList.add(this.getTextNode());
                }
                return new ListIterator.OfNodes((List<NodeInfo>)arrayList);
            }
        }
        return super.iterateAxis(by, nodeTest);
    }

    @Override
    public boolean isAncestorOrSelf(TinyNodeImpl tinyNodeImpl) {
        return this.equals(tinyNodeImpl);
    }

    public TinyTextualElementText getTextNode() {
        if (this.a == null) {
            this.a = new TinyTextualElementText(this);
        }
        return this.a;
    }

    public class TinyTextualElementText
    implements SourceLocator,
    NodeInfo {
        private IntValuePredicate a = new IntValuePredicate(10);
        private /* synthetic */ TinyTextualElement b;

        public TinyTextualElementText(TinyTextualElement tinyTextualElement) {
            this.b = tinyTextualElement;
        }

        @Override
        public boolean hasFingerprint() {
            return true;
        }

        @Override
        public TreeInfo getTreeInfo() {
            return this.b.getTreeInfo();
        }

        @Override
        public void setSystemId(String string) {
        }

        @Override
        public final int getNodeKind() {
            return 3;
        }

        @Override
        public String getStringValue() {
            return this.getStringValueCS().toString();
        }

        @Override
        public CharSequence getStringValueCS() {
            return ((TinyNodeImpl)this.b).getStringValueCS();
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof TinyTextualElementText && this.getParent().equals(((TinyTextualElementText)object).getParent());
        }

        @Override
        public void generateId(FastStringBuffer fastStringBuffer) {
            this.b.generateId(fastStringBuffer);
            fastStringBuffer.append("T");
        }

        @Override
        public String getSystemId() {
            return this.b.getSystemId();
        }

        @Override
        public String getBaseURI() {
            return ((TinyNodeImpl)this.b).getBaseURI();
        }

        @Override
        public int compareOrder(NodeInfo nodeInfo) {
            if (nodeInfo.equals(this)) {
                return 0;
            }
            if (nodeInfo.equals(this.getParent())) {
                return 1;
            }
            return this.getParent().compareOrder(nodeInfo);
        }

        @Override
        public int getFingerprint() {
            return -1;
        }

        @Override
        public String getPrefix() {
            return "";
        }

        @Override
        public String getURI() {
            return "";
        }

        @Override
        public String getDisplayName() {
            return "";
        }

        @Override
        public String getLocalPart() {
            return "";
        }

        @Override
        public boolean hasChildNodes() {
            return false;
        }

        @Override
        public String getAttributeValue(String string, String string2) {
            return null;
        }

        @Override
        public int getLineNumber() {
            return this.getParent().getLineNumber();
        }

        @Override
        public int getColumnNumber() {
            return this.getParent().getColumnNumber();
        }

        @Override
        public Location saveLocation() {
            return this;
        }

        @Override
        public SchemaType getSchemaType() {
            return null;
        }

        @Override
        public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] namespaceBindingArray) {
            return null;
        }

        @Override
        public AtomicSequence atomize() {
            return new UntypedAtomicValue(this.getStringValueCS());
        }

        @Override
        public AxisIterator iterateAxis(byte by) {
            switch (by) {
                case 0: {
                    return ((TinyNodeImpl)this.b).iterateAxis((byte)1);
                }
                case 13: {
                    return new Navigator.PrecedingEnumeration(this, true);
                }
                case 1: {
                    TinyTextualElementText tinyTextualElementText = this;
                    return new PrependAxisIterator(tinyTextualElementText, tinyTextualElementText.getParent().iterateAxis((byte)1));
                }
                case 6: {
                    return new Navigator.FollowingEnumeration(this);
                }
                case 10: {
                    return new Navigator.PrecedingEnumeration(this, false);
                }
                case 9: {
                    return SingleNodeIterator.makeIterator(this.getParent());
                }
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 8: 
                case 11: {
                    return EmptyIterator.OfNodes.THE_INSTANCE;
                }
                case 5: 
                case 12: {
                    return SingleNodeIterator.makeIterator(this);
                }
            }
            throw new IllegalArgumentException("Unknown axis number " + by);
        }

        @Override
        public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
            switch (by) {
                case 0: {
                    return this.getParent().iterateAxis((byte)1, nodeTest);
                }
                case 13: {
                    return new Navigator.AxisFilter(new Navigator.PrecedingEnumeration(this, true), nodeTest);
                }
                case 1: {
                    TinyTextualElementText tinyTextualElementText = this;
                    return new Navigator.AxisFilter(new PrependAxisIterator(tinyTextualElementText, tinyTextualElementText.getParent().iterateAxis((byte)1)), nodeTest);
                }
                case 6: {
                    return new Navigator.AxisFilter(new Navigator.FollowingEnumeration(this), nodeTest);
                }
                case 10: {
                    return new Navigator.AxisFilter(new Navigator.PrecedingEnumeration(this, false), nodeTest);
                }
                case 9: {
                    return Navigator.filteredSingleton(this.getParent(), nodeTest);
                }
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 8: 
                case 11: {
                    return EmptyIterator.OfNodes.THE_INSTANCE;
                }
                case 5: 
                case 12: {
                    return Navigator.filteredSingleton(this, nodeTest);
                }
            }
            throw new IllegalArgumentException("Unknown axis number " + by);
        }

        @Override
        public NodeInfo getParent() {
            return this.b;
        }

        @Override
        public NodeInfo getRoot() {
            return this.getParent().getRoot();
        }

        @Override
        public void copy(Receiver receiver, int n2, Location location) {
            receiver.characters(this.getStringValueCS(), location, 0);
        }
    }
}

