/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.GenericTreeInfo;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.PrefixPool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.SystemIdMap;
import net.sf.saxon.tree.tiny.AppendableCharSequence;
import net.sf.saxon.tree.tiny.CharSlice;
import net.sf.saxon.tree.tiny.GraftedElement;
import net.sf.saxon.tree.tiny.LargeStringBuffer;
import net.sf.saxon.tree.tiny.NodeVectorTree;
import net.sf.saxon.tree.tiny.Statistics;
import net.sf.saxon.tree.tiny.TinyAttributeImpl;
import net.sf.saxon.tree.tiny.TinyDocumentImpl;
import net.sf.saxon.tree.tiny.TinyElementImpl;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyParentNodeImpl;
import net.sf.saxon.tree.tiny.TinyTextImpl;
import net.sf.saxon.tree.tiny.TinyTextualElement;
import net.sf.saxon.tree.tiny.WhitespaceTextImpl;
import net.sf.saxon.tree.tiny.j;
import net.sf.saxon.tree.tiny.k;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInListType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.z.IntArraySet;
import net.sf.saxon.z.IntHashMap;
import net.sf.saxon.z.IntHashSet;
import net.sf.saxon.z.IntSet;

public final class TinyTree
extends GenericTreeInfo
implements NodeVectorTree {
    private static final String[] a = new String[0];
    protected AppendableCharSequence charBuffer;
    protected FastStringBuffer commentBuffer = null;
    protected int numberOfNodes = 0;
    public byte[] nodeKind;
    protected short[] depth;
    protected int[] next;
    protected int[] alpha;
    protected int[] beta;
    protected int[] nameCode;
    protected int[] prior = null;
    protected SchemaType[] typeArray = null;
    protected AtomicSequence[] typedValueArray = null;
    protected IntSet idRefElements = null;
    protected IntSet idRefAttributes = null;
    protected IntSet nilledElements = null;
    protected IntSet defaultedAttributes = null;
    protected IntSet topWithinEntity = null;
    private boolean b = true;
    public static final int TYPECODE_IDREF = 0x20000000;
    protected int numberOfAttributes = 0;
    protected int[] attParent;
    protected int[] attCode;
    protected CharSequence[] attValue;
    protected AtomicSequence[] attTypedValue;
    protected SimpleType[] attType;
    protected int numberOfNamespaces = 0;
    protected int[] namespaceParent;
    protected NamespaceBinding[] namespaceBinding;
    private int[] c = null;
    private int[] d = null;
    private SystemIdMap e = null;
    protected boolean usesNamespaces = false;
    protected PrefixPool prefixPool = new PrefixPool();
    private HashMap<String, NodeInfo> f;
    protected HashMap<String, String[]> entityTable;
    private NodeInfo g;
    protected List<GraftedElement> externalNodes;
    protected IntHashMap<String> knownBaseUris;
    public static final boolean useBulkCopy = false;
    public static boolean useGraft = false;

    public TinyTree(Configuration configuration, Statistics statistics) {
        super(configuration);
        int n2 = (int)statistics.getAverageNodes() + 1;
        int n3 = (int)statistics.getAverageAttributes() + 1;
        int n4 = (int)statistics.getAverageNamespaces() + 1;
        int n5 = (int)statistics.getAverageCharacters() + 1;
        this.nodeKind = new byte[n2];
        this.depth = new short[n2];
        this.next = new int[n2];
        this.alpha = new int[n2];
        this.beta = new int[n2];
        this.nameCode = new int[n2];
        this.numberOfAttributes = 0;
        this.attParent = new int[n3];
        this.attCode = new int[n3];
        this.attValue = new String[n3];
        this.numberOfNamespaces = 0;
        this.namespaceParent = new int[n4];
        this.namespaceBinding = new NamespaceBinding[n4];
        this.charBuffer = n5 > 65000 ? new LargeStringBuffer() : new FastStringBuffer(n5);
        ((GenericTreeInfo)this).setConfiguration(configuration);
    }

    @Override
    public final void setConfiguration(Configuration configuration) {
        super.setConfiguration(configuration);
        this.b = configuration.isLicensedFeature(1) && configuration.getBooleanProperty(Feature.USE_TYPED_VALUE_CACHE);
        this.a(0, NamespaceBinding.XML);
    }

    private void a(short s2, int n2) {
        if (this.nodeKind.length < this.numberOfNodes + n2) {
            s2 = (short)(s2 == 11 ? this.numberOfNodes + 1 : Math.max(this.numberOfNodes << 1, this.numberOfNodes + n2));
            this.nodeKind = Arrays.copyOf(this.nodeKind, (int)s2);
            this.next = Arrays.copyOf(this.next, (int)s2);
            this.depth = Arrays.copyOf(this.depth, (int)s2);
            this.alpha = Arrays.copyOf(this.alpha, (int)s2);
            this.beta = Arrays.copyOf(this.beta, (int)s2);
            this.nameCode = Arrays.copyOf(this.nameCode, (int)s2);
            if (this.typeArray != null) {
                this.typeArray = Arrays.copyOf(this.typeArray, (int)s2);
            }
            if (this.typedValueArray != null) {
                this.typedValueArray = Arrays.copyOf(this.typedValueArray, (int)s2);
            }
            if (this.c != null) {
                this.c = Arrays.copyOf(this.c, (int)s2);
                this.d = Arrays.copyOf(this.d, (int)s2);
            }
        }
    }

    private void d(int n2) {
        if (this.attParent.length < this.numberOfAttributes + n2) {
            int n3 = Math.max(this.numberOfAttributes + n2, this.numberOfAttributes << 1);
            if (n3 == 0) {
                n3 = n2 + 10;
            }
            this.attParent = Arrays.copyOf(this.attParent, n3);
            this.attCode = Arrays.copyOf(this.attCode, n3);
            this.attValue = Arrays.copyOf(this.attValue, n3);
            if (this.attType != null) {
                this.attType = Arrays.copyOf(this.attType, n3);
            }
            if (this.attTypedValue != null) {
                this.attTypedValue = Arrays.copyOf(this.attTypedValue, n3);
            }
        }
    }

    private void e(int n2) {
        if (this.namespaceParent.length < this.numberOfNamespaces + n2) {
            if ((n2 = Math.max(this.numberOfNamespaces << 1, this.numberOfNamespaces + n2)) == 0) {
                n2 = 10;
            }
            this.namespaceParent = Arrays.copyOf(this.namespaceParent, n2);
            this.namespaceBinding = Arrays.copyOf(this.namespaceBinding, n2);
        }
    }

    public final PrefixPool getPrefixPool() {
        return this.prefixPool;
    }

    public final void setCopiedFrom(NodeInfo nodeInfo) {
        this.g = nodeInfo;
    }

    public final NodeInfo getCopiedFrom() {
        return this.g;
    }

    final int a(short s2, int n2, int n3, int n4, int n5) {
        this.a(s2, 1);
        this.nodeKind[this.numberOfNodes] = (byte)s2;
        this.depth[this.numberOfNodes] = (short)n2;
        this.alpha[this.numberOfNodes] = n3;
        this.beta[this.numberOfNodes] = n4;
        this.nameCode[this.numberOfNodes] = n5;
        this.next[this.numberOfNodes] = -1;
        if (this.typeArray != null) {
            this.typeArray[this.numberOfNodes] = Untyped.getInstance();
        }
        if (this.numberOfNodes == 0) {
            TinyTree tinyTree = this;
            tinyTree.setDocumentNumber(tinyTree.getConfiguration().getDocumentNumberAllocator().allocateDocumentNumber());
        }
        return this.numberOfNodes++;
    }

    final void a(CharSequence charSequence) {
        if (this.charBuffer instanceof FastStringBuffer && this.charBuffer.length() > 65000) {
            LargeStringBuffer largeStringBuffer = new LargeStringBuffer();
            largeStringBuffer.append(this.charBuffer);
            this.charBuffer = largeStringBuffer;
        }
        this.charBuffer.append(charSequence);
    }

    public final int addTextNodeCopy(int n2, int n3) {
        return this.a((short)3, n2, this.alpha[n3], this.beta[n3], -1);
    }

    final void a(Statistics statistics) {
        if (this.numberOfNodes * 3 < this.nodeKind.length || this.nodeKind.length - this.numberOfNodes > 20000) {
            this.nodeKind = Arrays.copyOf(this.nodeKind, this.numberOfNodes);
            this.next = Arrays.copyOf(this.next, this.numberOfNodes);
            this.depth = Arrays.copyOf(this.depth, this.numberOfNodes);
            this.alpha = Arrays.copyOf(this.alpha, this.numberOfNodes);
            this.beta = Arrays.copyOf(this.beta, this.numberOfNodes);
            this.nameCode = Arrays.copyOf(this.nameCode, this.numberOfNodes);
            if (this.typeArray != null) {
                this.typeArray = Arrays.copyOf(this.typeArray, this.numberOfNodes);
            }
            if (this.c != null) {
                this.c = Arrays.copyOf(this.c, this.numberOfNodes);
                this.d = Arrays.copyOf(this.d, this.numberOfNodes);
            }
        }
        if (this.numberOfAttributes * 3 < this.attParent.length || this.attParent.length - this.numberOfAttributes > 1000) {
            int n2 = this.numberOfAttributes;
            if (n2 == 0) {
                this.attParent = IntArraySet.EMPTY_INT_ARRAY;
                this.attCode = IntArraySet.EMPTY_INT_ARRAY;
                this.attValue = a;
                this.attType = null;
            } else {
                this.attParent = Arrays.copyOf(this.attParent, this.numberOfAttributes);
                this.attCode = Arrays.copyOf(this.attCode, this.numberOfAttributes);
                this.attValue = Arrays.copyOf(this.attValue, this.numberOfAttributes);
            }
            if (this.attType != null) {
                this.attType = Arrays.copyOf(this.attType, this.numberOfAttributes);
            }
        }
        if (this.numberOfNamespaces * 3 < this.namespaceParent.length) {
            this.namespaceParent = Arrays.copyOf(this.namespaceParent, this.numberOfNamespaces);
            this.namespaceBinding = Arrays.copyOf(this.namespaceBinding, this.numberOfNamespaces);
        }
        this.prefixPool.condense();
        statistics.updateStatistics(this.numberOfNodes, this.numberOfAttributes, this.numberOfNamespaces, this.charBuffer.length());
    }

    final void a(int n2, SchemaType schemaType) {
        if (!schemaType.equals(Untyped.getInstance())) {
            if (this.typeArray == null) {
                this.typeArray = new SchemaType[this.nodeKind.length];
                Arrays.fill(this.typeArray, 0, this.nodeKind.length, Untyped.getInstance());
            }
            assert (this.typeArray != null);
            this.typeArray[n2] = schemaType;
        }
    }

    public final int getTypeAnnotation(int n2) {
        if (this.typeArray == null) {
            return 630;
        }
        return this.typeArray[n2].getFingerprint();
    }

    public final SchemaType getSchemaType(int n2) {
        if (this.typeArray == null) {
            return Untyped.getInstance();
        }
        return this.typeArray[n2];
    }

    public final AtomicSequence getTypedValueOfElement(TinyElementImpl object) {
        int n2 = ((TinyNodeImpl)object).nodeNr;
        if (this.typedValueArray == null || this.typedValueArray[n2] == null) {
            SchemaType schemaType = this.getSchemaType(n2);
            int n3 = schemaType.getFingerprint();
            if (n3 == 630 || n3 == 631 || n3 == 572) {
                object = TinyParentNodeImpl.getStringValueCS(this, n2);
                return new UntypedAtomicValue((CharSequence)object);
            }
            if (n3 == 513) {
                object = TinyParentNodeImpl.getStringValueCS(this, n2);
                return new StringValue((CharSequence)object);
            }
            if (n3 == 529) {
                object = TinyParentNodeImpl.getStringValueCS(this, n2);
                return new AnyURIValue((CharSequence)object);
            }
            object = schemaType.atomize((NodeInfo)object);
            if (this.b) {
                if (this.typedValueArray == null) {
                    this.typedValueArray = new AtomicSequence[this.nodeKind.length];
                }
                this.typedValueArray[n2] = object;
            }
            return object;
        }
        return this.typedValueArray[n2];
    }

    public final AtomicSequence getTypedValueOfElement(int n2) {
        if (this.typedValueArray == null || this.typedValueArray[n2] == null) {
            Object object = this.getSchemaType(n2);
            int n3 = object.getFingerprint();
            if (n3 == 631 || n3 == 630) {
                CharSequence charSequence = TinyParentNodeImpl.getStringValueCS(this, n2);
                return new UntypedAtomicValue(charSequence);
            }
            if (n3 == 513) {
                CharSequence charSequence = TinyParentNodeImpl.getStringValueCS(this, n2);
                return new StringValue(charSequence);
            }
            if (n3 == 529) {
                CharSequence charSequence = TinyParentNodeImpl.getStringValueCS(this, n2);
                return new AnyURIValue(charSequence);
            }
            if (n3 == 560) {
                CharSequence charSequence = TinyParentNodeImpl.getStringValueCS(this, n2);
                return new StringValue(charSequence, BuiltInAtomicType.ID);
            }
            TinyNodeImpl tinyNodeImpl = this.getNode(n2);
            object = object.atomize(tinyNodeImpl);
            if (this.b) {
                if (this.typedValueArray == null) {
                    this.typedValueArray = new AtomicSequence[this.nodeKind.length];
                }
                this.typedValueArray[n2] = object;
            }
            return object;
        }
        return this.typedValueArray[n2];
    }

    public final AtomicSequence getTypedValueOfAttribute(TinyAttributeImpl groundedValue, int n2) {
        if (this.attType == null) {
            return new UntypedAtomicValue(this.attValue[n2]);
        }
        if (this.attTypedValue == null || this.attTypedValue[n2] == null) {
            SimpleType simpleType = this.c(n2);
            if (simpleType.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                return new UntypedAtomicValue(this.attValue[n2]);
            }
            if (simpleType.equals(BuiltInAtomicType.STRING)) {
                return new StringValue(this.attValue[n2]);
            }
            if (simpleType.equals(BuiltInAtomicType.ANY_URI)) {
                return new AnyURIValue(this.attValue[n2]);
            }
            if (groundedValue == null) {
                groundedValue = new TinyAttributeImpl(this, n2);
            }
            groundedValue = simpleType.atomize((NodeInfo)groundedValue);
            if (this.b) {
                if (this.attTypedValue == null) {
                    this.attTypedValue = new AtomicSequence[this.attParent.length];
                }
                this.attTypedValue[n2] = groundedValue;
            }
            return groundedValue;
        }
        return this.attTypedValue[n2];
    }

    @Override
    public final int getNodeKind(int n2) {
        if ((n2 = this.nodeKind[n2]) == 4) {
            return 3;
        }
        return n2;
    }

    public final int getNameCode(int n2) {
        return this.nameCode[n2];
    }

    @Override
    public final int getFingerprint(int n2) {
        if ((n2 = this.nameCode[n2]) == -1) {
            return -1;
        }
        return n2 & 0xFFFFF;
    }

    public final String getPrefix(int n2) {
        if ((n2 = this.nameCode[n2] >> 20) <= 0) {
            if (n2 == 0) {
                return "";
            }
            return null;
        }
        return this.prefixPool.getPrefix(n2);
    }

    final void a() {
        if (this.prior == null || this.prior.length < this.numberOfNodes) {
            this.b();
        }
    }

    private synchronized void b() {
        int[] nArray = new int[this.numberOfNodes];
        Arrays.fill(nArray, 0, this.numberOfNodes, -1);
        for (int i2 = 0; i2 < this.numberOfNodes; ++i2) {
            int n2 = this.next[i2];
            if (n2 <= i2) continue;
            nArray[n2] = i2;
        }
        this.prior = nArray;
    }

    final void a(NodeInfo nodeInfo, int n2, int n3, SimpleType simpleType, CharSequence charSequence, int n4) {
        this.d(1);
        this.attParent[this.numberOfAttributes] = n2;
        this.attCode[this.numberOfAttributes] = n3;
        this.attValue[this.numberOfAttributes] = charSequence.toString();
        if (!simpleType.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            TinyTree tinyTree = this;
            if (tinyTree.attType == null) {
                tinyTree.attType = new SimpleType[tinyTree.attParent.length];
                Arrays.fill(tinyTree.attType, 0, tinyTree.numberOfAttributes, BuiltInAtomicType.UNTYPED_ATOMIC);
            }
        }
        if (this.attType != null) {
            this.attType[this.numberOfAttributes] = simpleType;
        }
        if (this.alpha[n2] == -1) {
            this.alpha[n2] = this.numberOfAttributes;
        }
        if (nodeInfo instanceof TinyDocumentImpl) {
            boolean bl2;
            block25: {
                boolean bl3 = false;
                try {
                    if ((n4 & 0x800) != 0) {
                        bl3 = true;
                    } else if ((n3 & 0xFFFFF) == 388) {
                        bl3 = true;
                    } else if (simpleType.isIdType()) {
                        bl3 = true;
                    }
                }
                catch (MissingComponentException missingComponentException) {}
                if (bl3) {
                    String string = Whitespace.trim(charSequence);
                    this.attValue[this.numberOfAttributes] = string;
                    if (NameChecker.isValidNCName(string)) {
                        TinyNodeImpl tinyNodeImpl = this.getNode(n2);
                        this.a(tinyNodeImpl, string);
                    } else if (this.attType != null) {
                        this.attType[this.numberOfAttributes] = BuiltInAtomicType.UNTYPED_ATOMIC;
                    }
                }
                bl2 = false;
                try {
                    if ((n4 & 0x1000) != 0) {
                        bl2 = true;
                        break block25;
                    }
                    if (simpleType == BuiltInAtomicType.IDREF || simpleType == BuiltInListType.IDREFS) {
                        bl2 = true;
                        break block25;
                    }
                    if (!simpleType.isIdRefType()) break block25;
                    try {
                        Object object = simpleType.getTypedValue(charSequence, null, this.getConfiguration().getConversionRules());
                        object = object.iterator();
                        while (object.hasNext()) {
                            AtomicValue atomicValue = (AtomicValue)object.next();
                            if (!atomicValue.getItemType().isIdRefType()) continue;
                            bl2 = true;
                        }
                    }
                    catch (ValidationException validationException) {}
                }
                catch (MissingComponentException missingComponentException) {}
            }
            if (bl2) {
                if (this.idRefAttributes == null) {
                    this.idRefAttributes = new IntHashSet();
                }
                this.idRefAttributes.add(this.numberOfAttributes);
            }
        }
        ++this.numberOfAttributes;
    }

    public final void markDefaultedAttribute(int n2) {
        if (this.defaultedAttributes == null) {
            this.defaultedAttributes = new IntHashSet();
        }
        this.defaultedAttributes.add(n2);
    }

    public final boolean isDefaultedAttribute(int n2) {
        return this.defaultedAttributes != null && this.defaultedAttributes.contains(n2);
    }

    public final void indexIDElement(NodeInfo nodeInfo, int n2) {
        String string = Whitespace.trim(TinyParentNodeImpl.getStringValueCS(this, n2));
        if (nodeInfo.getNodeKind() == 9 && NameChecker.isValidNCName(string)) {
            nodeInfo = this.getNode(n2);
            this.a((TinyNodeImpl)nodeInfo, string);
        }
    }

    public final boolean hasXmlSpacePreserveAttribute() {
        for (int i2 = 0; i2 < this.numberOfAttributes; ++i2) {
            if ((this.attCode[i2] & 0xFFFFF) != 386 || !"preserve".equals(this.attValue[i2].toString())) continue;
            return true;
        }
        return false;
    }

    final void a(int n2, NamespaceBinding namespaceBinding) {
        this.e(1);
        this.namespaceParent[this.numberOfNamespaces] = n2;
        this.namespaceBinding[this.numberOfNamespaces] = namespaceBinding;
        if (this.beta[n2] == -1) {
            this.beta[n2] = this.numberOfNamespaces;
        }
        ++this.numberOfNamespaces;
        if (!namespaceBinding.isXmlNamespace()) {
            this.usesNamespaces = true;
        }
    }

    @Override
    public final TinyNodeImpl getNode(int n2) {
        switch (this.nodeKind[n2]) {
            case 9: {
                return (TinyDocumentImpl)((GenericTreeInfo)this).getRootNode();
            }
            case 1: {
                return new TinyElementImpl(this, n2);
            }
            case 17: {
                return new TinyTextualElement(this, n2);
            }
            case 33: {
                return this.externalNodes.get(this.alpha[n2]);
            }
            case 3: {
                return new TinyTextImpl(this, n2);
            }
            case 4: {
                return new WhitespaceTextImpl(this, n2);
            }
            case 8: {
                return new j(this, n2);
            }
            case 7: {
                return new k(this, n2);
            }
            case 12: {
                throw new IllegalArgumentException("Attempting to treat a parent pointer as a node");
            }
            case 11: {
                throw new IllegalArgumentException("Attempting to treat a stopper entry as a node");
            }
        }
        throw new IllegalStateException("Unknown node kind " + this.nodeKind[n2]);
    }

    final StringValue a(int n2) {
        switch (this.nodeKind[n2]) {
            case 1: 
            case 9: {
                int n3 = this.depth[n2];
                if (this.depth[++n2] <= n3) {
                    return UntypedAtomicValue.ZERO_LENGTH_UNTYPED;
                }
                if (this.nodeKind[n2] == 3 && this.depth[n2 + 1] <= n3) {
                    int n4 = this.beta[n2];
                    int n5 = n3 = this.alpha[n2];
                    return new UntypedAtomicValue(this.charBuffer.subSequence(n5, n5 + n4));
                }
                if (this.nodeKind[n2] == 4 && this.depth[n2 + 1] <= n3) {
                    return new UntypedAtomicValue(WhitespaceTextImpl.getStringValueCS(this, n2));
                }
                FastStringBuffer fastStringBuffer = null;
                while (n2 < this.numberOfNodes && this.depth[n2] > n3) {
                    if (this.nodeKind[n2] == 3) {
                        if (fastStringBuffer == null) {
                            fastStringBuffer = new FastStringBuffer(256);
                        }
                        fastStringBuffer.append(TinyTextImpl.getStringValue(this, n2));
                    } else if (this.nodeKind[n2] == 4) {
                        if (fastStringBuffer == null) {
                            fastStringBuffer = new FastStringBuffer(256);
                        }
                        WhitespaceTextImpl.appendStringValue(this, n2, fastStringBuffer);
                    }
                    ++n2;
                }
                if (fastStringBuffer == null) {
                    return UntypedAtomicValue.ZERO_LENGTH_UNTYPED;
                }
                return new UntypedAtomicValue(fastStringBuffer.condense());
            }
            case 3: {
                return new UntypedAtomicValue(TinyTextImpl.getStringValue(this, n2));
            }
            case 4: {
                return new UntypedAtomicValue(WhitespaceTextImpl.getStringValueCS(this, n2));
            }
            case 7: 
            case 8: {
                int n6 = this.alpha[n2];
                n2 = this.beta[n2];
                if (n2 == 0) {
                    return UntypedAtomicValue.ZERO_LENGTH_UNTYPED;
                }
                char[] cArray = new char[n2];
                assert (this.commentBuffer != null);
                int n7 = n6;
                this.commentBuffer.getChars(n7, n7 + n2, cArray, 0);
                return new StringValue(new CharSlice(cArray, 0, n2));
            }
        }
        throw new IllegalStateException("Unknown node kind");
    }

    final TinyAttributeImpl b(int n2) {
        return new TinyAttributeImpl(this, n2);
    }

    final SimpleType c(int n2) {
        if (this.attType == null) {
            return BuiltInAtomicType.UNTYPED_ATOMIC;
        }
        return this.attType[n2];
    }

    public final boolean isIdAttribute(int n2) {
        try {
            return this.attType != null && this.c(n2).isIdType();
        }
        catch (MissingComponentException missingComponentException) {
            return false;
        }
    }

    public final boolean isIdrefAttribute(int n2) {
        return this.idRefAttributes != null && this.idRefAttributes.contains(n2);
    }

    public final boolean isIdElement(int n2) {
        try {
            return this.getSchemaType(n2).isIdType() && this.getTypedValueOfElement(n2).getLength() == 1;
        }
        catch (XPathException xPathException) {
            return false;
        }
    }

    public final boolean isIdrefElement(int n2) {
        Object object2 = this.getSchemaType(n2);
        try {
            if (object2.isIdRefType()) {
                if (object2 == BuiltInAtomicType.IDREF || object2 == BuiltInListType.IDREFS) {
                    return true;
                }
                try {
                    for (Object object2 : this.getTypedValueOfElement(n2)) {
                        if (!((AtomicValue)object2).getItemType().isIdRefType()) continue;
                        return true;
                    }
                }
                catch (XPathException xPathException) {}
            }
        }
        catch (MissingComponentException missingComponentException) {
            return false;
        }
        return false;
    }

    final void a(int n2, String string) {
        if (string == null) {
            string = "";
        }
        if (this.e == null) {
            this.e = new SystemIdMap();
        }
        this.e.setSystemId(n2, string);
    }

    public final String getSystemId(int n2) {
        if (this.e == null) {
            return null;
        }
        return this.e.getSystemId(n2);
    }

    @Override
    public final NodeInfo getRootNode() {
        if (this.getNodeKind(0) == 9) {
            if (this.root != null) {
                return this.root;
            }
            this.root = new TinyDocumentImpl(this);
            return this.root;
        }
        return this.getNode(0);
    }

    public final void setLineNumbering() {
        this.c = new int[this.nodeKind.length];
        Arrays.fill(this.c, -1);
        this.d = new int[this.nodeKind.length];
        Arrays.fill(this.d, -1);
    }

    final void a(int n2, int n3, int n4) {
        if (this.c != null) {
            assert (this.d != null);
            this.c[n2] = n3;
            this.d[n2] = n4;
        }
    }

    public final int getLineNumber(int n2) {
        if (this.c != null) {
            while (n2 >= 0) {
                int n3 = this.c[n2];
                if (n3 > 0) {
                    return n3;
                }
                --n2;
            }
        }
        return -1;
    }

    public final int getColumnNumber(int n2) {
        if (this.d != null) {
            while (n2 >= 0) {
                int n3 = this.d[n2];
                if (n3 > 0) {
                    return n3;
                }
                --n2;
            }
        }
        return -1;
    }

    public final void setNilled(int n2) {
        if (this.nilledElements == null) {
            this.nilledElements = new IntHashSet();
        }
        this.nilledElements.add(n2);
    }

    public final boolean isNilled(int n2) {
        return this.nilledElements != null && this.nilledElements.contains(n2);
    }

    private void a(TinyNodeImpl tinyNodeImpl, String string) {
        if (this.f == null) {
            this.f = new HashMap(256);
        }
        this.f.putIfAbsent(string, tinyNodeImpl);
    }

    @Override
    public final NodeInfo selectID(String string, boolean bl2) {
        if (this.f == null) {
            return null;
        }
        NodeInfo nodeInfo = this.f.get(string);
        if (nodeInfo != null && bl2 && nodeInfo.isId() && nodeInfo.getStringValue().equals(string)) {
            nodeInfo = nodeInfo.getParent();
        }
        return nodeInfo;
    }

    final void a(String string, String string2, String string3) {
        if (this.entityTable == null) {
            this.entityTable = new HashMap(20);
        }
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        stringArray[0] = string2;
        stringArray2[1] = string3;
        this.entityTable.put(string, stringArray2);
    }

    @Override
    public final Iterator<String> getUnparsedEntityNames() {
        if (this.entityTable == null) {
            List list = Collections.emptyList();
            return list.iterator();
        }
        return this.entityTable.keySet().iterator();
    }

    @Override
    public final String[] getUnparsedEntity(String string) {
        if (this.entityTable == null) {
            return null;
        }
        return this.entityTable.get(string);
    }

    public final NamePool getNamePool() {
        return this.getConfiguration().getNamePool();
    }

    public final void markTopWithinEntity(int n2) {
        if (this.topWithinEntity == null) {
            this.topWithinEntity = new IntHashSet();
        }
        this.topWithinEntity.add(n2);
    }

    public final boolean isTopWithinEntity(int n2) {
        return this.topWithinEntity != null && this.topWithinEntity.contains(n2);
    }

    public final void diagnosticDump() {
        int n2;
        NamePool namePool = this.getNamePool();
        System.err.println("    node    kind   depth    next   alpha    beta    name    type");
        for (n2 = 0; n2 < this.numberOfNodes; ++n2) {
            String string = "";
            if (this.nameCode[n2] != -1) {
                try {
                    string = namePool.getEQName(this.nameCode[n2]);
                }
                catch (Exception exception) {
                    string = "#" + this.nameCode[1];
                }
            }
            System.err.println(TinyTree.f(n2) + TinyTree.f(this.nodeKind[n2]) + TinyTree.f(this.depth[n2]) + TinyTree.f(this.next[n2]) + TinyTree.f(this.alpha[n2]) + TinyTree.f(this.beta[n2]) + TinyTree.f(this.nameCode[n2]) + TinyTree.f(this.getTypeAnnotation(n2)) + " " + string);
        }
        System.err.println("    attr  parent    name    value");
        for (n2 = 0; n2 < this.numberOfAttributes; ++n2) {
            System.err.println(TinyTree.f(n2) + TinyTree.f(this.attParent[n2]) + TinyTree.f(this.attCode[n2]) + "    " + this.attValue[n2]);
        }
        System.err.println("      ns  parent  prefix     uri");
        for (n2 = 0; n2 < this.numberOfNamespaces; ++n2) {
            System.err.println(TinyTree.f(n2) + TinyTree.f(this.namespaceParent[n2]) + this.namespaceBinding[n2].getPrefix() + "=" + this.namespaceBinding[n2].getURI());
        }
    }

    public static synchronized void diagnosticDump(NodeInfo nodeInfo) {
        if (nodeInfo instanceof TinyNodeImpl) {
            TinyTree tinyTree = ((TinyNodeImpl)nodeInfo).tree;
            System.err.println("Tree containing node " + ((TinyNodeImpl)nodeInfo).nodeNr);
            tinyTree.diagnosticDump();
            return;
        }
        System.err.println("Node is not in a TinyTree");
    }

    private static String f(int n2) {
        String string = "        " + n2;
        return string.substring(string.length() - 8);
    }

    public final void showSize() {
        System.err.println("Tree size: " + this.numberOfNodes + " nodes, " + this.charBuffer.length() + " characters, " + this.numberOfAttributes + " attributes");
    }

    @Override
    public final boolean isTyped() {
        return this.typeArray != null;
    }

    public final int getNumberOfNodes() {
        return this.numberOfNodes;
    }

    public final int getNumberOfAttributes() {
        return this.numberOfAttributes;
    }

    public final int getNumberOfNamespaces() {
        return this.numberOfNamespaces;
    }

    @Override
    public final byte[] getNodeKindArray() {
        return this.nodeKind;
    }

    public final short[] getNodeDepthArray() {
        return this.depth;
    }

    @Override
    public final int[] getNameCodeArray() {
        return this.nameCode;
    }

    public final SchemaType[] getTypeArray() {
        return this.typeArray;
    }

    public final int[] getNextPointerArray() {
        return this.next;
    }

    public final int[] getAlphaArray() {
        return this.alpha;
    }

    public final int[] getBetaArray() {
        return this.beta;
    }

    public final AppendableCharSequence getCharacterBuffer() {
        return this.charBuffer;
    }

    public final CharSequence getCommentBuffer() {
        return this.commentBuffer;
    }

    public final int[] getAttributeNameCodeArray() {
        return this.attCode;
    }

    public final SimpleType[] getAttributeTypeArray() {
        return this.attType;
    }

    public final int[] getAttributeParentArray() {
        return this.attParent;
    }

    public final CharSequence[] getAttributeValueArray() {
        return this.attValue;
    }

    public final NamespaceBinding[] getNamespaceBindings() {
        return this.namespaceBinding;
    }

    public final int[] getNamespaceParentArray() {
        return this.namespaceParent;
    }

    public final boolean isUsesNamespaces() {
        return this.usesNamespaces;
    }

    public final void bulkCopy(TinyTree tinyTree, int n2, int[] nArray, int n3) {
        int n4 = tinyTree.next[n2];
        while (n4 < n2 && n4 >= 0) {
            n4 = tinyTree.next[n4];
        }
        if (n4 == -1 && (n4 = tinyTree.numberOfNodes) - 1 < tinyTree.nodeKind.length && tinyTree.nodeKind[n4 - 1] == 11) {
            --n4;
        }
        assert ((n4 -= n2) > 0);
        this.a((short)1, n4);
        System.arraycopy(tinyTree.nodeKind, n2, this.nodeKind, this.numberOfNodes, n4);
        int n5 = n3 - tinyTree.depth[n2];
        block10: for (int i2 = 0; i2 < n4; ++i2) {
            int n6 = n2 + i2;
            int n7 = this.numberOfNodes + i2;
            this.depth[n7] = (short)(tinyTree.depth[n6] + n5);
            this.next[n7] = tinyTree.next[n6] + (n7 - n6);
            switch (tinyTree.nodeKind[n6]) {
                case 1: {
                    Object object;
                    int n8;
                    int n9;
                    int n10;
                    int n11;
                    int n12;
                    this.nameCode[n7] = tinyTree.nameCode[n6] & 0xFFFFF | this.prefixPool.obtainPrefixCode(tinyTree.getPrefix(n6)) << 20;
                    int n13 = tinyTree.alpha[n6];
                    if (n13 >= 0) {
                        for (n12 = n13; n12 < tinyTree.numberOfAttributes && tinyTree.attParent[n12] == n6; ++n12) {
                        }
                        n11 = n12 - n13;
                        this.d(n11);
                        n10 = n13;
                        this.alpha[n7] = n9 = this.numberOfAttributes;
                        System.arraycopy(tinyTree.attValue, n13, this.attValue, n9, n11);
                        int n14 = n9;
                        Arrays.fill(this.attParent, n14, n14 + n11, n7);
                        n13 = 0;
                        while (n13 < n11) {
                            n8 = this.attCode[n9] = tinyTree.attCode[n10];
                            if (NamePool.isPrefixed(this.attCode[n9])) {
                                object = tinyTree.prefixPool.getPrefix(n8 >> 20);
                                this.attCode[n9] = n8 & 0xFFFFF | this.prefixPool.obtainPrefixCode((String)object) << 20;
                            } else {
                                this.attCode[n9] = n8;
                            }
                            if (tinyTree.isIdAttribute(n10)) {
                                TinyTree tinyTree2 = this;
                                tinyTree2.a(tinyTree2.getNode(n7), tinyTree.attValue[n10].toString());
                            }
                            if (tinyTree.isIdrefAttribute(n10)) {
                                if (this.idRefAttributes == null) {
                                    this.idRefAttributes = new IntHashSet();
                                }
                                this.idRefAttributes.add(n9);
                            }
                            ++n13;
                            ++n10;
                            ++n9;
                        }
                        this.numberOfAttributes += n11;
                    } else {
                        this.alpha[n7] = -1;
                    }
                    if (i2 == 0) {
                        Object object2;
                        n12 = 0;
                        n9 = n3;
                        Object object3 = nArray;
                        n11 = n7;
                        TinyTree tinyTree3 = this;
                        assert (tinyTree3.nodeKind[n11] == 1);
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        --n9;
                        while (n9 >= 0) {
                            int n15;
                            n8 = object3[n9];
                            if (n8 >= 0 && tinyTree3.nodeKind[n8] == 1 && (n15 = tinyTree3.beta[n8]) >= 0) {
                                while (n15 < tinyTree3.numberOfNamespaces && tinyTree3.namespaceParent[n15] == n8) {
                                    object2 = tinyTree3.namespaceBinding[n15];
                                    String string = ((NamespaceBinding)object2).getPrefix();
                                    hashMap.computeIfAbsent(string, arg_0 -> TinyTree.a((NamespaceBinding)object2, arg_0));
                                    ++n15;
                                }
                            }
                            --n9;
                        }
                        object3 = new ArrayList();
                        NamespaceBinding[] namespaceBindingArray = tinyTree.namespaceBinding;
                        n13 = n6;
                        while (n13 != -1 && tinyTree.nodeKind[n13] == 1) {
                            for (n8 = tinyTree.beta[n13]; n8 > 0 && n8 < tinyTree.numberOfNamespaces && tinyTree.namespaceParent[n8] == n13; ++n8) {
                                NamespaceBinding namespaceBinding = namespaceBindingArray[n8];
                                String string = namespaceBinding.getPrefix();
                                if (string.isEmpty()) {
                                    n12 = 1;
                                }
                                if ((object2 = (String)hashMap.get(string)) != null && ((String)object2).equals(string)) continue;
                                object3.add(namespaceBinding);
                            }
                            n13 = TinyNodeImpl.a(tinyTree, n13);
                        }
                        if (n12 == 0 && hashMap.get("") != null) {
                            object3.add(NamespaceBinding.DEFAULT_UNDECLARATION);
                        }
                        n8 = this.numberOfNamespaces;
                        this.e(object3.size());
                        this.beta[n7] = n8;
                        object = object3.iterator();
                        while (object.hasNext()) {
                            NamespaceBinding namespaceBinding = (NamespaceBinding)object.next();
                            this.namespaceBinding[n8++] = namespaceBinding;
                        }
                        Arrays.fill(this.namespaceParent, this.numberOfNamespaces, n8, n7);
                        this.numberOfNamespaces = n8;
                        continue block10;
                    }
                    n12 = tinyTree.beta[n6];
                    if (n12 >= 0) {
                        for (n11 = n12; n11 < tinyTree.numberOfNamespaces && tinyTree.namespaceParent[n11] == n6; ++n11) {
                        }
                        n10 = n11 - n12;
                        this.e(n10);
                        this.beta[n7] = n9 = this.numberOfNamespaces;
                        System.arraycopy(tinyTree.namespaceBinding, n12, this.namespaceBinding, n9, n10);
                        int n16 = n9;
                        Arrays.fill(this.namespaceParent, n16, n16 + n10, n7);
                        this.numberOfNamespaces += n10;
                        continue block10;
                    }
                    this.beta[n7] = -1;
                    continue block10;
                }
                case 17: {
                    int n13 = tinyTree.alpha[n6];
                    int n12 = tinyTree.beta[n6];
                    this.nameCode[n7] = tinyTree.nameCode[n6] & 0xFFFFF | this.prefixPool.obtainPrefixCode(tinyTree.getPrefix(n6)) << 20;
                    this.alpha[n7] = this.charBuffer.length();
                    int n17 = n13;
                    this.a(tinyTree.charBuffer.subSequence(n17, n17 + n12));
                    this.beta[n7] = n12;
                    continue block10;
                }
                case 3: {
                    int n13 = tinyTree.alpha[n6];
                    int n12 = tinyTree.beta[n6];
                    this.nameCode[n7] = -1;
                    this.alpha[n7] = this.charBuffer.length();
                    int n18 = n13;
                    this.a(tinyTree.charBuffer.subSequence(n18, n18 + n12));
                    this.beta[n7] = n12;
                    continue block10;
                }
                case 4: {
                    this.nameCode[n7] = -1;
                    this.alpha[n7] = tinyTree.alpha[n6];
                    this.beta[n7] = tinyTree.beta[n6];
                    continue block10;
                }
                case 8: {
                    int n13 = tinyTree.alpha[n6];
                    int n12 = tinyTree.beta[n6];
                    this.nameCode[n7] = -1;
                    int n19 = n13;
                    CharSequence charSequence = tinyTree.commentBuffer.subSequence(n19, n19 + n12);
                    if (this.commentBuffer == null) {
                        this.commentBuffer = new FastStringBuffer(256);
                    }
                    this.alpha[n7] = this.commentBuffer.length();
                    this.commentBuffer.append(charSequence);
                    this.beta[n7] = n12;
                    continue block10;
                }
                case 7: {
                    int n13 = tinyTree.alpha[n6];
                    int n12 = tinyTree.beta[n6];
                    this.nameCode[n7] = tinyTree.nameCode[n6];
                    int n20 = n13;
                    CharSequence charSequence = tinyTree.commentBuffer.subSequence(n20, n20 + n12);
                    if (this.commentBuffer == null) {
                        this.commentBuffer = new FastStringBuffer(256);
                    }
                    this.alpha[n7] = this.commentBuffer.length();
                    this.commentBuffer.append(charSequence);
                    this.beta[n7] = n12;
                    continue block10;
                }
                case 12: {
                    this.nameCode[n7] = -1;
                    this.alpha[n7] = tinyTree.alpha[n6] + (n7 - n6);
                    this.beta[n7] = -1;
                }
            }
        }
        this.numberOfNodes += n4;
    }

    public final void graft(NodeInfo nodeInfo, int n2, int n3, boolean bl2) {
        assert (nodeInfo.getNodeKind() == 1);
        if (this.externalNodes == null) {
            this.externalNodes = new ArrayList<GraftedElement>();
        }
        int n4 = this.externalNodes.size();
        int n5 = this.getNamePool().allocateFingerprint(nodeInfo.getURI(), nodeInfo.getLocalPart());
        int n6 = this.prefixPool.obtainPrefixCode(nodeInfo.getPrefix());
        n5 = n6 << 20 | n5;
        this.a((short)33, n3, n4, -1, n5);
        this.externalNodes.add(new GraftedElement(this, n2, nodeInfo, bl2));
    }

    public final boolean containsGraftedSubtrees() {
        return this.externalNodes != null;
    }

    private static /* synthetic */ String a(NamespaceBinding namespaceBinding, String string) {
        return namespaceBinding.getURI();
    }
}

