/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.tree.tiny.CompressedWhitespace;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.UntypedAtomicValue;

public final class WhitespaceTextImpl
extends TinyNodeImpl {
    public WhitespaceTextImpl(TinyTree tinyTree, int n2) {
        this.tree = tinyTree;
        this.nodeNr = n2;
    }

    @Override
    public final String getStringValue() {
        return ((TinyNodeImpl)this).getStringValueCS().toString();
    }

    @Override
    public final CharSequence getStringValueCS() {
        long l2 = (long)this.tree.alpha[this.nodeNr] << 32 | (long)this.tree.beta[this.nodeNr] & 0xFFFFFFFFL;
        return new CompressedWhitespace(l2);
    }

    public static CharSequence getStringValueCS(TinyTree tinyTree, int n2) {
        long l2 = (long)tinyTree.alpha[n2] << 32 | (long)tinyTree.beta[n2] & 0xFFFFFFFFL;
        return new CompressedWhitespace(l2);
    }

    public static void appendStringValue(TinyTree tinyTree, int n2, FastStringBuffer fastStringBuffer) {
        long l2 = (long)tinyTree.alpha[n2] << 32 | (long)tinyTree.beta[n2] & 0xFFFFFFFFL;
        CompressedWhitespace.uncompress(l2, fastStringBuffer);
    }

    @Override
    public final AtomicSequence atomize() {
        return new UntypedAtomicValue(((TinyNodeImpl)this).getStringValueCS());
    }

    public static long getLongValue(TinyTree tinyTree, int n2) {
        return (long)tinyTree.alpha[n2] << 32 | (long)tinyTree.beta[n2] & 0xFFFFFFFFL;
    }

    @Override
    public final int getNodeKind() {
        return 3;
    }

    @Override
    public final void copy(Receiver receiver, int n2, Location location) {
        receiver.characters(((TinyNodeImpl)this).getStringValueCS(), location, 0);
    }
}

