/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.util;

import java.util.Arrays;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SimpleType;
import org.xml.sax.Attributes;

public class AttributeCollectionImpl
implements AttributeCollection,
Attributes {
    private Configuration a;
    private NodeName[] b = null;
    private String[] c = null;
    private Location[] d = null;
    private int[] e = null;
    private int f = 0;
    private SimpleType[] g = null;
    public static AttributeCollectionImpl EMPTY_ATTRIBUTE_COLLECTION = new AttributeCollectionImpl(null);

    public AttributeCollectionImpl(Configuration configuration) {
        this.a = configuration;
        this.f = 0;
    }

    public static AttributeCollectionImpl copy(AttributeCollectionImpl attributeCollectionImpl) {
        if (attributeCollectionImpl.getLength() == 0) {
            return EMPTY_ATTRIBUTE_COLLECTION;
        }
        AttributeCollectionImpl attributeCollectionImpl2 = new AttributeCollectionImpl(attributeCollectionImpl.a);
        new AttributeCollectionImpl(attributeCollectionImpl.a).f = attributeCollectionImpl.f;
        attributeCollectionImpl2.b = new NodeName[attributeCollectionImpl.f];
        attributeCollectionImpl2.c = new String[attributeCollectionImpl.f];
        attributeCollectionImpl2.e = new int[attributeCollectionImpl.f];
        attributeCollectionImpl2.d = new Location[attributeCollectionImpl.f];
        System.arraycopy(attributeCollectionImpl.b, 0, attributeCollectionImpl2.b, 0, attributeCollectionImpl.f);
        System.arraycopy(attributeCollectionImpl.c, 0, attributeCollectionImpl2.c, 0, attributeCollectionImpl.f);
        System.arraycopy(attributeCollectionImpl.e, 0, attributeCollectionImpl2.e, 0, attributeCollectionImpl.f);
        System.arraycopy(attributeCollectionImpl.d, 0, attributeCollectionImpl2.d, 0, attributeCollectionImpl.f);
        if (attributeCollectionImpl.g != null) {
            attributeCollectionImpl2.g = new SimpleType[attributeCollectionImpl.f];
            System.arraycopy(attributeCollectionImpl.g, 0, attributeCollectionImpl2.g, 0, attributeCollectionImpl.f);
        }
        return attributeCollectionImpl2;
    }

    public void addAttribute(NodeName nodeName, SimpleType simpleType, String string, Location location, int n2) {
        int n3;
        if (this.c == null) {
            this.b = new NodeName[5];
            this.c = new String[5];
            this.e = new int[5];
            this.d = new Location[5];
            if (!simpleType.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                this.g = new SimpleType[5];
            }
            this.f = 0;
        }
        if (this.c.length == this.f) {
            n3 = this.f == 0 ? 5 : this.f << 1;
            this.b = Arrays.copyOf(this.b, n3);
            this.c = Arrays.copyOf(this.c, n3);
            this.e = Arrays.copyOf(this.e, n3);
            this.d = Arrays.copyOf(this.d, n3);
            if (this.g != null) {
                this.g = Arrays.copyOf(this.g, n3);
            }
        }
        n3 = this.f;
        this.b[n3] = nodeName;
        this.e[n3] = n2;
        this.d[n3] = location.saveLocation();
        this.setTypeAnnotation(n3, simpleType);
        this.c[this.f++] = string;
    }

    public void setAttribute(int n2, NodeName nodeName, SimpleType simpleType, String string, Location location, int n3) {
        this.b[n2] = nodeName;
        this.e[n2] = n3;
        this.d[n2] = location;
        this.setTypeAnnotation(n2, simpleType);
        this.c[n2] = string;
    }

    public void clear() {
        this.f = 0;
    }

    public void compact() {
        if (this.f == 0) {
            this.e = null;
            this.c = null;
            return;
        }
        if (this.c != null && this.c.length > this.f) {
            this.c = Arrays.copyOf(this.c, this.f);
            this.e = Arrays.copyOf(this.e, this.f);
            this.b = Arrays.copyOf(this.b, this.f);
            this.d = Arrays.copyOf(this.d, this.f);
            if (this.g != null) {
                this.g = Arrays.copyOf(this.g, this.f);
            }
        }
    }

    @Override
    public int getLength() {
        if (this.c == null) {
            return 0;
        }
        return this.f;
    }

    @Override
    public int getFingerprint(int n2) {
        if (this.b == null) {
            return -1;
        }
        if (n2 < 0 || n2 >= this.f || this.b[n2] == null) {
            return -1;
        }
        return this.b[n2].obtainFingerprint(this.a.getNamePool());
    }

    @Override
    public NodeName getNodeName(int n2) {
        if (this.b == null) {
            return null;
        }
        if (n2 < 0 || n2 >= this.f) {
            return null;
        }
        return this.b[n2];
    }

    @Override
    public SimpleType getTypeAnnotation(int n2) {
        if (this.g == null) {
            return BuiltInAtomicType.UNTYPED_ATOMIC;
        }
        if (n2 < 0 || n2 >= this.f) {
            return BuiltInAtomicType.UNTYPED_ATOMIC;
        }
        return this.g[n2];
    }

    @Override
    public Location getLocation(int n2) {
        if (this.d == null) {
            return ExplicitLocation.UNKNOWN_LOCATION;
        }
        if (n2 < 0 || n2 >= this.f) {
            return ExplicitLocation.UNKNOWN_LOCATION;
        }
        return this.d[n2];
    }

    @Override
    public String getSystemId(int n2) {
        return this.getLocation(n2).getSystemId();
    }

    @Override
    public int getLineNumber(int n2) {
        return this.getLocation(n2).getLineNumber();
    }

    @Override
    public int getProperties(int n2) {
        if (this.e == null) {
            return -1;
        }
        if (n2 < 0 || n2 >= this.f) {
            return -1;
        }
        return this.e[n2];
    }

    @Override
    public String getPrefix(int n2) {
        if (this.b == null) {
            return null;
        }
        if (n2 < 0 || n2 >= this.f) {
            return null;
        }
        return this.b[n2].getPrefix();
    }

    @Override
    public String getQName(int n2) {
        if (this.b == null) {
            return null;
        }
        if (n2 < 0 || n2 >= this.f) {
            return null;
        }
        return this.b[n2].getDisplayName();
    }

    @Override
    public String getLocalName(int n2) {
        if (this.b == null) {
            return null;
        }
        if (n2 < 0 || n2 >= this.f) {
            return null;
        }
        return this.b[n2].getLocalPart();
    }

    @Override
    public String getURI(int n2) {
        if (this.b == null) {
            return null;
        }
        if (n2 < 0 || n2 >= this.f) {
            return null;
        }
        return this.b[n2].getURI();
    }

    @Override
    public String getType(int n2) {
        n2 = this.getTypeAnnotation(n2).getFingerprint();
        switch (n2) {
            case 560: {
                return "ID";
            }
            case 561: {
                return "IDREF";
            }
            case 556: {
                return "NMTOKEN";
            }
            case 563: {
                return "ENTITY";
            }
            case 562: {
                return "IDREFS";
            }
            case 557: {
                return "NMTOKENS";
            }
            case 564: {
                return "ENTITIES";
            }
        }
        return "CDATA";
    }

    @Override
    public String getType(String string, String string2) {
        int n2 = this.a(string, string2);
        if (n2 < 0) {
            return null;
        }
        return this.getType(n2);
    }

    @Override
    public String getValue(int n2) {
        if (this.c == null) {
            return null;
        }
        if (n2 < 0 || n2 >= this.f) {
            return null;
        }
        return this.c[n2];
    }

    @Override
    public String getValue(String string, String string2) {
        int n2 = this.a(string, string2);
        if (n2 < 0) {
            return null;
        }
        return this.getValue(n2);
    }

    @Override
    public String getValueByFingerprint(int n2) {
        if ((n2 = this.a(n2)) < 0) {
            return null;
        }
        return this.getValue(n2);
    }

    @Override
    public int getIndex(String string) {
        String[] stringArray;
        if (this.b == null) {
            return -1;
        }
        if (string.indexOf(58) < 0) {
            return this.a("", string);
        }
        try {
            stringArray = NameChecker.getQNameParts(string);
        }
        catch (QNameException qNameException) {
            return -1;
        }
        String string2 = stringArray[0];
        if (string2.isEmpty()) {
            return this.a("", string);
        }
        string = stringArray[1];
        for (int i2 = 0; i2 < this.f; ++i2) {
            if (this.b[i2] == null) continue;
            String string3 = this.b[i2].getLocalPart();
            String string4 = this.b[i2].getPrefix();
            if (!string.equals(string3) || !string2.equals(string4)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int getIndex(String string, String string2) {
        return this.a(string, string2);
    }

    @Override
    public int getIndexByFingerprint(int n2) {
        return this.a(n2);
    }

    @Override
    public String getType(String string) {
        int n2 = this.getIndex(string);
        return this.getType(n2);
    }

    @Override
    public String getValue(String string) {
        int n2 = this.getIndex(string);
        return this.getValue(n2);
    }

    public boolean hasAttributeInNamespace(String string) {
        if (this.b == null || this.a == null) {
            return false;
        }
        for (int i2 = 0; i2 < this.f; ++i2) {
            if (this.b[i2] == null || !this.b[i2].hasURI(string)) continue;
            return true;
        }
        return false;
    }

    private int a(String string, String string2) {
        if (this.b == null || this.a == null) {
            return -1;
        }
        for (int i2 = 0; i2 < this.f; ++i2) {
            if (this.b[i2] == null || !this.b[i2].hasURI(string) || !string2.equals(this.b[i2].getLocalPart())) continue;
            return i2;
        }
        return -1;
    }

    private int a(int n2) {
        if (this.b == null || this.a == null) {
            return -1;
        }
        NamePool namePool = this.a.getNamePool();
        for (int i2 = 0; i2 < this.f; ++i2) {
            NodeName nodeName = this.b[i2];
            if (nodeName == null || !(nodeName.hasFingerprint() ? nodeName.getFingerprint() == n2 : nodeName.hasURI(namePool.getURI(n2)) && nodeName.getLocalPart().equals(namePool.getLocalName(n2)))) continue;
            return i2;
        }
        return -1;
    }

    public int findByNodeName(NodeName nodeName) {
        if (this.e == null || this.a == null) {
            return -1;
        }
        if (nodeName.hasFingerprint()) {
            return this.a(nodeName.getFingerprint());
        }
        return this.a(nodeName.getURI(), nodeName.getLocalPart());
    }

    @Override
    public boolean isId(int n2) {
        try {
            return !this.isDeleted(n2) && (StandardNames.XML_ID_NAME.equals(this.b[n2]) || (this.getProperties(n2) & 0x800) != 0 || this.getTypeAnnotation(n2).isIdType());
        }
        catch (MissingComponentException missingComponentException) {
            return false;
        }
    }

    @Override
    public boolean isIdref(int n2) {
        try {
            return this.getTypeAnnotation(n2).isIdRefType();
        }
        catch (MissingComponentException missingComponentException) {
            return false;
        }
    }

    public void removeAttribute(int n2) {
        this.b[n2] = null;
        this.e[n2] = -1;
        this.c[n2] = null;
        this.d[n2] = null;
        if (this.g != null) {
            this.g[n2] = null;
        }
    }

    public boolean isDeleted(int n2) {
        return this.b[n2] == null;
    }

    public void renameAttribute(int n2, NodeName nodeName) {
        this.b[n2] = nodeName;
        if (this.g != null) {
            this.g[n2] = BuiltInAtomicType.UNTYPED_ATOMIC;
        }
    }

    public void replaceAttribute(int n2, CharSequence charSequence) {
        this.c[n2] = charSequence.toString();
    }

    public void setTypeAnnotation(int n2, SimpleType simpleType) {
        block2: {
            block3: {
                block1: {
                    if (!simpleType.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) break block1;
                    if (this.g == null) break block2;
                    break block3;
                }
                if (this.g == null) {
                    this.g = new SimpleType[this.b.length];
                    Arrays.fill(this.g, BuiltInAtomicType.UNTYPED_ATOMIC);
                }
            }
            this.g[n2] = simpleType;
        }
    }

    public void swap(int n2, int n3) {
        Object object = this.b[n2];
        this.b[n2] = this.b[n3];
        this.b[n3] = object;
        if (this.g != null) {
            object = this.g[n2];
            this.g[n2] = this.g[n3];
            this.g[n3] = object;
        }
        object = this.c[n2];
        this.c[n2] = this.c[n3];
        this.c[n3] = object;
        int n4 = this.e[n2];
        this.e[n2] = this.e[n3];
        this.e[n3] = n4;
        Location location = this.d[n2];
        this.d[n2] = this.d[n3];
        this.d[n3] = location;
    }
}

