/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.util;

import java.io.Writer;
import java.util.Arrays;
import net.sf.saxon.regex.BMPString;
import net.sf.saxon.regex.GeneralUnicodeString;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.tree.tiny.AppendableCharSequence;
import net.sf.saxon.tree.tiny.CharSlice;
import net.sf.saxon.tree.tiny.CompressedWhitespace;

public final class FastStringBuffer
implements AppendableCharSequence {
    public static final int C16 = 16;
    public static final int C64 = 64;
    public static final int C256 = 256;
    public static final int C1024 = 1024;
    private char[] a;
    private int b = 0;

    public FastStringBuffer(int n2) {
        this.a = new char[n2];
    }

    public FastStringBuffer(CharSequence charSequence) {
        this.a = new char[charSequence.length()];
        this.append(charSequence);
    }

    public final void append(String string) {
        int n2 = string.length();
        this.ensureCapacity(n2);
        string.getChars(0, n2, this.a, this.b);
        this.b += n2;
    }

    public final void append(CharSlice charSlice) {
        int n2 = charSlice.length();
        this.ensureCapacity(n2);
        charSlice.copyTo(this.a, this.b);
        this.b += n2;
    }

    public final void append(FastStringBuffer fastStringBuffer) {
        int n2 = fastStringBuffer.length();
        this.ensureCapacity(n2);
        fastStringBuffer.getChars(0, n2, this.a, this.b);
        this.b += n2;
    }

    public final void append(StringBuffer stringBuffer) {
        int n2 = stringBuffer.length();
        this.ensureCapacity(n2);
        stringBuffer.getChars(0, n2, this.a, this.b);
        this.b += n2;
    }

    @Override
    public final void append(CharSequence charSequence) {
        int n2;
        block7: {
            while (true) {
                n2 = charSequence.length();
                this.ensureCapacity(n2);
                if (charSequence instanceof CharSlice) {
                    ((CharSlice)charSequence).copyTo(this.a, this.b);
                    break block7;
                }
                if (charSequence instanceof String) {
                    ((String)charSequence).getChars(0, n2, this.a, this.b);
                    break block7;
                }
                if (charSequence instanceof FastStringBuffer) {
                    ((FastStringBuffer)charSequence).getChars(0, n2, this.a, this.b);
                    break block7;
                }
                if (charSequence instanceof CompressedWhitespace) {
                    ((CompressedWhitespace)charSequence).uncompress(this);
                    return;
                }
                if (!(charSequence instanceof BMPString)) break;
                charSequence = ((BMPString)charSequence).getCharSequence();
            }
            if (charSequence instanceof GeneralUnicodeString) {
                for (n2 = 0; n2 < ((UnicodeString)((GeneralUnicodeString)charSequence)).uLength(); ++n2) {
                    this.appendWideChar(((UnicodeString)((GeneralUnicodeString)charSequence)).uCharAt(n2));
                }
                return;
            }
            charSequence.toString().getChars(0, n2, this.a, this.b);
        }
        this.b += n2;
    }

    public final void append(char[] cArray, int n2, int n3) {
        this.ensureCapacity(n3);
        System.arraycopy(cArray, n2, this.a, this.b, n3);
        this.b += n3;
    }

    public final void append(char[] cArray) {
        int n2 = cArray.length;
        this.ensureCapacity(n2);
        System.arraycopy(cArray, 0, this.a, this.b, n2);
        this.b += n2;
    }

    public final void append(char c2) {
        this.ensureCapacity(1);
        this.a[this.b++] = c2;
    }

    public final void appendWideChar(int n2) {
        if (n2 > 65535) {
            this.append(UTF16CharacterSet.highSurrogate(n2));
            this.append(UTF16CharacterSet.lowSurrogate(n2));
            return;
        }
        this.append((char)n2);
    }

    public final void append(UnicodeString unicodeString) {
        if (unicodeString instanceof BMPString) {
            this.append(((BMPString)unicodeString).getCharSequence());
            return;
        }
        for (int i2 = 0; i2 < unicodeString.uLength(); ++i2) {
            this.appendWideChar(unicodeString.uCharAt(i2));
        }
    }

    public final void prependWideChar(int n2) {
        if (n2 > 65535) {
            this.prepend(UTF16CharacterSet.lowSurrogate(n2));
            this.prepend(UTF16CharacterSet.highSurrogate(n2));
            return;
        }
        this.prepend((char)n2);
    }

    @Override
    public final int length() {
        return this.b;
    }

    @Override
    public final boolean isEmpty() {
        return this.b == 0;
    }

    @Override
    public final char charAt(int n2) {
        if (n2 >= this.b) {
            throw new IndexOutOfBoundsException("" + n2);
        }
        return this.a[n2];
    }

    @Override
    public final CharSequence subSequence(int n2, int n3) {
        return new CharSlice(this.a, n2, n3 - n2);
    }

    public final void getChars(int n2, int n3, char[] cArray, int n4) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 > this.b) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        if (n2 > n3) {
            throw new StringIndexOutOfBoundsException(n3 - n2);
        }
        System.arraycopy(this.a, n2, cArray, n4, n3 - n2);
    }

    public final int indexOf(char c2) {
        for (int i2 = 0; i2 < this.b; ++i2) {
            if (this.a[i2] != c2) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public final String toString() {
        this.condense();
        return new String(this.a, 0, this.b);
    }

    public final boolean equals(Object object) {
        return object instanceof CharSequence && this.toString().equals(object.toString());
    }

    public final int hashCode() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.b; ++i2) {
            n2 = n2 * 31 + this.a[i2];
        }
        return n2;
    }

    public final char[] toCharArray() {
        if (this.b == this.a.length) {
            return this.a;
        }
        char[] cArray = new char[this.b];
        System.arraycopy(this.a, 0, cArray, 0, this.b);
        return cArray;
    }

    public final void setCharAt(int n2, char c2) {
        if (n2 < 0 || n2 > this.b) {
            throw new IndexOutOfBoundsException("" + n2);
        }
        this.a[n2] = c2;
    }

    public final void insert(int n2, char c2) {
        if (n2 < 0 || n2 > this.b) {
            throw new IndexOutOfBoundsException("" + n2);
        }
        this.ensureCapacity(1);
        System.arraycopy(this.a, n2, this.a, n2 + 1, this.b - n2);
        ++this.b;
        this.a[n2] = c2;
    }

    public final void insertWideChar(int n2, int n3) {
        if (n2 < 0 || n2 > this.b) {
            throw new IndexOutOfBoundsException("" + n2);
        }
        if (n3 > 65535) {
            this.ensureCapacity(2);
            System.arraycopy(this.a, n2, this.a, n2 + 2, this.b - n2);
            this.b += 2;
            this.a[n2] = UTF16CharacterSet.highSurrogate(n3);
            this.a[n2 + 1] = UTF16CharacterSet.lowSurrogate(n3);
            return;
        }
        this.ensureCapacity(1);
        System.arraycopy(this.a, n2, this.a, n2 + 1, this.b - n2);
        ++this.b;
        this.a[n2] = (char)n3;
    }

    public final void removeCharAt(int n2) {
        if (n2 < 0 || n2 > this.b) {
            throw new IndexOutOfBoundsException("" + n2);
        }
        --this.b;
        System.arraycopy(this.a, n2 + 1, this.a, n2, this.b - n2);
    }

    public final void prepend(char c2) {
        char[] cArray = new char[this.a.length + 1];
        System.arraycopy(this.a, 0, cArray, 1, this.b);
        cArray[0] = c2;
        ++this.b;
        this.a = cArray;
    }

    public final void prepend(CharSequence charSequence) {
        int n2 = charSequence.length();
        char[] cArray = new char[this.a.length + n2];
        System.arraycopy(this.a, 0, cArray, n2, this.b);
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[i2] = charSequence.charAt(i2);
        }
        this.b += n2;
        this.a = cArray;
    }

    public final void prependRepeated(char c2, int n2) {
        if (n2 > 0) {
            char[] cArray = new char[this.a.length + n2];
            System.arraycopy(this.a, 0, cArray, n2, this.b);
            Arrays.fill(cArray, 0, n2, c2);
            this.b += n2;
            this.a = cArray;
        }
    }

    @Override
    public final void setLength(int n2) {
        if (n2 < 0 || n2 > this.b) {
            return;
        }
        this.b = n2;
    }

    public final void ensureCapacity(int n2) {
        if (this.b + n2 > this.a.length) {
            int n3 = this.a.length << 1;
            if (n3 < this.b + n2) {
                n3 = this.b + (n2 << 1);
            }
            this.a = Arrays.copyOf(this.a, n3);
        }
    }

    public final FastStringBuffer condense() {
        if (this.a.length - this.b > 256 || this.a.length > this.b << 1 && this.a.length - this.b > 20) {
            this.a = Arrays.copyOf(this.a, this.b);
        }
        return this;
    }

    public final void write(Writer writer) {
        writer.write(this.a, 0, this.b);
    }

    public static String diagnosticPrint(CharSequence charSequence) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length() << 1);
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 > ' ' && c2 < '\u007f') {
                fastStringBuffer.append(c2);
                continue;
            }
            fastStringBuffer.append("\\u");
            for (int i3 = 12; i3 >= 0; i3 -= 4) {
                fastStringBuffer.append("0123456789ABCDEF".charAt(c2 >> i3 & 0xF));
            }
        }
        return fastStringBuffer.toString();
    }
}

