/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.InScopeNamespaces;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.tiny.TinyNodeImpl;

public class NamespaceIterator
implements Iterator<NamespaceBinding> {
    private NodeInfo a;
    private int b;
    private NamespaceBinding c;
    private NamespaceBinding[] d;
    private HashSet<String> e;

    public static Iterator<NamespaceBinding> iterateNamespaces(NodeInfo iterable) {
        if (iterable.getNodeKind() == 1) {
            return new NamespaceIterator((NodeInfo)iterable);
        }
        iterable = Collections.emptyList();
        return iterable.iterator();
    }

    public static void sendNamespaces(NodeInfo nodeInfo, Receiver receiver) {
        if (nodeInfo instanceof TinyNodeImpl && !((TinyNodeImpl)nodeInfo).getTree().isUsesNamespaces()) {
            return;
        }
        while (nodeInfo != null && nodeInfo.getNodeKind() == 1) {
            NamespaceBinding[] namespaceBindingArray = nodeInfo.getDeclaredNamespaces(null);
            if (namespaceBindingArray.length > 0) {
                receiver.namespace(new InScopeNamespaces(nodeInfo), 0);
                return;
            }
            nodeInfo = nodeInfo.getParent();
        }
    }

    private NamespaceIterator(NodeInfo nodeInfo) {
        this.a = nodeInfo;
        this.e = new HashSet(8);
        this.b = 0;
        this.d = nodeInfo.getDeclaredNamespaces(null);
    }

    @Override
    public boolean hasNext() {
        block6: {
            NamespaceBinding namespaceBinding;
            if (this.a == null || this.c == null && this.b != 0) {
                return false;
            }
            NamespaceIterator namespaceIterator = this;
            while (true) {
                boolean bl2 = namespaceIterator.b >= namespaceIterator.d.length;
                namespaceBinding = null;
                if (!bl2) {
                    boolean bl3 = bl2 = (namespaceBinding = namespaceIterator.d[namespaceIterator.b++]) == null;
                }
                if (bl2) {
                    namespaceIterator.a = namespaceIterator.a.getParent();
                    if (namespaceIterator.a != null && namespaceIterator.a.getNodeKind() == 1) {
                        namespaceIterator.d = namespaceIterator.a.getDeclaredNamespaces(namespaceIterator.d);
                        namespaceIterator.b = 0;
                        continue;
                    }
                    namespaceIterator.c = null;
                    break block6;
                }
                String string = namespaceBinding.getURI();
                String string2 = namespaceBinding.getPrefix();
                if (string.isEmpty()) {
                    namespaceIterator.e.add(string2);
                    continue;
                }
                if (namespaceIterator.e.add(string2)) break;
            }
            namespaceIterator.c = namespaceBinding;
        }
        return this.c != null;
    }

    @Override
    public NamespaceBinding next() {
        return this.c;
    }
}

