/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AbsolutePath;
import net.sf.saxon.om.CopyOptions;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.LocalNameTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NamespaceTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.SameNameTest;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.iter.ReversibleIterator;
import net.sf.saxon.tree.iter.SingleNodeIterator;
import net.sf.saxon.tree.tiny.TinyElementImpl;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyTextualElement;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.NamespaceIterator;
import net.sf.saxon.tree.wrapper.SiblingCountingNode;
import net.sf.saxon.tree.wrapper.VirtualCopy;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.UType;
import net.sf.saxon.type.Untyped;

public final class Navigator {
    private static int[] a = new int[]{-1, 3, 2, 3, -1, -1, -1, 3, 3, 0, -1, -1, -1, 1};

    private Navigator() {
    }

    public static String getAttributeValue(NodeInfo nodeInfo, String string, String string2) {
        return nodeInfo.getAttributeValue(string, string2);
    }

    public static String getInheritedAttributeValue(NodeInfo nodeInfo, String string, String string2) {
        while (nodeInfo != null) {
            String string3 = nodeInfo.getAttributeValue(string, string2);
            if (string3 == null) {
                nodeInfo = nodeInfo.getParent();
                continue;
            }
            return string3;
        }
        return null;
    }

    public static StructuredQName getNodeName(NodeInfo nodeInfo) {
        if (nodeInfo.getLocalPart() != null) {
            return new StructuredQName(nodeInfo.getPrefix(), nodeInfo.getURI(), nodeInfo.getLocalPart());
        }
        return null;
    }

    public static NodeInfo getOutermostElement(TreeInfo treeInfo) {
        return treeInfo.getRootNode().iterateAxis((byte)3, NodeKindTest.ELEMENT).next();
    }

    public static NodeTest makeNodeTest(NamePool namePool, int n2, String string, String string2) {
        if (string == null && string2 == null) {
            return NodeKindTest.makeNodeKindTest(n2);
        }
        if (string == null) {
            return new LocalNameTest(namePool, n2, string2);
        }
        if (string2 == null) {
            return new NamespaceTest(namePool, n2, string);
        }
        int n3 = namePool.allocateFingerprint(string, string2);
        return new NameTest(n2, n3, namePool);
    }

    public static String getBaseURI(NodeInfo nodeInfo2) {
        return Navigator.getBaseURI(nodeInfo2, nodeInfo -> {
            NodeInfo nodeInfo2 = nodeInfo.getParent();
            return nodeInfo2 == null || !nodeInfo2.getSystemId().equals(nodeInfo.getSystemId());
        });
    }

    public static String getBaseURI(NodeInfo object, Predicate<NodeInfo> predicate) {
        String string = object instanceof TinyElementImpl ? ((TinyElementImpl)object).getAttributeValue(385) : object.getAttributeValue("http://www.w3.org/XML/1998/namespace", "base");
        if (string != null) {
            Object object2;
            try {
                object2 = new URI(string);
                if (!((URI)object2).isAbsolute()) {
                    NodeInfo nodeInfo = object.getParent();
                    if (nodeInfo == null) {
                        URI uRI = new URI(object.getSystemId());
                        object = string.isEmpty() ? uRI : uRI.resolve((URI)object2);
                        return ((URI)object).toString();
                    }
                    String string2 = object.getSystemId();
                    if (string2 == null) {
                        return null;
                    }
                    nodeInfo.getSystemId();
                    if (object instanceof TinyElementImpl) {
                        ((TinyElementImpl)object).getTree().isTopWithinEntity(((TinyElementImpl)object).getNodeNumber());
                    }
                    object = new URI(predicate.test((NodeInfo)object) ? string2 : nodeInfo.getBaseURI());
                    object2 = string.isEmpty() ? object : ((URI)object).resolve((URI)object2);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                return string;
            }
            return ((URI)object2).toString();
        }
        String string3 = object.getSystemId();
        if (string3 == null) {
            return null;
        }
        NodeInfo nodeInfo = object.getParent();
        if (nodeInfo == null) {
            return string3;
        }
        String string4 = nodeInfo.getSystemId();
        if (string3.equals(string4) || string4.isEmpty()) {
            return nodeInfo.getBaseURI();
        }
        return string3;
    }

    public static String getPath(NodeInfo nodeInfo) {
        return Navigator.getPath(nodeInfo, null);
    }

    public static String getPath(NodeInfo object, XPathContext xPathContext) {
        if (object == null) {
            return "";
        }
        boolean bl2 = object.getConfiguration().isStreamedNode((NodeInfo)object);
        Object object2 = object.getParent();
        switch (object.getNodeKind()) {
            case 9: {
                return "/";
            }
            case 1: {
                if (object2 == null) {
                    return object.getDisplayName();
                }
                if (((String)(object2 = Navigator.getPath((NodeInfo)object2, xPathContext))).equals("/")) {
                    return "/" + object.getDisplayName();
                }
                return (String)object2 + '/' + object.getDisplayName() + (bl2 ? "" : "[" + Navigator.getNumberSimple((NodeInfo)object, xPathContext) + "]");
            }
            case 2: {
                return Navigator.getPath((NodeInfo)object2, xPathContext) + "/@" + object.getDisplayName();
            }
            case 3: {
                object2 = Navigator.getPath((NodeInfo)object2, xPathContext);
                return (String)(((String)object2).equals("/") ? "" : object2) + "/text()" + (bl2 ? "" : "[" + Navigator.getNumberSimple((NodeInfo)object, xPathContext) + "]");
            }
            case 8: {
                object2 = Navigator.getPath((NodeInfo)object2, xPathContext);
                return (String)(((String)object2).equals("/") ? "" : object2) + "/comment()" + (bl2 ? "" : "[" + Navigator.getNumberSimple((NodeInfo)object, xPathContext) + "]");
            }
            case 7: {
                object2 = Navigator.getPath((NodeInfo)object2, xPathContext);
                return (String)(((String)object2).equals("/") ? "" : object2) + "/processing-instruction()" + (bl2 ? "" : "[" + Navigator.getNumberSimple((NodeInfo)object, xPathContext) + "]");
            }
            case 13: {
                object = object.getLocalPart();
                if (((String)object).isEmpty()) {
                    object = "*[not(local-name()]";
                }
                return Navigator.getPath((NodeInfo)object2, xPathContext) + "/namespace::" + (String)object;
            }
        }
        return "";
    }

    public static AbsolutePath getAbsolutePath(NodeInfo object) {
        boolean bl2 = object.getConfiguration().isStreamedNode((NodeInfo)object);
        LinkedList<AbsolutePath.PathElement> linkedList = new LinkedList<AbsolutePath.PathElement>();
        String string = object.getSystemId();
        while (object != null && object.getNodeKind() != 9) {
            linkedList.add(0, new AbsolutePath.PathElement(object.getNodeKind(), NameOfNode.makeName((NodeInfo)object), bl2 ? -1 : Navigator.getNumberSimple((NodeInfo)object, null)));
            object = object.getParent();
        }
        object = new AbsolutePath(linkedList);
        ((AbsolutePath)object).setSystemId(string);
        return object;
    }

    public static boolean haveSameName(NodeInfo nodeInfo, NodeInfo nodeInfo2) {
        if (nodeInfo.hasFingerprint() && nodeInfo2.hasFingerprint()) {
            return nodeInfo.getFingerprint() == nodeInfo2.getFingerprint();
        }
        return nodeInfo.getLocalPart().equals(nodeInfo2.getLocalPart()) && nodeInfo.getURI().equals(nodeInfo2.getURI());
    }

    public static int getNumberSimple(NodeInfo nodeInfo, XPathContext object) {
        NodeInfo nodeInfo2;
        Object object2 = nodeInfo.getLocalPart().isEmpty() ? NodeKindTest.makeNodeKindTest(nodeInfo.getNodeKind()) : new SameNameTest(nodeInfo);
        object = object == null ? null : object.getController();
        object2 = nodeInfo.iterateAxis((byte)11, (NodeTest)object2);
        int n2 = 1;
        while ((nodeInfo2 = object2.next()) != null) {
            int n3;
            if (object != null && (n3 = ((Controller)object).getRememberedNumber(nodeInfo2)) > 0) {
                ((Controller)object).setRememberedNumber(nodeInfo, n3 += n2);
                return n3;
            }
            ++n2;
        }
        if (object != null) {
            ((Controller)object).setRememberedNumber(nodeInfo, n2);
        }
        return n2;
    }

    public static int getNumberSingle(NodeInfo nodeInfo, Pattern pattern, Pattern pattern2, XPathContext xPathContext) {
        block9: {
            if (pattern == null && pattern2 == null) {
                return Navigator.getNumberSimple(nodeInfo, xPathContext);
            }
            boolean bl2 = false;
            if (pattern == null) {
                pattern = nodeInfo.getLocalPart().isEmpty() ? new NodeTestPattern(NodeKindTest.makeNodeKindTest(nodeInfo.getNodeKind())) : new NodeTestPattern(new SameNameTest(nodeInfo));
                bl2 = true;
            }
            if (!bl2) {
                do {
                    if (pattern.matches(nodeInfo, xPathContext)) {
                        if (pattern2 != null) {
                            NodeInfo nodeInfo2 = nodeInfo;
                            while (!pattern2.matches(nodeInfo2, xPathContext)) {
                                if ((nodeInfo2 = nodeInfo2.getParent()) != null) continue;
                                return 0;
                            }
                        }
                        break block9;
                    }
                    if (pattern2 == null || !pattern2.matches(nodeInfo, xPathContext)) continue;
                    return 0;
                } while ((nodeInfo = nodeInfo.getParent()) != null);
                return 0;
            }
        }
        AxisIterator axisIterator = nodeInfo.iterateAxis((byte)11, Navigator.a(pattern));
        boolean bl3 = pattern instanceof NodeTestPattern;
        int n2 = 1;
        NodeInfo nodeInfo3;
        while ((nodeInfo3 = (NodeInfo)axisIterator.next()) != null) {
            if (!bl3 && !pattern.matches(nodeInfo3, xPathContext)) continue;
            ++n2;
        }
        return n2;
    }

    public static int getNumberAny(Expression expression, NodeInfo nodeInfo, Pattern pattern, Pattern pattern2, XPathContext xPathContext, boolean bl2) {
        Object[] objectArray;
        Object[] objectArray2;
        NodeInfo nodeInfo2 = null;
        int n2 = 0;
        Controller controller = xPathContext.getController();
        assert (controller != null);
        if ((bl2 = !bl2 && pattern2 == null) && (objectArray2 = (Object[])controller.getUserData(expression.getLocation(), "xsl:number")) != null) {
            nodeInfo2 = (NodeInfo)objectArray2[0];
            n2 = (Integer)objectArray2[1];
        }
        int n3 = 0;
        if (pattern == null) {
            pattern = nodeInfo.getLocalPart().isEmpty() ? new NodeTestPattern(NodeKindTest.makeNodeKindTest(nodeInfo.getNodeKind())) : new NodeTestPattern(new SameNameTest(nodeInfo));
            n3 = 1;
        } else if (pattern.matches(nodeInfo, xPathContext)) {
            n3 = 1;
        }
        Object object = pattern2 == null ? Navigator.a(pattern) : (pattern2.getUType() == UType.ELEMENT && pattern.getUType() == UType.ELEMENT ? NodeKindTest.ELEMENT : AnyNodeTest.getInstance());
        if (pattern2 != null && pattern2.matches(nodeInfo, xPathContext)) {
            return n3;
        }
        object = nodeInfo.iterateAxis((byte)13, (NodeTest)object);
        while ((objectArray = (Object[])object.next()) != null) {
            if (pattern.matches((Item<?>)objectArray, xPathContext)) {
                if (n3 == 1 && objectArray.equals(nodeInfo2)) {
                    n3 = n2 + 1;
                    break;
                }
                ++n3;
            }
            if (pattern2 == null || !pattern2.matches((Item<?>)objectArray, xPathContext)) continue;
        }
        if (bl2) {
            Object[] objectArray3 = new Object[2];
            objectArray = objectArray3;
            objectArray3[0] = nodeInfo;
            objectArray[1] = n3;
            controller.setUserData(expression.getLocation(), "xsl:number", objectArray);
        }
        return n3;
    }

    public static List<Long> getNumberMulti(NodeInfo nodeInfo, Pattern pattern, Pattern pattern2, XPathContext xPathContext) {
        ArrayList<Long> arrayList = new ArrayList<Long>(5);
        if (pattern == null) {
            pattern = nodeInfo.getLocalPart().isEmpty() ? new NodeTestPattern(NodeKindTest.makeNodeKindTest(nodeInfo.getNodeKind())) : new NodeTestPattern(new SameNameTest(nodeInfo));
        }
        do {
            if (!pattern.matches(nodeInfo, xPathContext)) continue;
            int n2 = Navigator.getNumberSingle(nodeInfo, pattern, null, xPathContext);
            arrayList.add(0, Long.valueOf(n2));
        } while ((pattern2 == null || !pattern2.matches(nodeInfo, xPathContext)) && (nodeInfo = nodeInfo.getParent()) != null);
        return arrayList;
    }

    private static NodeTest a(Pattern pattern) {
        ItemType itemType = ((Expression)pattern).getItemType();
        if (itemType instanceof NodeTest) {
            return (NodeTest)itemType;
        }
        if (pattern.getUType().overlaps(UType.ANY_NODE)) {
            return AnyNodeTest.getInstance();
        }
        return ErrorType.getInstance();
    }

    public static void copy(NodeInfo nodeInfo, Receiver receiver, int n2, Location location) {
        switch (nodeInfo.getNodeKind()) {
            case 9: {
                NodeInfo nodeInfo2;
                receiver.startDocument(CopyOptions.getStartDocumentProperties(n2));
                AxisIterator axisIterator = nodeInfo.iterateAxis((byte)3, AnyNodeTest.getInstance());
                while ((nodeInfo2 = axisIterator.next()) != null) {
                    nodeInfo2.copy(receiver, n2, location);
                }
                receiver.endDocument();
                return;
            }
            case 1: {
                NodeInfo nodeInfo3;
                Object object = (n2 & 4) != 0 ? nodeInfo.getSchemaType() : Untyped.getInstance();
                receiver.startElement(NameOfNode.makeName(nodeInfo), (SchemaType)object, location, 0);
                if ((n2 & 1) != 0) {
                    NamespaceBinding namespaceBinding;
                    NamespaceBinding[] namespaceBindingArray = nodeInfo.getDeclaredNamespaces(null);
                    object = namespaceBindingArray;
                    int n3 = namespaceBindingArray.length;
                    for (int i2 = 0; i2 < n3 && (namespaceBinding = object[i2]) != null; ++i2) {
                        receiver.namespace(namespaceBinding, 0);
                    }
                } else if ((n2 & 2) != 0) {
                    NamespaceIterator.sendNamespaces(nodeInfo, receiver);
                }
                AxisIterator axisIterator = nodeInfo.iterateAxis((byte)2, AnyNodeTest.getInstance());
                while ((object = axisIterator.next()) != null) {
                    object.copy(receiver, n2, location);
                }
                receiver.startContent();
                object = nodeInfo.iterateAxis((byte)3, AnyNodeTest.getInstance());
                int n4 = n2;
                if ((n2 & 2) != 0) {
                    n4 = n2 & 0xFFFFFFFD | 1;
                }
                while ((nodeInfo3 = object.next()) != null) {
                    nodeInfo3.copy(receiver, n4, location);
                }
                receiver.endElement();
                return;
            }
            case 2: {
                BuiltInAtomicType builtInAtomicType = (n2 & 4) != 0 ? (SimpleType)nodeInfo.getSchemaType() : BuiltInAtomicType.UNTYPED_ATOMIC;
                receiver.attribute(NameOfNode.makeName(nodeInfo), builtInAtomicType, nodeInfo.getStringValueCS(), location, 0);
                return;
            }
            case 3: {
                CharSequence charSequence = nodeInfo.getStringValueCS();
                if (charSequence.length() != 0) {
                    receiver.characters(charSequence, location, 0);
                }
                return;
            }
            case 8: {
                receiver.comment(nodeInfo.getStringValueCS(), location, 0);
                return;
            }
            case 7: {
                receiver.processingInstruction(nodeInfo.getLocalPart(), nodeInfo.getStringValueCS(), location, 0);
                return;
            }
            case 13: {
                receiver.namespace(new NamespaceBinding(nodeInfo.getLocalPart(), nodeInfo.getStringValue()), 0);
                return;
            }
        }
    }

    public static int compareOrder(SiblingCountingNode nodeInfo, SiblingCountingNode nodeInfo2) {
        NodeInfo nodeInfo3;
        if (((Object)nodeInfo).equals(nodeInfo2)) {
            return 0;
        }
        NodeInfo nodeInfo4 = nodeInfo.getParent();
        if (nodeInfo4 == null) {
            return -1;
        }
        NodeInfo nodeInfo5 = nodeInfo2.getParent();
        if (nodeInfo5 == null) {
            return 1;
        }
        if (nodeInfo4.equals(nodeInfo5)) {
            int n2;
            int n3 = a[nodeInfo.getNodeKind()];
            if (n3 == (n2 = a[nodeInfo2.getNodeKind()])) {
                return nodeInfo.getSiblingPosition() - nodeInfo2.getSiblingPosition();
            }
            return n3 - n2;
        }
        int n4 = 0;
        int n5 = 0;
        NodeInfo nodeInfo6 = nodeInfo2;
        for (nodeInfo3 = nodeInfo; nodeInfo3 != null; nodeInfo3 = nodeInfo3.getParent()) {
            ++n4;
        }
        while (nodeInfo6 != null) {
            ++n5;
            nodeInfo6 = nodeInfo6.getParent();
        }
        nodeInfo3 = nodeInfo;
        while (n4 > n5) {
            nodeInfo3 = nodeInfo3.getParent();
            assert (nodeInfo3 != null);
            if (nodeInfo3.equals(nodeInfo2)) {
                return 1;
            }
            --n4;
        }
        nodeInfo6 = nodeInfo2;
        while (n5 > n4) {
            nodeInfo6 = nodeInfo6.getParent();
            assert (nodeInfo6 != null);
            if (nodeInfo6.equals(nodeInfo)) {
                return -1;
            }
            --n5;
        }
        while (true) {
            nodeInfo = nodeInfo3.getParent();
            nodeInfo2 = nodeInfo6.getParent();
            if (nodeInfo == null || nodeInfo2 == null) {
                throw new NullPointerException("Node order comparison - internal error");
            }
            if (nodeInfo.equals(nodeInfo2)) {
                if (nodeInfo3.getNodeKind() == 2 && nodeInfo6.getNodeKind() != 2) {
                    return -1;
                }
                if (nodeInfo3.getNodeKind() != 2 && nodeInfo6.getNodeKind() == 2) {
                    return 1;
                }
                return ((SiblingCountingNode)nodeInfo3).getSiblingPosition() - ((SiblingCountingNode)nodeInfo6).getSiblingPosition();
            }
            nodeInfo3 = nodeInfo;
            nodeInfo6 = nodeInfo2;
        }
    }

    public static int comparePosition(NodeInfo nodeInfo, NodeInfo nodeInfo2) {
        NodeInfo nodeInfo3;
        if (nodeInfo.getNodeKind() == 2 || nodeInfo.getNodeKind() == 13 || nodeInfo2.getNodeKind() == 2 || nodeInfo2.getNodeKind() == 13) {
            throw new UnsupportedOperationException();
        }
        if (nodeInfo.equals(nodeInfo2)) {
            return 12;
        }
        NodeInfo nodeInfo4 = nodeInfo.getParent();
        if (nodeInfo4 == null) {
            return 0;
        }
        NodeInfo nodeInfo5 = nodeInfo2.getParent();
        if (nodeInfo5 == null) {
            return 4;
        }
        if (nodeInfo4.equals(nodeInfo5)) {
            if (nodeInfo.compareOrder(nodeInfo2) < 0) {
                return 10;
            }
            return 6;
        }
        int n2 = 0;
        int n3 = 0;
        NodeInfo nodeInfo6 = nodeInfo2;
        for (nodeInfo3 = nodeInfo; nodeInfo3 != null; nodeInfo3 = nodeInfo3.getParent()) {
            ++n2;
        }
        while (nodeInfo6 != null) {
            ++n3;
            nodeInfo6 = nodeInfo6.getParent();
        }
        nodeInfo3 = nodeInfo;
        while (n2 > n3) {
            nodeInfo3 = nodeInfo3.getParent();
            assert (nodeInfo3 != null);
            if (nodeInfo3.equals(nodeInfo2)) {
                return 4;
            }
            --n2;
        }
        nodeInfo6 = nodeInfo2;
        while (n3 > n2) {
            nodeInfo6 = nodeInfo6.getParent();
            assert (nodeInfo6 != null);
            if (nodeInfo6.equals(nodeInfo)) {
                return 0;
            }
            --n3;
        }
        if (nodeInfo.compareOrder(nodeInfo2) < 0) {
            return 10;
        }
        return 6;
    }

    public static void appendSequentialKey(SiblingCountingNode siblingCountingNode, FastStringBuffer fastStringBuffer, boolean bl2) {
        if (bl2) {
            fastStringBuffer.append('w');
            fastStringBuffer.append(Long.toString(siblingCountingNode.getTreeInfo().getDocumentNumber()));
        }
        if (siblingCountingNode.getNodeKind() != 9) {
            NodeInfo nodeInfo = siblingCountingNode.getParent();
            if (nodeInfo != null) {
                Navigator.appendSequentialKey((SiblingCountingNode)nodeInfo, fastStringBuffer, false);
            }
            if (siblingCountingNode.getNodeKind() == 2) {
                fastStringBuffer.append('A');
            }
        }
        fastStringBuffer.append(Navigator.alphaKey(siblingCountingNode.getSiblingPosition()));
    }

    public static String alphaKey(int n2) {
        if (n2 <= 0) {
            return "a";
        }
        if (n2 < 10) {
            return "b" + n2;
        }
        if (n2 < 100) {
            return "c" + n2;
        }
        if (n2 < 1000) {
            return "d" + n2;
        }
        if (n2 < 10000) {
            return "e" + n2;
        }
        if (n2 < 100000) {
            return "f" + n2;
        }
        if (n2 < 1000000) {
            return "g" + n2;
        }
        if (n2 < 10000000) {
            return "h" + n2;
        }
        if (n2 < 100000000) {
            return "i" + n2;
        }
        if (n2 < 1000000000) {
            return "j" + n2;
        }
        return "k" + n2;
    }

    public static boolean isAncestorOrSelf(NodeInfo nodeInfo, NodeInfo nodeInfo2) {
        int n2 = nodeInfo.getNodeKind();
        if (n2 != 1 && n2 != 9) {
            return nodeInfo.equals(nodeInfo2);
        }
        if (nodeInfo instanceof TinyNodeImpl) {
            if (nodeInfo2 instanceof TinyNodeImpl) {
                return ((TinyNodeImpl)nodeInfo).isAncestorOrSelf((TinyNodeImpl)nodeInfo2);
            }
            if (nodeInfo2 instanceof TinyTextualElement.TinyTextualElementText) {
                return nodeInfo.equals(nodeInfo2) || Navigator.isAncestorOrSelf(nodeInfo, nodeInfo2.getParent());
            }
            if (nodeInfo2.getNodeKind() != 13 && !(nodeInfo2 instanceof VirtualCopy)) {
                return false;
            }
        }
        while (nodeInfo2 != null) {
            if (nodeInfo.equals(nodeInfo2)) {
                return true;
            }
            nodeInfo2 = nodeInfo2.getParent();
        }
        return false;
    }

    public static AxisIterator filteredSingleton(NodeInfo nodeInfo, NodeTest nodeTest) {
        if (nodeInfo != null && nodeTest.matchesNode(nodeInfo)) {
            return SingleNodeIterator.makeIterator(nodeInfo);
        }
        return EmptyIterator.OfNodes.THE_INSTANCE;
    }

    public static int getSiblingPosition(NodeInfo object, NodeTest nodeTest, int n2) {
        if (object instanceof SiblingCountingNode && nodeTest instanceof AnyNodeTest) {
            return ((SiblingCountingNode)object).getSiblingPosition();
        }
        object = object.iterateAxis((byte)11, nodeTest);
        int n3 = 1;
        while (object.next() != null) {
            if (++n3 <= n2) continue;
            return n3;
        }
        return n3;
    }

    public static final class PrecedingEnumeration
    implements AxisIterator {
        private NodeInfo a;
        private AncestorEnumeration b;
        private AxisIterator c = null;
        private DescendantEnumeration d = null;
        private boolean e;

        public PrecedingEnumeration(NodeInfo nodeInfo, boolean bl2) {
            this.a = nodeInfo;
            this.e = bl2;
            this.b = new AncestorEnumeration(nodeInfo, false);
            switch (nodeInfo.getNodeKind()) {
                case 1: 
                case 3: 
                case 7: 
                case 8: {
                    this.c = nodeInfo.iterateAxis((byte)11);
                    return;
                }
            }
            this.c = EmptyIterator.OfNodes.THE_INSTANCE;
        }

        @Override
        public final NodeInfo next() {
            block6: {
                NodeInfo nodeInfo;
                while (true) {
                    if (this.d != null) {
                        nodeInfo = this.d.next();
                        if (nodeInfo != null) {
                            return nodeInfo;
                        }
                        this.d = null;
                    }
                    if (this.c != null) {
                        nodeInfo = this.c.next();
                        if (nodeInfo != null) {
                            if (nodeInfo.hasChildNodes()) {
                                this.d = new DescendantEnumeration(nodeInfo, true, false);
                                continue;
                            }
                            this.d = null;
                            return nodeInfo;
                        }
                        this.d = null;
                        this.c = null;
                    }
                    if ((nodeInfo = this.b.next()) == null) break block6;
                    this.c = nodeInfo.getNodeKind() == 9 ? EmptyIterator.OfNodes.THE_INSTANCE : nodeInfo.iterateAxis((byte)11);
                    if (this.e) break;
                }
                return nodeInfo;
            }
            return null;
        }
    }

    public static final class FollowingEnumeration
    implements AxisIterator {
        private NodeInfo a;
        private AncestorEnumeration b;
        private AxisIterator c = null;
        private DescendantEnumeration d = null;

        public FollowingEnumeration(NodeInfo nodeInfo) {
            this.a = nodeInfo;
            this.b = new AncestorEnumeration(nodeInfo, false);
            switch (nodeInfo.getNodeKind()) {
                case 1: 
                case 3: 
                case 7: 
                case 8: {
                    this.c = nodeInfo.iterateAxis((byte)7);
                    return;
                }
                case 2: 
                case 13: {
                    nodeInfo = nodeInfo.getParent();
                    if (nodeInfo == null) break;
                    this.c = nodeInfo.iterateAxis((byte)3);
                    return;
                }
            }
            this.c = EmptyIterator.OfNodes.THE_INSTANCE;
        }

        @Override
        public final NodeInfo next() {
            while (true) {
                NodeInfo nodeInfo;
                if (this.d != null) {
                    nodeInfo = this.d.next();
                    if (nodeInfo != null) {
                        return nodeInfo;
                    }
                    this.d = null;
                }
                if (this.c != null) {
                    nodeInfo = this.c.next();
                    if (nodeInfo != null) {
                        this.d = nodeInfo.hasChildNodes() ? new DescendantEnumeration(nodeInfo, false, true) : null;
                        return nodeInfo;
                    }
                    this.d = null;
                    this.c = null;
                }
                if ((nodeInfo = this.b.next()) == null) break;
                if (nodeInfo.getNodeKind() == 9) {
                    this.c = EmptyIterator.OfNodes.THE_INSTANCE;
                    continue;
                }
                this.c = nodeInfo.iterateAxis((byte)7);
            }
            return null;
        }
    }

    public static final class DescendantEnumeration
    implements AxisIterator {
        private AxisIterator a = null;
        private DescendantEnumeration b = null;
        private NodeInfo c;
        private boolean d;
        private boolean e;
        private boolean f = false;

        public DescendantEnumeration(NodeInfo nodeInfo, boolean bl2, boolean bl3) {
            this.c = nodeInfo;
            this.d = bl2;
            this.e = bl3;
        }

        @Override
        public final NodeInfo next() {
            while (true) {
                Iterable<NodeInfo> iterable;
                if (this.b != null) {
                    iterable = this.b.next();
                    if (iterable != null) {
                        return iterable;
                    }
                    this.b = null;
                }
                if (this.a != null) {
                    iterable = this.a.next();
                    if (iterable != null) {
                        if (iterable.hasChildNodes()) {
                            if (this.e) {
                                this.b = new DescendantEnumeration((NodeInfo)iterable, false, true);
                                return iterable;
                            }
                            this.b = new DescendantEnumeration((NodeInfo)iterable, true, false);
                            continue;
                        }
                        return iterable;
                    }
                    if (this.e || !this.d) {
                        return null;
                    }
                    this.f = true;
                    this.a = null;
                    return this.c;
                }
                if (this.f) {
                    return null;
                }
                if (this.c.hasChildNodes()) {
                    this.a = this.c.iterateAxis((byte)3);
                    if (!this.e) {
                        if (this.a instanceof ReversibleIterator) {
                            this.a = (AxisIterator)((ReversibleIterator)((Object)this.a)).getReverseIterator();
                        } else {
                            NodeInfo nodeInfo;
                            iterable = new LinkedList();
                            AxisIterator axisIterator = this.c.iterateAxis((byte)3);
                            while ((nodeInfo = axisIterator.next()) != null) {
                                ((LinkedList)iterable).addFirst(nodeInfo);
                            }
                            this.a = new ListIterator.OfNodes((List<NodeInfo>)iterable);
                        }
                    }
                } else {
                    this.a = EmptyIterator.OfNodes.THE_INSTANCE;
                }
                if (this.e && this.d) break;
            }
            return this.c;
        }

        public final void advance() {
        }
    }

    public static final class AncestorEnumeration
    implements AxisIterator {
        private boolean a;
        private boolean b;
        private NodeInfo c;
        private NodeInfo d;

        public AncestorEnumeration(NodeInfo nodeInfo, boolean bl2) {
            this.c = nodeInfo;
            this.a = bl2;
            this.d = nodeInfo;
            this.b = true;
        }

        @Override
        public final NodeInfo next() {
            if (this.b) {
                this.b = false;
                if (this.a) {
                    return this.d;
                }
            }
            this.d = this.d == null ? null : this.d.getParent();
            return this.d;
        }
    }

    public static class EmptyTextFilter
    implements AxisIterator {
        private AxisIterator a;

        public EmptyTextFilter(AxisIterator axisIterator) {
            this.a = axisIterator;
        }

        @Override
        public NodeInfo next() {
            NodeInfo nodeInfo;
            do {
                if ((nodeInfo = this.a.next()) != null) continue;
                return null;
            } while (nodeInfo.getNodeKind() == 3 && nodeInfo.getStringValueCS().length() == 0);
            return nodeInfo;
        }
    }

    public static class AxisFilter
    implements AxisIterator {
        private AxisIterator a;
        private NodeTest b;

        public AxisFilter(AxisIterator axisIterator, NodeTest nodeTest) {
            this.a = axisIterator;
            this.b = nodeTest;
        }

        @Override
        public NodeInfo next() {
            NodeInfo nodeInfo;
            do {
                if ((nodeInfo = this.a.next()) != null) continue;
                return null;
            } while (!this.b.matchesNode(nodeInfo));
            return nodeInfo;
        }
    }
}

