/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.wrapper;

import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.GenericTreeInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.NamespaceNode;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.wrapper.VirtualNode;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;

public abstract class AbstractNodeWrapper
implements NodeInfo,
VirtualNode {
    protected TreeInfo treeInfo;

    @Override
    public TreeInfo getTreeInfo() {
        return this.treeInfo;
    }

    @Override
    public final Object getRealNode() {
        return this.getUnderlyingNode();
    }

    public NamePool getNamePool() {
        return this.getConfiguration().getNamePool();
    }

    @Override
    public AtomicSequence atomize() {
        switch (this.getNodeKind()) {
            case 7: 
            case 8: {
                return new StringValue(this.getStringValueCS());
            }
        }
        return new UntypedAtomicValue(this.getStringValueCS());
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof AbstractNodeWrapper)) {
            return false;
        }
        object = (AbstractNodeWrapper)object;
        return this.getUnderlyingNode().equals(object.getUnderlyingNode());
    }

    @Override
    public int hashCode() {
        return this.getUnderlyingNode().hashCode();
    }

    @Override
    public String getSystemId() {
        if (this.treeInfo instanceof GenericTreeInfo) {
            return ((GenericTreeInfo)this.treeInfo).getSystemId();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSystemId(String string) {
        if (this.treeInfo instanceof GenericTreeInfo) {
            ((GenericTreeInfo)this.treeInfo).setSystemId(string);
            return;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public String getBaseURI() {
        if (this.getNodeKind() == 13) {
            return null;
        }
        NodeInfo nodeInfo = this;
        if (this.getNodeKind() != 1) {
            nodeInfo = this.getParent();
        }
        while (nodeInfo != null) {
            String string = nodeInfo.getAttributeValue("http://www.w3.org/XML/1998/namespace", "base");
            if (string != null) {
                return string;
            }
            nodeInfo = nodeInfo.getParent();
        }
        return this.getRoot().getSystemId();
    }

    @Override
    public int getLineNumber() {
        return -1;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }

    @Override
    public Location saveLocation() {
        return this;
    }

    @Override
    public String getStringValue() {
        return this.getStringValueCS().toString();
    }

    @Override
    public String getDisplayName() {
        String string = this.getPrefix();
        String string2 = this.getLocalPart();
        if (string.isEmpty()) {
            return string2;
        }
        return string + ":" + string2;
    }

    @Override
    public String getAttributeValue(String string, String string2) {
        return null;
    }

    @Override
    public AxisIterator iterateAxis(byte by) {
        return this.iterateAxis(by, AnyNodeTest.getInstance());
    }

    @Override
    public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
        int n2 = this.getNodeKind();
        switch (by) {
            case 0: {
                if (n2 == 9) {
                    return EmptyIterator.OfNodes.THE_INSTANCE;
                }
                return new Navigator.AxisFilter(new Navigator.AncestorEnumeration(this, false), nodeTest);
            }
            case 1: {
                if (n2 == 9) {
                    return Navigator.filteredSingleton(this, nodeTest);
                }
                return new Navigator.AxisFilter(new Navigator.AncestorEnumeration(this, true), nodeTest);
            }
            case 2: {
                if (n2 != 1) {
                    return EmptyIterator.OfNodes.THE_INSTANCE;
                }
                return this.iterateAttributes(nodeTest);
            }
            case 3: {
                if (n2 == 1 || n2 == 9) {
                    return this.iterateChildren(nodeTest);
                }
                return EmptyIterator.OfNodes.THE_INSTANCE;
            }
            case 4: {
                if (n2 == 1 || n2 == 9) {
                    return this.iterateDescendants(nodeTest, false);
                }
                return EmptyIterator.OfNodes.THE_INSTANCE;
            }
            case 5: {
                if (n2 == 1 || n2 == 9) {
                    return this.iterateDescendants(nodeTest, true);
                }
                return Navigator.filteredSingleton(this, nodeTest);
            }
            case 6: {
                return new Navigator.AxisFilter(new Navigator.FollowingEnumeration(this), nodeTest);
            }
            case 7: {
                switch (n2) {
                    case 2: 
                    case 9: 
                    case 13: {
                        return EmptyIterator.OfNodes.THE_INSTANCE;
                    }
                }
                return this.iterateSiblings(nodeTest, true);
            }
            case 8: {
                if (n2 != 1) {
                    return EmptyIterator.OfNodes.THE_INSTANCE;
                }
                return NamespaceNode.makeIterator(this, nodeTest);
            }
            case 9: {
                return Navigator.filteredSingleton(this.getParent(), nodeTest);
            }
            case 10: {
                return new Navigator.AxisFilter(new Navigator.PrecedingEnumeration(this, false), nodeTest);
            }
            case 11: {
                switch (n2) {
                    case 2: 
                    case 9: 
                    case 13: {
                        return EmptyIterator.OfNodes.THE_INSTANCE;
                    }
                }
                return this.iterateSiblings(nodeTest, false);
            }
            case 12: {
                return Navigator.filteredSingleton(this, nodeTest);
            }
            case 13: {
                return new Navigator.AxisFilter(new Navigator.PrecedingEnumeration(this, true), nodeTest);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + by);
    }

    protected abstract AxisIterator iterateAttributes(NodeTest var1);

    protected abstract AxisIterator iterateChildren(NodeTest var1);

    protected abstract AxisIterator iterateSiblings(NodeTest var1, boolean var2);

    protected AxisIterator iterateDescendants(NodeTest nodeTest, boolean bl2) {
        AxisIterator axisIterator = new Navigator.DescendantEnumeration(this, bl2, true);
        if (!(nodeTest instanceof AnyNodeTest)) {
            axisIterator = new Navigator.AxisFilter(axisIterator, nodeTest);
        }
        return axisIterator;
    }

    @Override
    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] namespaceBindingArray) {
        return new NamespaceBinding[0];
    }

    @Override
    public NodeInfo getRoot() {
        NodeInfo nodeInfo = this;
        NodeInfo nodeInfo2;
        while ((nodeInfo2 = nodeInfo.getParent()) != null) {
            nodeInfo = nodeInfo2;
        }
        return nodeInfo;
    }

    @Override
    public boolean hasChildNodes() {
        switch (this.getNodeKind()) {
            case 1: 
            case 9: {
                return this.iterateAxis((byte)3).next() != null;
            }
        }
        return false;
    }

    @Override
    public int getFingerprint() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasFingerprint() {
        return false;
    }
}

