/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.wrapper;

import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.wrapper.VirtualNode;
import net.sf.saxon.type.SchemaType;

public abstract class AbstractVirtualNode
implements VirtualNode {
    protected NodeInfo node;
    protected AbstractVirtualNode parent;
    protected TreeInfo docWrapper;

    @Override
    public TreeInfo getTreeInfo() {
        return this.docWrapper;
    }

    @Override
    public NodeInfo getUnderlyingNode() {
        return this.node;
    }

    @Override
    public int getFingerprint() {
        if (this.node.hasFingerprint()) {
            return this.node.getFingerprint();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasFingerprint() {
        return this.node.hasFingerprint();
    }

    @Override
    public Object getRealNode() {
        Object object = this;
        while ((object = ((VirtualNode)object).getUnderlyingNode()) instanceof VirtualNode) {
        }
        return object;
    }

    @Override
    public int getNodeKind() {
        return this.node.getNodeKind();
    }

    @Override
    public AtomicSequence atomize() {
        return this.node.atomize();
    }

    @Override
    public SchemaType getSchemaType() {
        return this.node.getSchemaType();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof AbstractVirtualNode) {
            return this.node.equals(((AbstractVirtualNode)object).node);
        }
        return this.node.equals(object);
    }

    @Override
    public int hashCode() {
        return this.node.hashCode() ^ 0x3C3C3C3C;
    }

    @Override
    public String getSystemId() {
        return this.node.getSystemId();
    }

    @Override
    public void setSystemId(String string) {
        this.node.setSystemId(string);
    }

    @Override
    public String getBaseURI() {
        return this.node.getBaseURI();
    }

    @Override
    public int getLineNumber() {
        return this.node.getLineNumber();
    }

    @Override
    public int getColumnNumber() {
        return this.node.getColumnNumber();
    }

    @Override
    public Location saveLocation() {
        return this;
    }

    @Override
    public int compareOrder(NodeInfo nodeInfo) {
        if (nodeInfo instanceof AbstractVirtualNode) {
            return this.node.compareOrder(((AbstractVirtualNode)nodeInfo).node);
        }
        return this.node.compareOrder(nodeInfo);
    }

    @Override
    public final String getStringValue() {
        return this.getStringValueCS().toString();
    }

    @Override
    public CharSequence getStringValueCS() {
        return this.node.getStringValueCS();
    }

    @Override
    public String getLocalPart() {
        return this.node.getLocalPart();
    }

    @Override
    public String getURI() {
        return this.node.getURI();
    }

    @Override
    public String getPrefix() {
        return this.node.getPrefix();
    }

    @Override
    public String getDisplayName() {
        return this.node.getDisplayName();
    }

    @Override
    public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
        return new Navigator.AxisFilter(this.iterateAxis(by), nodeTest);
    }

    @Override
    public String getAttributeValue(String string, String string2) {
        return this.node.getAttributeValue(string, string2);
    }

    @Override
    public NodeInfo getRoot() {
        NodeInfo nodeInfo = this;
        NodeInfo nodeInfo2;
        while ((nodeInfo2 = nodeInfo.getParent()) != null) {
            nodeInfo = nodeInfo2;
        }
        return nodeInfo;
    }

    @Override
    public boolean hasChildNodes() {
        return this.node.hasChildNodes();
    }

    @Override
    public void generateId(FastStringBuffer fastStringBuffer) {
        this.node.generateId(fastStringBuffer);
    }

    @Override
    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] namespaceBindingArray) {
        return this.node.getDeclaredNamespaces(namespaceBindingArray);
    }

    @Override
    public boolean isId() {
        return this.node.isId();
    }

    @Override
    public boolean isIdref() {
        return this.node.isIdref();
    }

    @Override
    public boolean isNilled() {
        return this.node.isNilled();
    }
}

