/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.wrapper;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.SingleNodeIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.wrapper.VirtualCopy;
import net.sf.saxon.tree.wrapper.VirtualTreeInfo;
import net.sf.saxon.value.UntypedAtomicValue;

public class SnapshotNode
extends VirtualCopy
implements NodeInfo {
    protected NodeInfo pivot;

    protected SnapshotNode(NodeInfo nodeInfo, NodeInfo nodeInfo2) {
        super(nodeInfo, nodeInfo2.getRoot());
        this.pivot = nodeInfo2;
    }

    public static SnapshotNode makeSnapshot(NodeInfo object) {
        NodeInfo nodeInfo = object;
        SnapshotNode snapshotNode = new SnapshotNode(nodeInfo, nodeInfo);
        object = object.getConfiguration();
        VirtualTreeInfo virtualTreeInfo = new VirtualTreeInfo((Configuration)object);
        long l2 = ((Configuration)object).getDocumentNumberAllocator().allocateDocumentNumber();
        virtualTreeInfo.setDocumentNumber(l2);
        virtualTreeInfo.setCopyAccumulators(true);
        snapshotNode.tree = virtualTreeInfo;
        virtualTreeInfo.setRootNode(((VirtualCopy)snapshotNode).getRoot());
        return snapshotNode;
    }

    @Override
    protected SnapshotNode wrap(NodeInfo nodeInfo) {
        nodeInfo = new SnapshotNode(nodeInfo, this.pivot);
        v0.tree = this.tree;
        return nodeInfo;
    }

    @Override
    public CharSequence getStringValueCS() {
        if (Navigator.isAncestorOrSelf(this.original, this.pivot)) {
            return this.pivot.getStringValueCS();
        }
        return this.original.getStringValueCS();
    }

    @Override
    public NodeInfo getParent() {
        if (this.parent == null) {
            NodeInfo nodeInfo = this.original.getParent();
            if (nodeInfo == null) {
                return null;
            }
            this.parent = this.wrap(nodeInfo);
        }
        return this.parent;
    }

    @Override
    public NodeInfo getRoot() {
        return super.getRoot();
    }

    @Override
    public void copy(Receiver receiver, int n2, Location location) {
        Navigator.copy(this, receiver, n2, location);
    }

    @Override
    public AtomicSequence atomize() {
        switch (this.getNodeKind()) {
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 13: {
                return this.original.atomize();
            }
        }
        if (Navigator.isAncestorOrSelf(this.pivot, this.original)) {
            return this.original.atomize();
        }
        return new UntypedAtomicValue(this.pivot.getStringValueCS());
    }

    @Override
    public boolean isId() {
        return this.original.isId();
    }

    @Override
    public boolean isIdref() {
        return this.original.isIdref();
    }

    @Override
    public boolean isNilled() {
        return this.original.isNilled();
    }

    @Override
    public String getPublicId() {
        if (this.original instanceof SourceLocator) {
            return this.original.getPublicId();
        }
        return null;
    }

    @Override
    public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
        switch (this.getNodeKind()) {
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 13: {
                return super.iterateAxis(by, nodeTest);
            }
        }
        if (!this.original.isSameNodeInfo(this.pivot) && Navigator.isAncestorOrSelf(this.original, this.pivot)) {
            switch (by) {
                case 3: {
                    SnapshotNode snapshotNode;
                    SnapshotNode snapshotNode2 = this;
                    int n2 = snapshotNode2.pivot.getNodeKind();
                    SnapshotNode snapshotNode3 = snapshotNode2;
                    SnapshotNode snapshotNode4 = snapshotNode3.wrap(snapshotNode3.pivot);
                    if ((n2 == 2 || n2 == 13) && ((VirtualCopy)snapshotNode4).getParent().isSameNodeInfo(snapshotNode2)) {
                        snapshotNode = null;
                    } else {
                        while (true) {
                            SnapshotNode snapshotNode5;
                            if ((snapshotNode5 = (SnapshotNode)((VirtualCopy)snapshotNode4).getParent()) == null) {
                                throw new AssertionError();
                            }
                            if (snapshotNode5.isSameNodeInfo(snapshotNode2)) {
                                snapshotNode = snapshotNode4;
                                break;
                            }
                            snapshotNode4 = snapshotNode5;
                        }
                    }
                    return SingleNodeIterator.makeIterator(snapshotNode);
                }
                case 4: 
                case 5: {
                    AxisIterator axisIterator = new Navigator.DescendantEnumeration(this, by == 5, true);
                    if (!(nodeTest instanceof AnyNodeTest)) {
                        axisIterator = new Navigator.AxisFilter(axisIterator, nodeTest);
                    }
                    return axisIterator;
                }
            }
            return super.iterateAxis(by, nodeTest);
        }
        return super.iterateAxis(by, nodeTest);
    }

    @Override
    protected boolean isIncludedInCopy(NodeInfo nodeInfo) {
        switch (nodeInfo.getNodeKind()) {
            case 2: 
            case 13: {
                return this.isIncludedInCopy(nodeInfo.getParent());
            }
        }
        return Navigator.isAncestorOrSelf(this.pivot, nodeInfo) || Navigator.isAncestorOrSelf(nodeInfo, this.pivot);
    }
}

