/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.wrapper;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.wrapper.AbstractVirtualNode;
import net.sf.saxon.tree.wrapper.SpaceStrippedDocument;
import net.sf.saxon.tree.wrapper.VirtualNode;
import net.sf.saxon.tree.wrapper.WrappingFunction;
import net.sf.saxon.tree.wrapper.WrappingIterator;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.Whitespace;

public class SpaceStrippedNode
extends AbstractVirtualNode
implements WrappingFunction {
    protected SpaceStrippedNode() {
    }

    protected SpaceStrippedNode(NodeInfo nodeInfo, SpaceStrippedNode spaceStrippedNode) {
        this.node = nodeInfo;
        this.parent = spaceStrippedNode;
    }

    protected static SpaceStrippedNode makeWrapper(NodeInfo nodeInfo, SpaceStrippedDocument spaceStrippedDocument, SpaceStrippedNode spaceStrippedNode) {
        nodeInfo = new SpaceStrippedNode(nodeInfo, spaceStrippedNode);
        v0.docWrapper = spaceStrippedDocument;
        return nodeInfo;
    }

    @Override
    public VirtualNode makeWrapper(NodeInfo nodeInfo, VirtualNode virtualNode) {
        nodeInfo = new SpaceStrippedNode(nodeInfo, (SpaceStrippedNode)virtualNode);
        v0.docWrapper = this.docWrapper;
        return nodeInfo;
    }

    public static boolean isPreservedNode(NodeInfo object, SpaceStrippedDocument spaceStrippedDocument, NodeInfo nodeInfo) {
        Object object2;
        if (object.getNodeKind() != 3 || nodeInfo == null || !Whitespace.isWhite(object.getStringValueCS())) {
            return true;
        }
        object = nodeInfo.getSchemaType();
        if (object.isSimpleType() || ((ComplexType)object).isSimpleContent()) {
            return true;
        }
        if (spaceStrippedDocument.containsPreserveSpace()) {
            object = nodeInfo;
            while (object.getNodeKind() == 1) {
                object2 = object.getAttributeValue("http://www.w3.org/XML/1998/namespace", "space");
                if (object2 != null) {
                    if ("preserve".equals(object2)) {
                        return true;
                    }
                    if ("default".equals(object2)) break;
                }
                object = object.getParent();
            }
        }
        if (spaceStrippedDocument.containsAssertions()) {
            object = nodeInfo;
            while (object.getNodeKind() == 1) {
                object2 = object.getSchemaType();
                if (object2 instanceof ComplexType && ((ComplexType)object2).hasAssertions()) {
                    return true;
                }
                object = object.getParent();
            }
        }
        try {
            int n2 = spaceStrippedDocument.getStrippingRule().isSpacePreserving(NameOfNode.makeName(nodeInfo), null);
            return n2 == 1;
        }
        catch (XPathException xPathException) {
            return true;
        }
    }

    @Override
    public AtomicSequence atomize() {
        if (this.getNodeKind() == 1) {
            return this.getSchemaType().atomize(this);
        }
        return this.node.atomize();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof SpaceStrippedNode) {
            return this.node.equals(((SpaceStrippedNode)object).node);
        }
        return this.node.equals(object);
    }

    @Override
    public int compareOrder(NodeInfo nodeInfo) {
        if (nodeInfo instanceof SpaceStrippedNode) {
            return this.node.compareOrder(((SpaceStrippedNode)nodeInfo).node);
        }
        return this.node.compareOrder(nodeInfo);
    }

    @Override
    public CharSequence getStringValueCS() {
        switch (this.getNodeKind()) {
            case 1: 
            case 9: {
                NodeInfo nodeInfo;
                AxisIterator axisIterator = ((AbstractVirtualNode)this).iterateAxis((byte)4, NodeKindTest.makeNodeKindTest(3));
                FastStringBuffer fastStringBuffer = new FastStringBuffer(64);
                while ((nodeInfo = axisIterator.next()) != null) {
                    fastStringBuffer.append(nodeInfo.getStringValueCS());
                }
                return fastStringBuffer.condense();
            }
        }
        return this.node.getStringValueCS();
    }

    @Override
    public NodeInfo getParent() {
        NodeInfo nodeInfo;
        if (this.parent == null && (nodeInfo = this.node.getParent()) != null) {
            this.parent = SpaceStrippedNode.makeWrapper(nodeInfo, (SpaceStrippedDocument)this.docWrapper, null);
        }
        return this.parent;
    }

    @Override
    public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
        if (nodeTest.getUType().intersection(UType.TEXT) == UType.VOID || by == 2 || by == 8) {
            SpaceStrippedNode spaceStrippedNode = this;
            return new WrappingIterator(this.node.iterateAxis(by, nodeTest), spaceStrippedNode, spaceStrippedNode.a(by));
        }
        SpaceStrippedNode spaceStrippedNode = this;
        return new a(spaceStrippedNode, spaceStrippedNode.node.iterateAxis(by, nodeTest), this.a(by));
    }

    @Override
    public AxisIterator iterateAxis(byte by) {
        switch (by) {
            case 2: 
            case 8: {
                SpaceStrippedNode spaceStrippedNode = this;
                return new WrappingIterator(this.node.iterateAxis(by), spaceStrippedNode, spaceStrippedNode);
            }
            case 3: {
                SpaceStrippedNode spaceStrippedNode = this;
                return new a(spaceStrippedNode, spaceStrippedNode.node.iterateAxis(by), this);
            }
            case 7: 
            case 11: {
                SpaceStrippedNode spaceStrippedNode = (SpaceStrippedNode)this.getParent();
                if (spaceStrippedNode == null) {
                    return EmptyIterator.OfNodes.THE_INSTANCE;
                }
                SpaceStrippedNode spaceStrippedNode2 = this;
                return new a(spaceStrippedNode2, spaceStrippedNode2.node.iterateAxis(by), spaceStrippedNode);
            }
        }
        SpaceStrippedNode spaceStrippedNode = this;
        return new a(spaceStrippedNode, spaceStrippedNode.node.iterateAxis(by), null);
    }

    private SpaceStrippedNode a(byte by) {
        switch (by) {
            case 2: 
            case 3: 
            case 8: {
                return this;
            }
            case 7: 
            case 11: {
                return (SpaceStrippedNode)this.getParent();
            }
        }
        return null;
    }

    @Override
    public void copy(Receiver receiver, int n2, Location location) {
        receiver = new Stripper(((SpaceStrippedDocument)this.docWrapper).getStrippingRule(), receiver);
        this.node.copy(receiver, n2, location);
    }

    private final class a
    implements AxisIterator {
        private AxisIterator a;
        private SpaceStrippedNode b;
        private SpaceStrippedNode c;
        private int d;
        private /* synthetic */ SpaceStrippedNode e;

        public a(SpaceStrippedNode spaceStrippedNode, AxisIterator axisIterator, SpaceStrippedNode spaceStrippedNode2) {
            this.e = spaceStrippedNode;
            this.a = axisIterator;
            this.b = spaceStrippedNode2;
            this.d = 0;
        }

        @Override
        public final NodeInfo next() {
            NodeInfo nodeInfo;
            boolean bl2;
            do {
                if ((nodeInfo = this.a.next()) == null) {
                    return null;
                }
                NodeInfo nodeInfo2 = nodeInfo;
                a a2 = this;
                if (nodeInfo2.getNodeKind() != 3) {
                    bl2 = true;
                    continue;
                }
                NodeInfo nodeInfo3 = a2.b == null ? nodeInfo2.getParent() : a2.b.node;
                bl2 = SpaceStrippedNode.isPreservedNode(nodeInfo2, (SpaceStrippedDocument)a2.e.docWrapper, nodeInfo3);
            } while (!bl2);
            this.c = SpaceStrippedNode.makeWrapper(nodeInfo, (SpaceStrippedDocument)this.e.docWrapper, this.b);
            ++this.d;
            return this.c;
        }

        @Override
        public final void close() {
            this.a.close();
        }

        @Override
        public final int getProperties() {
            return 0;
        }
    }
}

