/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.wrapper;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.wrapper.AbstractVirtualNode;
import net.sf.saxon.tree.wrapper.TypeStrippedDocument;
import net.sf.saxon.tree.wrapper.VirtualNode;
import net.sf.saxon.tree.wrapper.WrappingFunction;
import net.sf.saxon.tree.wrapper.WrappingIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.UntypedAtomicValue;

public class TypeStrippedNode
extends AbstractVirtualNode
implements WrappingFunction {
    protected TypeStrippedNode() {
    }

    protected TypeStrippedNode(NodeInfo nodeInfo, TypeStrippedNode typeStrippedNode) {
        this.node = nodeInfo;
        this.parent = typeStrippedNode;
    }

    public static TypeStrippedNode makeWrapper(NodeInfo nodeInfo, TypeStrippedDocument typeStrippedDocument, TypeStrippedNode typeStrippedNode) {
        nodeInfo = new TypeStrippedNode(nodeInfo, typeStrippedNode);
        v0.docWrapper = typeStrippedDocument;
        return nodeInfo;
    }

    @Override
    public VirtualNode makeWrapper(NodeInfo nodeInfo, VirtualNode virtualNode) {
        nodeInfo = new TypeStrippedNode(nodeInfo, (TypeStrippedNode)virtualNode);
        v0.docWrapper = this.docWrapper;
        return nodeInfo;
    }

    @Override
    public AtomicSequence atomize() {
        return new UntypedAtomicValue(this.getStringValueCS());
    }

    @Override
    public SchemaType getSchemaType() {
        if (this.getNodeKind() == 1) {
            return Untyped.getInstance();
        }
        return BuiltInAtomicType.UNTYPED_ATOMIC;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof TypeStrippedNode) {
            return this.node.equals(((TypeStrippedNode)object).node);
        }
        return this.node.equals(object);
    }

    @Override
    public int compareOrder(NodeInfo nodeInfo) {
        if (nodeInfo instanceof TypeStrippedNode) {
            return this.node.compareOrder(((TypeStrippedNode)nodeInfo).node);
        }
        return this.node.compareOrder(nodeInfo);
    }

    @Override
    public NodeInfo getParent() {
        NodeInfo nodeInfo;
        if (this.parent == null && (nodeInfo = this.node.getParent()) != null) {
            this.parent = TypeStrippedNode.makeWrapper(nodeInfo, (TypeStrippedDocument)this.docWrapper, null);
        }
        return this.parent;
    }

    @Override
    public AxisIterator iterateAxis(byte by) {
        return new WrappingIterator(this.node.iterateAxis(by), this, null);
    }

    @Override
    public void copy(Receiver receiver, int n2, Location location) {
        this.node.copy(receiver, n2 & 0xFFFFFFFB, location);
    }

    @Override
    public boolean isNilled() {
        return false;
    }
}

