/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.wrapper;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.AxisInfo;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.NamespaceNode;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.tiny.GraftedElement;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.NamespaceIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.wrapper.VirtualTreeInfo;
import net.sf.saxon.type.SchemaType;

public class VirtualCopy
implements NodeInfo {
    protected String systemId;
    protected NodeInfo original;
    protected VirtualCopy parent;
    protected NodeInfo root;
    protected VirtualTreeInfo tree;
    private boolean a = false;
    private GraftedElement b = null;

    protected VirtualCopy(NodeInfo nodeInfo, NodeInfo nodeInfo2) {
        this.original = nodeInfo;
        this.systemId = nodeInfo.getBaseURI();
        this.root = nodeInfo2;
    }

    public static VirtualCopy makeVirtualCopy(NodeInfo object) {
        while (object instanceof VirtualCopy) {
            object = ((VirtualCopy)object).original;
        }
        NodeInfo nodeInfo = object;
        VirtualCopy virtualCopy = new VirtualCopy(nodeInfo, nodeInfo);
        object = object.getConfiguration();
        VirtualTreeInfo virtualTreeInfo = new VirtualTreeInfo((Configuration)object, virtualCopy);
        long l2 = ((Configuration)object).getDocumentNumberAllocator().allocateDocumentNumber();
        virtualTreeInfo.setDocumentNumber(l2);
        virtualCopy.tree = virtualTreeInfo;
        return virtualCopy;
    }

    public static VirtualCopy makeVirtualCopy(NodeInfo object, GraftedElement graftedElement) {
        NodeInfo nodeInfo = object;
        VirtualCopy virtualCopy = new VirtualCopy(nodeInfo, nodeInfo);
        object = object.getConfiguration();
        VirtualTreeInfo virtualTreeInfo = new VirtualTreeInfo((Configuration)object, virtualCopy);
        long l2 = ((Configuration)object).getDocumentNumberAllocator().allocateDocumentNumber();
        virtualTreeInfo.setDocumentNumber(l2);
        virtualCopy.tree = virtualTreeInfo;
        virtualCopy.b = graftedElement;
        virtualCopy.systemId = graftedElement.getSystemId();
        return virtualCopy;
    }

    protected VirtualCopy wrap(NodeInfo nodeInfo) {
        nodeInfo = new VirtualCopy(nodeInfo, this.root);
        v0.tree = this.tree;
        ((VirtualCopy)nodeInfo).b = this.b;
        ((VirtualCopy)nodeInfo).systemId = this.systemId;
        ((VirtualCopy)nodeInfo).a = this.a;
        return nodeInfo;
    }

    public NodeInfo getOriginalNode() {
        return this.original;
    }

    public GraftedElement getGraftingHost() {
        return this.b;
    }

    @Override
    public VirtualTreeInfo getTreeInfo() {
        return this.tree;
    }

    public void setDropNamespaces(boolean bl2) {
        this.a = bl2;
    }

    @Override
    public int getFingerprint() {
        return this.original.getFingerprint();
    }

    @Override
    public boolean hasFingerprint() {
        return this.original.hasFingerprint();
    }

    @Override
    public int getNodeKind() {
        return this.original.getNodeKind();
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof VirtualCopy && this.getTreeInfo() == ((VirtualCopy)object).getTreeInfo() && this.original.equals(((VirtualCopy)object).original);
    }

    @Override
    public int hashCode() {
        return this.original.hashCode() ^ (int)(this.getTreeInfo().getDocumentNumber() & Integer.MAX_VALUE) << 19;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public String getBaseURI() {
        return Navigator.getBaseURI(this);
    }

    @Override
    public int getLineNumber() {
        return this.original.getLineNumber();
    }

    @Override
    public int getColumnNumber() {
        return this.original.getColumnNumber();
    }

    @Override
    public Location saveLocation() {
        return this;
    }

    @Override
    public int compareOrder(NodeInfo nodeInfo) {
        if (nodeInfo instanceof VirtualCopy) {
            if (this.b != null && ((VirtualCopy)nodeInfo).b != null) {
                int n2 = this.b.compareOrder(((VirtualCopy)nodeInfo).b);
                if (n2 == 0) {
                    return this.original.compareOrder(((VirtualCopy)nodeInfo).original);
                }
                return n2;
            }
            int n3 = this.root.compareOrder(((VirtualCopy)nodeInfo).root);
            if (n3 == 0) {
                return this.original.compareOrder(((VirtualCopy)nodeInfo).original);
            }
            return n3;
        }
        return nodeInfo.compareOrder(this.original);
    }

    @Override
    public String getStringValue() {
        return this.getStringValueCS().toString();
    }

    @Override
    public CharSequence getStringValueCS() {
        return this.original.getStringValueCS();
    }

    @Override
    public String getLocalPart() {
        return this.original.getLocalPart();
    }

    @Override
    public String getURI() {
        return this.original.getURI();
    }

    @Override
    public String getPrefix() {
        return this.original.getPrefix();
    }

    @Override
    public String getDisplayName() {
        return this.original.getDisplayName();
    }

    @Override
    public Configuration getConfiguration() {
        return this.original.getConfiguration();
    }

    @Override
    public SchemaType getSchemaType() {
        return this.original.getSchemaType();
    }

    @Override
    public NodeInfo getParent() {
        if (this.original.equals(this.root)) {
            if (this.b == null) {
                return null;
            }
            return this.b.getParent();
        }
        if (this.parent == null) {
            NodeInfo nodeInfo = this.original.getParent();
            if (nodeInfo == null) {
                return null;
            }
            this.parent = this.wrap(nodeInfo);
        }
        return this.parent;
    }

    @Override
    public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
        VirtualCopy virtualCopy = null;
        switch (by) {
            case 2: 
            case 3: {
                virtualCopy = this;
                break;
            }
            case 7: 
            case 11: 
            case 12: {
                virtualCopy = this.parent;
                break;
            }
            case 0: {
                return new Navigator.AxisFilter(new Navigator.AncestorEnumeration(this, false), nodeTest);
            }
            case 1: {
                return new Navigator.AxisFilter(new Navigator.AncestorEnumeration(this, true), nodeTest);
            }
            case 8: {
                if (this.getNodeKind() != 1) {
                    return EmptyIterator.OfNodes.THE_INSTANCE;
                }
                return NamespaceNode.makeIterator(this, nodeTest);
            }
            case 9: {
                return Navigator.filteredSingleton(this.getParent(), nodeTest);
            }
            case 10: {
                return new Navigator.AxisFilter(new Navigator.PrecedingEnumeration(this, false), nodeTest);
            }
            case 6: {
                return new Navigator.AxisFilter(new Navigator.FollowingEnumeration(this), nodeTest);
            }
            case 13: {
                return new Navigator.AxisFilter(new Navigator.PrecedingEnumeration(this, true), nodeTest);
            }
        }
        VirtualCopy virtualCopy2 = this;
        return virtualCopy2.makeCopier(virtualCopy2.original.iterateAxis(by, nodeTest), virtualCopy, !AxisInfo.isSubtreeAxis[by]);
    }

    @Override
    public String getAttributeValue(String string, String string2) {
        return this.original.getAttributeValue(string, string2);
    }

    @Override
    public NodeInfo getRoot() {
        NodeInfo nodeInfo = this;
        NodeInfo nodeInfo2;
        while ((nodeInfo2 = nodeInfo.getParent()) != null) {
            nodeInfo = nodeInfo2;
        }
        return nodeInfo;
    }

    @Override
    public boolean hasChildNodes() {
        return this.original.hasChildNodes();
    }

    @Override
    public void generateId(FastStringBuffer fastStringBuffer) {
        fastStringBuffer.append("d");
        fastStringBuffer.append(Long.toString(this.getTreeInfo().getDocumentNumber()));
        this.original.generateId(fastStringBuffer);
    }

    @Override
    public void copy(Receiver receiver, int n2, Location location) {
        if (this.a) {
            n2 &= 0xFFFFFFFD;
        }
        this.original.copy(receiver, n2, location);
    }

    @Override
    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] object) {
        if (this.getNodeKind() == 1) {
            if (this.a) {
                object = new ArrayList(5);
                String string = this.getURI();
                if (string.isEmpty()) {
                    if (this.getParent() != null && !this.getParent().getURI().isEmpty()) {
                        object.add(new NamespaceBinding("", ""));
                    }
                } else {
                    object.add(new NamespaceBinding(this.getPrefix(), this.getURI()));
                }
                this.original.iterateAxis((byte)2).forEach(arg_0 -> VirtualCopy.a((List)object, arg_0));
                return object.toArray(NamespaceBinding.EMPTY_ARRAY);
            }
            if (this.original == this.root) {
                object = new ArrayList();
                Iterator<NamespaceBinding> iterator = NamespaceIterator.iterateNamespaces(this.original);
                boolean bl2 = false;
                while (iterator.hasNext()) {
                    NamespaceBinding namespaceBinding = iterator.next();
                    object.add(namespaceBinding);
                    if (!namespaceBinding.getPrefix().isEmpty()) continue;
                    bl2 = true;
                }
                if (!bl2 && this.b != null && this.b.hasDefaultNamespace()) {
                    object.add(NamespaceBinding.DEFAULT_UNDECLARATION);
                }
                return object.toArray(NamespaceBinding.EMPTY_ARRAY);
            }
            return this.original.getDeclaredNamespaces((NamespaceBinding[])object);
        }
        return null;
    }

    @Override
    public void setSystemId(String string) {
        this.systemId = string;
    }

    @Override
    public AtomicSequence atomize() {
        return this.original.atomize();
    }

    @Override
    public boolean isId() {
        return this.original.isId();
    }

    @Override
    public boolean isIdref() {
        return this.original.isIdref();
    }

    @Override
    public boolean isNilled() {
        return this.original.isNilled();
    }

    @Override
    public String getPublicId() {
        if (this.original instanceof SourceLocator) {
            return this.original.getPublicId();
        }
        return null;
    }

    protected boolean isIncludedInCopy(NodeInfo nodeInfo) {
        return Navigator.isAncestorOrSelf(this.root, nodeInfo);
    }

    protected VirtualCopier makeCopier(AxisIterator axisIterator, VirtualCopy virtualCopy, boolean bl2) {
        return new VirtualCopier(this, axisIterator, virtualCopy, bl2);
    }

    private static /* synthetic */ void a(List list, NodeInfo iterable) {
        if (iterable.getURI() != null && !list.contains(iterable = new NamespaceBinding(iterable.getPrefix(), iterable.getURI()))) {
            list.add(iterable);
        }
    }

    protected class VirtualCopier
    implements AxisIterator {
        protected AxisIterator base;
        private VirtualCopy a;
        protected boolean testInclusion;
        private /* synthetic */ VirtualCopy b;

        public VirtualCopier(VirtualCopy virtualCopy, AxisIterator axisIterator, VirtualCopy virtualCopy2, boolean bl2) {
            this.b = virtualCopy;
            this.base = axisIterator;
            this.a = virtualCopy2;
            this.testInclusion = bl2;
        }

        @Override
        public NodeInfo next() {
            NodeInfo nodeInfo = this.base.next();
            if (nodeInfo != null) {
                if (this.testInclusion && !this.b.isIncludedInCopy(nodeInfo)) {
                    return null;
                }
                nodeInfo = this.b.wrap(nodeInfo);
                v0.parent = this.a;
                ((VirtualCopy)nodeInfo).systemId = this.b.systemId;
            }
            return nodeInfo;
        }

        @Override
        public void close() {
            this.base.close();
        }

        @Override
        public int getProperties() {
            return 0;
        }
    }
}

