/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Item;
import net.sf.saxon.query.AnnotationList;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.SequenceType;

public class AnyFunctionType
implements FunctionItemType {
    public static final AnyFunctionType ANY_FUNCTION = new AnyFunctionType();

    public static AnyFunctionType getInstance() {
        return ANY_FUNCTION;
    }

    @Override
    public UType getUType() {
        return UType.FUNCTION;
    }

    @Override
    public boolean isAtomicType() {
        return false;
    }

    @Override
    public boolean isPlainType() {
        return false;
    }

    @Override
    public boolean isMapType() {
        return false;
    }

    @Override
    public boolean isArrayType() {
        return false;
    }

    @Override
    public String getAlphaCode() {
        return "F";
    }

    @Override
    public SequenceType[] getArgumentTypes() {
        return null;
    }

    @Override
    public AnnotationList getAnnotationAssertions() {
        return AnnotationList.EMPTY;
    }

    @Override
    public boolean matches(Item item, TypeHierarchy typeHierarchy) {
        return item instanceof Function;
    }

    @Override
    public final ItemType getPrimitiveItemType() {
        return ANY_FUNCTION;
    }

    @Override
    public final int getPrimitiveType() {
        return 99;
    }

    @Override
    public String toString() {
        return "function(*)";
    }

    @Override
    public PlainType getAtomizedItemType() {
        return null;
    }

    @Override
    public boolean isAtomizable(TypeHierarchy typeHierarchy) {
        return true;
    }

    @Override
    public int relationship(FunctionItemType functionItemType, TypeHierarchy typeHierarchy) {
        if (functionItemType == this) {
            return 0;
        }
        return 1;
    }

    @Override
    public Expression makeFunctionSequenceCoercer(Expression expression, RoleDiagnostic roleDiagnostic) {
        return new ItemChecker(expression, this, roleDiagnostic);
    }

    @Override
    public SequenceType getResultType() {
        return SequenceType.ANY_SEQUENCE;
    }

    @Override
    public String generateJavaScriptItemTypeTest(ItemType itemType, int n2) {
        return "return SaxonJS.U.isMap(item) || SaxonJS.U.isArray(item);";
    }

    @Override
    public String generateJavaScriptItemTypeAcceptor(String string, int n2) {
        return "if (typeof val == 'object') {return val;} else {throw SaxonJS.XError('Cannot convert supplied JS value to a map or array');}";
    }
}

