/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.instruct.ValueOf;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.AtomicArray;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.NumericType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NotationValue;
import net.sf.saxon.value.QualifiedNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class BuiltInAtomicType
implements AtomicType,
ItemType.WithSequenceTypeCache {
    private int a;
    private int b;
    private int c;
    private UType d;
    private String e;
    private boolean f = false;
    public StringConverter stringConverter;
    private SequenceType g;
    private SequenceType h;
    private SequenceType i;
    private SequenceType j;
    private static Map<String, BuiltInAtomicType> k = new HashMap<String, BuiltInAtomicType>(100);
    public static final BuiltInAtomicType ANY_ATOMIC = BuiltInAtomicType.a(632, AnySimpleType.getInstance(), "A", true);
    public static final BuiltInAtomicType STRING = BuiltInAtomicType.a(513, ANY_ATOMIC, "AS", true);
    public static final BuiltInAtomicType BOOLEAN = BuiltInAtomicType.a(514, ANY_ATOMIC, "AB", true);
    public static final BuiltInAtomicType DURATION = BuiltInAtomicType.a(518, ANY_ATOMIC, "AR", false);
    public static final BuiltInAtomicType DATE_TIME = BuiltInAtomicType.a(519, ANY_ATOMIC, "AM", true);
    public static final BuiltInAtomicType DATE = BuiltInAtomicType.a(521, ANY_ATOMIC, "AA", true);
    public static final BuiltInAtomicType TIME = BuiltInAtomicType.a(520, ANY_ATOMIC, "AT", true);
    public static final BuiltInAtomicType G_YEAR_MONTH = BuiltInAtomicType.a(522, ANY_ATOMIC, "AH", false);
    public static final BuiltInAtomicType G_MONTH = BuiltInAtomicType.a(526, ANY_ATOMIC, "AI", false);
    public static final BuiltInAtomicType G_MONTH_DAY = BuiltInAtomicType.a(524, ANY_ATOMIC, "AJ", false);
    public static final BuiltInAtomicType G_YEAR = BuiltInAtomicType.a(523, ANY_ATOMIC, "AG", false);
    public static final BuiltInAtomicType G_DAY = BuiltInAtomicType.a(525, ANY_ATOMIC, "AK", false);
    public static final BuiltInAtomicType HEX_BINARY = BuiltInAtomicType.a(527, ANY_ATOMIC, "AX", true);
    public static final BuiltInAtomicType BASE64_BINARY = BuiltInAtomicType.a(528, ANY_ATOMIC, "A2", true);
    public static final BuiltInAtomicType ANY_URI = BuiltInAtomicType.a(529, ANY_ATOMIC, "AU", true);
    public static final BuiltInAtomicType QNAME = BuiltInAtomicType.a(530, ANY_ATOMIC, "AQ", false);
    public static final BuiltInAtomicType NOTATION = BuiltInAtomicType.a(531, ANY_ATOMIC, "AN", false);
    public static final BuiltInAtomicType UNTYPED_ATOMIC = BuiltInAtomicType.a(631, ANY_ATOMIC, "AZ", true);
    public static final BuiltInAtomicType DECIMAL = BuiltInAtomicType.a(515, ANY_ATOMIC, "AD", true);
    public static final BuiltInAtomicType FLOAT = BuiltInAtomicType.a(516, ANY_ATOMIC, "AF", true);
    public static final BuiltInAtomicType DOUBLE = BuiltInAtomicType.a(517, ANY_ATOMIC, "AO", true);
    public static final BuiltInAtomicType INTEGER = BuiltInAtomicType.a(533, DECIMAL, "ADI", true);
    public static final BuiltInAtomicType NON_POSITIVE_INTEGER = BuiltInAtomicType.a(534, INTEGER, "ADIN", true);
    public static final BuiltInAtomicType NEGATIVE_INTEGER = BuiltInAtomicType.a(535, NON_POSITIVE_INTEGER, "ADINN", true);
    public static final BuiltInAtomicType LONG = BuiltInAtomicType.a(536, INTEGER, "ADIL", true);
    public static final BuiltInAtomicType INT = BuiltInAtomicType.a(537, LONG, "ADILI", true);
    public static final BuiltInAtomicType SHORT = BuiltInAtomicType.a(538, INT, "ADILIS", true);
    public static final BuiltInAtomicType BYTE = BuiltInAtomicType.a(539, SHORT, "ADILISB", true);
    public static final BuiltInAtomicType NON_NEGATIVE_INTEGER = BuiltInAtomicType.a(540, INTEGER, "ADIP", true);
    public static final BuiltInAtomicType POSITIVE_INTEGER = BuiltInAtomicType.a(541, NON_NEGATIVE_INTEGER, "ADIPP", true);
    public static final BuiltInAtomicType UNSIGNED_LONG = BuiltInAtomicType.a(542, NON_NEGATIVE_INTEGER, "ADIPL", true);
    public static final BuiltInAtomicType UNSIGNED_INT = BuiltInAtomicType.a(543, UNSIGNED_LONG, "ADIPLI", true);
    public static final BuiltInAtomicType UNSIGNED_SHORT = BuiltInAtomicType.a(544, UNSIGNED_INT, "ADIPLIS", true);
    public static final BuiltInAtomicType UNSIGNED_BYTE = BuiltInAtomicType.a(545, UNSIGNED_SHORT, "ADIPLISB", true);
    public static final BuiltInAtomicType YEAR_MONTH_DURATION = BuiltInAtomicType.a(633, DURATION, "ARY", true);
    public static final BuiltInAtomicType DAY_TIME_DURATION = BuiltInAtomicType.a(634, DURATION, "ARD", true);
    public static final BuiltInAtomicType NORMALIZED_STRING = BuiltInAtomicType.a(553, STRING, "ASN", true);
    public static final BuiltInAtomicType TOKEN = BuiltInAtomicType.a(554, NORMALIZED_STRING, "ASNT", true);
    public static final BuiltInAtomicType LANGUAGE = BuiltInAtomicType.a(555, TOKEN, "ASNTL", true);
    public static final BuiltInAtomicType NAME = BuiltInAtomicType.a(558, TOKEN, "ASNTN", true);
    public static final BuiltInAtomicType NMTOKEN = BuiltInAtomicType.a(556, TOKEN, "ASNTK", true);
    public static final BuiltInAtomicType NCNAME = BuiltInAtomicType.a(559, NAME, "ASNTNC", true);
    public static final BuiltInAtomicType ID = BuiltInAtomicType.a(560, NCNAME, "ASNTNCI", true);
    public static final BuiltInAtomicType IDREF = BuiltInAtomicType.a(561, NCNAME, "ASNTNCR", true);
    public static final BuiltInAtomicType ENTITY = BuiltInAtomicType.a(563, NCNAME, "ASNTNCE", true);
    public static final BuiltInAtomicType DATE_TIME_STAMP = BuiltInAtomicType.a(565, DATE_TIME, "AMP", true);

    private BuiltInAtomicType(int n2) {
        this.a = n2;
    }

    @Override
    public String getName() {
        return StandardNames.getLocalName(this.a);
    }

    @Override
    public UType getUType() {
        return this.d;
    }

    @Override
    public String getTargetNamespace() {
        return "http://www.w3.org/2001/XMLSchema";
    }

    @Override
    public String getEQName() {
        return "Q{http://www.w3.org/2001/XMLSchema}" + this.getName();
    }

    @Override
    public boolean isAbstract() {
        switch (this.a) {
            case 531: 
            case 573: 
            case 632: 
            case 635: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isExternalType() {
        return false;
    }

    @Override
    public boolean isBuiltInType() {
        return true;
    }

    @Override
    public StructuredQName getTypeName() {
        return new StructuredQName(StandardNames.getPrefix(this.a), StandardNames.getURI(this.a), StandardNames.getLocalName(this.a));
    }

    @Override
    public String getAlphaCode() {
        return this.e;
    }

    @Override
    public SequenceType one() {
        if (this.g == null) {
            this.g = new SequenceType(this, 16384);
        }
        return this.g;
    }

    @Override
    public SequenceType zeroOrOne() {
        if (this.i == null) {
            this.i = new SequenceType(this, 24576);
        }
        return this.i;
    }

    @Override
    public SequenceType oneOrMore() {
        if (this.h == null) {
            this.h = new SequenceType(this, 49152);
        }
        return this.h;
    }

    @Override
    public SequenceType zeroOrMore() {
        if (this.j == null) {
            this.j = new SequenceType(this, 57344);
        }
        return this.j;
    }

    @Override
    public int getRedefinitionLevel() {
        return 0;
    }

    @Override
    public boolean isOrdered(boolean bl2) {
        return this.f || bl2 && (this == DURATION || this == ANY_ATOMIC);
    }

    @Override
    public String getSystemId() {
        return null;
    }

    public boolean isPrimitiveNumeric() {
        switch (this.getFingerprint()) {
            case 515: 
            case 516: 
            case 517: 
            case 533: {
                return true;
            }
        }
        return false;
    }

    @Override
    public final SchemaComponent.ValidationStatus getValidationStatus() {
        return SchemaComponent.ValidationStatus.VALIDATED;
    }

    @Override
    public final int getBlock() {
        return 0;
    }

    @Override
    public final int getDerivationMethod() {
        return 1;
    }

    @Override
    public final boolean allowsDerivation(int n2) {
        return true;
    }

    @Override
    public int getFinalProhibitions() {
        return 0;
    }

    public final void setBaseTypeFingerprint(int n2) {
        this.b = n2;
    }

    @Override
    public final int getFingerprint() {
        return this.a;
    }

    @Override
    public final StructuredQName getStructuredQName() {
        return new StructuredQName("xs", "http://www.w3.org/2001/XMLSchema", StandardNames.getLocalName(this.a));
    }

    @Override
    public String getDisplayName() {
        return StandardNames.getDisplayName(this.a);
    }

    @Override
    public final boolean isPrimitiveType() {
        return Type.isPrimitiveAtomicType(this.a);
    }

    @Override
    public final boolean isComplexType() {
        return false;
    }

    @Override
    public final boolean isAnonymousType() {
        return false;
    }

    @Override
    public boolean isPlainType() {
        return true;
    }

    @Override
    public final SchemaType getBaseType() {
        if (this.b == -1) {
            return null;
        }
        return BuiltInType.getSchemaType(this.b);
    }

    @Override
    public boolean matches(Item item, TypeHierarchy typeHierarchy) {
        return item instanceof AtomicValue && Type.isSubType(((AtomicValue)item).getItemType(), this);
    }

    @Override
    public BuiltInAtomicType getPrimitiveItemType() {
        if (this.isPrimitiveType()) {
            return this;
        }
        ItemType itemType = (ItemType)((Object)this.getBaseType());
        assert (itemType != null);
        if (itemType.isPlainType()) {
            return (BuiltInAtomicType)itemType.getPrimitiveItemType();
        }
        return this;
    }

    @Override
    public int getPrimitiveType() {
        return this.c;
    }

    public boolean isAllowedInXSD10() {
        return this.getFingerprint() != 565;
    }

    @Override
    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public AtomicType getAtomizedItemType() {
        return this;
    }

    @Override
    public boolean isAtomizable(TypeHierarchy typeHierarchy) {
        return true;
    }

    public SchemaType getKnownBaseType() {
        return this.getBaseType();
    }

    @Override
    public boolean isSameType(SchemaType schemaType) {
        return schemaType.getFingerprint() == this.getFingerprint();
    }

    @Override
    public String getDescription() {
        return this.getDisplayName();
    }

    @Override
    public void checkTypeDerivationIsOK(SchemaType schemaType, int n2) {
        if (schemaType != AnySimpleType.getInstance() && !this.isSameType(schemaType)) {
            SchemaType schemaType2 = this.getBaseType();
            if (schemaType2 == null) {
                throw new SchemaException("The type " + this.getDescription() + " is not validly derived from the type " + schemaType.getDescription());
            }
            try {
                schemaType2.checkTypeDerivationIsOK(schemaType, n2);
                return;
            }
            catch (SchemaException schemaException) {
                throw new SchemaException("The type " + this.getDescription() + " is not validly derived from the type " + schemaType.getDescription());
            }
        }
    }

    @Override
    public final boolean isSimpleType() {
        return true;
    }

    @Override
    public boolean isAtomicType() {
        return true;
    }

    @Override
    public boolean isIdType() {
        return this.a == 560;
    }

    @Override
    public boolean isIdRefType() {
        return this.a == 561;
    }

    @Override
    public boolean isListType() {
        return false;
    }

    @Override
    public boolean isUnionType() {
        return false;
    }

    @Override
    public int getWhitespaceAction() {
        switch (this.getFingerprint()) {
            case 513: {
                return 0;
            }
            case 553: {
                return 1;
            }
        }
        return 2;
    }

    @Override
    public SchemaType getBuiltInBaseType() {
        BuiltInAtomicType builtInAtomicType;
        for (builtInAtomicType = this; builtInAtomicType != null && builtInAtomicType.getFingerprint() > 1023; builtInAtomicType = (BuiltInAtomicType)builtInAtomicType.getBaseType()) {
        }
        return builtInAtomicType;
    }

    @Override
    public boolean isNamespaceSensitive() {
        BuiltInAtomicType builtInAtomicType = this;
        int n2 = builtInAtomicType.getFingerprint();
        while (n2 > 1023) {
            builtInAtomicType = (BuiltInAtomicType)builtInAtomicType.getBaseType();
            assert (builtInAtomicType != null);
            n2 = builtInAtomicType.getFingerprint();
        }
        return n2 == 530 || n2 == 531;
    }

    @Override
    public ValidationFailure validateContent(CharSequence object, NamespaceResolver namespaceResolver, ConversionRules conversionRules) {
        int n2 = this.getFingerprint();
        if (n2 == 513 || n2 == 573 || n2 == 631 || n2 == 632) {
            return null;
        }
        StringConverter stringConverter = this.stringConverter;
        if (stringConverter == null) {
            stringConverter = this.getStringConverter(conversionRules);
            if (this.isNamespaceSensitive()) {
                if (namespaceResolver == null) {
                    throw new UnsupportedOperationException("Cannot validate a QName without a namespace resolver");
                }
                object = (stringConverter = (StringConverter)stringConverter.setNamespaceResolver(namespaceResolver)).convertString((CharSequence)object);
                if (object instanceof ValidationFailure) {
                    return (ValidationFailure)object;
                }
                if (this.a == 531 && !conversionRules.isDeclaredNotation(((QualifiedNameValue)(object = (NotationValue)object)).getNamespaceURI(), ((QualifiedNameValue)object).getLocalName())) {
                    return new ValidationFailure("Notation {" + ((QualifiedNameValue)object).getNamespaceURI() + "}" + ((QualifiedNameValue)object).getLocalName() + " is not declared in the schema");
                }
                return null;
            }
        }
        return stringConverter.validate((CharSequence)object);
    }

    @Override
    public StringConverter getStringConverter(ConversionRules conversionRules) {
        if (this.stringConverter != null) {
            return this.stringConverter;
        }
        switch (this.a) {
            case 517: 
            case 635: {
                return conversionRules.getStringToDoubleConverter();
            }
            case 516: {
                return new StringConverter.StringToFloat(conversionRules);
            }
            case 519: {
                return new StringConverter.StringToDateTime(conversionRules);
            }
            case 565: {
                return new StringConverter.StringToDateTimeStamp(conversionRules);
            }
            case 521: {
                return new StringConverter.StringToDate(conversionRules);
            }
            case 523: {
                return new StringConverter.StringToGYear(conversionRules);
            }
            case 522: {
                return new StringConverter.StringToGYearMonth(conversionRules);
            }
            case 529: {
                return new StringConverter.StringToAnyURI(conversionRules);
            }
            case 530: {
                return new StringConverter.StringToQName(conversionRules);
            }
            case 531: {
                return new StringConverter.StringToNotation(conversionRules);
            }
        }
        throw new AssertionError((Object)("No string converter available for " + this));
    }

    @Override
    public AtomicSequence atomize(NodeInfo nodeInfo) {
        CharSequence charSequence = nodeInfo.getStringValueCS();
        if (charSequence.length() == 0 && nodeInfo.isNilled()) {
            return AtomicArray.EMPTY_ATOMIC_ARRAY;
        }
        if (this.a == 513) {
            return StringValue.makeStringValue(charSequence);
        }
        if (this.a == 631) {
            return new UntypedAtomicValue(charSequence);
        }
        StringConverter stringConverter = this.stringConverter;
        if (stringConverter == null) {
            stringConverter = this.getStringConverter(nodeInfo.getConfiguration().getConversionRules());
            if (this.isNamespaceSensitive()) {
                stringConverter = (StringConverter)stringConverter.setNamespaceResolver(new InscopeNamespaceResolver(nodeInfo));
            }
        }
        return stringConverter.convertString(charSequence).asAtomic();
    }

    @Override
    public AtomicSequence getTypedValue(CharSequence charSequence, NamespaceResolver namespaceResolver, ConversionRules object) {
        if (this.a == 513) {
            return StringValue.makeStringValue(charSequence);
        }
        if (this.a == 631) {
            return new UntypedAtomicValue(charSequence);
        }
        object = this.getStringConverter((ConversionRules)object);
        if (this.isNamespaceSensitive()) {
            object = (StringConverter)((Converter)object).setNamespaceResolver(namespaceResolver);
        }
        return ((StringConverter)object).convertString(charSequence).asAtomic();
    }

    public boolean equals(Object object) {
        return object instanceof BuiltInAtomicType && this.getFingerprint() == ((BuiltInAtomicType)object).getFingerprint();
    }

    public int hashCode() {
        return this.getFingerprint();
    }

    @Override
    public ValidationFailure validate(AtomicValue atomicValue, CharSequence charSequence, ConversionRules conversionRules) {
        switch (this.a) {
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 518: 
            case 519: 
            case 520: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 527: 
            case 528: 
            case 529: 
            case 530: 
            case 531: 
            case 533: 
            case 631: 
            case 635: {
                return null;
            }
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: 
            case 545: {
                return ((IntegerValue)atomicValue).validateAgainstSubType(this);
            }
            case 633: 
            case 634: {
                return null;
            }
            case 565: {
                if (((CalendarValue)atomicValue).getTimezoneInMinutes() == Integer.MIN_VALUE) {
                    return new ValidationFailure("xs:dateTimeStamp value must have a timezone");
                }
                return null;
            }
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 563: {
                return this.stringConverter.validate(atomicValue.getStringValueCS());
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void analyzeContentExpression(Expression expression, int n2) {
        BuiltInAtomicType.analyzeContentExpression(this, expression, n2);
    }

    public static void analyzeContentExpression(SimpleType simpleType, Expression expression, int n2) {
        if (n2 == 1 || n2 == 2 && (expression instanceof ValueOf || expression instanceof Literal)) {
            expression.checkPermittedContents(simpleType, true);
        }
    }

    private static BuiltInAtomicType a(int n2, SimpleType simpleType, String string, boolean bl2) {
        BuiltInAtomicType builtInAtomicType = new BuiltInAtomicType(n2);
        builtInAtomicType.setBaseTypeFingerprint(simpleType.getFingerprint());
        builtInAtomicType.c = builtInAtomicType.isPrimitiveType() ? n2 : ((AtomicType)simpleType).getPrimitiveType();
        builtInAtomicType.d = UType.fromTypeCode(builtInAtomicType.c);
        builtInAtomicType.f = bl2;
        builtInAtomicType.e = string;
        BuiltInType.a(n2, builtInAtomicType);
        k.put(string, builtInAtomicType);
        return builtInAtomicType;
    }

    public static BuiltInAtomicType getTypeWithAlphaCode(String string) {
        return k.get(string);
    }

    @Override
    public CharSequence preprocess(CharSequence charSequence) {
        return charSequence;
    }

    @Override
    public CharSequence postprocess(CharSequence charSequence) {
        return charSequence;
    }

    public Set<? extends PlainType> getPlainMemberTypes() {
        return Collections.singleton(this);
    }

    public boolean isNumericType() {
        BuiltInAtomicType builtInAtomicType = this.getPrimitiveItemType();
        return builtInAtomicType == NumericType.getInstance() || builtInAtomicType == DECIMAL || builtInAtomicType == DOUBLE || builtInAtomicType == FLOAT || builtInAtomicType == INTEGER;
    }

    @Override
    public String generateJavaScriptItemTypeTest(ItemType itemType, int n2) {
        if (this == NOTATION) {
            return "return false;";
        }
        if (n2 == 1) {
            return "return SaxonJS.U.Atomic." + this.getName() + ".matches(item);";
        }
        if (n2 == 2) {
            return "return SaxonJS.U.hasAtomicType(item, '" + this.getName() + "');";
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String generateJavaScriptItemTypeAcceptor(String string, int n2) {
        if (n2 == 1) {
            return "return SaxonJS.U.Atomic." + this.getName() + ".cast(val);";
        }
        if (n2 == 2) {
            return "return SaxonJS.U.cast(val, '" + this.getName() + "');";
        }
        throw new IllegalArgumentException("" + n2);
    }

    static {
        BuiltInAtomicType.ANY_ATOMIC.stringConverter = StringConverter.StringToString.INSTANCE;
        BuiltInAtomicType.STRING.stringConverter = StringConverter.StringToString.INSTANCE;
        BuiltInAtomicType.LANGUAGE.stringConverter = StringConverter.StringToLanguage.INSTANCE;
        BuiltInAtomicType.NORMALIZED_STRING.stringConverter = StringConverter.StringToNormalizedString.INSTANCE;
        BuiltInAtomicType.TOKEN.stringConverter = StringConverter.StringToToken.INSTANCE;
        BuiltInAtomicType.NCNAME.stringConverter = StringConverter.StringToNCName.TO_NCNAME;
        BuiltInAtomicType.NAME.stringConverter = StringConverter.StringToName.INSTANCE;
        BuiltInAtomicType.NMTOKEN.stringConverter = StringConverter.StringToNMTOKEN.INSTANCE;
        BuiltInAtomicType.ID.stringConverter = StringConverter.StringToNCName.TO_ID;
        BuiltInAtomicType.IDREF.stringConverter = StringConverter.StringToNCName.TO_IDREF;
        BuiltInAtomicType.ENTITY.stringConverter = StringConverter.StringToNCName.TO_ENTITY;
        BuiltInAtomicType.DECIMAL.stringConverter = StringConverter.StringToDecimal.INSTANCE;
        BuiltInAtomicType.INTEGER.stringConverter = StringConverter.StringToInteger.INSTANCE;
        BuiltInAtomicType.DURATION.stringConverter = StringConverter.StringToDuration.INSTANCE;
        BuiltInAtomicType.G_MONTH.stringConverter = StringConverter.StringToGMonth.INSTANCE;
        BuiltInAtomicType.G_MONTH_DAY.stringConverter = StringConverter.StringToGMonthDay.INSTANCE;
        BuiltInAtomicType.G_DAY.stringConverter = StringConverter.StringToGDay.INSTANCE;
        BuiltInAtomicType.DAY_TIME_DURATION.stringConverter = StringConverter.StringToDayTimeDuration.INSTANCE;
        BuiltInAtomicType.YEAR_MONTH_DURATION.stringConverter = StringConverter.StringToYearMonthDuration.INSTANCE;
        BuiltInAtomicType.TIME.stringConverter = StringConverter.StringToTime.INSTANCE;
        BuiltInAtomicType.BOOLEAN.stringConverter = StringConverter.StringToBoolean.INSTANCE;
        BuiltInAtomicType.HEX_BINARY.stringConverter = StringConverter.StringToHexBinary.INSTANCE;
        BuiltInAtomicType.BASE64_BINARY.stringConverter = StringConverter.StringToBase64Binary.INSTANCE;
        BuiltInAtomicType.UNTYPED_ATOMIC.stringConverter = StringConverter.StringToUntypedAtomic.INSTANCE;
        BuiltInAtomicType.NON_POSITIVE_INTEGER.stringConverter = new StringConverter.StringToIntegerSubtype(NON_POSITIVE_INTEGER);
        BuiltInAtomicType.NEGATIVE_INTEGER.stringConverter = new StringConverter.StringToIntegerSubtype(NEGATIVE_INTEGER);
        BuiltInAtomicType.LONG.stringConverter = new StringConverter.StringToIntegerSubtype(LONG);
        BuiltInAtomicType.INT.stringConverter = new StringConverter.StringToIntegerSubtype(INT);
        BuiltInAtomicType.SHORT.stringConverter = new StringConverter.StringToIntegerSubtype(SHORT);
        BuiltInAtomicType.BYTE.stringConverter = new StringConverter.StringToIntegerSubtype(BYTE);
        BuiltInAtomicType.NON_NEGATIVE_INTEGER.stringConverter = new StringConverter.StringToIntegerSubtype(NON_NEGATIVE_INTEGER);
        BuiltInAtomicType.POSITIVE_INTEGER.stringConverter = new StringConverter.StringToIntegerSubtype(POSITIVE_INTEGER);
        BuiltInAtomicType.UNSIGNED_LONG.stringConverter = new StringConverter.StringToIntegerSubtype(UNSIGNED_LONG);
        BuiltInAtomicType.UNSIGNED_INT.stringConverter = new StringConverter.StringToIntegerSubtype(UNSIGNED_INT);
        BuiltInAtomicType.UNSIGNED_SHORT.stringConverter = new StringConverter.StringToIntegerSubtype(UNSIGNED_SHORT);
        BuiltInAtomicType.UNSIGNED_BYTE.stringConverter = new StringConverter.StringToIntegerSubtype(UNSIGNED_BYTE);
    }
}

