/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.AtomicArray;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class BuiltInListType
implements ListType {
    private int a;
    public static BuiltInListType ENTITIES = BuiltInListType.a("http://www.w3.org/2001/XMLSchema", "ENTITIES");
    public static BuiltInListType IDREFS = BuiltInListType.a("http://www.w3.org/2001/XMLSchema", "IDREFS");
    public static BuiltInListType NMTOKENS = BuiltInListType.a("http://www.w3.org/2001/XMLSchema", "NMTOKENS");
    public static BuiltInListType ANY_URIS = BuiltInListType.a("http://www.w3.org/2001/XMLSchema-instance", "anonymous_schemaLocationType");
    private BuiltInAtomicType b;

    @Override
    public boolean isExternalType() {
        return false;
    }

    @Override
    public boolean isBuiltInType() {
        return true;
    }

    @Override
    public String getSystemId() {
        return null;
    }

    @Override
    public int getRedefinitionLevel() {
        return 0;
    }

    @Override
    public int getWhitespaceAction() {
        return 2;
    }

    public BuiltInListType(int n2) {
        this.a = n2;
        switch (n2) {
            case 564: {
                this.b = BuiltInAtomicType.ENTITY;
                return;
            }
            case 562: {
                this.b = BuiltInAtomicType.IDREF;
                return;
            }
            case 557: {
                this.b = BuiltInAtomicType.NMTOKEN;
                return;
            }
            case 645: {
                this.b = BuiltInAtomicType.ANY_URI;
            }
        }
    }

    @Override
    public SchemaComponent.ValidationStatus getValidationStatus() {
        return SchemaComponent.ValidationStatus.VALIDATED;
    }

    @Override
    public SchemaType getBaseType() {
        return AnySimpleType.getInstance();
    }

    @Override
    public boolean isAtomicType() {
        return false;
    }

    @Override
    public boolean isIdType() {
        return false;
    }

    @Override
    public boolean isIdRefType() {
        return this.a == 562;
    }

    @Override
    public boolean isListType() {
        return true;
    }

    @Override
    public boolean isUnionType() {
        return false;
    }

    @Override
    public boolean isAnonymousType() {
        return false;
    }

    @Override
    public SchemaType getBuiltInBaseType() {
        return this;
    }

    @Override
    public boolean isNamespaceSensitive() {
        return false;
    }

    @Override
    public String getName() {
        return StandardNames.getLocalName(this.a);
    }

    @Override
    public String getTargetNamespace() {
        return "http://www.w3.org/2001/XMLSchema";
    }

    @Override
    public String getEQName() {
        return "Q{http://www.w3.org/2001/XMLSchema}" + this.getName();
    }

    @Override
    public int getFingerprint() {
        return this.a;
    }

    @Override
    public String getDisplayName() {
        return StandardNames.getDisplayName(this.a);
    }

    @Override
    public boolean isComplexType() {
        return false;
    }

    @Override
    public boolean isSimpleType() {
        return true;
    }

    @Override
    public int getBlock() {
        return 0;
    }

    public SchemaType getKnownBaseType() {
        return AnySimpleType.getInstance();
    }

    @Override
    public int getDerivationMethod() {
        return 8;
    }

    @Override
    public boolean allowsDerivation(int n2) {
        return true;
    }

    @Override
    public int getFinalProhibitions() {
        return 0;
    }

    @Override
    public AtomicSequence atomize(NodeInfo nodeInfo) {
        try {
            return this.getTypedValue(nodeInfo.getStringValue(), new InscopeNamespaceResolver(nodeInfo), nodeInfo.getConfiguration().getConversionRules());
        }
        catch (ValidationException validationException) {
            throw new XPathException("Internal error: value doesn't match its type annotation. " + validationException.getMessage());
        }
    }

    @Override
    public boolean isSameType(SchemaType schemaType) {
        return schemaType.getFingerprint() == this.getFingerprint();
    }

    @Override
    public String getDescription() {
        return this.getDisplayName();
    }

    @Override
    public void checkTypeDerivationIsOK(SchemaType schemaType, int n2) {
    }

    public String getLocalName() {
        return StandardNames.getLocalName(this.a);
    }

    @Override
    public StructuredQName getStructuredQName() {
        return new StructuredQName("xs", "http://www.w3.org/2001/XMLSchema", this.getLocalName());
    }

    @Override
    public SimpleType getItemType() {
        return this.b;
    }

    public String applyWhitespaceNormalization(String string) {
        return Whitespace.collapseWhitespace(string).toString();
    }

    @Override
    public void analyzeContentExpression(Expression expression, int n2) {
        BuiltInAtomicType.analyzeContentExpression(this, expression, n2);
    }

    @Override
    public ValidationFailure validateContent(CharSequence object, NamespaceResolver namespaceResolver, ConversionRules conversionRules) {
        ConversionResult conversionResult;
        SimpleType simpleType = this.getItemType();
        object = new Whitespace.Tokenizer((CharSequence)object);
        boolean bl2 = false;
        while ((conversionResult = ((Whitespace.Tokenizer)object).next()) != null) {
            bl2 = true;
            if ((conversionResult = simpleType.validateContent(conversionResult.getStringValue(), namespaceResolver, conversionRules)) == null) continue;
            return conversionResult;
        }
        if (!bl2) {
            return new ValidationFailure("The built-in list type " + StandardNames.getDisplayName(this.a) + " does not allow a zero-length list");
        }
        return null;
    }

    @Override
    public AtomicSequence getTypedValue(CharSequence object, NamespaceResolver namespaceResolver, ConversionRules conversionRules) {
        object = new Whitespace.Tokenizer((CharSequence)object);
        a a2 = new a(0);
        new a(0).a = namespaceResolver;
        a2.b = (AtomicType)this.getItemType();
        a2.c = conversionRules;
        try {
            return new AtomicArray(new MappingIterator<StringValue, AtomicValue>((SequenceIterator<StringValue>)object, a2));
        }
        catch (XPathException xPathException) {
            throw new ValidationException(xPathException);
        }
    }

    private static BuiltInListType a(String object, String string) {
        object = new BuiltInListType(StandardNames.getFingerprint((String)object, string));
        BuiltInType.a(((BuiltInListType)object).getFingerprint(), (SchemaType)object);
        return object;
    }

    @Override
    public CharSequence preprocess(CharSequence charSequence) {
        return charSequence;
    }

    @Override
    public CharSequence postprocess(CharSequence charSequence) {
        return charSequence;
    }

    private static final class a
    implements MappingFunction<StringValue, AtomicValue> {
        public NamespaceResolver a;
        public AtomicType b;
        public ConversionRules c;

        private a() {
        }

        private AtomicIterator a(StringValue stringValue) {
            try {
                return this.b.getTypedValue(stringValue.getStringValueCS(), this.a, this.c).iterate();
            }
            catch (ValidationException validationException) {
                throw new XPathException(validationException);
            }
        }

        @Override
        public final /* synthetic */ SequenceIterator map(Item item) {
            return this.a((StringValue)item);
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

