/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.math.BigDecimal;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.GDayValue;
import net.sf.saxon.value.GMonthDayValue;
import net.sf.saxon.value.GMonthValue;
import net.sf.saxon.value.GYearMonthValue;
import net.sf.saxon.value.GYearValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NotationValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.TimeValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.YearMonthDurationValue;

public abstract class Converter {
    private ConversionRules a;

    public static AtomicValue convert(AtomicValue conversionResult, AtomicType atomicType, ConversionRules object) {
        if ((object = ((ConversionRules)object).getConverter(((AtomicValue)conversionResult).getPrimitiveType(), atomicType)) == null) {
            conversionResult = new ValidationFailure("Cannot convert value from " + ((AtomicValue)conversionResult).getPrimitiveType() + " to " + atomicType);
            ((ValidationFailure)conversionResult).setErrorCode("FORG0001");
            throw ((ValidationFailure)conversionResult).makeException();
        }
        return ((Converter)object).convert((AtomicValue)conversionResult).asAtomic();
    }

    protected Converter() {
    }

    protected Converter(ConversionRules conversionRules) {
        this.setConversionRules(conversionRules);
    }

    public abstract ConversionResult convert(AtomicValue var1);

    public final void setConversionRules(ConversionRules conversionRules) {
        this.a = conversionRules;
    }

    public final ConversionRules getConversionRules() {
        return this.a;
    }

    public boolean isAlwaysSuccessful() {
        return false;
    }

    public Converter setNamespaceResolver(NamespaceResolver namespaceResolver) {
        return this;
    }

    public NamespaceResolver getNamespaceResolver() {
        return null;
    }

    public static class PromoterToFloat
    extends Converter {
        private StringConverter a = null;

        @Override
        public ConversionResult convert(AtomicValue conversionResult) {
            if (conversionResult instanceof FloatValue) {
                return conversionResult;
            }
            if (conversionResult instanceof DoubleValue) {
                conversionResult = new ValidationFailure("Cannot promote from xs:double to xs:float");
                ((ValidationFailure)conversionResult).setErrorCode("XPTY0004");
                return conversionResult;
            }
            if (conversionResult instanceof NumericValue) {
                return new FloatValue((float)((NumericValue)conversionResult).getDoubleValue());
            }
            if (conversionResult instanceof UntypedAtomicValue) {
                if (this.a == null) {
                    this.a = BuiltInAtomicType.FLOAT.getStringConverter(this.getConversionRules());
                }
                return ((Converter)this.a).convert((UntypedAtomicValue)conversionResult);
            }
            conversionResult = new ValidationFailure("Cannot promote non-numeric value to xs:double");
            ((ValidationFailure)conversionResult).setErrorCode("XPTY0004");
            return conversionResult;
        }
    }

    public static class PromoterToDouble
    extends Converter {
        private StringConverter a = null;

        @Override
        public ConversionResult convert(AtomicValue conversionResult) {
            if (conversionResult instanceof DoubleValue) {
                return conversionResult;
            }
            if (conversionResult instanceof NumericValue) {
                return new DoubleValue(((NumericValue)conversionResult).getDoubleValue());
            }
            if (conversionResult instanceof UntypedAtomicValue) {
                if (this.a == null) {
                    this.a = BuiltInAtomicType.DOUBLE.getStringConverter(this.getConversionRules());
                }
                return ((Converter)this.a).convert((UntypedAtomicValue)conversionResult);
            }
            conversionResult = new ValidationFailure("Cannot promote non-numeric value to xs:double");
            ((ValidationFailure)conversionResult).setErrorCode("XPTY0004");
            return conversionResult;
        }
    }

    public static class QNameToNotation
    extends UnfailingConverter {
        public static final QNameToNotation INSTANCE = new QNameToNotation();

        @Override
        public NotationValue convert(AtomicValue atomicValue) {
            return new NotationValue(((QNameValue)atomicValue).getStructuredQName(), BuiltInAtomicType.NOTATION);
        }
    }

    public static class NotationToQName
    extends UnfailingConverter {
        public static final NotationToQName INSTANCE = new NotationToQName();

        @Override
        public QNameValue convert(AtomicValue atomicValue) {
            return new QNameValue(((NotationValue)atomicValue).getStructuredQName(), BuiltInAtomicType.QNAME);
        }
    }

    public static class HexBinaryToBase64Binary
    extends UnfailingConverter {
        public static final HexBinaryToBase64Binary INSTANCE = new HexBinaryToBase64Binary();

        @Override
        public Base64BinaryValue convert(AtomicValue atomicValue) {
            return new Base64BinaryValue(((HexBinaryValue)atomicValue).getBinaryValue());
        }
    }

    public static class Base64BinaryToHexBinary
    extends UnfailingConverter {
        public static final Base64BinaryToHexBinary INSTANCE = new Base64BinaryToHexBinary();

        @Override
        public HexBinaryValue convert(AtomicValue atomicValue) {
            return new HexBinaryValue(((Base64BinaryValue)atomicValue).getBinaryValue());
        }
    }

    public static class NumericToBoolean
    extends UnfailingConverter {
        public static final NumericToBoolean INSTANCE = new NumericToBoolean();

        @Override
        public BooleanValue convert(AtomicValue atomicValue) {
            return BooleanValue.get(((AtomicValue)((NumericValue)atomicValue)).effectiveBooleanValue());
        }
    }

    public static class DateTimeToTime
    extends UnfailingConverter {
        public static final DateTimeToTime INSTANCE = new DateTimeToTime();

        @Override
        public TimeValue convert(AtomicValue atomicValue) {
            atomicValue = (DateTimeValue)atomicValue;
            return new TimeValue(((DateTimeValue)atomicValue).getHour(), ((DateTimeValue)atomicValue).getMinute(), ((DateTimeValue)atomicValue).getSecond(), ((DateTimeValue)atomicValue).getNanosecond(), ((CalendarValue)atomicValue).getTimezoneInMinutes(), "");
        }
    }

    public static class DateTimeToGDay
    extends UnfailingConverter {
        public static final DateTimeToGDay INSTANCE = new DateTimeToGDay();

        @Override
        public GDayValue convert(AtomicValue atomicValue) {
            atomicValue = (DateTimeValue)atomicValue;
            return new GDayValue(((DateTimeValue)atomicValue).getDay(), ((CalendarValue)atomicValue).getTimezoneInMinutes());
        }
    }

    public static class DateTimeToGMonthDay
    extends UnfailingConverter {
        public static final DateTimeToGMonthDay INSTANCE = new DateTimeToGMonthDay();

        @Override
        public GMonthDayValue convert(AtomicValue atomicValue) {
            atomicValue = (DateTimeValue)atomicValue;
            return new GMonthDayValue(((DateTimeValue)atomicValue).getMonth(), ((DateTimeValue)atomicValue).getDay(), ((CalendarValue)atomicValue).getTimezoneInMinutes());
        }
    }

    public static class DateTimeToGYear
    extends UnfailingConverter {
        public static final DateTimeToGYear INSTANCE = new DateTimeToGYear();

        @Override
        public GYearValue convert(AtomicValue atomicValue) {
            atomicValue = (DateTimeValue)atomicValue;
            return new GYearValue(((DateTimeValue)atomicValue).getYear(), ((CalendarValue)atomicValue).getTimezoneInMinutes(), ((DateTimeValue)atomicValue).isXsd10Rules());
        }
    }

    public static class DateTimeToGYearMonth
    extends UnfailingConverter {
        public static final DateTimeToGYearMonth INSTANCE = new DateTimeToGYearMonth();

        @Override
        public GYearMonthValue convert(AtomicValue atomicValue) {
            atomicValue = (DateTimeValue)atomicValue;
            return new GYearMonthValue(((DateTimeValue)atomicValue).getYear(), ((DateTimeValue)atomicValue).getMonth(), ((CalendarValue)atomicValue).getTimezoneInMinutes(), ((DateTimeValue)atomicValue).isXsd10Rules());
        }
    }

    public static class DateTimeToGMonth
    extends UnfailingConverter {
        public static final DateTimeToGMonth INSTANCE = new DateTimeToGMonth();

        @Override
        public GMonthValue convert(AtomicValue atomicValue) {
            atomicValue = (DateTimeValue)atomicValue;
            return new GMonthValue(((DateTimeValue)atomicValue).getMonth(), ((CalendarValue)atomicValue).getTimezoneInMinutes());
        }
    }

    public static class DateTimeToDate
    extends UnfailingConverter {
        public static final DateTimeToDate INSTANCE = new DateTimeToDate();

        @Override
        public DateValue convert(AtomicValue atomicValue) {
            atomicValue = (DateTimeValue)atomicValue;
            return new DateValue(((DateTimeValue)atomicValue).getYear(), ((DateTimeValue)atomicValue).getMonth(), ((DateTimeValue)atomicValue).getDay(), ((CalendarValue)atomicValue).getTimezoneInMinutes(), ((DateTimeValue)atomicValue).isXsd10Rules());
        }
    }

    public static class DateToDateTime
    extends UnfailingConverter {
        public static final DateToDateTime INSTANCE = new DateToDateTime();

        @Override
        public DateTimeValue convert(AtomicValue atomicValue) {
            return ((CalendarValue)((DateValue)atomicValue)).toDateTime();
        }
    }

    public static class DurationToYearMonthDuration
    extends UnfailingConverter {
        public static final DurationToYearMonthDuration INSTANCE = new DurationToYearMonthDuration();

        @Override
        public YearMonthDurationValue convert(AtomicValue atomicValue) {
            return YearMonthDurationValue.fromMonths(((DurationValue)atomicValue).getTotalMonths());
        }
    }

    public static class DurationToDayTimeDuration
    extends UnfailingConverter {
        public static final DurationToDayTimeDuration INSTANCE = new DurationToDayTimeDuration();

        @Override
        public DayTimeDurationValue convert(AtomicValue atomicValue) {
            if (((DurationValue)(atomicValue = (DurationValue)atomicValue)).signum() < 0) {
                return new DayTimeDurationValue(-((DurationValue)atomicValue).getDays(), -((DurationValue)atomicValue).getHours(), -((DurationValue)atomicValue).getMinutes(), -((DurationValue)atomicValue).getSeconds(), -((DurationValue)atomicValue).getNanoseconds());
            }
            return new DayTimeDurationValue(((DurationValue)atomicValue).getDays(), ((DurationValue)atomicValue).getHours(), ((DurationValue)atomicValue).getMinutes(), ((DurationValue)atomicValue).getSeconds(), ((DurationValue)atomicValue).getNanoseconds());
        }
    }

    public static class BooleanToInteger
    extends UnfailingConverter {
        public static final BooleanToInteger INSTANCE = new BooleanToInteger();

        @Override
        public Int64Value convert(AtomicValue atomicValue) {
            if (((BooleanValue)atomicValue).getBooleanValue()) {
                return Int64Value.PLUS_ONE;
            }
            return Int64Value.ZERO;
        }
    }

    public static class NumericToInteger
    extends Converter {
        public static final NumericToInteger INSTANCE = new NumericToInteger();

        @Override
        public ConversionResult convert(AtomicValue object) {
            if ((object = (NumericValue)object) instanceof IntegerValue) {
                return object;
            }
            try {
                if (object instanceof DoubleValue) {
                    return IntegerValue.makeIntegerValue((DoubleValue)object);
                }
                if (object instanceof FloatValue) {
                    return IntegerValue.makeIntegerValue(new DoubleValue(((NumericValue)object).getDoubleValue()));
                }
                return BigIntegerValue.makeIntegerValue(((NumericValue)object).getDecimalValue().toBigInteger());
            }
            catch (ValidationException validationException) {
                object = validationException;
                return validationException.getValidationFailure();
            }
        }
    }

    public static class DecimalToInteger
    extends UnfailingConverter {
        public static final DecimalToInteger INSTANCE = new DecimalToInteger();

        @Override
        public IntegerValue convert(AtomicValue atomicValue) {
            if (atomicValue instanceof IntegerValue) {
                return (IntegerValue)atomicValue;
            }
            return BigIntegerValue.makeIntegerValue(((NumericValue)((BigDecimalValue)atomicValue)).getDecimalValue().toBigInteger());
        }
    }

    public static class FloatToInteger
    extends Converter {
        public static final FloatToInteger INSTANCE = new FloatToInteger();

        @Override
        public ConversionResult convert(AtomicValue atomicValue) {
            return IntegerValue.makeIntegerValue(new DoubleValue(((NumericValue)((FloatValue)atomicValue)).getDoubleValue()));
        }
    }

    public static class DoubleToInteger
    extends Converter {
        public static final DoubleToInteger INSTANCE = new DoubleToInteger();

        @Override
        public ConversionResult convert(AtomicValue atomicValue) {
            return IntegerValue.makeIntegerValue((DoubleValue)atomicValue);
        }
    }

    public static class BooleanToDecimal
    extends UnfailingConverter {
        public static final BooleanToDecimal INSTANCE = new BooleanToDecimal();

        @Override
        public BigDecimalValue convert(AtomicValue atomicValue) {
            if (((BooleanValue)atomicValue).getBooleanValue()) {
                return BigDecimalValue.ONE;
            }
            return BigDecimalValue.ZERO;
        }
    }

    public static class NumericToDecimal
    extends Converter {
        public static final NumericToDecimal INSTANCE = new NumericToDecimal();

        @Override
        public ConversionResult convert(AtomicValue object) {
            try {
                object = ((NumericValue)object).getDecimalValue();
                return new BigDecimalValue((BigDecimal)object);
            }
            catch (ValidationException validationException) {
                object = validationException;
                return validationException.getValidationFailure();
            }
        }
    }

    public static class IntegerToDecimal
    extends UnfailingConverter {
        public static final IntegerToDecimal INSTANCE = new IntegerToDecimal();

        @Override
        public BigDecimalValue convert(AtomicValue atomicValue) {
            if (atomicValue instanceof Int64Value) {
                return new BigDecimalValue(((NumericValue)((Int64Value)atomicValue)).longValue());
            }
            return new BigDecimalValue(((BigIntegerValue)atomicValue).asDecimal());
        }
    }

    public static class FloatToDecimal
    extends Converter {
        public static final FloatToDecimal INSTANCE = new FloatToDecimal();

        @Override
        public ConversionResult convert(AtomicValue object) {
            try {
                return new BigDecimalValue(((NumericValue)((FloatValue)object)).getFloatValue());
            }
            catch (ValidationException validationException) {
                object = validationException;
                return validationException.getValidationFailure();
            }
        }
    }

    public static class DoubleToDecimal
    extends Converter {
        public static final DoubleToDecimal INSTANCE = new DoubleToDecimal();

        @Override
        public ConversionResult convert(AtomicValue object) {
            try {
                return new BigDecimalValue(((NumericValue)((DoubleValue)object)).getDoubleValue());
            }
            catch (ValidationException validationException) {
                object = validationException;
                return validationException.getValidationFailure();
            }
        }
    }

    public static class BooleanToDouble
    extends UnfailingConverter {
        public static final BooleanToDouble INSTANCE = new BooleanToDouble();

        @Override
        public DoubleValue convert(AtomicValue atomicValue) {
            return new DoubleValue(((BooleanValue)atomicValue).getBooleanValue() ? 1.0 : 0.0);
        }
    }

    public static class NumericToDouble
    extends UnfailingConverter {
        public static final NumericToDouble INSTANCE = new NumericToDouble();

        @Override
        public DoubleValue convert(AtomicValue atomicValue) {
            if (atomicValue instanceof DoubleValue) {
                return (DoubleValue)atomicValue;
            }
            return new DoubleValue(((NumericValue)atomicValue).getDoubleValue());
        }
    }

    public static class BooleanToFloat
    extends UnfailingConverter {
        public static final BooleanToFloat INSTANCE = new BooleanToFloat();

        @Override
        public FloatValue convert(AtomicValue atomicValue) {
            return new FloatValue(((BooleanValue)atomicValue).getBooleanValue() ? 1.0f : 0.0f);
        }
    }

    public static class NumericToFloat
    extends UnfailingConverter {
        public static final NumericToFloat INSTANCE = new NumericToFloat();

        @Override
        public FloatValue convert(AtomicValue atomicValue) {
            return new FloatValue(((NumericValue)atomicValue).getFloatValue());
        }
    }

    public static class ToStringConverter
    extends UnfailingConverter {
        public static final ToStringConverter INSTANCE = new ToStringConverter();

        @Override
        public StringValue convert(AtomicValue atomicValue) {
            return new StringValue(atomicValue.getStringValueCS());
        }
    }

    public static class ToUntypedAtomicConverter
    extends UnfailingConverter {
        public static final ToUntypedAtomicConverter INSTANCE = new ToUntypedAtomicConverter();

        @Override
        public UntypedAtomicValue convert(AtomicValue atomicValue) {
            return new UntypedAtomicValue(atomicValue.getStringValueCS());
        }
    }

    public static class TwoPhaseConverter
    extends Converter {
        private Converter a;
        private Converter b;

        public TwoPhaseConverter(Converter converter, Converter converter2) {
            this.a = converter;
            this.b = converter2;
        }

        public static TwoPhaseConverter makeTwoPhaseConverter(AtomicType atomicType, AtomicType atomicType2, AtomicType atomicType3, ConversionRules conversionRules) {
            return new TwoPhaseConverter(conversionRules.getConverter(atomicType, atomicType2), conversionRules.getConverter(atomicType2, atomicType3));
        }

        @Override
        public Converter setNamespaceResolver(NamespaceResolver namespaceResolver) {
            return new TwoPhaseConverter(this.a.setNamespaceResolver(namespaceResolver), this.b.setNamespaceResolver(namespaceResolver));
        }

        @Override
        public ConversionResult convert(AtomicValue conversionResult) {
            if ((conversionResult = this.a.convert((AtomicValue)conversionResult)) instanceof ValidationFailure) {
                return conversionResult;
            }
            if (this.b instanceof DownCastingConverter) {
                ConversionResult conversionResult2 = conversionResult;
                return ((DownCastingConverter)this.b).convert((AtomicValue)conversionResult2, ((AtomicValue)conversionResult2).getCanonicalLexicalRepresentation());
            }
            return this.b.convert((AtomicValue)conversionResult);
        }
    }

    public static class DownCastingConverter
    extends Converter {
        private AtomicType a;

        public DownCastingConverter(AtomicType atomicType, ConversionRules conversionRules) {
            this.a = atomicType;
            this.setConversionRules(conversionRules);
        }

        public AtomicType getTargetType() {
            return this.a;
        }

        @Override
        public ConversionResult convert(AtomicValue atomicValue) {
            AtomicValue atomicValue2 = atomicValue;
            return this.convert(atomicValue2, atomicValue2.getCanonicalLexicalRepresentation());
        }

        public ConversionResult convert(AtomicValue atomicValue, CharSequence object) {
            if ((object = this.a.validate(atomicValue, (CharSequence)object, this.getConversionRules())) == null) {
                return atomicValue.copyAsSubType(this.a);
            }
            return object;
        }

        public ValidationFailure validate(AtomicValue atomicValue, CharSequence charSequence) {
            return this.a.validate(atomicValue, charSequence, this.getConversionRules());
        }
    }

    public static class UpCastingConverter
    extends UnfailingConverter {
        private AtomicType a;

        public UpCastingConverter(AtomicType atomicType) {
            this.a = atomicType;
        }

        @Override
        public AtomicValue convert(AtomicValue atomicValue) {
            return atomicValue.copyAsSubType(this.a);
        }
    }

    public static class IdentityConverter
    extends Converter {
        public static final IdentityConverter INSTANCE = new IdentityConverter();

        @Override
        public ConversionResult convert(AtomicValue atomicValue) {
            return atomicValue;
        }

        @Override
        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static abstract class UnfailingConverter
    extends Converter {
        @Override
        public abstract AtomicValue convert(AtomicValue var1);

        @Override
        public final boolean isAlwaysSuccessful() {
            return true;
        }
    }
}

