/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import net.sf.saxon.Configuration;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.ObjectValue;

public class JavaExternalObjectType
extends ExternalObjectType {
    protected Configuration config;
    protected Class<?> javaClass;

    public JavaExternalObjectType(Configuration configuration, Class<?> clazz) {
        this.config = configuration;
        this.javaClass = clazz;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public String getName() {
        return this.javaClass.getName();
    }

    @Override
    public String getTargetNamespace() {
        return "http://saxon.sf.net/java-type";
    }

    @Override
    public StructuredQName getTypeName() {
        return JavaExternalObjectType.classNameToQName(this.javaClass.getName());
    }

    @Override
    public ItemType getPrimitiveItemType() {
        return this.config.getJavaExternalObjectType(Object.class);
    }

    public int getRelationship(JavaExternalObjectType clazz) {
        clazz = ((JavaExternalObjectType)((Object)clazz)).javaClass;
        if (this.javaClass.equals(clazz)) {
            return 0;
        }
        if (this.javaClass.isAssignableFrom(clazz)) {
            return 1;
        }
        if (clazz.isAssignableFrom(this.javaClass)) {
            return 2;
        }
        if (this.javaClass.isInterface() || clazz.isInterface()) {
            return 3;
        }
        return 4;
    }

    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    @Override
    public boolean matches(Item item, TypeHierarchy typeHierarchy) {
        if (item instanceof ObjectValue) {
            item = ((ObjectValue)item).getObject();
            return this.javaClass.isAssignableFrom(item.getClass());
        }
        return false;
    }

    @Override
    public String toString() {
        return JavaExternalObjectType.classNameToQName(this.javaClass.getName()).getEQName();
    }

    public String getDisplayName() {
        return "java-type:" + this.javaClass.getName();
    }

    public int hashCode() {
        return this.javaClass.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof JavaExternalObjectType && this.javaClass == ((JavaExternalObjectType)object).javaClass;
    }

    public static String classNameToLocalName(String string) {
        return string.replace('$', '-').replace("[", "_-");
    }

    public static String localNameToClassName(String string) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(string.length());
        boolean bl2 = true;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (bl2) {
                if (c2 == '_' && i2 + 1 < string.length() && string.charAt(i2 + 1) == '-') {
                    fastStringBuffer.append('[');
                    ++i2;
                    continue;
                }
                bl2 = false;
                fastStringBuffer.append(c2 == '-' ? (char)'$' : (char)c2);
                continue;
            }
            fastStringBuffer.append(c2 == '-' ? (char)'$' : (char)c2);
        }
        return fastStringBuffer.toString();
    }

    public static StructuredQName classNameToQName(String string) {
        return new StructuredQName("jt", "http://saxon.sf.net/java-type", JavaExternalObjectType.classNameToLocalName(string));
    }
}

