/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.query.AnnotationList;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.AnyFunctionTypeWithAssertions;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public class SpecificFunctionType
extends AnyFunctionType {
    private SequenceType[] a;
    private SequenceType b;
    private AnnotationList c;

    public SpecificFunctionType(SequenceType[] sequenceTypeArray, SequenceType sequenceType) {
        this.a = Objects.requireNonNull(sequenceTypeArray);
        this.b = Objects.requireNonNull(sequenceType);
        this.c = AnnotationList.EMPTY;
    }

    public SpecificFunctionType(SequenceType[] sequenceTypeArray, SequenceType sequenceType, AnnotationList annotationList) {
        this.a = Objects.requireNonNull(sequenceTypeArray);
        this.b = Objects.requireNonNull(sequenceType);
        this.c = Objects.requireNonNull(annotationList);
    }

    public int getArity() {
        return this.a.length;
    }

    @Override
    public SequenceType[] getArgumentTypes() {
        return this.a;
    }

    @Override
    public SequenceType getResultType() {
        return this.b;
    }

    @Override
    public AnnotationList getAnnotationAssertions() {
        return this.c;
    }

    @Override
    public boolean isAtomizable(TypeHierarchy typeHierarchy) {
        if (this.getArity() != 1) {
            return false;
        }
        ItemType itemType = ((AnyFunctionType)this).getArgumentTypes()[0].getPrimaryType();
        return typeHierarchy.isSubType(BuiltInAtomicType.INTEGER, itemType);
    }

    @Override
    public String toString() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(100);
        fastStringBuffer.append("(function(");
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            fastStringBuffer.append(this.a[i2].toString());
            if (i2 >= this.a.length - 1) continue;
            fastStringBuffer.append(", ");
        }
        fastStringBuffer.append(") as ");
        fastStringBuffer.append(this.b.toString());
        fastStringBuffer.append(')');
        return fastStringBuffer.toString();
    }

    @Override
    public String toExportString() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(100);
        fastStringBuffer.append("(function(");
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            fastStringBuffer.append(this.a[i2].toExportString());
            if (i2 >= this.a.length - 1) continue;
            fastStringBuffer.append(", ");
        }
        fastStringBuffer.append(") as ");
        fastStringBuffer.append(this.b.toExportString());
        fastStringBuffer.append(')');
        return fastStringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof SpecificFunctionType) {
            object = (SpecificFunctionType)object;
            if (!this.b.equals(((SpecificFunctionType)object).b)) {
                return false;
            }
            if (this.a.length != ((SpecificFunctionType)object).a.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                if (this.a[i2].equals(((SpecificFunctionType)object).a[i2])) continue;
                return false;
            }
            return ((AnyFunctionType)this).getAnnotationAssertions().equals(((AnyFunctionType)object).getAnnotationAssertions());
        }
        return false;
    }

    public int hashCode() {
        int n2 = this.b.hashCode() ^ this.a.length;
        SequenceType[] sequenceTypeArray = this.a;
        int n3 = this.a.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            SequenceType sequenceType = sequenceTypeArray[i2];
            n2 ^= sequenceType.hashCode();
        }
        return n2;
    }

    @Override
    public int relationship(FunctionItemType functionItemType, TypeHierarchy typeHierarchy) {
        int n2;
        if (functionItemType == AnyFunctionType.getInstance() || functionItemType instanceof AnyFunctionTypeWithAssertions) {
            return 2;
        }
        if (this.equals(functionItemType)) {
            return 0;
        }
        if (functionItemType instanceof ArrayItemType || functionItemType instanceof MapType) {
            int n3 = functionItemType.relationship(this, typeHierarchy);
            switch (n3) {
                case 1: {
                    return 2;
                }
                case 2: {
                    return 1;
                }
            }
            return n3;
        }
        if (this.a.length != functionItemType.getArgumentTypes().length) {
            return 4;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        block16: for (n2 = 0; n2 < this.a.length; ++n2) {
            int n4 = typeHierarchy.sequenceTypeRelationship(this.a[n2], functionItemType.getArgumentTypes()[n2]);
            switch (n4) {
                case 4: {
                    return 4;
                }
                case 1: {
                    bl3 = true;
                    continue block16;
                }
                case 2: {
                    bl2 = true;
                    continue block16;
                }
                case 3: {
                    bl2 = true;
                    bl3 = true;
                }
            }
        }
        n2 = typeHierarchy.sequenceTypeRelationship(this.b, functionItemType.getResultType());
        switch (n2) {
            case 4: {
                return 4;
            }
            case 1: {
                bl2 = true;
                break;
            }
            case 2: {
                bl3 = true;
                break;
            }
            case 3: {
                bl2 = true;
                bl3 = true;
            }
        }
        if (bl2) {
            if (bl3) {
                return 3;
            }
            return 1;
        }
        if (bl3) {
            return 2;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean matches(Item iterator2, TypeHierarchy typeHierarchy) {
        void var2_5;
        if (!(iterator2 instanceof Function)) {
            return false;
        }
        if (iterator2 instanceof MapItem) {
            if (this.getArity() == 1 && this.a[0].getCardinality() == 16384 && this.a[0].getPrimaryType().isPlainType() && Cardinality.allowsZero(this.b.getCardinality())) {
                for (KeyValuePair keyValuePair : ((MapItem)((Object)iterator2)).keyValuePairs()) {
                    try {
                        if (this.b.matches(keyValuePair.value, (TypeHierarchy)var2_5)) continue;
                        return false;
                    }
                    catch (XPathException xPathException) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
        if (iterator2 instanceof ArrayItem) {
            if (this.getArity() == 1 && this.a[0].getCardinality() == 16384 && this.a[0].getPrimaryType().isPlainType()) {
                int n2 = var2_5.relationship(this.a[0].getPrimaryType(), BuiltInAtomicType.INTEGER);
                if (n2 != 0 && n2 != 2) {
                    return false;
                }
                for (Sequence sequence : ((ArrayItem)((Object)iterator2)).members()) {
                    try {
                        if (this.b.matches(sequence, (TypeHierarchy)var2_5)) continue;
                        return false;
                    }
                    catch (XPathException xPathException) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
        int n3 = var2_5.relationship(((Function)((Object)iterator2)).getFunctionItemType(), this);
        return n3 == 0 || n3 == 2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<String> explainMismatch(Item optional, TypeHierarchy optional2) {
        Object object;
        Object object2;
        if (!(optional instanceof Function)) {
            return Optional.empty();
        }
        if (optional instanceof MapItem) {
            if (this.getArity() != 1) {
                String string = "The function arity is " + this.getArity() + "; a map can only be supplied for a function type with arity 1";
                return Optional.of(string);
            }
            if (this.a[0].getCardinality() == 16384 && this.a[0].getPrimaryType().isPlainType()) {
                object2 = ((MapItem)((Object)optional)).keyValuePairs().iterator();
            } else {
                String string = "The function argument is of type " + this.a[0] + "; a map can only be supplied for a function type whose argument type is atomic";
                return Optional.of(string);
            }
            while (object2.hasNext()) {
                KeyValuePair keyValuePair = object2.next();
                try {
                    if (this.b.matches((Sequence<?>)keyValuePair.value, (TypeHierarchy)((Object)optional2))) continue;
                    String string = "The supplied map contains an entry with key (" + keyValuePair.key + ") whose corresponding value (" + Err.depictSequence(keyValuePair.value) + ") is not an instance of the return type in the function signature (" + this.b + ")";
                    optional = this.b.explainMismatch(keyValuePair.value, (TypeHierarchy)((Object)optional2));
                    if (optional.isPresent()) {
                        string = string + ". " + (String)optional.get();
                    }
                    return Optional.of(string);
                }
                catch (XPathException xPathException) {
                    return Optional.empty();
                }
            }
        }
        if (optional instanceof ArrayItem) {
            Iterator iterator;
            if (this.getArity() != 1) {
                object2 = "The function arity is " + this.getArity() + "; an array can only be supplied for a function type with arity 1";
                return Optional.of(object2);
            }
            if (this.a[0].getCardinality() == 16384 && this.a[0].getPrimaryType().isPlainType()) {
                int n2 = ((TypeHierarchy)((Object)optional2)).relationship(this.a[0].getPrimaryType(), BuiltInAtomicType.INTEGER);
                if (n2 != 0 && n2 != 2) {
                    String string = "The function expects an argument of type " + this.a[0] + "; an array can only be supplied for a function that expects an integer";
                    return Optional.of(string);
                }
                iterator = ((ArrayItem)((Object)optional)).iterator();
            } else {
                object2 = "The function argument is of type " + this.a[0] + "; an array can only be supplied for a function type whose argument type is xs:integer";
                return Optional.of(object2);
            }
            while (iterator.hasNext()) {
                object = (GroundedValue)iterator.next();
                try {
                    if (this.b.matches((Sequence<?>)object, (TypeHierarchy)((Object)optional2))) continue;
                    optional = "The supplied array contains an entry (" + Err.depictSequence(object) + ") is not an instance of the return type in the function signature (" + this.b + ")";
                    if ((optional2 = this.b.explainMismatch((GroundedValue)object, (TypeHierarchy)((Object)optional2))).isPresent()) {
                        optional = (String)((Object)optional) + ". " + optional2.get();
                    }
                    return Optional.of(optional);
                }
                catch (XPathException xPathException) {
                    return Optional.empty();
                }
            }
        }
        object2 = ((Function)((Object)optional)).getFunctionItemType();
        if (this.getArity() != ((Function)((Object)optional)).getArity()) {
            String string = "The required function arity is " + this.getArity() + "; the supplied function has arity " + ((Function)((Object)optional)).getArity();
            return Optional.of(string);
        }
        int n3 = ((TypeHierarchy)((Object)optional2)).sequenceTypeRelationship(this.b, object2.getResultType());
        if (n3 != 0 && n3 != 1) {
            object = "The return type of the required function is " + this.b + " but the returntype of the supplied function is " + object2.getResultType();
            return Optional.of(object);
        }
        int n4 = 0;
        while (n4 < this.getArity()) {
            int n5 = ((TypeHierarchy)((Object)optional2)).sequenceTypeRelationship(this.a[n4], object2.getArgumentTypes()[n4]);
            if (n5 != 0 && n5 != 2) {
                optional = "The type of the " + RoleDiagnostic.ordinal(n4 + 1) + " argument of the required function is " + this.a[n4] + " but the declaredtype of the corresponding argument of the supplied function is " + object2.getArgumentTypes()[n4];
                return Optional.of(optional);
            }
            ++n4;
        }
        return Optional.empty();
    }

    @Override
    public Expression makeFunctionSequenceCoercer(Expression expression, RoleDiagnostic roleDiagnostic) {
        return expression.getConfiguration().makeFunctionSequenceCoercer(this, expression, roleDiagnostic);
    }

    @Override
    public String generateJavaScriptItemTypeTest(ItemType itemType, int n2) {
        throw new XPathException("Cannot generate JS code for function type tests", "SXJS0001");
    }
}

