/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.util.regex.Pattern;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.GDayValue;
import net.sf.saxon.value.GMonthDayValue;
import net.sf.saxon.value.GMonthValue;
import net.sf.saxon.value.GYearMonthValue;
import net.sf.saxon.value.GYearValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NotationValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.TimeValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.value.YearMonthDurationValue;

public abstract class StringConverter
extends Converter {
    protected StringConverter() {
    }

    protected StringConverter(ConversionRules conversionRules) {
        super(conversionRules);
    }

    public abstract ConversionResult convertString(CharSequence var1);

    public ValidationFailure validate(CharSequence object) {
        if ((object = this.convertString((CharSequence)object)) instanceof ValidationFailure) {
            return (ValidationFailure)object;
        }
        return null;
    }

    @Override
    public ConversionResult convert(AtomicValue atomicValue) {
        return this.convertString(atomicValue.getStringValueCS());
    }

    public static class StringToUnionConverter
    extends StringConverter {
        private SimpleType a;
        private ConversionRules b;

        public StringToUnionConverter(PlainType plainType, ConversionRules conversionRules) {
            if (!plainType.isPlainType()) {
                throw new IllegalArgumentException();
            }
            if (((SimpleType)((Object)plainType)).isNamespaceSensitive()) {
                throw new IllegalArgumentException();
            }
            this.a = (SimpleType)((Object)plainType);
            this.b = conversionRules;
        }

        @Override
        public ConversionResult convertString(CharSequence object) {
            try {
                return this.a.getTypedValue((CharSequence)object, null, this.b).head();
            }
            catch (ValidationException validationException) {
                object = validationException;
                return validationException.getValidationFailure();
            }
        }
    }

    public static class StringToAnyURI
    extends StringConverter {
        public StringToAnyURI(ConversionRules conversionRules) {
            super(conversionRules);
        }

        @Override
        public ConversionResult convertString(CharSequence charSequence) {
            if (this.getConversionRules().isValidURI(charSequence)) {
                return new AnyURIValue(charSequence);
            }
            return new ValidationFailure("Invalid URI: " + charSequence);
        }

        @Override
        public ValidationFailure validate(CharSequence charSequence) {
            if (this.getConversionRules().isValidURI(charSequence)) {
                return null;
            }
            return new ValidationFailure("Invalid URI: " + charSequence);
        }
    }

    public static class StringToNotation
    extends StringConverter {
        private NamespaceResolver a;

        public StringToNotation(ConversionRules conversionRules) {
            super(conversionRules);
        }

        @Override
        public StringToNotation setNamespaceResolver(NamespaceResolver namespaceResolver) {
            StringToNotation stringToNotation = new StringToNotation(this.getConversionRules());
            new StringToNotation(this.getConversionRules()).a = namespaceResolver;
            return stringToNotation;
        }

        @Override
        public NamespaceResolver getNamespaceResolver() {
            return this.a;
        }

        @Override
        public ConversionResult convertString(CharSequence charSequence) {
            if (((Converter)this).getNamespaceResolver() == null) {
                throw new UnsupportedOperationException("Cannot validate a NOTATION without a namespace resolver");
            }
            try {
                String[] stringArray = NameChecker.getQNameParts(Whitespace.trimWhitespace(charSequence));
                String string = ((Converter)this).getNamespaceResolver().getURIForPrefix(stringArray[0], true);
                if (string == null) {
                    return new ValidationFailure("Namespace prefix " + Err.wrap(stringArray[0]) + " has not been declared");
                }
                if (!this.getConversionRules().isDeclaredNotation(string, stringArray[1])) {
                    return new ValidationFailure("Notation {" + string + "}" + stringArray[1] + " is not declared in the schema");
                }
                return new NotationValue(stringArray[0], string, stringArray[1], false);
            }
            catch (QNameException qNameException) {
                return new ValidationFailure("Invalid lexical QName " + Err.wrap(charSequence));
            }
            catch (XPathException xPathException) {
                return new ValidationFailure(xPathException.getMessage());
            }
        }
    }

    public static class StringToQName
    extends StringConverter {
        private NamespaceResolver a;

        public StringToQName(ConversionRules conversionRules) {
            super(conversionRules);
        }

        @Override
        public StringToQName setNamespaceResolver(NamespaceResolver namespaceResolver) {
            StringToQName stringToQName = new StringToQName(this.getConversionRules());
            new StringToQName(this.getConversionRules()).a = namespaceResolver;
            return stringToQName;
        }

        @Override
        public NamespaceResolver getNamespaceResolver() {
            return this.a;
        }

        @Override
        public ConversionResult convertString(CharSequence charSequence) {
            if (this.a == null) {
                throw new UnsupportedOperationException("Cannot validate a QName without a namespace resolver");
            }
            try {
                Object object = NameChecker.getQNameParts(Whitespace.trimWhitespace(charSequence));
                String string = this.a.getURIForPrefix(object[0], true);
                if (string == null) {
                    object = new ValidationFailure("Namespace prefix " + Err.wrap(object[0]) + " has not been declared");
                    object.setErrorCode("FONS0004");
                    return object;
                }
                return new QNameValue(object[0], string, object[1], BuiltInAtomicType.QNAME, false);
            }
            catch (QNameException qNameException) {
                return new ValidationFailure("Invalid lexical QName " + Err.wrap(charSequence));
            }
            catch (XPathException xPathException) {
                return new ValidationFailure(xPathException.getMessage());
            }
        }
    }

    public static class StringToBase64Binary
    extends StringConverter {
        public static final StringToBase64Binary INSTANCE = new StringToBase64Binary();

        @Override
        public ConversionResult convertString(CharSequence object) {
            try {
                return new Base64BinaryValue((CharSequence)object);
            }
            catch (XPathException xPathException) {
                object = xPathException;
                return ValidationFailure.fromException(xPathException);
            }
        }
    }

    public static class StringToHexBinary
    extends StringConverter {
        public static final StringToHexBinary INSTANCE = new StringToHexBinary();

        @Override
        public ConversionResult convertString(CharSequence object) {
            try {
                return new HexBinaryValue((CharSequence)object);
            }
            catch (XPathException xPathException) {
                object = xPathException;
                return ValidationFailure.fromException(xPathException);
            }
        }
    }

    public static class StringToBoolean
    extends StringConverter {
        public static final StringToBoolean INSTANCE = new StringToBoolean();

        @Override
        public ConversionResult convertString(CharSequence charSequence) {
            return BooleanValue.fromString(charSequence);
        }
    }

    public static class StringToTime
    extends StringConverter {
        public static final StringToTime INSTANCE = new StringToTime();

        @Override
        public ConversionResult convertString(CharSequence charSequence) {
            return TimeValue.makeTimeValue(charSequence);
        }
    }

    public static class StringToGDay
    extends StringConverter {
        public static final StringToGDay INSTANCE = new StringToGDay();

        @Override
        public ConversionResult convertString(CharSequence charSequence) {
            return GDayValue.makeGDayValue(charSequence);
        }
    }

    public static class StringToGMonthDay
    extends StringConverter {
        public static final StringToGMonthDay INSTANCE = new StringToGMonthDay();

        @Override
        public ConversionResult convertString(CharSequence charSequence) {
            return GMonthDayValue.makeGMonthDayValue(charSequence);
        }
    }

    public static class StringToGYear
    extends StringConverter {
        public StringToGYear(ConversionRules conversionRules) {
            super(conversionRules);
        }

        @Override
        public ConversionResult convertString(CharSequence charSequence) {
            return GYearValue.makeGYearValue(charSequence, this.getConversionRules());
        }
    }

    public static class StringToGYearMonth
    extends StringConverter {
        public StringToGYearMonth(ConversionRules conversionRules) {
            super(conversionRules);
        }

        @Override
        public ConversionResult convertString(CharSequence charSequence) {
            return GYearMonthValue.makeGYearMonthValue(charSequence, this.getConversionRules());
        }
    }

    public static class StringToGMonth
    extends StringConverter {
        public static final StringToGMonth INSTANCE = new StringToGMonth();

        @Override
        public ConversionResult convertString(CharSequence charSequence) {
            return GMonthValue.makeGMonthValue(charSequence);
        }
    }

    public static class StringToDate
    extends StringConverter {
        public StringToDate(ConversionRules conversionRules) {
            super(conversionRules);
        }

        @Override
        public ConversionResult convertString(CharSequence charSequence) {
            return DateValue.makeDateValue(charSequence, this.getConversionRules());
        }
    }

    public static class StringToDateTimeStamp
    extends StringConverter {
        public StringToDateTimeStamp(ConversionRules conversionRules) {
            super(conversionRules);
        }

        @Override
        public ConversionResult convertString(CharSequence charSequence) {
            ConversionResult conversionResult = DateTimeValue.makeDateTimeValue(charSequence, this.getConversionRules());
            if (conversionResult instanceof DateTimeValue) {
                if (!((DateTimeValue)conversionResult).hasTimezone()) {
                    return new ValidationFailure("Supplied DateTimeStamp value " + charSequence + " has no time zone");
                }
                ((DateTimeValue)conversionResult).setTypeLabel(BuiltInAtomicType.DATE_TIME_STAMP);
            }
            return conversionResult;
        }
    }

    public static class StringToDateTime
    extends StringConverter {
        public StringToDateTime(ConversionRules conversionRules) {
            super(conversionRules);
        }

        @Override
        public ConversionResult convertString(CharSequence charSequence) {
            return DateTimeValue.makeDateTimeValue(charSequence, this.getConversionRules());
        }
    }

    public static class StringToYearMonthDuration
    extends StringConverter {
        public static final StringToYearMonthDuration INSTANCE = new StringToYearMonthDuration();

        @Override
        public ConversionResult convertString(CharSequence charSequence) {
            return YearMonthDurationValue.makeYearMonthDurationValue(charSequence);
        }
    }

    public static class StringToDayTimeDuration
    extends StringConverter {
        public static final StringToDayTimeDuration INSTANCE = new StringToDayTimeDuration();

        @Override
        public ConversionResult convertString(CharSequence charSequence) {
            return DayTimeDurationValue.makeDayTimeDurationValue(charSequence);
        }
    }

    public static class StringToDuration
    extends StringConverter {
        public static final StringToDuration INSTANCE = new StringToDuration();

        @Override
        public ConversionResult convertString(CharSequence charSequence) {
            return DurationValue.makeDuration(charSequence);
        }
    }

    public static class StringToIntegerSubtype
    extends StringConverter {
        private BuiltInAtomicType a;

        public StringToIntegerSubtype(BuiltInAtomicType builtInAtomicType) {
            this.a = builtInAtomicType;
        }

        @Override
        public ConversionResult convertString(CharSequence object) {
            if ((object = IntegerValue.stringToInteger((CharSequence)object)) instanceof Int64Value) {
                boolean bl2 = IntegerValue.checkRange(((NumericValue)((Int64Value)object)).longValue(), this.a);
                if (bl2) {
                    return ((AtomicValue)((Int64Value)object)).copyAsSubType(this.a);
                }
                return new ValidationFailure("Integer value is out of range for type " + this.a);
            }
            if (object instanceof BigIntegerValue) {
                boolean bl3 = IntegerValue.checkBigRange(((IntegerValue)((BigIntegerValue)object)).asBigInteger(), this.a);
                if (bl3) {
                    ((BigIntegerValue)object).setTypeLabel(this.a);
                    return object;
                }
                return new ValidationFailure("Integer value is out of range for type " + this.a);
            }
            assert (object instanceof ValidationFailure);
            return object;
        }
    }

    public static class StringToInteger
    extends StringConverter {
        public static final StringToInteger INSTANCE = new StringToInteger();

        public ConversionResult convert(StringValue stringValue) {
            return IntegerValue.stringToInteger(stringValue.getStringValueCS());
        }

        @Override
        public ConversionResult convertString(CharSequence charSequence) {
            return IntegerValue.stringToInteger(charSequence);
        }

        @Override
        public ValidationFailure validate(CharSequence charSequence) {
            return IntegerValue.castableAsInteger(charSequence);
        }
    }

    public static class StringToDecimal
    extends StringConverter {
        public static final StringToDecimal INSTANCE = new StringToDecimal();

        @Override
        public ConversionResult convertString(CharSequence charSequence) {
            return BigDecimalValue.makeDecimalValue(charSequence, true);
        }

        @Override
        public ValidationFailure validate(CharSequence charSequence) {
            if (BigDecimalValue.castableAsDecimal(charSequence)) {
                return null;
            }
            return new ValidationFailure("Cannot convert string to decimal: " + charSequence);
        }
    }

    public static class StringToFloat
    extends StringConverter {
        public StringToFloat(ConversionRules conversionRules) {
            super(conversionRules);
        }

        @Override
        public ConversionResult convertString(CharSequence object) {
            try {
                float f2 = (float)this.getConversionRules().getStringToDoubleConverter().stringToNumber((CharSequence)object);
                return new FloatValue(f2);
            }
            catch (NumberFormatException numberFormatException) {
                object = new ValidationFailure("Cannot convert string to float: " + object);
                ((ValidationFailure)object).setErrorCode("FORG0001");
                return object;
            }
        }
    }

    public static class StringToDerivedStringSubtype
    extends StringConverter {
        private AtomicType a;
        private StringConverter b;
        private int c;

        public StringToDerivedStringSubtype(ConversionRules conversionRules, AtomicType atomicType) {
            super(conversionRules);
            this.a = atomicType;
            this.c = atomicType.getWhitespaceAction();
            this.b = ((AtomicType)atomicType.getBuiltInBaseType()).getStringConverter(conversionRules);
        }

        @Override
        public ConversionResult convertString(CharSequence charSequence) {
            ValidationFailure validationFailure = this.b.validate(charSequence = Whitespace.applyWhitespaceNormalization(this.c, charSequence));
            if (validationFailure != null) {
                return validationFailure;
            }
            try {
                charSequence = this.a.preprocess(charSequence);
            }
            catch (ValidationException validationException) {
                ValidationException validationException2 = validationException;
                return validationException.getValidationFailure();
            }
            StringValue stringValue = new StringValue(charSequence);
            validationFailure = this.a.validate(stringValue, charSequence, this.getConversionRules());
            if (validationFailure == null) {
                stringValue.setTypeLabel(this.a);
                return stringValue;
            }
            return validationFailure;
        }
    }

    public static class StringToStringSubtype
    extends StringConverter {
        private AtomicType a;
        private int b;

        public StringToStringSubtype(ConversionRules conversionRules, AtomicType atomicType) {
            super(conversionRules);
            this.a = atomicType;
            this.b = atomicType.getWhitespaceAction();
        }

        @Override
        public ConversionResult convertString(CharSequence object) {
            object = Whitespace.applyWhitespaceNormalization(this.b, (CharSequence)object);
            try {
                object = this.a.preprocess((CharSequence)object);
            }
            catch (ValidationException validationException) {
                ValidationException validationException2 = validationException;
                return validationException.getValidationFailure();
            }
            StringValue stringValue = new StringValue((CharSequence)object);
            object = this.a.validate(stringValue, (CharSequence)object, this.getConversionRules());
            if (object == null) {
                stringValue.setTypeLabel(this.a);
                return stringValue;
            }
            return object;
        }

        @Override
        public ValidationFailure validate(CharSequence object) {
            object = Whitespace.applyWhitespaceNormalization(this.b, (CharSequence)object);
            try {
                object = this.a.preprocess((CharSequence)object);
            }
            catch (ValidationException validationException) {
                object = validationException;
                return validationException.getValidationFailure();
            }
            return this.a.validate(new StringValue((CharSequence)object), (CharSequence)object, this.getConversionRules());
        }
    }

    public static class StringToName
    extends StringToNCName {
        public static final StringToName INSTANCE = new StringToName();

        public StringToName() {
            super(BuiltInAtomicType.NAME);
        }

        @Override
        public ConversionResult convertString(CharSequence charSequence) {
            ValidationFailure validationFailure = ((StringConverter)this).validate(charSequence);
            if (validationFailure == null) {
                return new StringValue(Whitespace.trimWhitespace(charSequence), BuiltInAtomicType.NAME);
            }
            return validationFailure;
        }

        @Override
        public ValidationFailure validate(CharSequence charSequence) {
            if (NameChecker.isValidNCName(charSequence = Whitespace.trimWhitespace(charSequence))) {
                return null;
            }
            FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length());
            fastStringBuffer.append(charSequence);
            for (int i2 = 0; i2 < fastStringBuffer.length(); ++i2) {
                if (fastStringBuffer.charAt(i2) != ':') continue;
                fastStringBuffer.setCharAt(i2, '_');
            }
            if (NameChecker.isValidNCName(fastStringBuffer)) {
                return null;
            }
            return new ValidationFailure("The value '" + charSequence + "' is not a valid xs:Name");
        }
    }

    public static class StringToNMTOKEN
    extends StringConverter {
        public static final StringToNMTOKEN INSTANCE = new StringToNMTOKEN();

        @Override
        public ConversionResult convertString(CharSequence charSequence) {
            CharSequence charSequence2 = Whitespace.trimWhitespace(charSequence);
            if (NameChecker.isValidNmtoken(charSequence2)) {
                return new StringValue(charSequence2, BuiltInAtomicType.NMTOKEN);
            }
            return new ValidationFailure("The value '" + charSequence + "' is not a valid xs:NMTOKEN");
        }

        @Override
        public ValidationFailure validate(CharSequence charSequence) {
            if (NameChecker.isValidNmtoken(Whitespace.trimWhitespace(charSequence))) {
                return null;
            }
            return new ValidationFailure("The value '" + charSequence + "' is not a valid xs:NMTOKEN");
        }
    }

    public static class StringToNCName
    extends StringConverter {
        public static final StringToNCName TO_ID = new StringToNCName(BuiltInAtomicType.ID);
        public static final StringToNCName TO_ENTITY = new StringToNCName(BuiltInAtomicType.ENTITY);
        public static final StringToNCName TO_NCNAME = new StringToNCName(BuiltInAtomicType.NCNAME);
        public static final StringToNCName TO_IDREF = new StringToNCName(BuiltInAtomicType.IDREF);
        private AtomicType a;

        public StringToNCName(AtomicType atomicType) {
            this.a = atomicType;
        }

        @Override
        public ConversionResult convertString(CharSequence charSequence) {
            CharSequence charSequence2 = Whitespace.trimWhitespace(charSequence);
            if (NameChecker.isValidNCName(charSequence2)) {
                return new StringValue(charSequence2, this.a);
            }
            return new ValidationFailure("The value '" + charSequence + "' is not a valid " + this.a.getDisplayName());
        }

        @Override
        public ValidationFailure validate(CharSequence charSequence) {
            if (NameChecker.isValidNCName(Whitespace.trimWhitespace(charSequence))) {
                return null;
            }
            return new ValidationFailure("The value '" + charSequence + "' is not a valid " + this.a.getDisplayName());
        }
    }

    public static class StringToLanguage
    extends StringConverter {
        private static final Pattern a = Pattern.compile("[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*");
        public static final StringToLanguage INSTANCE = new StringToLanguage();

        @Override
        public ConversionResult convertString(CharSequence charSequence) {
            CharSequence charSequence2 = Whitespace.trimWhitespace(charSequence);
            if (!a.matcher(charSequence2).matches()) {
                return new ValidationFailure("The value '" + charSequence + "' is not a valid xs:language");
            }
            return new StringValue(charSequence2, BuiltInAtomicType.LANGUAGE);
        }

        @Override
        public ValidationFailure validate(CharSequence charSequence) {
            if (a.matcher(Whitespace.trimWhitespace(charSequence)).matches()) {
                return null;
            }
            return new ValidationFailure("The value '" + charSequence + "' is not a valid xs:language");
        }
    }

    public static class StringToToken
    extends StringConverter {
        public static final StringToToken INSTANCE = new StringToToken();

        @Override
        public ConversionResult convertString(CharSequence charSequence) {
            return new StringValue(Whitespace.collapseWhitespace(charSequence), BuiltInAtomicType.TOKEN);
        }

        @Override
        public ValidationFailure validate(CharSequence charSequence) {
            return null;
        }

        @Override
        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class StringToNormalizedString
    extends StringConverter {
        public static final StringToNormalizedString INSTANCE = new StringToNormalizedString();

        @Override
        public ConversionResult convertString(CharSequence charSequence) {
            return new StringValue(Whitespace.normalizeWhitespace(charSequence), BuiltInAtomicType.NORMALIZED_STRING);
        }

        @Override
        public ValidationFailure validate(CharSequence charSequence) {
            return null;
        }

        @Override
        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class StringToUntypedAtomic
    extends StringConverter {
        public static final StringToUntypedAtomic INSTANCE = new StringToUntypedAtomic();

        @Override
        public UntypedAtomicValue convert(AtomicValue atomicValue) {
            return new UntypedAtomicValue(atomicValue.getStringValueCS());
        }

        @Override
        public ConversionResult convertString(CharSequence charSequence) {
            return new UntypedAtomicValue(charSequence);
        }

        @Override
        public ValidationFailure validate(CharSequence charSequence) {
            return null;
        }

        @Override
        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class StringToString
    extends StringConverter {
        public static final StringToString INSTANCE = new StringToString();

        @Override
        public ConversionResult convert(AtomicValue atomicValue) {
            return new StringValue(atomicValue.getStringValueCS());
        }

        @Override
        public ConversionResult convertString(CharSequence charSequence) {
            return new StringValue(charSequence);
        }

        @Override
        public ValidationFailure validate(CharSequence charSequence) {
            return null;
        }

        @Override
        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class StringToNonStringDerivedType
    extends StringConverter {
        private StringConverter a;
        private Converter.DownCastingConverter b;

        public StringToNonStringDerivedType(StringConverter stringConverter, Converter.DownCastingConverter downCastingConverter) {
            this.a = stringConverter;
            this.b = downCastingConverter;
        }

        @Override
        public StringToNonStringDerivedType setNamespaceResolver(NamespaceResolver namespaceResolver) {
            return new StringToNonStringDerivedType((StringConverter)this.a.setNamespaceResolver(namespaceResolver), (Converter.DownCastingConverter)this.b.setNamespaceResolver(namespaceResolver));
        }

        public ConversionResult convert(StringValue object) {
            object = ((AtomicValue)object).getStringValueCS();
            try {
                object = this.b.getTargetType().preprocess((CharSequence)object);
            }
            catch (ValidationException validationException) {
                ValidationException validationException2 = validationException;
                return validationException.getValidationFailure();
            }
            ConversionResult conversionResult = this.a.convertString((CharSequence)object);
            if (conversionResult instanceof ValidationFailure) {
                return conversionResult;
            }
            return this.b.convert((AtomicValue)conversionResult, (CharSequence)object);
        }

        @Override
        public ConversionResult convertString(CharSequence charSequence) {
            try {
                charSequence = this.b.getTargetType().preprocess(charSequence);
            }
            catch (ValidationException validationException) {
                ValidationException validationException2 = validationException;
                return validationException.getValidationFailure();
            }
            ConversionResult conversionResult = this.a.convertString(charSequence);
            if (conversionResult instanceof ValidationFailure) {
                return conversionResult;
            }
            return this.b.convert((AtomicValue)conversionResult, charSequence);
        }

        @Override
        public ValidationFailure validate(CharSequence charSequence) {
            try {
                charSequence = this.b.getTargetType().preprocess(charSequence);
            }
            catch (ValidationException validationException) {
                ValidationException validationException2 = validationException;
                return validationException.getValidationFailure();
            }
            ConversionResult conversionResult = this.a.convertString(charSequence);
            if (conversionResult instanceof ValidationFailure) {
                return (ValidationFailure)conversionResult;
            }
            return this.b.validate((AtomicValue)conversionResult, charSequence);
        }
    }
}

