/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import net.sf.saxon.trans.Err;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.Whitespace;

public class StringToDouble
extends StringConverter {
    private static StringToDouble a = new StringToDouble();
    private static double[] b = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8};

    public static StringToDouble getInstance() {
        return a;
    }

    protected StringToDouble() {
    }

    public double stringToNumber(CharSequence charSequence) {
        String string;
        int n2;
        int n3 = charSequence.length();
        boolean bl2 = false;
        boolean bl3 = false;
        if (n3 < 9) {
            int n4;
            n2 = 0;
            long l2 = 0L;
            int n5 = -1;
            int n6 = -1;
            boolean bl4 = false;
            block10: for (n4 = 0; n4 < n3; ++n4) {
                char c2 = charSequence.charAt(n4);
                switch (c2) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        bl3 = true;
                        if (n6 == -1) continue block10;
                        bl4 = true;
                        continue block10;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        if (bl4) {
                            throw new NumberFormatException("Numeric value contains embedded whitespace");
                        }
                        n6 = n4;
                        l2 = l2 * 10L + (long)(c2 - 48);
                        continue block10;
                    }
                    case '.': {
                        if (bl4) {
                            throw new NumberFormatException("Numeric value contains embedded whitespace");
                        }
                        if (n5 != -1) {
                            throw new NumberFormatException("Only one decimal point allowed");
                        }
                        n5 = n4;
                        continue block10;
                    }
                    case 'D': 
                    case 'F': 
                    case 'N': 
                    case 'X': 
                    case 'd': 
                    case 'f': 
                    case 'n': 
                    case 'x': {
                        bl2 = true;
                        n2 = 1;
                        break block10;
                    }
                    default: {
                        n2 = 1;
                    }
                }
            }
            if (n2 == 0) {
                if (n6 == -1) {
                    throw new NumberFormatException("String to double conversion: no digits found");
                }
                if (n5 == -1 || n5 > n6) {
                    return l2;
                }
                n4 = n6 - n5;
                return (double)l2 / b[n4];
            }
        } else {
            block11: for (n2 = 0; n2 < n3; ++n2) {
                char c3 = charSequence.charAt(n2);
                switch (c3) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        bl3 = true;
                        continue block11;
                    }
                    case '+': 
                    case '-': 
                    case '.': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case 'E': 
                    case 'e': {
                        continue block11;
                    }
                    default: {
                        bl2 = true;
                        break block11;
                    }
                }
            }
        }
        String string2 = string = bl3 ? Whitespace.trimWhitespace(charSequence).toString() : charSequence.toString();
        if ("INF".equals(string)) {
            return Double.POSITIVE_INFINITY;
        }
        if ("+INF".equals(string)) {
            return this.signedPositiveInfinity();
        }
        if ("-INF".equals(string)) {
            return Double.NEGATIVE_INFINITY;
        }
        if ("NaN".equals(string)) {
            return Double.NaN;
        }
        if (bl2) {
            throw new NumberFormatException("invalid floating point value: " + charSequence);
        }
        return Double.parseDouble(string);
    }

    protected double signedPositiveInfinity() {
        throw new NumberFormatException("the float/double value '+INF' is not allowed under XSD 1.0");
    }

    @Override
    public ConversionResult convertString(CharSequence charSequence) {
        try {
            double d2 = this.stringToNumber(charSequence);
            return new DoubleValue(d2);
        }
        catch (NumberFormatException numberFormatException) {
            return new ValidationFailure("Cannot convert string " + Err.wrap(charSequence, 4) + " to double");
        }
    }
}

