/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import net.sf.saxon.Configuration;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.SameNameTest;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.JavaExternalObjectType;
import net.sf.saxon.type.NumericType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.ExternalObject;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceType;

public abstract class Type {
    public static final short ELEMENT = 1;
    public static final short ATTRIBUTE = 2;
    public static final short TEXT = 3;
    public static final short WHITESPACE_TEXT = 4;
    public static final short PROCESSING_INSTRUCTION = 7;
    public static final short COMMENT = 8;
    public static final short DOCUMENT = 9;
    public static final short NAMESPACE = 13;
    public static final short STOPPER = 11;
    public static final short PARENT_POINTER = 12;
    public static final short TEXTUAL_ELEMENT = 17;
    public static final short EXTERNAL_NODE_REFERENCE = 33;
    public static final short NODE = 0;
    public static final ItemType NODE_TYPE = AnyNodeTest.getInstance();
    public static final short ITEM = 88;
    public static final ItemType ITEM_TYPE = AnyItemType.getInstance();
    public static final short FUNCTION = 99;

    private Type() {
    }

    public static boolean isNodeType(ItemType itemType) {
        return itemType instanceof NodeTest;
    }

    public static ItemType getItemType(Item object, TypeHierarchy typeHierarchy) {
        if (object == null) {
            return AnyItemType.getInstance();
        }
        if (object instanceof AtomicValue) {
            return ((AtomicValue)object).getItemType();
        }
        if (object instanceof NodeInfo) {
            object = (NodeInfo)object;
            if (typeHierarchy == null) {
                typeHierarchy = object.getConfiguration().getTypeHierarchy();
            }
            switch (object.getNodeKind()) {
                case 9: {
                    NodeInfo nodeInfo;
                    object = object.iterateAxis((byte)3);
                    ItemType itemType = null;
                    while ((nodeInfo = object.next()) != null) {
                        int n2 = nodeInfo.getNodeKind();
                        if (n2 == 3) {
                            itemType = null;
                            break;
                        }
                        if (n2 != 1) continue;
                        if (itemType != null) {
                            itemType = null;
                            break;
                        }
                        itemType = Type.getItemType(nodeInfo, typeHierarchy);
                    }
                    if (itemType == null) {
                        return NodeKindTest.DOCUMENT;
                    }
                    return new DocumentNodeTest((NodeTest)itemType);
                }
                case 1: {
                    SchemaType schemaType = object.getSchemaType();
                    if (schemaType.equals(Untyped.getInstance()) || schemaType.equals(AnyType.getInstance())) {
                        return new SameNameTest((NodeInfo)object);
                    }
                    return new CombinedNodeTest(new SameNameTest((NodeInfo)object), 23, new ContentTypeTest(1, schemaType, object.getConfiguration(), false));
                }
                case 2: {
                    SchemaType schemaType = object.getSchemaType();
                    if (schemaType.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                        return new SameNameTest((NodeInfo)object);
                    }
                    return new CombinedNodeTest(new SameNameTest((NodeInfo)object), 23, new ContentTypeTest(2, schemaType, object.getConfiguration(), false));
                }
                case 3: {
                    return NodeKindTest.TEXT;
                }
                case 8: {
                    return NodeKindTest.COMMENT;
                }
                case 7: {
                    return NodeKindTest.PROCESSING_INSTRUCTION;
                }
                case 13: {
                    return NodeKindTest.NAMESPACE;
                }
            }
            throw new IllegalArgumentException("Unknown node kind " + object.getNodeKind());
        }
        if (object instanceof ExternalObject) {
            if (typeHierarchy == null) {
                throw new IllegalArgumentException("typeHierarchy is required for an external object");
            }
            return ((ExternalObject)object).getItemType(typeHierarchy);
        }
        if (object instanceof MapItem) {
            if (typeHierarchy == null) {
                return MapType.ANY_MAP_TYPE;
            }
            return ((MapItem)object).getItemType(typeHierarchy);
        }
        if (object instanceof ArrayItem) {
            if (typeHierarchy == null) {
                return ArrayItemType.ANY_ARRAY_TYPE;
            }
            return new ArrayItemType(((ArrayItem)object).getMemberType(typeHierarchy));
        }
        return ((Function)object).getFunctionItemType();
    }

    public static String displayTypeName(Item item) {
        if (item instanceof NodeInfo) {
            Object object = (NodeInfo)item;
            switch (object.getNodeKind()) {
                case 9: {
                    return "document-node()";
                }
                case 1: {
                    object = object.getSchemaType();
                    return "element(" + ((NodeInfo)item).getDisplayName() + ", " + object.getDisplayName() + ')';
                }
                case 2: {
                    object = object.getSchemaType();
                    return "attribute(" + ((NodeInfo)item).getDisplayName() + ", " + object.getDisplayName() + ')';
                }
                case 3: {
                    return "text()";
                }
                case 8: {
                    return "comment()";
                }
                case 7: {
                    return "processing-instruction()";
                }
                case 13: {
                    return "namespace()";
                }
            }
            return "";
        }
        if (item instanceof ExternalObject) {
            return ObjectValue.displayTypeName(((ExternalObject)item).getObject());
        }
        if (item instanceof AtomicValue) {
            return ((AtomicValue)item).getItemType().toString();
        }
        if (item instanceof Function) {
            return "function(*)";
        }
        return item.getClass().toString();
    }

    public static ItemType getBuiltInItemType(String object, String string) {
        if ((object = BuiltInType.getSchemaType(StandardNames.getFingerprint((String)object, string))) instanceof ItemType) {
            return (ItemType)object;
        }
        return null;
    }

    public static SimpleType getBuiltInSimpleType(String object, String string) {
        if ((object = BuiltInType.getSchemaType(StandardNames.getFingerprint((String)object, string))) instanceof SimpleType && ((SimpleType)object).isBuiltInType()) {
            return (SimpleType)object;
        }
        return null;
    }

    public static boolean isSubType(AtomicType schemaType, AtomicType atomicType) {
        do {
            if (schemaType.getFingerprint() != atomicType.getFingerprint()) continue;
            return true;
        } while ((schemaType = schemaType.getBaseType()) instanceof AtomicType);
        return false;
    }

    public static ItemType getCommonSuperType(ItemType object, ItemType itemType, TypeHierarchy object2) {
        if (object == itemType) {
            return object;
        }
        if (object instanceof ErrorType) {
            return itemType;
        }
        if (itemType instanceof ErrorType) {
            return object;
        }
        if (object instanceof JavaExternalObjectType && itemType instanceof JavaExternalObjectType) {
            object2 = ((JavaExternalObjectType)object).getConfiguration();
            Class<?> clazz = ((JavaExternalObjectType)object).getJavaClass();
            object = ((JavaExternalObjectType)itemType).getJavaClass();
            return ((Configuration)object2).getJavaExternalObjectType(Type.a(clazz, object));
        }
        if (object instanceof MapType && itemType instanceof MapType) {
            if (object == MapType.EMPTY_MAP_TYPE) {
                return itemType;
            }
            if (itemType == MapType.EMPTY_MAP_TYPE) {
                return object;
            }
            object2 = Type.getCommonSuperType(((MapType)object).getKeyType(), ((MapType)itemType).getKeyType());
            AtomicType atomicType = object2 instanceof AtomicType ? (AtomicType)object2 : object2.getAtomizedItemType().getPrimitiveItemType();
            object = SequenceType.makeSequenceType(Type.getCommonSuperType(((MapType)object).getValueType().getPrimaryType(), ((MapType)itemType).getValueType().getPrimaryType()), Cardinality.union(((MapType)object).getValueType().getCardinality(), ((MapType)itemType).getValueType().getCardinality()));
            return new MapType(atomicType, (SequenceType)object);
        }
        int n2 = ((TypeHierarchy)object2).relationship((ItemType)object, itemType);
        if (n2 == 0) {
            return object;
        }
        if (n2 == 2) {
            return itemType;
        }
        if (n2 == 1) {
            return object;
        }
        return object.getUType().union(itemType.getUType()).toItemType();
    }

    public static ItemType getCommonSuperType(ItemType object, ItemType object2) {
        ItemType itemType;
        if (object == object2) {
            return object;
        }
        if (object instanceof ErrorType) {
            return object2;
        }
        if (object2 instanceof ErrorType) {
            return object;
        }
        if (object == AnyItemType.getInstance() || object2 == AnyItemType.getInstance()) {
            return AnyItemType.getInstance();
        }
        Object object3 = object.getPrimitiveItemType();
        if (object3 == (itemType = object2.getPrimitiveItemType())) {
            return object3;
        }
        if (object3 == BuiltInAtomicType.DECIMAL && itemType == BuiltInAtomicType.INTEGER || itemType == BuiltInAtomicType.DECIMAL && object3 == BuiltInAtomicType.INTEGER) {
            return BuiltInAtomicType.DECIMAL;
        }
        if (object3 instanceof BuiltInAtomicType && ((BuiltInAtomicType)object3).isNumericType() && itemType instanceof BuiltInAtomicType && ((BuiltInAtomicType)itemType).isNumericType()) {
            return NumericType.getInstance();
        }
        if (object.isAtomicType() && object2.isAtomicType()) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
        if (object instanceof NodeTest && object2 instanceof NodeTest) {
            return AnyNodeTest.getInstance();
        }
        if (object instanceof JavaExternalObjectType && object2 instanceof JavaExternalObjectType) {
            object3 = ((JavaExternalObjectType)object).getConfiguration();
            object = ((JavaExternalObjectType)object).getJavaClass();
            object2 = ((JavaExternalObjectType)object2).getJavaClass();
            return ((Configuration)object3).getJavaExternalObjectType(Type.a(object, object2));
        }
        return AnyItemType.getInstance();
    }

    public static SequenceType getCommonSuperType(SequenceType sequenceType, SequenceType sequenceType2) {
        if (sequenceType.equals(sequenceType2)) {
            return sequenceType;
        }
        return SequenceType.makeSequenceType(Type.getCommonSuperType(sequenceType.getPrimaryType(), sequenceType2.getPrimaryType()), Cardinality.union(sequenceType.getCardinality(), sequenceType2.getCardinality()));
    }

    private static Class<?> a(Class<?> clazz, Class<?> clazz2) {
        while (clazz != clazz2) {
            if (clazz == null || clazz2 == null) {
                return null;
            }
            if (!clazz.isArray() && clazz.isAssignableFrom(clazz2)) {
                return clazz;
            }
            if (!clazz2.isArray() && clazz2.isAssignableFrom(clazz)) {
                return clazz2;
            }
            if (clazz.isInterface() || clazz2.isInterface()) {
                return Object.class;
            }
            clazz2 = clazz2.getSuperclass();
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }

    public static boolean isPrimitiveAtomicType(int n2) {
        return n2 >= 0 && (n2 <= 533 || n2 == 635 || n2 == 631 || n2 == 632 || n2 == 634 || n2 == 633 || n2 == 573);
    }

    public static boolean isPrimitiveAtomicUType(int n2) {
        return n2 >= 0 && n2 <= 533;
    }

    public static boolean isGuaranteedComparable(BuiltInAtomicType builtInAtomicType, BuiltInAtomicType builtInAtomicType2, boolean bl2) {
        if (builtInAtomicType == builtInAtomicType2) {
            return true;
        }
        if (builtInAtomicType.isPrimitiveNumeric()) {
            return builtInAtomicType2.isPrimitiveNumeric();
        }
        if (builtInAtomicType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || builtInAtomicType.equals(BuiltInAtomicType.ANY_URI)) {
            builtInAtomicType = BuiltInAtomicType.STRING;
        }
        if (builtInAtomicType2.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || builtInAtomicType2.equals(BuiltInAtomicType.ANY_URI)) {
            builtInAtomicType2 = BuiltInAtomicType.STRING;
        }
        if (!bl2) {
            if (builtInAtomicType.equals(BuiltInAtomicType.DAY_TIME_DURATION)) {
                builtInAtomicType = BuiltInAtomicType.DURATION;
            }
            if (builtInAtomicType2.equals(BuiltInAtomicType.DAY_TIME_DURATION)) {
                builtInAtomicType2 = BuiltInAtomicType.DURATION;
            }
            if (builtInAtomicType.equals(BuiltInAtomicType.YEAR_MONTH_DURATION)) {
                builtInAtomicType = BuiltInAtomicType.DURATION;
            }
            if (builtInAtomicType2.equals(BuiltInAtomicType.YEAR_MONTH_DURATION)) {
                builtInAtomicType2 = BuiltInAtomicType.DURATION;
            }
        }
        return builtInAtomicType == builtInAtomicType2;
    }

    public static boolean isPossiblyComparable(BuiltInAtomicType builtInAtomicType, BuiltInAtomicType builtInAtomicType2, boolean bl2) {
        if (builtInAtomicType == builtInAtomicType2) {
            return true;
        }
        if (builtInAtomicType.equals(BuiltInAtomicType.ANY_ATOMIC) || builtInAtomicType2.equals(BuiltInAtomicType.ANY_ATOMIC)) {
            return true;
        }
        if (builtInAtomicType.isPrimitiveNumeric()) {
            return builtInAtomicType2.isPrimitiveNumeric();
        }
        if (builtInAtomicType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || builtInAtomicType.equals(BuiltInAtomicType.ANY_URI)) {
            builtInAtomicType = BuiltInAtomicType.STRING;
        }
        if (builtInAtomicType2.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || builtInAtomicType2.equals(BuiltInAtomicType.ANY_URI)) {
            builtInAtomicType2 = BuiltInAtomicType.STRING;
        }
        if (builtInAtomicType.equals(BuiltInAtomicType.DAY_TIME_DURATION)) {
            builtInAtomicType = BuiltInAtomicType.DURATION;
        }
        if (builtInAtomicType2.equals(BuiltInAtomicType.DAY_TIME_DURATION)) {
            builtInAtomicType2 = BuiltInAtomicType.DURATION;
        }
        if (builtInAtomicType.equals(BuiltInAtomicType.YEAR_MONTH_DURATION)) {
            builtInAtomicType = BuiltInAtomicType.DURATION;
        }
        if (builtInAtomicType2.equals(BuiltInAtomicType.YEAR_MONTH_DURATION)) {
            builtInAtomicType2 = BuiltInAtomicType.DURATION;
        }
        return builtInAtomicType == builtInAtomicType2;
    }

    public static boolean isGenerallyComparable(BuiltInAtomicType builtInAtomicType, BuiltInAtomicType builtInAtomicType2, boolean bl2) {
        return builtInAtomicType.equals(BuiltInAtomicType.ANY_ATOMIC) || builtInAtomicType2.equals(BuiltInAtomicType.ANY_ATOMIC) || builtInAtomicType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || builtInAtomicType2.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || Type.isGuaranteedComparable(builtInAtomicType, builtInAtomicType2, bl2);
    }

    public static boolean isGuaranteedGenerallyComparable(BuiltInAtomicType builtInAtomicType, BuiltInAtomicType builtInAtomicType2, boolean bl2) {
        return !builtInAtomicType.equals(BuiltInAtomicType.ANY_ATOMIC) && !builtInAtomicType2.equals(BuiltInAtomicType.ANY_ATOMIC) && Type.isGenerallyComparable(builtInAtomicType, builtInAtomicType2, bl2);
    }
}

