/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.CardinalityCheckingIterator;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.ItemTypeCheckingFunction;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.FunctionAnnotationHandler;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.LocalNameTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NamespaceTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.QNameTest;
import net.sf.saxon.pattern.SameNameTest;
import net.sf.saxon.query.Annotation;
import net.sf.saxon.query.AnnotationList;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyExternalObjectType;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.JavaExternalObjectType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.UType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.z.IntHashSet;
import net.sf.saxon.z.IntSet;
import net.sf.saxon.z.IntUniversalSet;

public class TypeHierarchy {
    private Map<a, Integer> a;
    protected Configuration config;
    public static final int SAME_TYPE = 0;
    public static final int SUBSUMES = 1;
    public static final int SUBSUMED_BY = 2;
    public static final int OVERLAPS = 3;
    public static final int DISJOINT = 4;

    public TypeHierarchy(Configuration configuration) {
        this.config = configuration;
        this.a = new ConcurrentHashMap<a, Integer>();
    }

    public Sequence<?> applyFunctionConversionRules(Sequence<?> sequenceIterator, SequenceType sequenceType, RoleDiagnostic roleDiagnostic, Location location) {
        ItemType itemType = SequenceTool.getItemType(sequenceIterator, this);
        sequenceIterator = sequenceIterator.iterate();
        ItemType itemType2 = sequenceType.getPrimaryType();
        if (itemType2.isPlainType()) {
            ItemMappingFunction<Item, Item> itemMappingFunction;
            if (!itemType.isPlainType()) {
                try {
                    sequenceIterator = Atomizer.getAtomizingIterator(sequenceIterator, false);
                }
                catch (XPathException xPathException) {
                    ValidationFailure validationFailure = new ValidationFailure("Failed to atomize the " + roleDiagnostic.getMessage() + ": " + xPathException.getMessage());
                    validationFailure.setErrorCode("XPTY0117");
                    throw validationFailure.makeException();
                }
                itemType = itemType.getAtomizedItemType();
            }
            if (this.relationship(itemType, BuiltInAtomicType.UNTYPED_ATOMIC) != 4 && !this.isSubType(BuiltInAtomicType.UNTYPED_ATOMIC, itemType2)) {
                boolean bl2 = ((SimpleType)((Object)itemType2)).isNamespaceSensitive();
                if (bl2) {
                    itemMappingFunction = item -> {
                        if (item instanceof UntypedAtomicValue) {
                            roleDiagnostic = new ValidationFailure("Failed to convert the " + ((RoleDiagnostic)roleDiagnostic).getMessage() + ": Implicit conversion of untypedAtomic value to " + itemType2 + " is not allowed");
                            ((ValidationFailure)((Object)roleDiagnostic)).setErrorCode("XPTY0117");
                            throw ((ValidationFailure)((Object)roleDiagnostic)).makeException();
                        }
                        return item;
                    };
                } else if (((SimpleType)((Object)itemType2)).isUnionType()) {
                    itemMappingFunction = this.config.getConversionRules();
                    itemMappingFunction = item -> {
                        if (item instanceof UntypedAtomicValue) {
                            try {
                                return ((SimpleType)((Object)itemType2)).getTypedValue(item.getStringValueCS(), null, (ConversionRules)((Object)itemMappingFunction)).head();
                            }
                            catch (ValidationException validationException) {
                                itemType2 = validationException;
                                validationException.setErrorCode("XPTY0004");
                                throw itemType2;
                            }
                        }
                        return item;
                    };
                } else {
                    itemMappingFunction = item -> {
                        if (item instanceof UntypedAtomicValue) {
                            return Converter.convert((UntypedAtomicValue)item, (AtomicType)itemType2, this.config.getConversionRules());
                        }
                        return item;
                    };
                }
                sequenceIterator = new ItemMappingIterator<Item, Item>(sequenceIterator, itemMappingFunction, true);
            }
            if (itemType2.equals(BuiltInAtomicType.DOUBLE)) {
                itemMappingFunction = item -> {
                    if (item instanceof NumericValue) {
                        return (DoubleValue)Converter.convert((NumericValue)item, BuiltInAtomicType.DOUBLE, this.config.getConversionRules()).asAtomic();
                    }
                    throw new XPathException("Failed to convert the " + roleDiagnostic.getMessage() + ": Cannot promote non-numeric value to xs:double", "XPTY0004");
                };
                sequenceIterator = new ItemMappingIterator<Item, Item>(sequenceIterator, itemMappingFunction, true);
            } else if (itemType2.equals(BuiltInAtomicType.FLOAT)) {
                itemMappingFunction = item -> {
                    if (item instanceof DoubleValue) {
                        throw new XPathException("Failed to convert the " + roleDiagnostic.getMessage() + ": Cannot promote xs:double value to xs:float", "XPTY0004");
                    }
                    if (item instanceof NumericValue) {
                        return (FloatValue)Converter.convert((NumericValue)item, BuiltInAtomicType.FLOAT, this.config.getConversionRules()).asAtomic();
                    }
                    throw new XPathException("Failed to convert the " + roleDiagnostic.getMessage() + ": Cannot promote non-numeric value to xs:float", "XPTY0004");
                };
                sequenceIterator = new ItemMappingIterator<Item, Item>(sequenceIterator, itemMappingFunction, true);
            }
            if (itemType2.equals(BuiltInAtomicType.STRING) && this.relationship(itemType, BuiltInAtomicType.ANY_URI) != 4) {
                itemMappingFunction = item -> {
                    if (item instanceof AnyURIValue) {
                        return new StringValue(item.getStringValueCS());
                    }
                    return item;
                };
                sequenceIterator = new ItemMappingIterator<Item, Item>(sequenceIterator, itemMappingFunction, true);
            }
        }
        sequenceIterator = this.applyFunctionCoercion(sequenceIterator, itemType, itemType2, location);
        int n2 = this.relationship(itemType, itemType2);
        if (n2 != 0 && n2 != 2) {
            ItemTypeCheckingFunction itemTypeCheckingFunction = new ItemTypeCheckingFunction(itemType2, roleDiagnostic, location, this.config);
            sequenceIterator = new ItemMappingIterator(sequenceIterator, itemTypeCheckingFunction, true);
        }
        if (sequenceType.getCardinality() != 57344) {
            sequenceIterator = new CardinalityCheckingIterator(sequenceIterator, sequenceType.getCardinality(), roleDiagnostic, location);
        }
        return SequenceTool.toMemoSequence(sequenceIterator);
    }

    protected SequenceIterator<?> applyFunctionCoercion(SequenceIterator<?> sequenceIterator, ItemType itemType, ItemType itemType2, Location location) {
        return sequenceIterator;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public boolean isSubType(ItemType itemType, ItemType itemType2) {
        int n2 = this.relationship(itemType, itemType2);
        return n2 == 0 || n2 == 2;
    }

    public int relationship(ItemType itemType, ItemType itemType2) {
        if (itemType == null) {
            throw new NullPointerException();
        }
        if ((itemType = TypeHierarchy.a(itemType)).equals(itemType2 = TypeHierarchy.a(itemType2))) {
            return 0;
        }
        if (itemType2 instanceof AnyItemType) {
            return 2;
        }
        if (itemType instanceof AnyItemType) {
            return 1;
        }
        if (itemType instanceof ErrorType) {
            return 2;
        }
        if (itemType2 instanceof ErrorType) {
            return 1;
        }
        a a2 = new a(itemType, itemType2);
        Integer n2 = this.a.get(a2);
        if (n2 == null) {
            n2 = this.a(itemType, itemType2);
            this.a.put(a2, n2);
        }
        return n2;
    }

    private static ItemType a(ItemType itemType) {
        if (itemType instanceof SameNameTest) {
            return ((SameNameTest)itemType).getEquivalentNameTest();
        }
        return itemType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int a(ItemType iterator, ItemType object) {
        SchemaType schemaType;
        AtomicType atomicType;
        block55: {
            block56: {
                IntSet intSet;
                IntSet intSet2;
                QNameTest qNameTest;
                block57: {
                    TypeHierarchy.b(iterator);
                    TypeHierarchy.b((ItemType)object);
                    if (iterator == object) {
                        return 0;
                    }
                    if (iterator instanceof AnyItemType) {
                        if (!(object instanceof AnyItemType)) return 1;
                        return 0;
                    }
                    if (object instanceof AnyItemType) {
                        return 2;
                    }
                    if (iterator.isPlainType()) {
                        if (object instanceof NodeTest) return 4;
                        if (object instanceof FunctionItemType) return 4;
                        if (object instanceof JavaExternalObjectType) {
                            return 4;
                        }
                        if (iterator == BuiltInAtomicType.ANY_ATOMIC && object.isPlainType()) {
                            return 1;
                        }
                        if (object == BuiltInAtomicType.ANY_ATOMIC) {
                            return 2;
                        }
                        if (iterator instanceof AtomicType && object instanceof AtomicType) {
                            if (((AtomicType)((Object)iterator)).getFingerprint() == ((AtomicType)object).getFingerprint()) {
                                return 0;
                            }
                            atomicType = (AtomicType)object;
                            break block55;
                        } else {
                            if (!iterator.isAtomicType() && object.isPlainType()) {
                                Set<? extends PlainType> set = TypeHierarchy.a(((PlainType)((Object)iterator)).getPlainMemberTypes());
                                Set<? extends PlainType> set2 = TypeHierarchy.a(((PlainType)object).getPlainMemberTypes());
                                iterator = set2;
                                Set<? extends PlainType> set3 = set;
                                TypeHierarchy typeHierarchy = this;
                                iterator = iterator.iterator();
                                block5: while (true) {
                                    PlainType plainType;
                                    int n2;
                                    if (!iterator.hasNext()) return 4;
                                    object = (PlainType)iterator.next();
                                    Iterator<? extends PlainType> iterator2 = set3.iterator();
                                    do {
                                        if (!iterator2.hasNext()) continue block5;
                                    } while ((n2 = typeHierarchy.relationship(plainType = iterator2.next(), (ItemType)object)) == 4);
                                    break;
                                }
                                boolean bl2 = true;
                                if (!bl2) {
                                    return 4;
                                }
                                boolean bl3 = set.containsAll(set2);
                                boolean bl4 = set2.containsAll(set);
                                if (bl3 && bl4) {
                                    return 0;
                                }
                                if (bl3) {
                                    return 1;
                                }
                                if (bl4) {
                                    return 2;
                                }
                                if (this.a(set, set2)) {
                                    return 1;
                                }
                                if (!this.a(set2, set)) return 3;
                                return 2;
                            }
                            if (!(iterator instanceof AtomicType)) throw new IllegalStateException();
                            int n3 = this.relationship((ItemType)object, (ItemType)((Object)iterator));
                            return TypeHierarchy.inverseRelationship(n3);
                        }
                    }
                    if (!(iterator instanceof NodeTest)) break block56;
                    if (object.isPlainType()) return 4;
                    if (!(object instanceof FunctionItemType)) break block57;
                    return 4;
                }
                if (iterator instanceof AnyNodeTest) {
                    if (!(object instanceof AnyNodeTest)) return 1;
                    return 0;
                }
                if (object instanceof AnyNodeTest) {
                    return 2;
                }
                if (object instanceof ErrorType) {
                    return 4;
                }
                UType uType = iterator.getUType();
                Object object2 = object.getUType();
                if (!uType.overlaps((UType)object2)) {
                    return 4;
                }
                int n4 = uType.equals(object2) ? 0 : (((UType)object2).subsumes(uType) ? 2 : (uType.subsumes((UType)object2) ? 1 : 3));
                Optional<IntSet> optional = ((NodeTest)((Object)iterator)).getRequiredNodeNames();
                Optional<IntSet> optional2 = ((NodeTest)object).getRequiredNodeNames();
                int n5 = iterator instanceof QNameTest && object instanceof QNameTest ? ((object2 = (QNameTest)((Object)iterator)).equals(qNameTest = (QNameTest)object) ? 0 : (qNameTest instanceof NameTest ? (object2.matches(((NodeTest)((NameTest)qNameTest)).getMatchingNodeName()) ? 1 : 4) : (object2 instanceof NameTest ? (qNameTest.matches(((NodeTest)((NameTest)object2)).getMatchingNodeName()) ? 2 : 4) : (qNameTest instanceof SameNameTest ? (object2.matches(((SameNameTest)qNameTest).getMatchingNodeName()) ? 1 : 4) : (object2 instanceof SameNameTest ? (qNameTest.matches(((SameNameTest)object2).getMatchingNodeName()) ? 2 : 4) : (object2 instanceof NamespaceTest && qNameTest instanceof NamespaceTest ? 4 : (object2 instanceof LocalNameTest && qNameTest instanceof LocalNameTest ? 4 : 3))))))) : (optional.isPresent() && optional.get() instanceof IntUniversalSet ? (optional2.isPresent() && optional2.get() instanceof IntUniversalSet ? 0 : 1) : (optional2.isPresent() && optional2.get() instanceof IntUniversalSet ? 2 : (!optional.isPresent() || !optional2.isPresent() ? (iterator.equals(object) ? 0 : 3) : ((intSet2 = optional.get()).containsAll(intSet = optional2.get()) ? (intSet2.size() == intSet.size() ? 0 : 1) : (intSet.containsAll(intSet2) ? 2 : (IntHashSet.containsSome(intSet2, intSet) ? 3 : 4))))));
                int n6 = this.computeContentRelationship((ItemType)((Object)iterator), (ItemType)object, optional, optional2);
                if (n4 == 0 && n5 == 0 && n6 == 0) {
                    return 0;
                }
                if (!(n4 != 0 && n4 != 1 || n5 != 0 && n5 != 1)) {
                    if (n6 == 0) return 1;
                    if (n6 == 1) {
                        return 1;
                    }
                }
                if (!(n4 != 0 && n4 != 2 || n5 != 0 && n5 != 2)) {
                    if (n6 == 0) return 2;
                    if (n6 == 2) {
                        return 2;
                    }
                }
                if (n5 == 4) return 4;
                if (n6 == 4) return 4;
                return 3;
            }
            if (iterator instanceof AnyExternalObjectType) {
                block58: {
                    if (!(object instanceof AnyExternalObjectType)) {
                        return 4;
                    }
                    if (!(iterator instanceof JavaExternalObjectType)) break block58;
                    if (object == AnyExternalObjectType.THE_INSTANCE) {
                        return 2;
                    }
                    if (!(object instanceof JavaExternalObjectType)) return 4;
                    return ((JavaExternalObjectType)((Object)iterator)).getRelationship((JavaExternalObjectType)object);
                }
                if (!(object instanceof JavaExternalObjectType)) return 4;
                return 1;
            }
            try {
                Object object3;
                Object object4;
                if (iterator instanceof MapType && object instanceof MapType) {
                    int n7;
                    if (iterator == MapType.EMPTY_MAP_TYPE) {
                        return 2;
                    }
                    if (object == MapType.EMPTY_MAP_TYPE) {
                        return 1;
                    }
                    if (iterator == MapType.ANY_MAP_TYPE) {
                        return 1;
                    }
                    if (object == MapType.ANY_MAP_TYPE) {
                        return 2;
                    }
                    AtomicType atomicType2 = ((MapType)((Object)iterator)).getKeyType();
                    AtomicType atomicType3 = ((MapType)object).getKeyType();
                    object4 = ((MapType)((Object)iterator)).getValueType();
                    object3 = ((MapType)object).getValueType();
                    int n8 = this.relationship(atomicType2, atomicType3);
                    int n9 = TypeHierarchy.a(n8, n7 = this.sequenceTypeRelationship((SequenceType)object4, (SequenceType)object3));
                    if (n9 == 0) return n9;
                    if (n9 == 1) return n9;
                    if (n9 == 2) {
                        return n9;
                    }
                }
                if (!(object instanceof FunctionItemType)) {
                    return 4;
                }
                int n10 = ((FunctionItemType)((Object)iterator)).relationship((FunctionItemType)object, this);
                if (n10 == 4) {
                    return 4;
                }
                int n11 = 0;
                object4 = ((FunctionItemType)((Object)iterator)).getAnnotationAssertions();
                object3 = ((FunctionItemType)object).getAnnotationAssertions();
                Iterable iterable = new HashSet<String>();
                Iterator<Annotation> iterator3 = ((AnnotationList)object4).iterator();
                while (iterator3.hasNext()) {
                    Annotation annotation = iterator3.next();
                    iterable.add(annotation.getAnnotationQName().getURI());
                }
                Iterator<Annotation> iterator4 = ((AnnotationList)object3).iterator();
                while (iterator4.hasNext()) {
                    Annotation annotation = iterator4.next();
                    iterable.add(annotation.getAnnotationQName().getURI());
                }
                Iterator iterator5 = iterable.iterator();
                while (true) {
                    if (!iterator5.hasNext()) {
                        return TypeHierarchy.a(n10, n11);
                    }
                    String string = (String)iterator5.next();
                    FunctionAnnotationHandler functionAnnotationHandler = this.config.getFunctionAnnotationHandler(string);
                    if (functionAnnotationHandler == null) continue;
                    int n12 = 0;
                    object = ((AnnotationList)object4).filterByNamespace(string);
                    iterable = ((AnnotationList)object3).filterByNamespace(string);
                    if (((AnnotationList)object).isEmpty()) {
                        if (!((AnnotationList)iterable).isEmpty()) {
                            n12 = 1;
                        }
                    } else {
                        n12 = ((AnnotationList)iterable).isEmpty() ? 2 : functionAnnotationHandler.relationship((AnnotationList)object, (AnnotationList)iterable);
                    }
                    n11 = TypeHierarchy.a(n11, n12);
                }
            }
            catch (MissingComponentException missingComponentException) {
                return 3;
            }
        }
        while (true) {
            if (((AtomicType)((Object)iterator)).getFingerprint() == atomicType.getFingerprint()) {
                return 1;
            }
            schemaType = atomicType.getBaseType();
            if (!(schemaType instanceof AtomicType)) break;
            atomicType = (AtomicType)schemaType;
        }
        atomicType = (AtomicType)((Object)iterator);
        while (atomicType.getFingerprint() != ((AtomicType)object).getFingerprint()) {
            schemaType = atomicType.getBaseType();
            if (!(schemaType instanceof AtomicType)) {
                return 4;
            }
            atomicType = (AtomicType)schemaType;
        }
        return 2;
    }

    private static void b(ItemType itemType) {
        Objects.requireNonNull(itemType);
        if (!itemType.isTrueItemType()) {
            throw new AssertionError((Object)(itemType + " is a non-pure union type"));
        }
    }

    private static int a(int n2, int n3) {
        if (n2 == 0 && n3 == 0) {
            return 0;
        }
        if (!(n2 != 0 && n2 != 1 || n3 != 0 && n3 != 1)) {
            return 1;
        }
        if (!(n2 != 0 && n2 != 2 || n3 != 0 && n3 != 2)) {
            return 2;
        }
        if (n2 == 4 || n3 == 4) {
            return 4;
        }
        return 3;
    }

    private static <X> Set<X> a(Iterable<X> object) {
        HashSet hashSet = new HashSet();
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            hashSet.add(e2);
        }
        return hashSet;
    }

    private boolean a(Set<? extends PlainType> set, Set<? extends PlainType> object) {
        object = object.iterator();
        while (object.hasNext()) {
            PlainType plainType = (PlainType)object.next();
            boolean bl2 = false;
            for (PlainType plainType2 : set) {
                int n2 = this.relationship(plainType2, plainType);
                if (n2 != 1 && n2 != 0) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            return false;
        }
        return true;
    }

    protected int computeContentRelationship(ItemType itemType, ItemType itemType2, Optional<IntSet> optional, Optional<IntSet> object) {
        int n2;
        if (itemType instanceof DocumentNodeTest) {
            n2 = itemType2 instanceof DocumentNodeTest ? this.relationship(((DocumentNodeTest)itemType).getElementTest(), ((DocumentNodeTest)itemType2).getElementTest()) : 2;
        } else if (itemType2 instanceof DocumentNodeTest) {
            n2 = 1;
        } else {
            object = ((NodeTest)itemType).getContentType();
            SchemaType schemaType = ((NodeTest)itemType2).getContentType();
            n2 = this.schemaTypeRelationship((SchemaType)object, schemaType);
        }
        boolean bl2 = ((NodeTest)itemType).isNillable();
        boolean bl3 = ((NodeTest)itemType2).isNillable();
        if (bl2 != bl3) {
            switch (n2) {
                case 1: {
                    if (bl3) {
                        n2 = 3;
                        break;
                    }
                }
                case 2: {
                    if (bl2) {
                        n2 = 3;
                        break;
                    }
                }
                case 0: {
                    n2 = bl2 ? 1 : 2;
                }
            }
        }
        return n2;
    }

    public int sequenceTypeRelationship(SequenceType sequenceType, SequenceType sequenceType2) {
        int n2;
        int n3 = sequenceType.getCardinality();
        if (n3 == (n2 = sequenceType2.getCardinality())) {
            n3 = 0;
        } else if (Cardinality.subsumes(n3, n2)) {
            n3 = 1;
        } else if (Cardinality.subsumes(n2, n3)) {
            n3 = 2;
        } else {
            if (n3 == 8192 && !Cardinality.allowsZero(n2)) {
                return 4;
            }
            if (n2 == 8192 && !Cardinality.allowsZero(n3)) {
                return 4;
            }
            n3 = 3;
        }
        int n4 = this.relationship(sequenceType.getPrimaryType(), sequenceType2.getPrimaryType());
        if (n4 == 4) {
            return 4;
        }
        if (n3 == 0 || n3 == n4) {
            return n4;
        }
        if (n4 == 0) {
            return n3;
        }
        return 3;
    }

    public int schemaTypeRelationship(SchemaType schemaType, SchemaType schemaType2) {
        if (schemaType.isSameType(schemaType2)) {
            return 0;
        }
        if (schemaType instanceof AnyType) {
            return 1;
        }
        if (schemaType2 instanceof AnyType) {
            return 2;
        }
        if (schemaType instanceof Untyped && (schemaType2 == BuiltInAtomicType.ANY_ATOMIC || schemaType2 == BuiltInAtomicType.UNTYPED_ATOMIC)) {
            return 3;
        }
        if (schemaType2 instanceof Untyped && (schemaType == BuiltInAtomicType.ANY_ATOMIC || schemaType == BuiltInAtomicType.UNTYPED_ATOMIC)) {
            return 3;
        }
        if (schemaType instanceof PlainType && ((PlainType)((Object)schemaType)).isPlainType() && schemaType2 instanceof PlainType && ((PlainType)((Object)schemaType2)).isPlainType()) {
            return this.relationship((ItemType)((Object)schemaType), (ItemType)((Object)schemaType2));
        }
        SchemaType schemaType3 = schemaType;
        while ((schemaType3 = schemaType3.getBaseType()) != null) {
            if (!schemaType3.isSameType(schemaType2)) continue;
            return 2;
        }
        while ((schemaType2 = schemaType2.getBaseType()) != null) {
            if (!schemaType2.isSameType(schemaType)) continue;
            return 1;
        }
        return 4;
    }

    public static int inverseRelationship(int n2) {
        switch (n2) {
            case 0: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
        }
        throw new IllegalArgumentException();
    }

    public ItemType getGenericFunctionItemType() {
        return AnyItemType.getInstance();
    }

    private static final class a {
        private ItemType a;
        private ItemType b;

        public a(ItemType itemType, ItemType itemType2) {
            this.a = itemType;
            this.b = itemType2;
        }

        public final int hashCode() {
            return this.a.hashCode() ^ this.b.hashCode();
        }

        public final boolean equals(Object object) {
            if (object instanceof a) {
                object = (a)object;
                return this.a.equals(((a)object).a) && this.b.equals(((a)object).b);
            }
            return false;
        }
    }
}

