/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.util.Optional;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.Genre;
import net.sf.saxon.om.Item;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceType;

public interface UnionType
extends ItemType,
SimpleType {
    public boolean containsListType();

    public Iterable<PlainType> getPlainMemberTypes();

    public SequenceType getResultTypeOfCast();

    public ValidationFailure checkAgainstFacets(AtomicValue var1, ConversionRules var2);

    @Override
    default public Optional<String> explainMismatch(Item item, TypeHierarchy object) {
        if (item.getGenre() == Genre.ATOMIC) {
            object = new FastStringBuffer(256);
            ((FastStringBuffer)object).append("The required type is a union type allowing any of ");
            String string = "(";
            try {
                for (PlainType plainType : this.getPlainMemberTypes()) {
                    ((FastStringBuffer)object).append(string);
                    string = ", ";
                    ((FastStringBuffer)object).append(plainType.getTypeName().getDisplayName());
                }
            }
            catch (MissingComponentException missingComponentException) {
                ((FastStringBuffer)object).append("*member types unobtainable*");
            }
            ((FastStringBuffer)object).append("), but the supplied type ");
            ((FastStringBuffer)object).append(((AtomicValue)item).getItemType().getDisplayName());
            ((FastStringBuffer)object).append(" is not any of these");
            return Optional.of(((FastStringBuffer)object).toString());
        }
        return Optional.empty();
    }
}

