/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.Invalidity;
import net.sf.saxon.om.AbsolutePath;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;

public class ValidationFailure
implements Location,
Invalidity,
ConversionResult {
    private String a;
    private String b;
    private String c;
    private int d = -1;
    private int e = -1;
    private AbsolutePath f;
    private AbsolutePath g;
    private NodeInfo h;
    private List<NodeInfo> i;
    private int j = -1;
    private String k;
    private String l;
    private SchemaType m;
    private StructuredQName n;
    private ValidationException o;
    private boolean p;

    public ValidationFailure(String string) {
        this.a = string;
        this.setErrorCode("FORG0001");
    }

    public static ValidationFailure fromException(Exception exception) {
        if (exception instanceof ValidationException) {
            return ((ValidationException)exception).getValidationFailure();
        }
        if (exception instanceof XPathException) {
            ValidationFailure validationFailure = new ValidationFailure(exception.getMessage());
            if (((XPathException)exception).getErrorCodeQName() == null) {
                validationFailure.setErrorCode("FORG0001");
            } else {
                validationFailure.setErrorCodeQName(((XPathException)exception).getErrorCodeQName());
            }
            validationFailure.setLocator(((XPathException)exception).getLocator());
            return validationFailure;
        }
        return new ValidationFailure(exception.getMessage());
    }

    public void setConstraintReference(int n2, String string, String string2) {
        this.j = n2;
        this.k = string;
        this.l = string2;
    }

    public void setConstraintReference(ValidationFailure validationFailure) {
        this.j = validationFailure.j;
        this.k = validationFailure.k;
        this.l = validationFailure.l;
    }

    @Override
    public int getSchemaPart() {
        return this.j;
    }

    @Override
    public String getConstraintName() {
        return this.k;
    }

    @Override
    public String getConstraintClauseNumber() {
        return this.l;
    }

    @Override
    public String getConstraintReference() {
        return this.k + '.' + this.l;
    }

    public String getConstraintReferenceMessage() {
        if (this.j == -1) {
            return null;
        }
        return "See http://www.w3.org/TR/xmlschema11-" + this.j + "/#" + this.k + " clause " + this.l;
    }

    public void addOffendingNode(NodeInfo nodeInfo) {
        if (this.i == null) {
            this.i = new ArrayList<NodeInfo>();
        }
        this.i.add(nodeInfo);
    }

    public List<NodeInfo> getOffendingNodes() {
        if (this.i == null) {
            return Collections.emptyList();
        }
        return this.i;
    }

    @Override
    public AbsolutePath getPath() {
        return this.f;
    }

    public void setPath(AbsolutePath absolutePath) {
        this.f = absolutePath;
    }

    @Override
    public AbsolutePath getContextPath() {
        return this.g;
    }

    public void setContextPath(AbsolutePath absolutePath) {
        this.g = absolutePath;
    }

    public NodeInfo getInvalidNode() {
        return this.h;
    }

    public void setInvalidNode(NodeInfo nodeInfo) {
        this.h = nodeInfo;
    }

    @Override
    public String getMessage() {
        return this.a;
    }

    public void setMessage(String string) {
        this.a = string;
    }

    public String toString() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer("ValidationException: ");
        String string = this.getMessage();
        if (string != null) {
            fastStringBuffer.append(string);
        }
        return fastStringBuffer.toString();
    }

    @Override
    public String getPublicId() {
        Location location = this.getLocator();
        if (this.c == null && location != null && location != this) {
            return location.getPublicId();
        }
        return this.c;
    }

    @Override
    public String getSystemId() {
        Location location = this.getLocator();
        if (this.b == null && location != null && location != this) {
            return location.getSystemId();
        }
        return this.b;
    }

    @Override
    public int getLineNumber() {
        Location location = this.getLocator();
        if (this.d == -1 && location != null && location != this) {
            return location.getLineNumber();
        }
        return this.d;
    }

    @Override
    public int getColumnNumber() {
        Location location = this.getLocator();
        if (this.e == -1 && location != null && location != this) {
            return location.getColumnNumber();
        }
        return this.e;
    }

    @Override
    public Location saveLocation() {
        return new ExplicitLocation(this);
    }

    public void setPublicId(String string) {
        this.c = string;
    }

    public void setSystemId(String string) {
        this.b = string;
    }

    public void setLineNumber(int n2) {
        this.d = n2;
    }

    public void setColumnNumber(int n2) {
        this.e = n2;
    }

    public void setLocator(SourceLocator sourceLocator) {
        if (sourceLocator != null) {
            this.setPublicId(sourceLocator.getPublicId());
            this.setSystemId(sourceLocator.getSystemId());
            this.setLineNumber(sourceLocator.getLineNumber());
            this.setColumnNumber(sourceLocator.getColumnNumber());
        }
    }

    public void setSourceLocator(SourceLocator sourceLocator) {
        if (sourceLocator != null) {
            this.setPublicId(sourceLocator.getPublicId());
            this.setSystemId(sourceLocator.getSystemId());
            this.setLineNumber(sourceLocator.getLineNumber());
            this.setColumnNumber(sourceLocator.getColumnNumber());
        }
    }

    public Location getLocator() {
        return this;
    }

    public void setErrorCode(String string) {
        if (string == null) {
            this.n = null;
            return;
        }
        this.n = new StructuredQName("err", "http://www.w3.org/2005/xqt-errors", string);
    }

    public void setErrorCodeQName(StructuredQName structuredQName) {
        this.n = structuredQName;
    }

    @Override
    public String getErrorCode() {
        if (this.n == null) {
            return null;
        }
        if (this.n.hasURI("http://www.w3.org/2005/xqt-errors")) {
            return this.n.getLocalPart();
        }
        return this.n.getEQName();
    }

    public StructuredQName getErrorCodeQName() {
        return this.n;
    }

    public void setSchemaType(SchemaType schemaType) {
        this.m = schemaType;
    }

    public SchemaType getSchemaType() {
        return this.m;
    }

    public ValidationException makeException() {
        if (this.o != null) {
            this.o.maybeSetLocation(this);
            return this.o;
        }
        ValidationException validationException = new ValidationException(this);
        if (this.n == null) {
            validationException.setErrorCode("FORG0001");
        } else {
            validationException.setErrorCodeQName(this.n);
        }
        validationException.setHasBeenReported(this.p);
        this.o = validationException;
        return validationException;
    }

    @Override
    public AtomicValue asAtomic() {
        throw this.makeException();
    }

    public boolean hasBeenReported() {
        return this.p;
    }

    public void setHasBeenReported(boolean bl2) {
        this.p = bl2;
        if (this.o != null) {
            this.o.setHasBeenReported(bl2);
        }
    }

    public String getValidationLocationText() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(256);
        AbsolutePath absolutePath = this.getAbsolutePath();
        if (absolutePath != null) {
            fastStringBuffer.append("Validating ");
            fastStringBuffer.append(absolutePath.getPathUsingPrefixes());
            if (absolutePath.getSystemId() != null) {
                fastStringBuffer.append(" in ");
                fastStringBuffer.append(absolutePath.getSystemId());
            }
        }
        return fastStringBuffer.toString();
    }

    public String getContextLocationText() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(256);
        AbsolutePath absolutePath = this.getContextPath();
        if (absolutePath != null) {
            fastStringBuffer.append("Currently processing ");
            fastStringBuffer.append(absolutePath.getPathUsingPrefixes());
            if (absolutePath.getSystemId() != null) {
                fastStringBuffer.append(" in ");
                fastStringBuffer.append(absolutePath.getSystemId());
            }
        }
        return fastStringBuffer.toString();
    }

    public AbsolutePath getAbsolutePath() {
        if (this.f != null) {
            return this.f;
        }
        return null;
    }
}

