/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public final class AnyURIValue
extends StringValue {
    public static final AnyURIValue EMPTY_URI = new AnyURIValue("");

    public AnyURIValue(CharSequence charSequence) {
        this.value = charSequence == null ? "" : Whitespace.collapseWhitespace(charSequence).toString();
        this.typeLabel = BuiltInAtomicType.ANY_URI;
    }

    public AnyURIValue(CharSequence charSequence, AtomicType atomicType) {
        this.value = charSequence == null ? "" : Whitespace.collapseWhitespace(charSequence).toString();
        this.typeLabel = atomicType;
    }

    @Override
    public final AtomicValue copyAsSubType(AtomicType atomicType) {
        AnyURIValue anyURIValue = new AnyURIValue(this.value);
        new AnyURIValue(this.value).typeLabel = atomicType;
        return anyURIValue;
    }

    @Override
    public final BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.ANY_URI;
    }

    public static String decode(String string) {
        if (string == null) {
            return string;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return string;
        }
        if (string.indexOf(37) < 0) {
            return string;
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer(n2);
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        Charset charset = Charset.forName("UTF-8");
        char c2 = string.charAt(0);
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < n2) {
            assert (c2 == string.charAt(n3));
            if (c2 == '[') {
                bl2 = true;
            } else if (bl2 && c2 == ']') {
                bl2 = false;
            }
            if (c2 != '%' || bl2) {
                fastStringBuffer.append(c2);
                if (++n3 >= n2) break;
                c2 = string.charAt(n3);
                continue;
            }
            byteBuffer.clear();
            do {
                assert (n2 - n3 >= 2);
                char c3 = string.charAt(++n3);
                char c4 = string.charAt(++n3);
                char c5 = c3;
                byteBuffer.put((byte)(AnyURIValue.a(c3) << 4 | AnyURIValue.a(c4)));
            } while (++n3 < n2 && (c2 = string.charAt(n3)) == '%');
            byteBuffer.flip();
            fastStringBuffer.append(charset.decode(byteBuffer));
        }
        return fastStringBuffer.toString();
    }

    private static int a(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48;
        }
        if (c2 >= 'a' && c2 <= 'f') {
            return c2 - 97 + 10;
        }
        if (c2 >= 'A' && c2 <= 'F') {
            return c2 - 65 + 10;
        }
        return 0;
    }
}

