/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.Iterator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.functions.AccessorFn;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Genre;
import net.sf.saxon.om.IdentityComparable;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingleAtomicIterator;
import net.sf.saxon.tree.jiter.MonoIterator;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.UType;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.Whitespace;

public abstract class AtomicValue
implements AtomicSequence,
IdentityComparable,
Item<AtomicValue>,
ConversionResult {
    protected AtomicType typeLabel;

    @Override
    public AtomicSequence atomize() {
        return this;
    }

    @Override
    public final AtomicValue head() {
        return this;
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public final SingleAtomicIterator iterate() {
        return new SingleAtomicIterator(this);
    }

    public void setTypeLabel(AtomicType atomicType) {
        this.typeLabel = atomicType;
    }

    @Override
    public abstract Comparable getSchemaComparable();

    public abstract AtomicMatchKey getXPathComparable(boolean var1, StringCollator var2, int var3);

    public AtomicMatchKey asMapKey() {
        try {
            return this.getXPathComparable(false, CodepointCollator.getInstance(), Integer.MIN_VALUE);
        }
        catch (NoDynamicContextException noDynamicContextException) {
            throw new IllegalStateException("No implicit timezone available");
        }
    }

    public abstract boolean equals(Object var1);

    public boolean isIdentical(AtomicValue atomicValue) {
        return this.getSchemaComparable().equals(atomicValue.getSchemaComparable());
    }

    @Override
    public boolean isIdentical(IdentityComparable identityComparable) {
        return identityComparable instanceof AtomicValue && this.isIdentical((AtomicValue)identityComparable);
    }

    @Override
    public int identityHashCode() {
        return this.hashCode();
    }

    @Override
    public final CharSequence getStringValueCS() {
        CharSequence charSequence = this.getPrimitiveStringValue();
        try {
            return this.typeLabel.postprocess(charSequence);
        }
        catch (XPathException xPathException) {
            return charSequence;
        }
    }

    @Override
    public CharSequence getCanonicalLexicalRepresentation() {
        return this.getStringValueCS();
    }

    public void process(XPathContext xPathContext) {
        xPathContext.getReceiver().append(this, ExplicitLocation.UNKNOWN_LOCATION, 524288);
    }

    @Override
    public final AtomicValue itemAt(int n2) {
        if (n2 == 0) {
            return this.head();
        }
        return null;
    }

    public final AtomicType getItemType() {
        return this.typeLabel;
    }

    public abstract BuiltInAtomicType getPrimitiveType();

    public final UType getUType() {
        return this.getItemType().getUType();
    }

    public final int getCardinality() {
        return 16384;
    }

    public abstract AtomicValue copyAsSubType(AtomicType var1);

    public boolean isNaN() {
        return false;
    }

    @Override
    public final String getStringValue() {
        return this.getStringValueCS().toString();
    }

    protected abstract CharSequence getPrimitiveStringValue();

    @Override
    public boolean effectiveBooleanValue() {
        XPathException xPathException = new XPathException("Effective boolean value is not defined for an atomic value of type " + Type.displayTypeName(this));
        xPathException.setIsTypeError(true);
        xPathException.setErrorCode("FORG0006");
        throw xPathException;
    }

    public AtomicValue getComponent(AccessorFn.Component component) {
        throw new UnsupportedOperationException("Data type does not support component extraction");
    }

    public void checkPermittedContents(SchemaType object, StaticContext staticContext, boolean bl2) {
        if (bl2) {
            SimpleType simpleType = null;
            if (object instanceof SimpleType) {
                simpleType = (SimpleType)object;
            } else if (object instanceof ComplexType && ((ComplexType)object).isSimpleContent()) {
                simpleType = ((ComplexType)object).getSimpleContentType();
            }
            if (simpleType != null && !simpleType.isNamespaceSensitive()) {
                object = simpleType.validateContent(this.getStringValueCS(), null, staticContext.getConfiguration().getConversionRules());
                if (object != null) {
                    throw ((ValidationFailure)object).makeException();
                }
                return;
            }
        }
        if (object instanceof ComplexType && !((ComplexType)object).isSimpleContent() && !((ComplexType)object).isMixedContent() && !Whitespace.isWhite(this.getStringValueCS())) {
            XPathException xPathException = new XPathException("Complex type " + object.getDescription() + " does not allow text content " + Err.wrap(this.getStringValueCS()));
            xPathException.setIsTypeError(true);
            throw xPathException;
        }
    }

    public void checkValidInJavascript() {
    }

    @Override
    public AtomicValue asAtomic() {
        return this;
    }

    public String toString() {
        return this.typeLabel + "(\"" + this.getStringValueCS() + "\")";
    }

    @Override
    public Iterator<AtomicValue> iterator() {
        return new MonoIterator<AtomicValue>(this);
    }

    @Override
    public final Genre getGenre() {
        return Genre.ATOMIC;
    }
}

