/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.Arrays;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Whitespace;

public class Base64BinaryValue
extends AtomicValue
implements Comparable,
AtomicMatchKey {
    private byte[] a;
    private static int[] b = new int[64];
    private static int[] c = new int[128];

    public Base64BinaryValue(CharSequence charSequence) {
        this.a = Base64BinaryValue.decode(charSequence);
        this.typeLabel = BuiltInAtomicType.BASE64_BINARY;
    }

    public Base64BinaryValue(byte[] byArray) {
        this.a = byArray;
        this.typeLabel = BuiltInAtomicType.BASE64_BINARY;
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType atomicType) {
        Base64BinaryValue base64BinaryValue = new Base64BinaryValue(this.a);
        new Base64BinaryValue(this.a).typeLabel = atomicType;
        return base64BinaryValue;
    }

    public byte[] getBinaryValue() {
        return this.a;
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.BASE64_BINARY;
    }

    @Override
    public String getPrimitiveStringValue() {
        return Base64BinaryValue.encode(this.a).toString();
    }

    public int getLengthInOctets() {
        return this.a.length;
    }

    @Override
    public Comparable getSchemaComparable() {
        return new a(this, 0);
    }

    @Override
    public AtomicMatchKey getXPathComparable(boolean bl2, StringCollator stringCollator, int n2) {
        return this;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof Base64BinaryValue && Arrays.equals(this.a, ((Base64BinaryValue)object).a);
    }

    public int hashCode() {
        return Base64BinaryValue.byteArrayHashCode(this.a);
    }

    protected static int byteArrayHashCode(byte[] byArray) {
        long l2 = 0L;
        for (int i2 = 0; i2 < Math.min(byArray.length, 64); ++i2) {
            l2 = l2 << 1 ^ (long)byArray[i2];
        }
        return (int)(l2 >> 32 ^ l2);
    }

    public static CharSequence encode(byte[] byArray) {
        int n2;
        int n3;
        FastStringBuffer fastStringBuffer = new FastStringBuffer(byArray.length);
        int n4 = byArray.length - byArray.length % 3;
        for (n3 = 0; n3 < n4; n3 += 3) {
            n2 = ((byArray[n3] & 0xFF) << 16) + ((byArray[n3 + 1] & 0xFF) << 8) + (byArray[n3 + 2] & 0xFF);
            fastStringBuffer.append((char)b[n2 >> 18 & 0x3F]);
            fastStringBuffer.append((char)b[n2 >> 12 & 0x3F]);
            fastStringBuffer.append((char)b[n2 >> 6 & 0x3F]);
            fastStringBuffer.append((char)b[n2 & 0x3F]);
        }
        n3 = byArray.length % 3;
        switch (n3) {
            default: {
                break;
            }
            case 1: {
                n2 = (byArray[n4] & 0xFF) << 4;
                fastStringBuffer.append((char)b[n2 >> 6 & 0x3F]);
                fastStringBuffer.append((char)b[n2 & 0x3F]);
                fastStringBuffer.append("==");
                break;
            }
            case 2: {
                n2 = ((byArray[n4] & 0xFF) << 10) + ((byArray[n4 + 1] & 0xFF) << 2);
                fastStringBuffer.append((char)b[n2 >> 12 & 0x3F]);
                fastStringBuffer.append((char)b[n2 >> 6 & 0x3F]);
                fastStringBuffer.append((char)b[n2 & 0x3F]);
                fastStringBuffer.append("=");
            }
        }
        return fastStringBuffer.condense();
    }

    public static byte[] decode(CharSequence charSequence) {
        char[] cArray = new char[4];
        byte[] byArray = new byte[charSequence.length()];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n3 < charSequence.length()) {
            int n8;
            if (!Whitespace.isWhite((char)(n8 = charSequence.charAt(n3++)))) {
                ++n6;
                if (n8 == 61) {
                    n5 = 1;
                    for (n8 = n3; n8 < charSequence.length(); ++n8) {
                        char c2 = charSequence.charAt(n8);
                        if (c2 == '=') {
                            ++n5;
                            ++n6;
                            continue;
                        }
                        if (Whitespace.isWhite(c2)) continue;
                        throw new XPathException("Base64 padding character '=' is followed by non-padding characters", "FORG0001");
                    }
                    if (n5 == 1 && "AEIMQUYcgkosw048".indexOf(n7) < 0) {
                        throw new XPathException("In base64, if the value ends with a single '=' character, then the preceding character must be one of [AEIMQUYcgkosw048]", "FORG0001");
                    }
                    if (n5 == 2 && "AQgw".indexOf(n7) < 0) {
                        throw new XPathException("In base64, if the value ends with '==', then the preceding character must be one of [AQgw]", "FORG0001");
                    }
                    if (n5 > 2) {
                        throw new XPathException("Found " + n5 + " '=' characters at end of base64 value; max is 2", "FORG0001");
                    }
                    if (n5 != (4 - n4) % 4) {
                        throw new XPathException("Required " + (4 - n4) % 4 + " '=' characters at end of base64 value; found " + n5, "FORG0001");
                    }
                    for (n8 = 0; n8 < n5; ++n8) {
                        cArray[n4++] = 65;
                    }
                    n3 = charSequence.length();
                } else {
                    n7 = n8;
                    cArray[n4++] = n8;
                }
                if (n4 == 4) {
                    n8 = (Base64BinaryValue.a(cArray[0]) << 18) + (Base64BinaryValue.a(cArray[1]) << 12) + (Base64BinaryValue.a(cArray[2]) << 6) + Base64BinaryValue.a(cArray[3]);
                    if (n2 + 3 > byArray.length) {
                        byte[] byArray2 = new byte[n2 << 1];
                        System.arraycopy(byArray, 0, byArray2, 0, n2);
                        byArray = byArray2;
                    }
                    byArray[n2++] = (byte)(n8 >> 16);
                    byArray[n2++] = (byte)(n8 >> 8);
                    byArray[n2++] = (byte)n8;
                    n4 = 0;
                }
            }
            if (n3 < charSequence.length()) continue;
            n2 -= n5;
            break;
        }
        if (n6 % 4 != 0) {
            throw new XPathException("Length of base64 value must be a multiple of four", "FORG0001");
        }
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, 0, byArray3, 0, n2);
        return byArray3;
    }

    private static int a(char c2) {
        int n2 = c2 < '\u0080' ? c[c2] : -1;
        if (n2 == -1) {
            if (UTF16CharacterSet.isSurrogate(c2)) {
                throw new XPathException("Invalid character (surrogate pair) in base64 value", "FORG0001");
            }
            throw new XPathException("Invalid character '" + c2 + "' in base64 value", "FORG0001");
        }
        return n2;
    }

    public int compareTo(Object object) {
        object = ((Base64BinaryValue)object).a;
        int n2 = this.a.length;
        int n3 = ((Object)object).length;
        int n4 = Math.min(n2, n3);
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = this.a[i2] & 0xFF;
            int n6 = object[i2] & 0xFF;
            if (n5 == n6) continue;
            if (n5 < n6) {
                return -1;
            }
            return 1;
        }
        return Integer.signum(n2 - n3);
    }

    static {
        Arrays.fill(c, -1);
        int n2 = 0;
        while (n2 < 64) {
            char c2 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".charAt(n2);
            Base64BinaryValue.b[n2] = c2;
            Base64BinaryValue.c[c2] = n2++;
        }
    }

    private final class a
    implements Comparable {
        private /* synthetic */ Base64BinaryValue a;

        private a(Base64BinaryValue base64BinaryValue) {
            this.a = base64BinaryValue;
        }

        public final int compareTo(Object object) {
            if (object instanceof a) {
                a a2;
                a a3 = this;
                a3 = (a)object;
                if (Arrays.equals(a2.a.a, a3.a.a)) {
                    return 0;
                }
            }
            return Integer.MIN_VALUE;
        }

        public final boolean equals(Object object) {
            return this.compareTo(object) == 0;
        }

        public final int hashCode() {
            return this.a.hashCode();
        }

        /* synthetic */ a(Base64BinaryValue base64BinaryValue, byte by) {
            this(base64BinaryValue);
        }
    }
}

