/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.regex.Pattern;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.Whitespace;

public final class BigDecimalValue
extends DecimalValue {
    public static final int DIVIDE_PRECISION = 18;
    private BigDecimal a;
    private Double b;
    public static final BigDecimal BIG_DECIMAL_ONE_MILLION = BigDecimal.valueOf(1000000L);
    public static final BigDecimal BIG_DECIMAL_ONE_BILLION = BigDecimal.valueOf(1000000000L);
    public static final BigDecimalValue ZERO = new BigDecimalValue(BigDecimal.valueOf(0L));
    public static final BigDecimalValue ONE = new BigDecimalValue(BigDecimal.valueOf(1L));
    public static final BigDecimalValue TWO = new BigDecimalValue(BigDecimal.valueOf(2L));
    public static final BigDecimalValue THREE = new BigDecimalValue(BigDecimal.valueOf(3L));
    public static final BigDecimal MAX_INT = BigDecimal.valueOf(Integer.MAX_VALUE);
    private static final Pattern c = Pattern.compile("(\\-|\\+)?((\\.[0-9]+)|([0-9]+(\\.[0-9]*)?))");

    public BigDecimalValue(BigDecimal bigDecimal) {
        this.a = bigDecimal.stripTrailingZeros();
        this.typeLabel = BuiltInAtomicType.DECIMAL;
    }

    public static ConversionResult makeDecimalValue(CharSequence object, boolean bl2) {
        try {
            return BigDecimalValue.parse((CharSequence)object);
        }
        catch (NumberFormatException numberFormatException) {
            object = new ValidationFailure("Cannot convert string " + Err.wrap(Whitespace.trim((CharSequence)object), 4) + " to xs:decimal: " + numberFormatException.getMessage());
            ((ValidationFailure)object).setErrorCode("FORG0001");
            return object;
        }
    }

    public static BigDecimalValue parse(CharSequence charSequence) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length());
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = false;
        int n4 = charSequence.length();
        block7: for (int i2 = 0; i2 < n4; ++i2) {
            char c2 = charSequence.charAt(i2);
            switch (c2) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (n3 == 0) continue block7;
                    n3 = 5;
                    continue block7;
                }
                case '+': {
                    if (n3 != 0) {
                        throw new NumberFormatException("unexpected sign");
                    }
                    n3 = 1;
                    continue block7;
                }
                case '-': {
                    if (n3 != 0) {
                        throw new NumberFormatException("unexpected sign");
                    }
                    n3 = 1;
                    fastStringBuffer.append(c2);
                    continue block7;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (n3 == 0) {
                        n3 = 1;
                    } else if (n3 >= 3) {
                        ++n2;
                    }
                    if (n3 == 5) {
                        throw new NumberFormatException("contains embedded whitespace");
                    }
                    fastStringBuffer.append(c2);
                    bl2 = true;
                    continue block7;
                }
                case '.': {
                    if (n3 == 5) {
                        throw new NumberFormatException("contains embedded whitespace");
                    }
                    if (n3 >= 3) {
                        throw new NumberFormatException("more than one decimal point");
                    }
                    n3 = 3;
                    continue block7;
                }
                default: {
                    throw new NumberFormatException("invalid character '" + c2 + "'");
                }
            }
        }
        if (!bl2) {
            throw new NumberFormatException("no digits in value");
        }
        while (n2 > 0) {
            FastStringBuffer fastStringBuffer2 = fastStringBuffer;
            if (fastStringBuffer2.charAt(fastStringBuffer2.length() - 1) != '0') break;
            FastStringBuffer fastStringBuffer3 = fastStringBuffer;
            fastStringBuffer3.setLength(fastStringBuffer3.length() - 1);
            --n2;
        }
        if (fastStringBuffer.isEmpty() || fastStringBuffer.length() == 1 && fastStringBuffer.charAt(0) == '-') {
            return ZERO;
        }
        BigInteger bigInteger = new BigInteger(fastStringBuffer.toString());
        BigDecimal bigDecimal = new BigDecimal(bigInteger, n2);
        return new BigDecimalValue(bigDecimal);
    }

    public static boolean castableAsDecimal(CharSequence charSequence) {
        charSequence = Whitespace.trimWhitespace(charSequence);
        return c.matcher(charSequence).matches();
    }

    public BigDecimalValue(double d2) {
        try {
            BigDecimal bigDecimal = new BigDecimal(d2);
            this.a = bigDecimal.stripTrailingZeros();
        }
        catch (NumberFormatException numberFormatException) {
            ValidationFailure validationFailure = new ValidationFailure("Cannot convert double " + Err.wrap("" + d2, 4) + " to decimal");
            validationFailure.setErrorCode("FOCA0002");
            throw validationFailure.makeException();
        }
        this.typeLabel = BuiltInAtomicType.DECIMAL;
    }

    public BigDecimalValue(long l2) {
        this.a = BigDecimal.valueOf(l2);
        this.typeLabel = BuiltInAtomicType.DECIMAL;
    }

    @Override
    public final AtomicValue copyAsSubType(AtomicType atomicType) {
        BigDecimalValue bigDecimalValue = new BigDecimalValue(this.a);
        new BigDecimalValue(this.a).typeLabel = atomicType;
        return bigDecimalValue;
    }

    @Override
    public final BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.DECIMAL;
    }

    @Override
    public final double getDoubleValue() {
        if (this.b == null) {
            double d2 = this.a.doubleValue();
            this.b = d2;
            return d2;
        }
        return this.b;
    }

    @Override
    public final float getFloatValue() {
        return (float)this.a.doubleValue();
    }

    @Override
    public final long longValue() {
        return (long)this.a.doubleValue();
    }

    @Override
    public final BigDecimal getDecimalValue() {
        return this.a;
    }

    @Override
    public final int hashCode() {
        BigDecimal bigDecimal = this.a.setScale(0, RoundingMode.DOWN);
        long l2 = bigDecimal.longValue();
        if (l2 > Integer.MIN_VALUE && l2 < Integer.MAX_VALUE) {
            return (int)l2;
        }
        return Double.valueOf(((NumericValue)this).getDoubleValue()).hashCode();
    }

    @Override
    public final boolean effectiveBooleanValue() {
        return this.a.signum() != 0;
    }

    @Override
    public final CharSequence getCanonicalLexicalRepresentation() {
        String string = this.getStringValue();
        if (string.indexOf(46) < 0) {
            string = string + ".0";
        }
        return string;
    }

    @Override
    public final CharSequence getPrimitiveStringValue() {
        return BigDecimalValue.decimalToString(this.a, new FastStringBuffer(16));
    }

    public static FastStringBuffer decimalToString(BigDecimal bigDecimal, FastStringBuffer fastStringBuffer) {
        int n2 = bigDecimal.scale();
        if (n2 == 0) {
            fastStringBuffer.append(bigDecimal.toString());
            return fastStringBuffer;
        }
        if (n2 < 0) {
            String string = bigDecimal.abs().unscaledValue().toString();
            if (string.equals("0")) {
                fastStringBuffer.append('0');
                return fastStringBuffer;
            }
            if (bigDecimal.signum() < 0) {
                fastStringBuffer.append('-');
            }
            fastStringBuffer.append(string);
            for (int i2 = 0; i2 < -n2; ++i2) {
                fastStringBuffer.append('0');
            }
            return fastStringBuffer;
        }
        String string = bigDecimal.abs().unscaledValue().toString();
        if (string.equals("0")) {
            fastStringBuffer.append('0');
            return fastStringBuffer;
        }
        int n3 = string.length();
        if (bigDecimal.signum() < 0) {
            fastStringBuffer.append('-');
        }
        if (n2 >= n3) {
            fastStringBuffer.append("0.");
            for (int i3 = n3; i3 < n2; ++i3) {
                fastStringBuffer.append('0');
            }
            fastStringBuffer.append(string);
        } else {
            fastStringBuffer.append(string.substring(0, n3 - n2));
            fastStringBuffer.append('.');
            fastStringBuffer.append(string.substring(n3 - n2));
        }
        return fastStringBuffer;
    }

    @Override
    public final NumericValue negate() {
        return new BigDecimalValue(this.a.negate());
    }

    @Override
    public final NumericValue floor() {
        return new BigDecimalValue(this.a.setScale(0, RoundingMode.FLOOR));
    }

    @Override
    public final NumericValue ceiling() {
        return new BigDecimalValue(this.a.setScale(0, RoundingMode.CEILING));
    }

    @Override
    public final NumericValue round(int n2) {
        if (n2 >= this.a.scale()) {
            return this;
        }
        switch (this.a.signum()) {
            case -1: {
                return new BigDecimalValue(this.a.setScale(n2, RoundingMode.HALF_DOWN));
            }
            case 0: {
                return this;
            }
            case 1: {
                return new BigDecimalValue(this.a.setScale(n2, RoundingMode.HALF_UP));
            }
        }
        return this;
    }

    @Override
    public final NumericValue roundHalfToEven(int n2) {
        if (n2 >= this.a.scale()) {
            return this;
        }
        BigDecimal bigDecimal = this.a.setScale(n2, RoundingMode.HALF_EVEN);
        return new BigDecimalValue(bigDecimal.stripTrailingZeros());
    }

    @Override
    public final int signum() {
        return this.a.signum();
    }

    @Override
    public final boolean isWholeNumber() {
        return this.a.scale() == 0 || this.a.compareTo(this.a.setScale(0, RoundingMode.DOWN)) == 0;
    }

    @Override
    public final int asSubscript() {
        if (((NumericValue)this).isWholeNumber() && this.a.compareTo(BigDecimal.ZERO) > 0 && this.a.compareTo(MAX_INT) <= 0) {
            try {
                return (int)((NumericValue)this).longValue();
            }
            catch (XPathException xPathException) {
                return -1;
            }
        }
        return -1;
    }

    @Override
    public final NumericValue abs() {
        if (this.a.signum() > 0) {
            return this;
        }
        return new BigDecimalValue(this.a.negate());
    }

    @Override
    public final int compareTo(NumericValue numericValue) {
        if (NumericValue.isInteger(numericValue)) {
            try {
                return this.a.compareTo(numericValue.getDecimalValue());
            }
            catch (XPathException xPathException) {
                throw new AssertionError((Object)"Conversion of integer to decimal should never fail");
            }
        }
        if (numericValue instanceof BigDecimalValue) {
            return this.a.compareTo(((BigDecimalValue)numericValue).a);
        }
        if (numericValue instanceof FloatValue) {
            return 0 - ((NumericValue)((FloatValue)numericValue)).compareTo(this);
        }
        return super.compareTo(numericValue);
    }

    @Override
    public final int compareTo(long l2) {
        if (l2 == 0L) {
            return this.a.signum();
        }
        return this.a.compareTo(BigDecimal.valueOf(l2));
    }

    @Override
    public final Comparable getSchemaComparable() {
        return new DecimalComparable(this);
    }

    @Override
    public final boolean isIdentical(AtomicValue atomicValue) {
        return atomicValue instanceof DecimalValue && ((AtomicValue)this).equals(atomicValue);
    }

    protected static class DecimalComparable
    implements Comparable {
        protected BigDecimalValue value;

        public DecimalComparable(BigDecimalValue bigDecimalValue) {
            this.value = bigDecimalValue;
        }

        public BigDecimal asBigDecimal() {
            return ((NumericValue)this.value).getDecimalValue();
        }

        public int compareTo(Object object) {
            if (object instanceof DecimalComparable) {
                return this.asBigDecimal().compareTo(((DecimalComparable)object).asBigDecimal());
            }
            if (object instanceof Int64Value.Int64Comparable) {
                return this.asBigDecimal().compareTo(BigDecimal.valueOf(((Int64Value.Int64Comparable)object).asLong()));
            }
            if (object instanceof BigIntegerValue.BigIntegerComparable) {
                return this.asBigDecimal().compareTo(new BigDecimal(((BigIntegerValue.BigIntegerComparable)object).asBigInteger()));
            }
            return Integer.MIN_VALUE;
        }

        public boolean equals(Object object) {
            return this.compareTo(object) == 0;
        }

        public int hashCode() {
            if (((NumericValue)this.value).isWholeNumber()) {
                IntegerValue integerValue = Converter.DecimalToInteger.INSTANCE.convert(this.value);
                return integerValue.getSchemaComparable().hashCode();
            }
            return ((NumericValue)this.value).hashCode();
        }
    }
}

