/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.sf.saxon.expr.Calculator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;

public final class BigIntegerValue
extends IntegerValue {
    private BigInteger a;
    private static final BigInteger b = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger c = BigInteger.valueOf(Integer.MIN_VALUE);
    public static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    public static final BigInteger MAX_UNSIGNED_LONG = new BigInteger("18446744073709551615");
    public static final BigIntegerValue ZERO = new BigIntegerValue(BigInteger.ZERO);

    public BigIntegerValue(BigInteger bigInteger) {
        this.a = bigInteger;
        this.typeLabel = BuiltInAtomicType.INTEGER;
    }

    public BigIntegerValue(BigInteger bigInteger, AtomicType atomicType) {
        this.a = bigInteger;
        this.typeLabel = atomicType;
    }

    public BigIntegerValue(long l2) {
        this.a = BigInteger.valueOf(l2);
        this.typeLabel = BuiltInAtomicType.INTEGER;
    }

    @Override
    public final AtomicValue copyAsSubType(AtomicType atomicType) {
        if (atomicType.getPrimitiveType() == 533) {
            BigIntegerValue bigIntegerValue = new BigIntegerValue(this.a);
            new BigIntegerValue(this.a).typeLabel = atomicType;
            return bigIntegerValue;
        }
        return new BigDecimalValue(new BigDecimal(this.a));
    }

    @Override
    public final ValidationFailure convertToSubType(BuiltInAtomicType object, boolean bl2) {
        if (!bl2) {
            this.typeLabel = object;
            return null;
        }
        if (IntegerValue.checkBigRange(this.a, (BuiltInAtomicType)object)) {
            this.typeLabel = object;
            return null;
        }
        object = new ValidationFailure("Integer value is out of range for subtype " + ((BuiltInAtomicType)object).getDisplayName());
        ((ValidationFailure)object).setErrorCode("FORG0001");
        return object;
    }

    @Override
    public final ValidationFailure validateAgainstSubType(BuiltInAtomicType object) {
        if (IntegerValue.checkBigRange(this.a, (BuiltInAtomicType)object)) {
            this.typeLabel = object;
            return null;
        }
        object = new ValidationFailure("Integer value is out of range for subtype " + ((BuiltInAtomicType)object).getDisplayName());
        ((ValidationFailure)object).setErrorCode("FORG0001");
        return object;
    }

    @Override
    public final int hashCode() {
        if (this.a.compareTo(c) >= 0 && this.a.compareTo(b) <= 0) {
            return this.a.intValue();
        }
        return Double.valueOf(((NumericValue)this).getDoubleValue()).hashCode();
    }

    @Override
    public final long longValue() {
        return this.a.longValue();
    }

    @Override
    public final BigInteger asBigInteger() {
        return this.a;
    }

    public final boolean isWithinLongRange() {
        return this.a.compareTo(MIN_LONG) >= 0 && this.a.compareTo(MAX_LONG) <= 0;
    }

    public final BigDecimal asDecimal() {
        return new BigDecimal(this.a);
    }

    @Override
    public final boolean effectiveBooleanValue() {
        return this.a.compareTo(BigInteger.ZERO) != 0;
    }

    @Override
    public final int compareTo(NumericValue numericValue) {
        if (numericValue instanceof BigIntegerValue) {
            return this.a.compareTo(((BigIntegerValue)numericValue).a);
        }
        if (numericValue instanceof Int64Value) {
            return this.a.compareTo(BigInteger.valueOf(((NumericValue)((Int64Value)numericValue)).longValue()));
        }
        if (numericValue instanceof BigDecimalValue) {
            return this.asDecimal().compareTo(((NumericValue)((BigDecimalValue)numericValue)).getDecimalValue());
        }
        return super.compareTo(numericValue);
    }

    @Override
    public final int compareTo(long l2) {
        if (l2 == 0L) {
            return this.a.signum();
        }
        return this.a.compareTo(BigInteger.valueOf(l2));
    }

    @Override
    public final String getPrimitiveStringValue() {
        return this.a.toString();
    }

    @Override
    public final double getDoubleValue() {
        return this.a.doubleValue();
    }

    @Override
    public final BigDecimal getDecimalValue() {
        return new BigDecimal(this.a);
    }

    @Override
    public final float getFloatValue() {
        return (float)((NumericValue)this).getDoubleValue();
    }

    @Override
    public final NumericValue negate() {
        return new BigIntegerValue(this.a.negate());
    }

    @Override
    public final NumericValue floor() {
        return this;
    }

    @Override
    public final NumericValue ceiling() {
        return this;
    }

    @Override
    public final NumericValue round(int n2) {
        if (n2 >= 0) {
            return this;
        }
        BigInteger bigInteger = BigInteger.valueOf(10L).pow(-n2);
        BigInteger[] bigIntegerArray = this.a.divideAndRemainder(bigInteger);
        int n3 = bigIntegerArray[1].compareTo(bigInteger.divide(BigInteger.valueOf(2L)));
        if (n3 >= 0) {
            bigIntegerArray[0] = bigIntegerArray[0].add(BigInteger.valueOf(1L));
        }
        return BigIntegerValue.makeIntegerValue(bigIntegerArray[0].multiply(bigInteger));
    }

    @Override
    public final NumericValue roundHalfToEven(int n2) {
        if (n2 >= 0) {
            return this;
        }
        BigInteger bigInteger = BigInteger.valueOf(10L).pow(-n2);
        BigInteger[] bigIntegerArray = this.a.divideAndRemainder(bigInteger);
        int n3 = bigIntegerArray[1].compareTo(bigInteger.divide(BigInteger.valueOf(2L)));
        if (n3 > 0) {
            bigIntegerArray[0] = bigIntegerArray[0].add(BigInteger.valueOf(1L));
        } else if (n3 == 0 && bigIntegerArray[0].mod(BigInteger.valueOf(2L)).signum() != 0) {
            bigIntegerArray[0] = bigIntegerArray[0].add(BigInteger.valueOf(1L));
        }
        return BigIntegerValue.makeIntegerValue(bigIntegerArray[0].multiply(bigInteger));
    }

    @Override
    public final int signum() {
        return this.a.signum();
    }

    @Override
    public final NumericValue abs() {
        if (this.a.signum() >= 0) {
            return this;
        }
        return new BigIntegerValue(this.a.abs());
    }

    @Override
    public final boolean isWholeNumber() {
        return true;
    }

    @Override
    public final int asSubscript() {
        if (this.a.compareTo(BigInteger.ZERO) > 0 && this.a.compareTo(b) <= 0) {
            return (int)((NumericValue)this).longValue();
        }
        return -1;
    }

    @Override
    public final IntegerValue plus(IntegerValue integerValue) {
        if (integerValue instanceof BigIntegerValue) {
            return BigIntegerValue.makeIntegerValue(this.a.add(((BigIntegerValue)integerValue).a));
        }
        return BigIntegerValue.makeIntegerValue(this.a.add(BigInteger.valueOf(((NumericValue)((Int64Value)integerValue)).longValue())));
    }

    @Override
    public final IntegerValue minus(IntegerValue integerValue) {
        if (integerValue instanceof BigIntegerValue) {
            return BigIntegerValue.makeIntegerValue(this.a.subtract(((BigIntegerValue)integerValue).a));
        }
        return BigIntegerValue.makeIntegerValue(this.a.subtract(BigInteger.valueOf(((NumericValue)((Int64Value)integerValue)).longValue())));
    }

    @Override
    public final IntegerValue times(IntegerValue integerValue) {
        if (integerValue instanceof BigIntegerValue) {
            return BigIntegerValue.makeIntegerValue(this.a.multiply(((BigIntegerValue)integerValue).a));
        }
        return BigIntegerValue.makeIntegerValue(this.a.multiply(BigInteger.valueOf(((NumericValue)((Int64Value)integerValue)).longValue())));
    }

    @Override
    public final NumericValue div(IntegerValue comparable) {
        comparable = comparable instanceof BigIntegerValue ? ((BigIntegerValue)comparable).a : BigInteger.valueOf(comparable.longValue());
        BigDecimalValue bigDecimalValue = new BigDecimalValue(new BigDecimal(this.a));
        comparable = new BigDecimalValue(new BigDecimal((BigInteger)comparable));
        return Calculator.decimalDivide(bigDecimalValue, comparable);
    }

    @Override
    public final IntegerValue mod(IntegerValue object) {
        try {
            if (object instanceof BigIntegerValue) {
                return BigIntegerValue.makeIntegerValue(this.a.remainder(((BigIntegerValue)object).a));
            }
            return BigIntegerValue.makeIntegerValue(this.a.remainder(BigInteger.valueOf(((NumericValue)object).longValue())));
        }
        catch (ArithmeticException arithmeticException) {
            object = BigInteger.valueOf(((NumericValue)object).longValue()).signum() == 0 ? new XPathException("Integer modulo zero", "FOAR0001") : new XPathException("Integer mod operation failure", arithmeticException);
            throw object;
        }
    }

    @Override
    public final IntegerValue idiv(IntegerValue comparable) {
        comparable = comparable instanceof BigIntegerValue ? ((BigIntegerValue)comparable).a : BigInteger.valueOf(comparable.longValue());
        try {
            return BigIntegerValue.makeIntegerValue(this.a.divide((BigInteger)comparable));
        }
        catch (ArithmeticException arithmeticException) {
            XPathException xPathException = "/ by zero".equals(arithmeticException.getMessage()) ? new XPathException("Integer division by zero", "FOAR0001") : new XPathException("Integer division failure", arithmeticException);
            throw xPathException;
        }
    }

    @Override
    public final Comparable getSchemaComparable() {
        return new BigIntegerComparable(this);
    }

    public final IntegerValue reduce() {
        if (((NumericValue)this).compareTo(Long.MAX_VALUE) < 0 && ((NumericValue)this).compareTo(Long.MIN_VALUE) > 0) {
            Int64Value int64Value = new Int64Value(((NumericValue)this).longValue());
            int64Value.setTypeLabel(this.typeLabel);
            return int64Value;
        }
        return this;
    }

    @Override
    public final BigIntegerValue asAtomic() {
        return this;
    }

    protected static class BigIntegerComparable
    implements Comparable {
        protected BigIntegerValue value;

        public BigIntegerComparable(BigIntegerValue bigIntegerValue) {
            this.value = bigIntegerValue;
        }

        public BigInteger asBigInteger() {
            return ((IntegerValue)this.value).asBigInteger();
        }

        public int compareTo(Object object) {
            if (object instanceof Int64Value.Int64Comparable) {
                return this.asBigInteger().compareTo(BigInteger.valueOf(((Int64Value.Int64Comparable)object).asLong()));
            }
            if (object instanceof BigIntegerComparable) {
                return this.asBigInteger().compareTo(((BigIntegerComparable)object).asBigInteger());
            }
            if (object instanceof BigDecimalValue.DecimalComparable) {
                return ((NumericValue)this.value).getDecimalValue().compareTo(((BigDecimalValue.DecimalComparable)object).asBigDecimal());
            }
            return Integer.MIN_VALUE;
        }

        public boolean equals(Object object) {
            return this.compareTo(object) == 0;
        }

        public int hashCode() {
            Comparable<BigInteger> comparable = ((IntegerValue)this.value).asBigInteger();
            if (comparable.compareTo(MAX_LONG) < 0 && comparable.compareTo(MIN_LONG) > 0) {
                comparable = new Int64Value(comparable.longValue());
                return ((NumericValue)comparable).hashCode();
            }
            return comparable.hashCode();
        }
    }
}

