/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.ComparisonException;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Whitespace;

public final class BooleanValue
extends AtomicValue
implements Comparable,
AtomicMatchKey {
    private boolean a;
    public static final BooleanValue TRUE = new BooleanValue(true);
    public static final BooleanValue FALSE = new BooleanValue(false);

    private BooleanValue(boolean bl2) {
        this.a = bl2;
        this.typeLabel = BuiltInAtomicType.BOOLEAN;
    }

    public static BooleanValue get(boolean bl2) {
        if (bl2) {
            return TRUE;
        }
        return FALSE;
    }

    public BooleanValue(boolean bl2, AtomicType atomicType) {
        this.a = bl2;
        this.typeLabel = atomicType;
    }

    @Override
    public final AtomicValue copyAsSubType(AtomicType atomicType) {
        BooleanValue booleanValue = new BooleanValue(this.a);
        new BooleanValue(this.a).typeLabel = atomicType;
        return booleanValue;
    }

    public static ConversionResult fromString(CharSequence charSequence) {
        int n2 = (charSequence = Whitespace.trimWhitespace(charSequence)).length();
        if (n2 == 1) {
            char c2 = charSequence.charAt(0);
            n2 = c2;
            if (c2 == '1') {
                return TRUE;
            }
            if (n2 == 48) {
                return FALSE;
            }
        } else if (n2 == 4) {
            if (charSequence.charAt(0) == 't' && charSequence.charAt(1) == 'r' && charSequence.charAt(2) == 'u' && charSequence.charAt(3) == 'e') {
                return TRUE;
            }
        } else if (n2 == 5 && charSequence.charAt(0) == 'f' && charSequence.charAt(1) == 'a' && charSequence.charAt(2) == 'l' && charSequence.charAt(3) == 's' && charSequence.charAt(4) == 'e') {
            return FALSE;
        }
        ValidationFailure validationFailure = new ValidationFailure("The string " + Err.wrap(charSequence, 4) + " cannot be cast to a boolean");
        validationFailure.setErrorCode("FORG0001");
        return validationFailure;
    }

    public final boolean getBooleanValue() {
        return this.a;
    }

    @Override
    public final boolean effectiveBooleanValue() {
        return this.a;
    }

    @Override
    public final BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.BOOLEAN;
    }

    @Override
    public final String getPrimitiveStringValue() {
        if (this.a) {
            return "true";
        }
        return "false";
    }

    @Override
    public final Comparable getSchemaComparable() {
        return new a(this, 0);
    }

    @Override
    public final AtomicMatchKey getXPathComparable(boolean bl2, StringCollator stringCollator, int n2) {
        return this;
    }

    public final int compareTo(Object object) {
        if (!(object instanceof BooleanValue)) {
            object = new XPathException("Boolean values are not comparable to " + object.getClass(), "XPTY0004");
            throw new ComparisonException((XPathException)object);
        }
        if (this.a == ((BooleanValue)object).a) {
            return 0;
        }
        if (this.a) {
            return 1;
        }
        return -1;
    }

    @Override
    public final boolean equals(Object object) {
        return object instanceof BooleanValue && this.a == ((BooleanValue)object).a;
    }

    public final int hashCode() {
        if (this.a) {
            return 0;
        }
        return 1;
    }

    @Override
    public final String toString() {
        return this.getStringValue() + "()";
    }

    private final class a
    implements Comparable {
        private /* synthetic */ BooleanValue a;

        private a(BooleanValue booleanValue) {
            this.a = booleanValue;
        }

        public final int compareTo(Object object) {
            if (this.equals(object)) {
                return 0;
            }
            return Integer.MIN_VALUE;
        }

        public final boolean equals(Object object) {
            if (object instanceof a) {
                a a2 = this;
                a a3 = a2;
                a3 = (a)object;
                if (a2.a.getBooleanValue() == a3.a.getBooleanValue()) {
                    return true;
                }
            }
            return false;
        }

        public final int hashCode() {
            a a2 = this;
            if (a2.a.getBooleanValue()) {
                return 9999999;
            }
            return 8888888;
        }

        /* synthetic */ a(BooleanValue booleanValue, byte by) {
            this(booleanValue);
        }
    }
}

