/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.util.GregorianCalendar;
import javax.xml.datatype.XMLGregorianCalendar;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.GDayValue;
import net.sf.saxon.value.GMonthDayValue;
import net.sf.saxon.value.GMonthValue;
import net.sf.saxon.value.GYearMonthValue;
import net.sf.saxon.value.GYearValue;
import net.sf.saxon.value.SaxonXMLGregorianCalendar;
import net.sf.saxon.value.TimeValue;

public abstract class CalendarValue
extends AtomicValue
implements AtomicMatchKey {
    private int a = Integer.MIN_VALUE;
    public static final int NO_TIMEZONE = Integer.MIN_VALUE;
    public static final int MISSING_TIMEZONE = Integer.MAX_VALUE;

    public static ConversionResult makeCalendarValue(CharSequence charSequence, ConversionRules conversionRules) {
        ConversionResult conversionResult;
        ConversionResult conversionResult2 = conversionResult = DateTimeValue.makeDateTimeValue(charSequence, conversionRules);
        if (conversionResult instanceof ValidationFailure) {
            conversionResult = DateValue.makeDateValue(charSequence, conversionRules);
        }
        if (conversionResult instanceof ValidationFailure) {
            conversionResult = TimeValue.makeTimeValue(charSequence);
        }
        if (conversionResult instanceof ValidationFailure) {
            conversionResult = GYearValue.makeGYearValue(charSequence, conversionRules);
        }
        if (conversionResult instanceof ValidationFailure) {
            conversionResult = GYearMonthValue.makeGYearMonthValue(charSequence, conversionRules);
        }
        if (conversionResult instanceof ValidationFailure) {
            conversionResult = GMonthValue.makeGMonthValue(charSequence);
        }
        if (conversionResult instanceof ValidationFailure) {
            conversionResult = GMonthDayValue.makeGMonthDayValue(charSequence);
        }
        if (conversionResult instanceof ValidationFailure) {
            conversionResult = GDayValue.makeGDayValue(charSequence);
        }
        if (conversionResult instanceof ValidationFailure) {
            return conversionResult2;
        }
        return conversionResult;
    }

    public final boolean hasTimezone() {
        return this.a != Integer.MIN_VALUE;
    }

    public final void setTimezoneInMinutes(int n2) {
        this.a = n2;
    }

    public abstract DateTimeValue toDateTime();

    public final int getTimezoneInMinutes() {
        return this.a;
    }

    public abstract GregorianCalendar getCalendar();

    public XMLGregorianCalendar getXMLGregorianCalendar() {
        return new SaxonXMLGregorianCalendar(this);
    }

    public abstract CalendarValue add(DurationValue var1);

    public DayTimeDurationValue subtract(CalendarValue object, XPathContext object2) {
        DateTimeValue dateTimeValue = this.toDateTime();
        object = ((CalendarValue)object).toDateTime();
        if (dateTimeValue.getTimezoneInMinutes() != ((CalendarValue)object).getTimezoneInMinutes()) {
            int n2;
            if (object2 == null || (n2 = object2.getImplicitTimezone()) == Integer.MAX_VALUE) {
                throw new NoDynamicContextException("Implicit timezone required");
            }
            dateTimeValue = dateTimeValue.adjustToUTC(n2);
            object = ((DateTimeValue)object).adjustToUTC(n2);
        }
        object2 = dateTimeValue.toJulianInstant();
        object = ((DateTimeValue)object).toJulianInstant();
        object = ((BigDecimal)object2).subtract((BigDecimal)object);
        return DayTimeDurationValue.fromSeconds((BigDecimal)object);
    }

    public final CalendarValue removeTimezone() {
        CalendarValue calendarValue = this;
        CalendarValue calendarValue2 = (CalendarValue)calendarValue.copyAsSubType(calendarValue.typeLabel);
        ((CalendarValue)calendarValue.copyAsSubType(calendarValue.typeLabel)).a = Integer.MIN_VALUE;
        return calendarValue2;
    }

    public abstract CalendarValue adjustTimezone(int var1);

    public final CalendarValue adjustTimezone(DayTimeDurationValue object) {
        long l2 = ((DayTimeDurationValue)object).getLengthInMicroseconds();
        if (l2 % 60000000L != 0L) {
            object = new XPathException("Timezone is not an integral number of minutes");
            ((XPathException)object).setErrorCode("FODT0003");
            throw object;
        }
        int n2 = (int)(l2 / 60000000L);
        if (Math.abs(n2) > 840) {
            XPathException xPathException = new XPathException("Timezone out of range (-14:00 to +14:00)");
            xPathException.setErrorCode("FODT0003");
            throw xPathException;
        }
        return this.adjustTimezone(n2);
    }

    @Override
    public AtomicMatchKey getXPathComparable(boolean bl2, StringCollator stringCollator, int n2) {
        if (bl2 && !(this instanceof Comparable)) {
            return null;
        }
        if (this.hasTimezone()) {
            return this;
        }
        if (n2 == Integer.MAX_VALUE) {
            throw new NoDynamicContextException("Unknown implicit timezone");
        }
        if (this.hasTimezone()) {
            return this;
        }
        return this.adjustTimezone(n2);
    }

    public AtomicMatchKey getComparisonKey(XPathContext xPathContext) {
        try {
            return ((AtomicValue)this).getXPathComparable(false, CodepointCollator.getInstance(), xPathContext.getImplicitTimezone());
        }
        catch (NoDynamicContextException noDynamicContextException) {
            return null;
        }
    }

    @Override
    public AtomicMatchKey asMapKey() {
        return new a(this, 0);
    }

    public abstract int compareTo(CalendarValue var1, int var2);

    @Override
    public boolean isIdentical(AtomicValue atomicValue) {
        return super.isIdentical(atomicValue) && this.a == ((CalendarValue)atomicValue).a;
    }

    @Override
    public int identityHashCode() {
        return this.hashCode() ^ this.a;
    }

    public final void appendTimezone(FastStringBuffer fastStringBuffer) {
        if (this.hasTimezone()) {
            CalendarValue.appendTimezone(this.getTimezoneInMinutes(), fastStringBuffer);
        }
    }

    public static void appendTimezone(int n2, FastStringBuffer fastStringBuffer) {
        if (n2 == 0) {
            fastStringBuffer.append("Z");
            return;
        }
        fastStringBuffer.append(n2 > 0 ? "+" : "-");
        n2 = Math.abs(n2);
        CalendarValue.a(fastStringBuffer, n2 / 60);
        fastStringBuffer.append(':');
        CalendarValue.a(fastStringBuffer, n2 % 60);
    }

    static void a(FastStringBuffer fastStringBuffer, int n2, int n3) {
        String string;
        String string2 = string = "000000000" + n2;
        fastStringBuffer.append(string2.substring(string2.length() - n3));
    }

    static void a(FastStringBuffer fastStringBuffer, int n2) {
        fastStringBuffer.append((char)(n2 / 10 + 48));
        fastStringBuffer.append((char)(n2 % 10 + 48));
    }

    private final class a
    implements AtomicMatchKey {
        private /* synthetic */ CalendarValue a;

        private a(CalendarValue calendarValue) {
            this.a = calendarValue;
        }

        public final boolean equals(Object object) {
            if (object instanceof a) {
                CalendarValue calendarValue = this.a;
                object = (a)object;
                object = ((a)object).a;
                if (calendarValue.hasTimezone() == ((CalendarValue)object).hasTimezone()) {
                    if (calendarValue.hasTimezone()) {
                        return ((AtomicValue)calendarValue.adjustTimezone(((CalendarValue)object).a)).isIdentical((AtomicValue)object);
                    }
                    return ((AtomicValue)calendarValue).isIdentical((AtomicValue)object);
                }
                return false;
            }
            return false;
        }

        public final int hashCode() {
            a a2 = this;
            return a2.a.hashCode();
        }

        /* synthetic */ a(CalendarValue calendarValue, byte by) {
            this(calendarValue);
        }
    }
}

