/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.VariableReference;

public final class Cardinality {
    private Cardinality() {
    }

    public static boolean allowsMany(int n2) {
        return (n2 & 0x8000) != 0;
    }

    public static boolean expectsMany(Expression expression) {
        while (true) {
            Binding binding;
            if (expression instanceof VariableReference && (binding = ((VariableReference)expression).getBinding()) instanceof LetExpression) {
                expression = ((LetExpression)binding).getSequence();
                continue;
            }
            if (expression instanceof Atomizer) {
                expression = ((Atomizer)expression).getBaseExpression();
                continue;
            }
            if (!(expression instanceof FilterExpression)) break;
            expression = ((FilterExpression)expression).getSelectExpression();
        }
        return Cardinality.allowsMany(expression.getCardinality());
    }

    public static boolean allowsZero(int n2) {
        return (n2 & 0x2000) != 0;
    }

    public static int union(int n2, int n3) {
        if ((n2 |= n3) == 40960) {
            n2 = 57344;
        }
        return n2;
    }

    public static int sum(int n2, int n3) {
        int n4 = Cardinality.a(n2) + Cardinality.a(n3);
        n3 = n2 = Cardinality.b(n2) + Cardinality.b(n3);
        n2 = n4;
        n4 = n2 == 0 ? 1 : 0;
        n2 = n2 <= 1 || n3 <= 1 ? 1 : 0;
        n3 = n3 > 1 ? 1 : 0;
        return (n4 != 0 ? 8192 : 0) + (n2 != 0 ? 16384 : 0) + (n3 != 0 ? 32768 : 0);
    }

    private static int a(int n2) {
        if (Cardinality.allowsZero(n2)) {
            return 0;
        }
        if (n2 == 32768) {
            return 2;
        }
        return 1;
    }

    private static int b(int n2) {
        if (Cardinality.allowsMany(n2)) {
            return 2;
        }
        if (n2 == 8192) {
            return 0;
        }
        return 1;
    }

    public static boolean subsumes(int n2, int n3) {
        return (n2 | n3) == n2;
    }

    public static int multiply(int n2, int n3) {
        if (n2 == 8192 || n3 == 8192) {
            return 8192;
        }
        if (n3 == 16384) {
            return n2;
        }
        if (n2 == 16384) {
            return n3;
        }
        if (n2 == 24576 && n3 == 24576) {
            return 24576;
        }
        if (n2 == 49152 && n3 == 49152) {
            return 49152;
        }
        return 57344;
    }

    public static String toString(int n2) {
        switch (n2) {
            case 24576: {
                return "zero or one";
            }
            case 16384: {
                return "exactly one";
            }
            case 57344: {
                return "zero or more";
            }
            case 49152: {
                return "one or more";
            }
            case 8192: {
                return "exactly zero";
            }
            case 32768: {
                return "more than one";
            }
        }
        return "code " + n2;
    }

    public static String getOccurrenceIndicator(int n2) {
        switch (n2) {
            case 24576: {
                return "?";
            }
            case 16384: {
                return "";
            }
            case 57344: {
                return "*";
            }
            case 49152: {
                return "+";
            }
            case 32768: {
                return "+";
            }
            case 8192: {
                return "\u00b0";
            }
        }
        return "*";
    }

    public static int fromOccurrenceIndicator(char c2) {
        switch (c2) {
            case '?': {
                return 24576;
            }
            case '1': {
                return 16384;
            }
            case '*': {
                return 57344;
            }
            case '+': {
                return 49152;
            }
            case '\u00b0': {
                return 8192;
            }
        }
        throw new AssertionError();
    }

    public static String generateJavaScriptChecker(int n2) {
        if (Cardinality.allowsZero(n2) && Cardinality.allowsMany(n2)) {
            return "function c() {return true;};";
        }
        if (n2 == 16384) {
            return "function c(n) {return n==1;};";
        }
        if (n2 == 8192) {
            return "function c(n) {return n==0;};";
        }
        if (!Cardinality.allowsZero(n2)) {
            return "function c(n) {return n>=1;};";
        }
        return "function c(n) {return n<=1;};";
    }
}

