/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.TimeZone;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.AccessorFn;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.GDateValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.TimeValue;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.value.YearMonthDurationValue;

public final class DateTimeValue
extends CalendarValue
implements Comparable,
TemporalAccessor {
    private int a;
    private byte b;
    private byte c;
    private byte d;
    private byte e;
    private byte f;
    private int g;
    private boolean h;
    public static final DateTimeValue EPOCH = new DateTimeValue(1970, 1, 1, 0, 0, 0, 0, 0, true);

    private DateTimeValue() {
    }

    public static DateTimeValue getCurrentDateTime(XPathContext object) {
        if (object == null || (object = object.getController()) == null) {
            return DateTimeValue.now();
        }
        return ((Controller)object).getCurrentDateTime();
    }

    public static DateTimeValue now() {
        return DateTimeValue.fromZonedDateTime(ZonedDateTime.now());
    }

    public DateTimeValue(Calendar calendar, boolean bl2) {
        int n2 = calendar.get(0);
        this.a = calendar.get(1);
        if (n2 == 0) {
            this.a = 1 - this.a;
        }
        this.b = (byte)(calendar.get(2) + 1);
        this.c = (byte)calendar.get(5);
        this.d = (byte)calendar.get(11);
        this.e = (byte)calendar.get(12);
        this.f = (byte)calendar.get(13);
        this.g = calendar.get(14) * 1000000;
        if (bl2) {
            int n3 = (calendar.get(15) + calendar.get(16)) / 60000;
            this.setTimezoneInMinutes(n3);
        }
        this.typeLabel = BuiltInAtomicType.DATE_TIME;
        this.h = true;
    }

    public static DateTimeValue fromJavaDate(Date date) {
        long l2 = date.getTime();
        return EPOCH.add(DayTimeDurationValue.fromMilliseconds(l2));
    }

    public static DateTimeValue fromJavaTime(long l2) {
        return EPOCH.add(DayTimeDurationValue.fromMilliseconds(l2));
    }

    public static DateTimeValue fromJavaInstant(long l2, int n2) {
        return EPOCH.add(((DurationValue)DayTimeDurationValue.fromSeconds(new BigDecimal(l2))).add(DayTimeDurationValue.fromNanoseconds(n2)));
    }

    public static DateTimeValue fromJavaInstant(Instant instant) {
        try {
            return DateTimeValue.fromJavaInstant(instant.getEpochSecond(), instant.getNano());
        }
        catch (XPathException xPathException) {
            throw new AssertionError();
        }
    }

    public static DateTimeValue fromZonedDateTime(ZonedDateTime temporalAccessor) {
        LocalDateTime localDateTime = temporalAccessor.toLocalDateTime();
        temporalAccessor = temporalAccessor.getOffset();
        int n2 = ((ZoneOffset)temporalAccessor).getTotalSeconds() / 60;
        DateTimeValue dateTimeValue = new DateTimeValue(localDateTime.getYear(), (byte)localDateTime.getMonthValue(), (byte)localDateTime.getDayOfMonth(), (byte)localDateTime.getHour(), (byte)localDateTime.getMinute(), (byte)localDateTime.getSecond(), localDateTime.getNano() / 1000, n2, false);
        new DateTimeValue(localDateTime.getYear(), (byte)localDateTime.getMonthValue(), (byte)localDateTime.getDayOfMonth(), (byte)localDateTime.getHour(), (byte)localDateTime.getMinute(), (byte)localDateTime.getSecond(), localDateTime.getNano() / 1000, n2, false).typeLabel = BuiltInAtomicType.DATE_TIME_STAMP;
        return dateTimeValue;
    }

    public static DateTimeValue fromLocalDateTime(LocalDateTime localDateTime) {
        return new DateTimeValue(localDateTime.getYear(), (byte)localDateTime.getMonthValue(), (byte)localDateTime.getDayOfMonth(), (byte)localDateTime.getHour(), (byte)localDateTime.getMinute(), (byte)localDateTime.getSecond(), localDateTime.getNano() / 1000, Integer.MIN_VALUE, false);
    }

    public static DateTimeValue makeDateTimeValue(DateValue dateValue, TimeValue timeValue) {
        if (dateValue == null || timeValue == null) {
            return null;
        }
        int n2 = dateValue.getTimezoneInMinutes();
        int n3 = timeValue.getTimezoneInMinutes();
        if (n2 != Integer.MIN_VALUE && n3 != Integer.MIN_VALUE && n2 != n3) {
            XPathException xPathException = new XPathException("Supplied date and time are in different timezones");
            xPathException.setErrorCode("FORG0008");
            throw xPathException;
        }
        DateTimeValue dateTimeValue = ((CalendarValue)dateValue).toDateTime();
        ((CalendarValue)dateValue).toDateTime().d = timeValue.getHour();
        dateTimeValue.e = timeValue.getMinute();
        dateTimeValue.f = timeValue.getSecond();
        dateTimeValue.g = timeValue.getNanosecond();
        dateTimeValue.setTimezoneInMinutes(Math.max(n2, n3));
        dateTimeValue.typeLabel = BuiltInAtomicType.DATE_TIME;
        dateTimeValue.h = dateValue.hasNoYearZero;
        return dateTimeValue;
    }

    public static ConversionResult makeDateTimeValue(CharSequence object, ConversionRules object2) {
        int n2;
        Object object3 = new DateTimeValue();
        new DateTimeValue().h = !((ConversionRules)object2).isAllowYearZero();
        StringTokenizer stringTokenizer = new StringTokenizer(Whitespace.trimWhitespace((CharSequence)object).toString(), "-:.+TZ", true);
        if (!stringTokenizer.hasMoreElements()) {
            return DateTimeValue.a("too short", (CharSequence)object);
        }
        String string = (String)stringTokenizer.nextElement();
        int n3 = 1;
        if ("+".equals(string)) {
            return DateTimeValue.a("Date must not start with '+' sign", (CharSequence)object);
        }
        if ("-".equals(string)) {
            n3 = -1;
            if (!stringTokenizer.hasMoreElements()) {
                return DateTimeValue.a("No year after '-'", (CharSequence)object);
            }
            string = (String)stringTokenizer.nextElement();
        }
        if ((n2 = DurationValue.simpleInteger(string)) < 0) {
            if (n2 == -1) {
                return DateTimeValue.a("Non-numeric year component", (CharSequence)object);
            }
            object3 = "FODT0001";
            object2 = object;
            object = "Year is outside the range that Saxon can handle";
            object = new ValidationFailure("Invalid dateTime value " + Err.wrap((CharSequence)object2, 4) + " (" + (String)object + ")");
            ((ValidationFailure)object).setErrorCode((String)object3);
            return object;
        }
        ((DateTimeValue)object3).a = n2 * n3;
        if (string.length() < 4) {
            return DateTimeValue.a("Year is less than four digits", (CharSequence)object);
        }
        if (string.length() > 4 && string.charAt(0) == '0') {
            return DateTimeValue.a("When year exceeds 4 digits, leading zeroes are not allowed", (CharSequence)object);
        }
        if (((DateTimeValue)object3).a == 0 && !((ConversionRules)object2).isAllowYearZero()) {
            return DateTimeValue.a("Year zero is not allowed", (CharSequence)object);
        }
        if (n3 < 0 && !((ConversionRules)object2).isAllowYearZero()) {
            ++((DateTimeValue)object3).a;
        }
        if (!stringTokenizer.hasMoreElements()) {
            return DateTimeValue.a("Too short", (CharSequence)object);
        }
        if (!"-".equals(stringTokenizer.nextElement())) {
            return DateTimeValue.a("Wrong delimiter after year", (CharSequence)object);
        }
        if (!stringTokenizer.hasMoreElements()) {
            return DateTimeValue.a("Too short", (CharSequence)object);
        }
        string = (String)stringTokenizer.nextElement();
        if (string.length() != 2) {
            return DateTimeValue.a("Month must be two digits", (CharSequence)object);
        }
        n2 = DurationValue.simpleInteger(string);
        if (n2 < 0) {
            return DateTimeValue.a("Non-numeric month component", (CharSequence)object);
        }
        ((DateTimeValue)object3).b = (byte)n2;
        if (((DateTimeValue)object3).b <= 0 || ((DateTimeValue)object3).b > 12) {
            return DateTimeValue.a("Month is out of range", (CharSequence)object);
        }
        if (!stringTokenizer.hasMoreElements()) {
            return DateTimeValue.a("Too short", (CharSequence)object);
        }
        if (!"-".equals(stringTokenizer.nextElement())) {
            return DateTimeValue.a("Wrong delimiter after month", (CharSequence)object);
        }
        if (!stringTokenizer.hasMoreElements()) {
            return DateTimeValue.a("Too short", (CharSequence)object);
        }
        string = (String)stringTokenizer.nextElement();
        if (string.length() != 2) {
            return DateTimeValue.a("Day must be two digits", (CharSequence)object);
        }
        n2 = DurationValue.simpleInteger(string);
        if (n2 < 0) {
            return DateTimeValue.a("Non-numeric day component", (CharSequence)object);
        }
        ((DateTimeValue)object3).c = (byte)n2;
        if (((DateTimeValue)object3).c <= 0 || ((DateTimeValue)object3).c > 31) {
            return DateTimeValue.a("Day is out of range", (CharSequence)object);
        }
        if (!stringTokenizer.hasMoreElements()) {
            return DateTimeValue.a("Too short", (CharSequence)object);
        }
        if (!"T".equals(stringTokenizer.nextElement())) {
            return DateTimeValue.a("Wrong delimiter after day", (CharSequence)object);
        }
        if (!stringTokenizer.hasMoreElements()) {
            return DateTimeValue.a("Too short", (CharSequence)object);
        }
        string = (String)stringTokenizer.nextElement();
        if (string.length() != 2) {
            return DateTimeValue.a("Hour must be two digits", (CharSequence)object);
        }
        n2 = DurationValue.simpleInteger(string);
        if (n2 < 0) {
            return DateTimeValue.a("Non-numeric hour component", (CharSequence)object);
        }
        ((DateTimeValue)object3).d = (byte)n2;
        if (((DateTimeValue)object3).d > 24) {
            return DateTimeValue.a("Hour is out of range", (CharSequence)object);
        }
        if (!stringTokenizer.hasMoreElements()) {
            return DateTimeValue.a("Too short", (CharSequence)object);
        }
        if (!":".equals(stringTokenizer.nextElement())) {
            return DateTimeValue.a("Wrong delimiter after hour", (CharSequence)object);
        }
        if (!stringTokenizer.hasMoreElements()) {
            return DateTimeValue.a("Too short", (CharSequence)object);
        }
        string = (String)stringTokenizer.nextElement();
        if (string.length() != 2) {
            return DateTimeValue.a("Minute must be two digits", (CharSequence)object);
        }
        n2 = DurationValue.simpleInteger(string);
        if (n2 < 0) {
            return DateTimeValue.a("Non-numeric minute component", (CharSequence)object);
        }
        ((DateTimeValue)object3).e = (byte)n2;
        if (((DateTimeValue)object3).e > 59) {
            return DateTimeValue.a("Minute is out of range", (CharSequence)object);
        }
        if (((DateTimeValue)object3).d == 24 && ((DateTimeValue)object3).e != 0) {
            return DateTimeValue.a("If hour is 24, minute must be 00", (CharSequence)object);
        }
        if (!stringTokenizer.hasMoreElements()) {
            return DateTimeValue.a("Too short", (CharSequence)object);
        }
        if (!":".equals(stringTokenizer.nextElement())) {
            return DateTimeValue.a("Wrong delimiter after minute", (CharSequence)object);
        }
        if (!stringTokenizer.hasMoreElements()) {
            return DateTimeValue.a("Too short", (CharSequence)object);
        }
        string = (String)stringTokenizer.nextElement();
        if (string.length() != 2) {
            return DateTimeValue.a("Second must be two digits", (CharSequence)object);
        }
        n2 = DurationValue.simpleInteger(string);
        if (n2 < 0) {
            return DateTimeValue.a("Non-numeric second component", (CharSequence)object);
        }
        ((DateTimeValue)object3).f = (byte)n2;
        if (((DateTimeValue)object3).f > 59) {
            return DateTimeValue.a("Second is out of range", (CharSequence)object);
        }
        if (((DateTimeValue)object3).d == 24 && ((DateTimeValue)object3).f != 0) {
            return DateTimeValue.a("If hour is 24, second must be 00", (CharSequence)object);
        }
        int n4 = 0;
        n3 = 0;
        int n5 = 0;
        while (stringTokenizer.hasMoreElements()) {
            if (n5 == 9) {
                return DateTimeValue.a("Characters after the end", (CharSequence)object);
            }
            String string2 = (String)stringTokenizer.nextElement();
            if (".".equals(string2)) {
                if (n5 != 0) {
                    return DateTimeValue.a("Decimal separator occurs twice", (CharSequence)object);
                }
                if (!stringTokenizer.hasMoreElements()) {
                    return DateTimeValue.a("Decimal point must be followed by digits", (CharSequence)object);
                }
                string = (String)stringTokenizer.nextElement();
                if (string.length() > 9 && string.matches("^[0-9]+$")) {
                    string = string.substring(0, 9);
                }
                if ((n2 = DurationValue.simpleInteger(string)) < 0) {
                    return DateTimeValue.a("Non-numeric fractional seconds component", (CharSequence)object);
                }
                double d2 = Double.parseDouble("." + string);
                int n6 = (int)Math.round(d2 * 1.0E9);
                if (n6 == 1000000000) {
                    // empty if block
                }
                ((DateTimeValue)object3).g = --n6;
                if (((DateTimeValue)object3).d == 24 && ((DateTimeValue)object3).g != 0) {
                    return DateTimeValue.a("If hour is 24, fractional seconds must be 0", (CharSequence)object);
                }
                n5 = 1;
                continue;
            }
            if ("Z".equals(string2)) {
                if (n5 > 1) {
                    return DateTimeValue.a("Z cannot occur here", (CharSequence)object);
                }
                n4 = 0;
                n5 = 9;
                ((CalendarValue)object3).setTimezoneInMinutes(0);
                continue;
            }
            if ("+".equals(string2) || "-".equals(string2)) {
                if (n5 > 1) {
                    return DateTimeValue.a(string2 + " cannot occur here", (CharSequence)object);
                }
                n5 = 2;
                if (!stringTokenizer.hasMoreElements()) {
                    return DateTimeValue.a("Missing timezone", (CharSequence)object);
                }
                string = (String)stringTokenizer.nextElement();
                if (string.length() != 2) {
                    return DateTimeValue.a("Timezone hour must be two digits", (CharSequence)object);
                }
                n2 = DurationValue.simpleInteger(string);
                if (n2 < 0) {
                    return DateTimeValue.a("Non-numeric timezone hour component", (CharSequence)object);
                }
                n4 = n2;
                if (n4 > 14) {
                    return DateTimeValue.a("Timezone is out of range (-14:00 to +14:00)", (CharSequence)object);
                }
                n4 *= 60;
                if (!"-".equals(string2)) continue;
                n3 = 1;
                continue;
            }
            if (":".equals(string2)) {
                if (n5 != 2) {
                    return DateTimeValue.a("Misplaced ':'", (CharSequence)object);
                }
                n5 = 9;
                string = (String)stringTokenizer.nextElement();
                n2 = DurationValue.simpleInteger(string);
                if (n2 < 0) {
                    return DateTimeValue.a("Non-numeric timezone minute component", (CharSequence)object);
                }
                int n7 = n2;
                if (string.length() != 2) {
                    return DateTimeValue.a("Timezone minute must be two digits", (CharSequence)object);
                }
                if (n7 > 59) {
                    return DateTimeValue.a("Timezone minute is out of range", (CharSequence)object);
                }
                if (Math.abs(n4) == 840 && n7 != 0) {
                    return DateTimeValue.a("Timezone is out of range (-14:00 to +14:00)", (CharSequence)object);
                }
                n4 += n7;
                if (n3 != 0) {
                    n4 = -n4;
                }
                ((CalendarValue)object3).setTimezoneInMinutes(n4);
                continue;
            }
            return DateTimeValue.a("Timezone format is incorrect", (CharSequence)object);
        }
        if (n5 == 2 || n5 == 3) {
            return DateTimeValue.a("Timezone incomplete", (CharSequence)object);
        }
        boolean bl2 = false;
        if (((DateTimeValue)object3).d == 24) {
            ((DateTimeValue)object3).d = 0;
            bl2 = true;
        }
        if (!DateValue.isValidDate(((DateTimeValue)object3).a, ((DateTimeValue)object3).b, ((DateTimeValue)object3).c)) {
            return DateTimeValue.a("Non-existent date", (CharSequence)object);
        }
        if (bl2) {
            DateValue dateValue = DateValue.tomorrow(((DateTimeValue)object3).a, ((DateTimeValue)object3).b, ((DateTimeValue)object3).c);
            ((DateTimeValue)object3).a = dateValue.getYear();
            ((DateTimeValue)object3).b = dateValue.getMonth();
            ((DateTimeValue)object3).c = dateValue.getDay();
        }
        ((AtomicValue)object3).typeLabel = BuiltInAtomicType.DATE_TIME;
        return object3;
    }

    public static DateTimeValue parse(CharSequence charSequence) {
        ConversionResult conversionResult = DateTimeValue.makeDateTimeValue(charSequence, ConversionRules.DEFAULT);
        if (conversionResult instanceof ValidationFailure) {
            throw new DateTimeParseException(((ValidationFailure)conversionResult).getMessage(), charSequence, 0);
        }
        return (DateTimeValue)conversionResult;
    }

    private static ValidationFailure a(String object, CharSequence charSequence) {
        object = new ValidationFailure("Invalid dateTime value " + Err.wrap(charSequence, 4) + " (" + (String)object + ")");
        ((ValidationFailure)object).setErrorCode("FORG0001");
        return object;
    }

    public DateTimeValue(int n2, byte by, byte by2, byte by3, byte by4, byte by5, int n3, int n4) {
        this.h = false;
        this.a = n2;
        this.b = by;
        this.c = by2;
        this.d = by3;
        this.e = by4;
        this.f = by5;
        this.g = n3;
        this.setTimezoneInMinutes(n4);
        this.typeLabel = BuiltInAtomicType.DATE_TIME;
    }

    public DateTimeValue(int n2, byte by, byte by2, byte by3, byte by4, byte by5, int n3, int n4, boolean bl2) {
        this.h = bl2;
        this.a = n2;
        this.b = by;
        this.c = by2;
        this.d = by3;
        this.e = by4;
        this.f = by5;
        this.g = n3 * 1000;
        this.setTimezoneInMinutes(n4);
        this.typeLabel = BuiltInAtomicType.DATE_TIME;
    }

    @Override
    public final BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.DATE_TIME;
    }

    public final int getYear() {
        return this.a;
    }

    public final byte getMonth() {
        return this.b;
    }

    public final byte getDay() {
        return this.c;
    }

    public final byte getHour() {
        return this.d;
    }

    public final byte getMinute() {
        return this.e;
    }

    public final byte getSecond() {
        return this.f;
    }

    public final int getMicrosecond() {
        return this.g / 1000;
    }

    public final int getNanosecond() {
        return this.g;
    }

    @Override
    public final DateTimeValue toDateTime() {
        return this;
    }

    public final boolean isXsd10Rules() {
        return this.h;
    }

    @Override
    public final void checkValidInJavascript() {
        if (this.a <= 0 || this.a > 9999) {
            throw new XPathException("Year out of range for Saxon-JS", "FODT0001");
        }
    }

    public final DateTimeValue adjustToUTC(int n2) {
        if (this.hasTimezone()) {
            return this.adjustTimezone(0);
        }
        if (n2 == Integer.MAX_VALUE || n2 == Integer.MIN_VALUE) {
            throw new NoDynamicContextException("DateTime operation needs access to implicit timezone");
        }
        DateTimeValue dateTimeValue = this.copyAsSubType(null);
        dateTimeValue.setTimezoneInMinutes(n2);
        return dateTimeValue.adjustTimezone(0);
    }

    public final BigDecimal toJulianInstant() {
        int n2 = DateValue.getJulianDayNumber(this.a, this.b, this.c);
        long l2 = (long)n2 * 24L * 60L * 60L;
        BigDecimal bigDecimal = BigDecimal.valueOf(l2 += ((long)this.d * 60L + (long)this.e) * 60L + (long)this.f);
        if (this.g == 0) {
            return bigDecimal;
        }
        return bigDecimal.add(BigDecimal.valueOf(this.g).divide(BigDecimalValue.BIG_DECIMAL_ONE_BILLION, 9, RoundingMode.HALF_EVEN));
    }

    public static DateTimeValue fromJulianInstant(BigDecimal bigDecimal) {
        Comparable<BigInteger> comparable = bigDecimal.toBigInteger();
        bigDecimal = bigDecimal.subtract(new BigDecimal((BigInteger)comparable)).multiply(BigDecimalValue.BIG_DECIMAL_ONE_BILLION);
        long l2 = ((BigInteger)comparable).longValue();
        long l3 = l2 / 86400L;
        comparable = DateValue.dateFromJulianDayNumber((int)l3);
        byte by = (byte)((l2 %= 86400L) / 3600L);
        byte by2 = (byte)((l2 %= 3600L) / 60L);
        return new DateTimeValue(((GDateValue)((Object)comparable)).getYear(), ((GDateValue)((Object)comparable)).getMonth(), ((GDateValue)((Object)comparable)).getDay(), by, by2, (byte)(l2 %= 60L), bigDecimal.intValue(), 0);
    }

    @Override
    public final GregorianCalendar getCalendar() {
        Cloneable cloneable;
        int n2;
        while (true) {
            n2 = dateTimeValue.hasTimezone() ? dateTimeValue.getTimezoneInMinutes() * 60000 : 0;
            cloneable = new SimpleTimeZone(n2, "LLL");
            if (n2 >= ((GregorianCalendar)(cloneable = new GregorianCalendar((TimeZone)cloneable))).getMinimum(15) && n2 <= ((GregorianCalendar)cloneable).getMaximum(15)) break;
            DateTimeValue dateTimeValue = dateTimeValue.adjustTimezone(0);
        }
        ((GregorianCalendar)cloneable).setGregorianChange(new Date(Long.MIN_VALUE));
        ((Calendar)cloneable).setLenient(false);
        int n3 = dateTimeValue.a;
        if (dateTimeValue.a <= 0) {
            n3 = dateTimeValue.h ? 1 - dateTimeValue.a : 0 - dateTimeValue.a;
            ((Calendar)cloneable).set(0, 0);
        }
        ((Calendar)cloneable).set(n3, dateTimeValue.b - 1, dateTimeValue.c, dateTimeValue.d, dateTimeValue.e, dateTimeValue.f);
        ((Calendar)cloneable).set(14, dateTimeValue.g / 1000000);
        ((Calendar)cloneable).set(15, n2);
        ((Calendar)cloneable).set(16, 0);
        return cloneable;
    }

    public final Instant toJavaInstant() {
        return Instant.from(this);
    }

    public final ZonedDateTime toZonedDateTime() {
        if (this.hasTimezone()) {
            return ZonedDateTime.from(this);
        }
        try {
            return ZonedDateTime.from(this.adjustToUTC(0));
        }
        catch (NoDynamicContextException noDynamicContextException) {
            throw new AssertionError((Object)noDynamicContextException);
        }
    }

    public final LocalDateTime toLocalDateTime() {
        return LocalDateTime.from(this);
    }

    @Override
    public final CharSequence getPrimitiveStringValue() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(30);
        int n2 = this.a;
        if (this.a <= 0 && (n2 = -n2 + (this.h ? 1 : 0)) != 0) {
            fastStringBuffer.append('-');
        }
        int n3 = n2;
        DateTimeValue.a(fastStringBuffer, n3, n3 > 9999 ? ("" + n2).length() : 4);
        fastStringBuffer.append('-');
        DateTimeValue.a(fastStringBuffer, this.b);
        fastStringBuffer.append('-');
        DateTimeValue.a(fastStringBuffer, this.c);
        fastStringBuffer.append('T');
        DateTimeValue.a(fastStringBuffer, this.d);
        fastStringBuffer.append(':');
        DateTimeValue.a(fastStringBuffer, this.e);
        fastStringBuffer.append(':');
        DateTimeValue.a(fastStringBuffer, this.f);
        if (this.g != 0) {
            fastStringBuffer.append('.');
            n2 = this.g;
            int n4 = 100000000;
            while (n2 > 0) {
                int n5 = n2 / n4;
                fastStringBuffer.append((char)(n5 + 48));
                n2 %= n4;
                n4 /= 10;
            }
        }
        if (this.hasTimezone()) {
            this.appendTimezone(fastStringBuffer);
        }
        return fastStringBuffer;
    }

    public final DateValue toDateValue() {
        return new DateValue(this.a, this.b, this.c, this.getTimezoneInMinutes(), this.h);
    }

    public final TimeValue toTimeValue() {
        return new TimeValue(this.d, this.e, this.f, this.g, this.getTimezoneInMinutes(), "");
    }

    @Override
    public final CharSequence getCanonicalLexicalRepresentation() {
        if (this.hasTimezone() && this.getTimezoneInMinutes() != 0) {
            return this.adjustTimezone(0).getStringValueCS();
        }
        return this.getStringValueCS();
    }

    @Override
    public final DateTimeValue copyAsSubType(AtomicType atomicType) {
        DateTimeValue dateTimeValue = new DateTimeValue(this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.getTimezoneInMinutes());
        new DateTimeValue(this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.getTimezoneInMinutes()).h = this.h;
        dateTimeValue.typeLabel = atomicType;
        return dateTimeValue;
    }

    @Override
    public final DateTimeValue adjustTimezone(int n2) {
        if (!this.hasTimezone()) {
            DateTimeValue dateTimeValue = this;
            DateTimeValue dateTimeValue2 = dateTimeValue.copyAsSubType(dateTimeValue.typeLabel);
            dateTimeValue2.setTimezoneInMinutes(n2);
            return dateTimeValue2;
        }
        int n3 = this.getTimezoneInMinutes();
        if (n3 == n2) {
            return this;
        }
        n3 = n2 - n3;
        int n4 = this.d;
        int n5 = this.e;
        if ((n5 += n3) < 0 || n5 > 59) {
            n4 = (int)((double)n4 + Math.floor((double)n5 / 60.0));
            n5 = (n5 + 1440) % 60;
        }
        if (n4 >= 0 && n4 < 24) {
            DateTimeValue dateTimeValue = new DateTimeValue(this.a, this.b, this.c, (byte)n4, (byte)n5, this.f, this.g, n2);
            new DateTimeValue(this.a, this.b, this.c, (byte)n4, (byte)n5, this.f, this.g, n2).h = this.h;
            return dateTimeValue;
        }
        CalendarValue calendarValue = this;
        while (n4 < 0) {
            calendarValue = DateValue.yesterday(((DateTimeValue)calendarValue).getYear(), ((DateTimeValue)calendarValue).getMonth(), ((DateTimeValue)calendarValue).getDay());
            calendarValue = new DateTimeValue(((GDateValue)calendarValue).getYear(), ((GDateValue)calendarValue).getMonth(), ((GDateValue)calendarValue).getDay(), (byte)(n4 += 24), (byte)n5, this.f, this.g, n2);
            v1.h = this.h;
        }
        if (n4 > 23) {
            calendarValue = DateValue.tomorrow(this.a, this.b, this.c);
            calendarValue = new DateTimeValue(((GDateValue)calendarValue).getYear(), ((GDateValue)calendarValue).getMonth(), ((GDateValue)calendarValue).getDay(), (byte)(n4 -= 24), (byte)n5, this.f, this.g, n2);
            v2.h = this.h;
        }
        return calendarValue;
    }

    @Override
    public final DateTimeValue add(DurationValue object) {
        if (object instanceof DayTimeDurationValue) {
            object = ((DayTimeDurationValue)object).getTotalSeconds();
            BigDecimal bigDecimal = this.toJulianInstant();
            bigDecimal = bigDecimal.add((BigDecimal)object);
            object = DateTimeValue.fromJulianInstant(bigDecimal);
            ((CalendarValue)object).setTimezoneInMinutes(this.getTimezoneInMinutes());
            ((DateTimeValue)object).h = this.h;
            return object;
        }
        if (object instanceof YearMonthDurationValue) {
            int n2 = ((YearMonthDurationValue)object).getLengthInMonths();
            int n3 = this.b - 1 + n2;
            n2 = this.a + n3 / 12;
            if ((n3 %= 12) < 0) {
                n3 += 12;
                --n2;
            }
            ++n3;
            int n4 = this.c;
            while (!DateValue.isValidDate(n2, n3, n4)) {
                --n4;
            }
            DateTimeValue dateTimeValue = new DateTimeValue(n2, (byte)n3, (byte)n4, this.d, this.e, this.f, this.g, this.getTimezoneInMinutes());
            new DateTimeValue(n2, (byte)n3, (byte)n4, this.d, this.e, this.f, this.g, this.getTimezoneInMinutes()).h = this.h;
            return dateTimeValue;
        }
        object = new XPathException("DateTime arithmetic is not supported on xs:duration, only on its subtypes");
        ((XPathException)object).setErrorCode("XPTY0004");
        ((XPathException)object).setIsTypeError(true);
        throw object;
    }

    @Override
    public final DayTimeDurationValue subtract(CalendarValue object, XPathContext xPathContext) {
        if (!(object instanceof DateTimeValue)) {
            object = new XPathException("First operand of '-' is a dateTime, but the second is not");
            ((XPathException)object).setErrorCode("XPTY0004");
            ((XPathException)object).setIsTypeError(true);
            throw object;
        }
        return super.subtract((CalendarValue)object, xPathContext);
    }

    public final BigDecimal secondsSinceEpoch() {
        try {
            Comparable comparable = this.adjustToUTC(0);
            comparable = ((DateTimeValue)comparable).toJulianInstant();
            BigDecimal bigDecimal = EPOCH.toJulianInstant();
            return ((BigDecimal)comparable).subtract(bigDecimal);
        }
        catch (NoDynamicContextException noDynamicContextException) {
            throw new AssertionError((Object)noDynamicContextException);
        }
    }

    @Override
    public final AtomicValue getComponent(AccessorFn.Component object) {
        switch (object) {
            case YEAR_ALLOWING_ZERO: {
                return Int64Value.makeIntegerValue(this.a);
            }
            case YEAR: {
                return Int64Value.makeIntegerValue(this.a > 0 || !this.h ? (long)this.a : (long)(this.a - 1));
            }
            case MONTH: {
                return Int64Value.makeIntegerValue(this.b);
            }
            case DAY: {
                return Int64Value.makeIntegerValue(this.c);
            }
            case HOURS: {
                return Int64Value.makeIntegerValue(this.d);
            }
            case MINUTES: {
                return Int64Value.makeIntegerValue(this.e);
            }
            case SECONDS: {
                object = BigDecimal.valueOf(this.g);
                object = ((BigDecimal)object).divide(BigDecimalValue.BIG_DECIMAL_ONE_BILLION, 6, 4);
                object = ((BigDecimal)object).add(BigDecimal.valueOf(this.f));
                return new BigDecimalValue((BigDecimal)object);
            }
            case WHOLE_SECONDS: {
                return Int64Value.makeIntegerValue(this.f);
            }
            case MICROSECONDS: {
                return new Int64Value(this.g / 1000);
            }
            case NANOSECONDS: {
                return new Int64Value(this.g);
            }
            case TIMEZONE: {
                if (this.hasTimezone()) {
                    return DayTimeDurationValue.fromMilliseconds(60000L * (long)this.getTimezoneInMinutes());
                }
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown component for dateTime: " + (Object)object);
    }

    @Override
    public final boolean isSupported(TemporalField temporalField) {
        if (temporalField.equals(ChronoField.OFFSET_SECONDS)) {
            return this.getTimezoneInMinutes() != Integer.MIN_VALUE;
        }
        if (temporalField instanceof ChronoField) {
            return true;
        }
        return temporalField.isSupportedBy(this);
    }

    @Override
    public final long getLong(TemporalField object) {
        if (object instanceof ChronoField) {
            switch ((ChronoField)object) {
                case NANO_OF_SECOND: {
                    return this.g;
                }
                case NANO_OF_DAY: {
                    return (long)(this.d * 3600 + this.e * 60 + this.f) * 1000000000L + (long)this.g;
                }
                case MICRO_OF_SECOND: {
                    return this.g / 1000;
                }
                case MICRO_OF_DAY: {
                    return (long)(this.d * 3600 + this.e * 60 + this.f) * 1000000L + (long)(this.g / 1000);
                }
                case MILLI_OF_SECOND: {
                    return this.g / 1000000;
                }
                case MILLI_OF_DAY: {
                    return (long)(this.d * 3600 + this.e * 60 + this.f) * 1000L + (long)(this.g / 1000000);
                }
                case SECOND_OF_MINUTE: {
                    return this.f;
                }
                case SECOND_OF_DAY: {
                    return this.d * 3600 + this.e * 60 + this.f;
                }
                case MINUTE_OF_HOUR: {
                    return this.e;
                }
                case MINUTE_OF_DAY: {
                    return this.d * 60 + this.e;
                }
                case HOUR_OF_AMPM: {
                    return this.d % 12;
                }
                case CLOCK_HOUR_OF_AMPM: {
                    return (this.d + 11) % 12 + 1;
                }
                case HOUR_OF_DAY: {
                    return this.d;
                }
                case CLOCK_HOUR_OF_DAY: {
                    return (this.d + 23) % 24 + 1;
                }
                case AMPM_OF_DAY: {
                    return this.d / 12;
                }
                case DAY_OF_WEEK: {
                    return DateValue.getDayOfWeek(this.a, this.b, this.c);
                }
                case ALIGNED_DAY_OF_WEEK_IN_MONTH: {
                    return (this.c - 1) % 7 + 1;
                }
                case ALIGNED_DAY_OF_WEEK_IN_YEAR: {
                    return (DateValue.getDayWithinYear(this.a, this.b, this.c) - 1) % 7 + 1;
                }
                case DAY_OF_MONTH: {
                    return this.c;
                }
                case DAY_OF_YEAR: {
                    return DateValue.getDayWithinYear(this.a, this.b, this.c);
                }
                case EPOCH_DAY: {
                    object = this.secondsSinceEpoch();
                    long l2 = this.secondsSinceEpoch().longValue() / 86400L;
                    if (((BigDecimal)object).signum() < 0) {
                        return l2 - 1L;
                    }
                    return l2;
                }
                case ALIGNED_WEEK_OF_MONTH: {
                    return (this.c - 1) / 7 + 1;
                }
                case ALIGNED_WEEK_OF_YEAR: {
                    return (DateValue.getDayWithinYear(this.a, this.b, this.c) - 1) / 7 + 1;
                }
                case MONTH_OF_YEAR: {
                    return this.b;
                }
                case PROLEPTIC_MONTH: {
                    return this.a * 12 + this.b - 1;
                }
                case YEAR_OF_ERA: {
                    return Math.abs(this.a) + (this.a < 0 ? 1 : 0);
                }
                case YEAR: {
                    return this.a;
                }
                case ERA: {
                    if (this.a < 0) {
                        return 0L;
                    }
                    return 1L;
                }
                case INSTANT_SECONDS: {
                    return this.secondsSinceEpoch().setScale(0, 3).longValue();
                }
                case OFFSET_SECONDS: {
                    int n2 = this.getTimezoneInMinutes();
                    if (n2 == Integer.MIN_VALUE) {
                        throw new UnsupportedTemporalTypeException("xs:dateTime value has no timezone");
                    }
                    return n2 * 60;
                }
            }
            throw new UnsupportedTemporalTypeException(object.toString());
        }
        return object.getFrom(this);
    }

    @Override
    public final int compareTo(CalendarValue calendarValue, int n2) {
        while (true) {
            if (!(calendarValue instanceof DateTimeValue)) {
                throw new ClassCastException("DateTime values are not comparable to " + calendarValue.getClass());
            }
            calendarValue = (DateTimeValue)calendarValue;
            if (dateTimeValue.getTimezoneInMinutes() == calendarValue.getTimezoneInMinutes()) {
                if (dateTimeValue.a != ((DateTimeValue)calendarValue).a) {
                    return IntegerValue.signum(dateTimeValue.a - ((DateTimeValue)calendarValue).a);
                }
                if (dateTimeValue.b != ((DateTimeValue)calendarValue).b) {
                    return IntegerValue.signum(dateTimeValue.b - ((DateTimeValue)calendarValue).b);
                }
                if (dateTimeValue.c != ((DateTimeValue)calendarValue).c) {
                    return IntegerValue.signum(dateTimeValue.c - ((DateTimeValue)calendarValue).c);
                }
                if (dateTimeValue.d != ((DateTimeValue)calendarValue).d) {
                    return IntegerValue.signum(dateTimeValue.d - ((DateTimeValue)calendarValue).d);
                }
                if (dateTimeValue.e != ((DateTimeValue)calendarValue).e) {
                    return IntegerValue.signum(dateTimeValue.e - ((DateTimeValue)calendarValue).e);
                }
                if (dateTimeValue.f != ((DateTimeValue)calendarValue).f) {
                    return IntegerValue.signum(dateTimeValue.f - ((DateTimeValue)calendarValue).f);
                }
                if (dateTimeValue.g != ((DateTimeValue)calendarValue).g) {
                    return IntegerValue.signum(dateTimeValue.g - ((DateTimeValue)calendarValue).g);
                }
                return 0;
            }
            calendarValue = ((DateTimeValue)calendarValue).adjustToUTC(n2);
            DateTimeValue dateTimeValue = dateTimeValue.adjustToUTC(n2);
        }
    }

    public final int compareTo(Object object) {
        try {
            return ((CalendarValue)this).compareTo((DateTimeValue)object, Integer.MAX_VALUE);
        }
        catch (Exception exception) {
            throw new ClassCastException("DateTime comparison requires access to implicit timezone");
        }
    }

    @Override
    public final Comparable getSchemaComparable() {
        return new a(this, 0);
    }

    @Override
    public final boolean equals(Object object) {
        return object instanceof DateTimeValue && this.compareTo(object) == 0;
    }

    public final int hashCode() {
        return DateTimeValue.a(this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.getTimezoneInMinutes());
    }

    static int a(int n2, byte by, byte by2, byte by3, byte by4, byte by5, int n3, int n4) {
        n4 = n4 == Integer.MIN_VALUE ? 0 : -n4;
        int n5 = by4 + n4;
        by4 = (byte)n5;
        if (n5 < 0 || by4 > 59) {
            by3 = (byte)((double)by3 + Math.floor((double)by4 / 60.0));
            by4 = (byte)((by4 + 1440) % 60);
        }
        while (by3 < 0) {
            by3 = (byte)(by3 + 24);
            DateValue dateValue = DateValue.yesterday(n2, by, by2);
            n2 = dateValue.getYear();
            by = dateValue.getMonth();
            by2 = dateValue.getDay();
        }
        while (by3 > 23) {
            by3 = (byte)(by3 - 24);
            DateValue dateValue = DateValue.tomorrow(n2, by, by2);
            n2 = dateValue.getYear();
            by = dateValue.getMonth();
            by2 = dateValue.getDay();
        }
        return n2 << 4 ^ by << 28 ^ by2 << 23 ^ by3 << 18 ^ by4 << 13 ^ by5 ^ n3;
    }

    private final class a
    implements Comparable {
        private /* synthetic */ DateTimeValue a;

        private a(DateTimeValue dateTimeValue) {
            this.a = dateTimeValue;
        }

        public final int compareTo(Object object) {
            if (object instanceof a) {
                DateTimeValue dateTimeValue = this.a;
                object = (a)object;
                object = ((a)object).a;
                if (dateTimeValue.hasTimezone()) {
                    if (((CalendarValue)object).hasTimezone()) {
                        dateTimeValue = dateTimeValue.adjustTimezone(0);
                        object = ((DateTimeValue)object).adjustTimezone(0);
                        return dateTimeValue.compareTo(object);
                    }
                    DateTimeValue dateTimeValue2 = ((DateTimeValue)object).adjustTimezone(840);
                    if (dateTimeValue.compareTo(dateTimeValue2) < 0) {
                        return -1;
                    }
                    dateTimeValue2 = ((DateTimeValue)object).adjustTimezone(-840);
                    if (dateTimeValue.compareTo(dateTimeValue2) > 0) {
                        return 1;
                    }
                    return Integer.MIN_VALUE;
                }
                if (((CalendarValue)object).hasTimezone()) {
                    DateTimeValue dateTimeValue3 = dateTimeValue.adjustTimezone(-840);
                    if (dateTimeValue3.compareTo(object) < 0) {
                        return -1;
                    }
                    dateTimeValue3 = dateTimeValue.adjustTimezone(840);
                    if (dateTimeValue3.compareTo(object) > 0) {
                        return 1;
                    }
                    return Integer.MIN_VALUE;
                }
                dateTimeValue = dateTimeValue.adjustTimezone(0);
                object = ((DateTimeValue)object).adjustTimezone(0);
                return dateTimeValue.compareTo(object);
            }
            return Integer.MIN_VALUE;
        }

        public final boolean equals(Object object) {
            if (object instanceof a) {
                a a2 = (a)object;
                if (this.a.hasTimezone() == a2.a.hasTimezone() && this.compareTo(object) == 0) {
                    return true;
                }
            }
            return false;
        }

        public final int hashCode() {
            DateTimeValue dateTimeValue = this.a.adjustTimezone(0);
            return dateTimeValue.a << 20 ^ dateTimeValue.b << 16 ^ dateTimeValue.c << 11 ^ dateTimeValue.d << 7 ^ dateTimeValue.e << 2 ^ dateTimeValue.f * 1000000000 + dateTimeValue.g;
        }

        /* synthetic */ a(DateTimeValue dateTimeValue, byte by) {
            this(dateTimeValue);
        }
    }
}

