/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.time.temporal.WeekFields;
import java.util.GregorianCalendar;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.GDateValue;
import net.sf.saxon.value.YearMonthDurationValue;

public class DateValue
extends GDateValue
implements Comparable {
    private DateValue() {
    }

    public DateValue(int n2, byte by, byte by2) {
        this.hasNoYearZero = true;
        this.year = n2;
        this.month = by;
        this.day = by2;
        this.typeLabel = BuiltInAtomicType.DATE;
    }

    public DateValue(int n2, byte by, byte by2, boolean bl2) {
        this.hasNoYearZero = bl2;
        this.year = n2;
        this.month = by;
        this.day = by2;
        this.typeLabel = BuiltInAtomicType.DATE;
    }

    public DateValue(int n2, byte by, byte by2, int n3, boolean bl2) {
        this.hasNoYearZero = bl2;
        this.year = n2;
        this.month = by;
        this.day = by2;
        this.setTimezoneInMinutes(n3);
        this.typeLabel = BuiltInAtomicType.DATE;
    }

    public DateValue(int n2, byte by, byte by2, int n3, AtomicType atomicType) {
        this.year = n2;
        this.month = by;
        this.day = by2;
        this.setTimezoneInMinutes(n3);
        this.typeLabel = atomicType;
    }

    public DateValue(CharSequence charSequence) {
        this(charSequence, ConversionRules.DEFAULT);
    }

    public DateValue(CharSequence charSequence, ConversionRules conversionRules) {
        DateValue.setLexicalValue(this, charSequence, conversionRules.isAllowYearZero()).asAtomic();
        this.typeLabel = BuiltInAtomicType.DATE;
    }

    public DateValue(GregorianCalendar gregorianCalendar, int n2) {
        int n3 = gregorianCalendar.get(0);
        this.year = gregorianCalendar.get(1);
        if (n3 == 0) {
            this.year = 1 - this.year;
        }
        this.month = (byte)(gregorianCalendar.get(2) + 1);
        this.day = (byte)gregorianCalendar.get(5);
        this.setTimezoneInMinutes(n2);
        this.typeLabel = BuiltInAtomicType.DATE;
    }

    public static ConversionResult makeDateValue(CharSequence charSequence, ConversionRules conversionRules) {
        DateValue dateValue = new DateValue();
        new DateValue().typeLabel = BuiltInAtomicType.DATE;
        return DateValue.setLexicalValue(dateValue, charSequence, conversionRules.isAllowYearZero());
    }

    public static DateValue parse(CharSequence charSequence) {
        ConversionResult conversionResult = DateValue.makeDateValue(charSequence, ConversionRules.DEFAULT);
        if (conversionResult instanceof ValidationFailure) {
            throw new DateTimeParseException(((ValidationFailure)conversionResult).getMessage(), charSequence, 0);
        }
        return (DateValue)conversionResult;
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.DATE;
    }

    public static DateValue tomorrow(int n2, byte by, byte by2) {
        if (DateValue.isValidDate(n2, by, by2 + 1)) {
            return new DateValue(n2, by, (byte)(by2 + 1), true);
        }
        if (by < 12) {
            return new DateValue(n2, (byte)(by + 1), 1, true);
        }
        return new DateValue(n2 + 1, 1, 1, true);
    }

    public static DateValue yesterday(int n2, byte by, byte by2) {
        if (by2 > 1) {
            return new DateValue(n2, by, (byte)(by2 - 1), true);
        }
        if (by > 1) {
            if (by == 3 && DateValue.isLeapYear(n2)) {
                return new DateValue(n2, 2, 29, true);
            }
            return new DateValue(n2, (byte)(by - 1), daysPerMonth[by - 2], true);
        }
        return new DateValue(n2 - 1, 12, 31, true);
    }

    @Override
    public CharSequence getPrimitiveStringValue() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(16);
        int n2 = this.year;
        if (this.year <= 0 && (n2 = -n2 + (this.hasNoYearZero ? 1 : 0)) != 0) {
            fastStringBuffer.append('-');
        }
        int n3 = n2;
        DateValue.a(fastStringBuffer, n3, n3 > 9999 ? ("" + n2).length() : 4);
        fastStringBuffer.append('-');
        DateValue.a(fastStringBuffer, this.month);
        fastStringBuffer.append('-');
        DateValue.a(fastStringBuffer, this.day);
        if (this.hasTimezone()) {
            this.appendTimezone(fastStringBuffer);
        }
        return fastStringBuffer;
    }

    @Override
    public CharSequence getCanonicalLexicalRepresentation() {
        DateValue dateValue = this;
        if (this.hasTimezone()) {
            if (this.getTimezoneInMinutes() > 720) {
                DateValue dateValue2 = this;
                dateValue = dateValue2.adjustTimezone(dateValue2.getTimezoneInMinutes() - 1440);
            } else if (this.getTimezoneInMinutes() <= -720) {
                DateValue dateValue3 = this;
                dateValue = dateValue3.adjustTimezone(dateValue3.getTimezoneInMinutes() + 1440);
            }
        }
        return dateValue.getStringValueCS();
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType atomicType) {
        DateValue dateValue = new DateValue(this.year, this.month, this.day, this.getTimezoneInMinutes(), this.hasNoYearZero);
        new DateValue(this.year, this.month, this.day, this.getTimezoneInMinutes(), this.hasNoYearZero).typeLabel = atomicType;
        return dateValue;
    }

    @Override
    public DateValue adjustTimezone(int n2) {
        DateTimeValue dateTimeValue = ((CalendarValue)this).toDateTime().adjustTimezone(n2);
        return new DateValue(dateTimeValue.getYear(), dateTimeValue.getMonth(), dateTimeValue.getDay(), dateTimeValue.getTimezoneInMinutes(), this.hasNoYearZero);
    }

    @Override
    public DateValue add(DurationValue durationValue) {
        if (durationValue instanceof DayTimeDurationValue) {
            long l2 = ((DayTimeDurationValue)durationValue).getLengthInMicroseconds();
            boolean bl2 = l2 < 0L;
            l2 = Math.abs(l2);
            int n2 = (int)Math.floor((double)l2 / 8.64E10);
            boolean bl3 = l2 % 86400000000L > 0L;
            int n3 = this.getJulianDayNumber();
            DateValue dateValue = DateValue.dateFromJulianDayNumber(n3 + (bl2 ? -n2 : n2));
            if (bl3 && bl2) {
                dateValue = DateValue.yesterday(dateValue.year, dateValue.month, dateValue.day);
            }
            dateValue.setTimezoneInMinutes(this.getTimezoneInMinutes());
            dateValue.hasNoYearZero = this.hasNoYearZero;
            return dateValue;
        }
        if (durationValue instanceof YearMonthDurationValue) {
            int n4 = ((YearMonthDurationValue)durationValue).getLengthInMonths();
            int n5 = this.month - 1 + n4;
            int n6 = this.year + n5 / 12;
            if ((n5 %= 12) < 0) {
                n5 += 12;
                --n6;
            }
            ++n5;
            int n7 = this.day;
            while (!DateValue.isValidDate(n6, n5, n7)) {
                --n7;
            }
            return new DateValue(n6, (byte)n5, (byte)n7, this.getTimezoneInMinutes(), this.hasNoYearZero);
        }
        XPathException xPathException = new XPathException("Date arithmetic is not available for xs:duration, only for its subtypes");
        xPathException.setIsTypeError(true);
        xPathException.setErrorCode("XPTY0004");
        throw xPathException;
    }

    @Override
    public DayTimeDurationValue subtract(CalendarValue object, XPathContext xPathContext) {
        if (!(object instanceof DateValue)) {
            object = new XPathException("First operand of '-' is a date, but the second is not");
            ((XPathException)object).setIsTypeError(true);
            ((XPathException)object).setErrorCode("XPTY0004");
            throw object;
        }
        return super.subtract((CalendarValue)object, xPathContext);
    }

    public int compareTo(Object object) {
        try {
            return ((CalendarValue)this).compareTo((DateValue)object, Integer.MAX_VALUE);
        }
        catch (Exception exception) {
            throw new ClassCastException("Date comparison requires access to implicit timezone");
        }
    }

    public static int getJulianDayNumber(int n2, int n3, int n4) {
        int n5 = n3 < 3 ? 1 : 0;
        n3 = monthData[n3 - 1];
        if ((n2 -= n5) >= 0) {
            return n4 + n3 + n2 * 365 + n2 / 4 - n2 / 100 + n2 / 400 + 1721118;
        }
        n2 += 12000;
        n2 = n4 + n3 + n2 * 365 + n2 / 4 - n2 / 100 + n2 / 400 + 1721118;
        return n2 - 4382910;
    }

    public int getJulianDayNumber() {
        return DateValue.getJulianDayNumber(this.year, this.month, this.day);
    }

    public static DateValue dateFromJulianDayNumber(int n2) {
        if (n2 >= 0) {
            n2 = n2 + 68569 + 1;
            int n3 = 4 * n2 / 146097;
            int n4 = 4000 * ((n2 -= (n3 * 146097 + 3) / 4) + 1) / 1461001;
            n2 = n2 - n4 * 1461 / 4 + 31;
            int n5 = n2 * 80 / 2447;
            int n6 = n2 - n5 * 2447 / 80;
            n2 = n5 / 11;
            n5 = n5 + 2 - n2 * 12;
            n2 = 100 * (n3 - 49) + n4 + n2;
            return new DateValue(n2, (byte)n5, (byte)n6, true);
        }
        DateValue dateValue = DateValue.dateFromJulianDayNumber(n2 + 4380000 + 3000 - 120 + 30);
        dateValue.year -= 12000;
        return dateValue;
    }

    public static int getDayWithinYear(int n2, int n3, int n4) {
        n3 = DateValue.getJulianDayNumber(n2, n3, n4);
        n2 = DateValue.getJulianDayNumber(n2, 1, 1);
        return n3 - n2 + 1;
    }

    public static int getDayOfWeek(int n2, int n3, int n4) {
        n2 = DateValue.getJulianDayNumber(n2, n3, n4);
        n2 -= 2378500;
        while (n2 <= 0) {
            n2 += 70000000;
        }
        return (n2 - 1) % 7 + 1;
    }

    public static int getWeekNumber(int n2, int n3, int n4) {
        LocalDate localDate = LocalDate.of(n2, n3, n4);
        return localDate.get(WeekFields.ISO.weekOfWeekBasedYear());
    }

    public static int getWeekNumberWithinMonth(int n2, int n3, int n4) {
        int n5;
        while ((n5 = DateValue.getDayOfWeek(n2, n3, 1)) > 4 && n5 + n4 <= 8) {
            DateValue dateValue = DateValue.yesterday(n2, (byte)n3, (byte)1);
            n4 = dateValue.day;
            n3 = dateValue.month;
            n2 = dateValue.year;
        }
        n2 = n5 < 5 ? 1 : 0;
        return (n4 + n5 - 2) / 7 + n2;
    }
}

