/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.Duration;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.DurationValue;

public final class DayTimeDurationValue
extends DurationValue
implements Comparable<DayTimeDurationValue> {
    private DayTimeDurationValue() {
        this.typeLabel = BuiltInAtomicType.DAY_TIME_DURATION;
    }

    public static ConversionResult makeDayTimeDurationValue(CharSequence object) {
        if ((object = DurationValue.makeDuration((CharSequence)object, false, true)) instanceof ValidationFailure) {
            return object;
        }
        object = (DurationValue)object;
        return Converter.DurationToDayTimeDuration.INSTANCE.convert((AtomicValue)object);
    }

    public DayTimeDurationValue(int n2, int n3, int n4, int n5, long l2, int n6) {
        if (n3 < 0 || n4 < 0 || n5 < 0 || l2 < 0L || n6 < 0) {
            throw new IllegalArgumentException("Negative component value");
        }
        if ((double)n3 * 86400.0 + (double)n4 * 3600.0 + (double)n5 * 60.0 + (double)l2 > 9.223372036854776E18) {
            throw new IllegalArgumentException("Duration seconds limit exceeded");
        }
        this.negative = n2 < 0;
        this.months = 0;
        long l3 = (long)n3 * 24L + (long)n4;
        long l4 = l3 * 60L + (long)n5;
        long l5 = l4 * 60L + l2;
        if (n6 > 1000000) {
            l5 += (long)(n6 / 1000000);
            n6 %= 1000000;
        }
        this.seconds = l5;
        this.nanoseconds = n6 * 1000;
        if (l5 == 0L && n6 == 0) {
            this.negative = false;
        }
        this.typeLabel = BuiltInAtomicType.DAY_TIME_DURATION;
    }

    public DayTimeDurationValue(int n2, int n3, int n4, long l2, int n5) {
        boolean bl2;
        boolean bl3 = n2 > 0 || n3 > 0 || n4 > 0 || l2 > 0L || n5 > 0;
        boolean bl4 = bl2 = n2 < 0 || n3 < 0 || n4 < 0 || l2 < 0L || n5 < 0;
        if (bl3 && bl2) {
            throw new IllegalArgumentException("Some component values are positive and others are negative");
        }
        if (bl2) {
            this.negative = true;
            n2 = -n2;
            n3 = -n3;
            n4 = -n4;
            l2 = -l2;
            n5 = -n5;
        }
        if ((double)n2 * 86400.0 + (double)n3 * 3600.0 + (double)n4 * 60.0 + (double)l2 > 9.223372036854776E18) {
            throw new IllegalArgumentException("Duration seconds limit exceeded");
        }
        this.months = 0;
        long l3 = (long)n2 * 24L + (long)n3;
        long l4 = l3 * 60L + (long)n4;
        long l5 = l4 * 60L + l2;
        if (n5 > 1000000000) {
            l5 += (long)(n5 / 1000000000);
            n5 %= 1000000000;
        }
        this.seconds = l5;
        this.nanoseconds = n5;
        this.typeLabel = BuiltInAtomicType.DAY_TIME_DURATION;
    }

    @Override
    public final AtomicValue copyAsSubType(AtomicType atomicType) {
        DayTimeDurationValue dayTimeDurationValue = DayTimeDurationValue.fromSeconds(this.getTotalSeconds());
        DayTimeDurationValue.fromSeconds(this.getTotalSeconds()).typeLabel = atomicType;
        return dayTimeDurationValue;
    }

    @Override
    public final BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.DAY_TIME_DURATION;
    }

    @Override
    public final CharSequence getPrimitiveStringValue() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(32);
        if (this.negative) {
            fastStringBuffer.append('-');
        }
        int n2 = this.getDays();
        int n3 = this.getHours();
        int n4 = this.getMinutes();
        int n5 = this.getSeconds();
        fastStringBuffer.append('P');
        if (n2 != 0) {
            fastStringBuffer.append(n2 + "D");
        }
        if (n2 == 0 || n3 != 0 || n4 != 0 || n5 != 0 || this.nanoseconds != 0) {
            fastStringBuffer.append('T');
        }
        if (n3 != 0) {
            fastStringBuffer.append(n3 + "H");
        }
        if (n4 != 0) {
            fastStringBuffer.append(n4 + "M");
        }
        if (n5 != 0 || this.nanoseconds != 0 || n2 == 0 && n4 == 0 && n3 == 0) {
            if (this.nanoseconds == 0) {
                fastStringBuffer.append(n5 + "S");
            } else {
                long l2 = (long)n5 * 1000000000L + (long)this.nanoseconds;
                String string = "" + l2;
                if (n5 == 0) {
                    string = "0000000000" + string;
                    string = string.substring(string.length() - 10);
                }
                fastStringBuffer.append(string.substring(0, string.length() - 9));
                fastStringBuffer.append('.');
                n3 = string.length() - 1;
                while (string.charAt(n3) == '0') {
                    --n3;
                }
                String string2 = string;
                fastStringBuffer.append(string2.substring(string2.length() - 9, n3 + 1));
                fastStringBuffer.append('S');
            }
        }
        return fastStringBuffer;
    }

    @Override
    public final double getLengthInSeconds() {
        double d2 = (double)this.seconds + (double)this.nanoseconds / 1.0E9;
        if (this.negative) {
            return -d2;
        }
        return d2;
    }

    public final long getLengthInMicroseconds() {
        if (this.seconds > 9223372036854L) {
            throw new ArithmeticException("Value is too large to be expressed in microseconds");
        }
        long l2 = this.seconds * 1000000L + (long)(this.nanoseconds / 1000);
        if (this.negative) {
            return -l2;
        }
        return l2;
    }

    public final long getLengthInNanoseconds() {
        if (this.seconds > 9223372036L) {
            throw new ArithmeticException("Value is too large to be expressed in nanoseconds");
        }
        long l2 = this.seconds * 1000000000L + (long)this.nanoseconds;
        if (this.negative) {
            return -l2;
        }
        return l2;
    }

    public static DayTimeDurationValue fromSeconds(BigDecimal bigDecimal) {
        DayTimeDurationValue dayTimeDurationValue = new DayTimeDurationValue();
        boolean bl2 = new DayTimeDurationValue().negative = bigDecimal.signum() < 0;
        if (dayTimeDurationValue.negative) {
            bigDecimal = bigDecimal.negate();
        }
        BigInteger bigInteger = bigDecimal.toBigInteger();
        dayTimeDurationValue.seconds = bigInteger.longValueExact();
        bigDecimal = bigDecimal.remainder(BigDecimal.ONE);
        bigDecimal = bigDecimal.multiply(BigDecimalValue.BIG_DECIMAL_ONE_BILLION);
        dayTimeDurationValue.nanoseconds = bigDecimal.intValue();
        if (dayTimeDurationValue.seconds == 0L && dayTimeDurationValue.nanoseconds == 0) {
            dayTimeDurationValue.negative = false;
        }
        return dayTimeDurationValue;
    }

    public static DayTimeDurationValue fromMilliseconds(long l2) {
        int n2 = Long.signum(l2);
        if (n2 < 0) {
            l2 = -l2;
        }
        try {
            return new DayTimeDurationValue(n2, 0, 0, 0, l2 / 1000L, (int)(l2 % 1000L) * 1000);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ValidationFailure("Duration exceeds limits").makeException();
        }
    }

    public static DayTimeDurationValue fromMicroseconds(long l2) {
        int n2 = Long.signum(l2);
        if (n2 < 0) {
            l2 = -l2;
        }
        return new DayTimeDurationValue(n2, 0, 0, 0, l2 / 1000000L, (int)(l2 % 1000000L));
    }

    public static DayTimeDurationValue fromNanoseconds(long l2) {
        return new DayTimeDurationValue(0, 0, 0, l2 / 1000000000L, (int)(l2 % 1000000000L));
    }

    public static DayTimeDurationValue fromJavaDuration(Duration duration) {
        long l2 = duration.getSeconds();
        int n2 = duration.getNano();
        if (l2 < 0L) {
            return new DayTimeDurationValue(0, 0, 0, l2, n2 + -1000000000);
        }
        return new DayTimeDurationValue(0, 0, 0, l2, n2);
    }

    public final Duration toJavaDuration() {
        if (this.negative) {
            return Duration.ofSeconds(-this.seconds, -this.nanoseconds);
        }
        return Duration.ofSeconds(this.seconds, this.nanoseconds);
    }

    @Override
    public final DurationValue multiply(long l2) {
        if (Math.abs(l2) < Integer.MAX_VALUE && Math.abs(this.seconds) < Integer.MAX_VALUE) {
            return new DayTimeDurationValue(0, 0, 0, this.seconds * l2 * (long)(this.negative ? -1 : 1), (int)((long)this.nanoseconds * l2 * (long)(this.negative ? -1 : 1)));
        }
        return this.a(BigDecimal.valueOf(l2));
    }

    @Override
    public final DayTimeDurationValue multiply(double d2) {
        if (Double.isNaN(d2)) {
            XPathException xPathException = new XPathException("Cannot multiply a duration by NaN");
            xPathException.setErrorCode("FOCA0005");
            throw xPathException;
        }
        if (Double.isInfinite(d2)) {
            XPathException xPathException = new XPathException("Cannot multiply a duration by infinity");
            xPathException.setErrorCode("FODT0002");
            throw xPathException;
        }
        BigDecimal bigDecimal = BigDecimal.valueOf(d2);
        return this.a(bigDecimal);
    }

    private DayTimeDurationValue a(BigDecimal serializable) {
        BigDecimal bigDecimal = this.getTotalSeconds();
        serializable = bigDecimal.multiply((BigDecimal)serializable);
        try {
            return DayTimeDurationValue.fromSeconds((BigDecimal)serializable);
        }
        catch (ArithmeticException | IllegalArgumentException runtimeException) {
            serializable = runtimeException;
            if (runtimeException.getCause() instanceof XPathException) {
                throw (XPathException)((Throwable)serializable).getCause();
            }
            serializable = new XPathException("Overflow when multiplying a duration by a number", (Throwable)serializable);
            ((XPathException)serializable).setErrorCode("FODT0002");
            throw serializable;
        }
    }

    @Override
    public final DurationValue divide(double d2) {
        if (Double.isNaN(d2)) {
            XPathException xPathException = new XPathException("Cannot divide a duration by NaN");
            xPathException.setErrorCode("FOCA0005");
            throw xPathException;
        }
        if (d2 == 0.0) {
            XPathException xPathException = new XPathException("Cannot divide a duration by zero");
            xPathException.setErrorCode("FODT0002");
            throw xPathException;
        }
        BigDecimal bigDecimal = this.getTotalSeconds();
        Serializable serializable = bigDecimal.divide(BigDecimal.valueOf(d2));
        try {
            return DayTimeDurationValue.fromSeconds((BigDecimal)serializable);
        }
        catch (ArithmeticException | IllegalArgumentException runtimeException) {
            serializable = runtimeException;
            if (runtimeException.getCause() instanceof XPathException) {
                throw (XPathException)((Throwable)serializable).getCause();
            }
            serializable = new XPathException("Overflow when dividing a duration by a number", (Throwable)serializable);
            ((XPathException)serializable).setErrorCode("FODT0002");
            throw serializable;
        }
    }

    @Override
    public final BigDecimalValue divide(DurationValue object) {
        if (object instanceof DayTimeDurationValue) {
            BigDecimal bigDecimal = this.getTotalSeconds();
            if (((BigDecimal)(object = ((DurationValue)object).getTotalSeconds())).signum() == 0) {
                object = new XPathException("Divide by zero (durations)");
                ((XPathException)object).setErrorCode("FOAR0001");
                throw object;
            }
            return new BigDecimalValue(bigDecimal.divide((BigDecimal)object, 20, RoundingMode.HALF_EVEN));
        }
        XPathException xPathException = new XPathException("Cannot divide two durations of different type");
        xPathException.setErrorCode("XPTY0004");
        throw xPathException;
    }

    @Override
    public final DurationValue add(DurationValue object) {
        if (object instanceof DayTimeDurationValue) {
            Comparable<DayTimeDurationValue> comparable = (DayTimeDurationValue)object;
            if (((this.seconds | ((DurationValue)((Object)comparable)).seconds) & 0xFFFFFFFF00000000L) != 0L) {
                try {
                    comparable = this.getTotalSeconds();
                    object = ((DurationValue)object).getTotalSeconds();
                    return DayTimeDurationValue.fromSeconds(((BigDecimal)comparable).add((BigDecimal)object));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    object = new XPathException("Overflow when adding two durations");
                    ((XPathException)object).setErrorCode("FODT0002");
                    throw object;
                }
            }
            return DayTimeDurationValue.fromNanoseconds(this.getLengthInNanoseconds() + ((DayTimeDurationValue)comparable).getLengthInNanoseconds());
        }
        XPathException xPathException = new XPathException("Cannot add two durations of different type");
        xPathException.setErrorCode("XPTY0004");
        throw xPathException;
    }

    @Override
    public final DurationValue subtract(DurationValue object) {
        if (object instanceof DayTimeDurationValue) {
            Comparable<DayTimeDurationValue> comparable = (DayTimeDurationValue)object;
            if (((this.seconds | ((DurationValue)((Object)comparable)).seconds) & 0xFFFFFFFF00000000L) != 0L) {
                try {
                    comparable = this.getTotalSeconds();
                    object = ((DurationValue)object).getTotalSeconds();
                    return DayTimeDurationValue.fromSeconds(((BigDecimal)comparable).subtract((BigDecimal)object));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    object = new XPathException("Overflow when subtracting two durations");
                    ((XPathException)object).setErrorCode("FODT0002");
                    throw object;
                }
            }
            return DayTimeDurationValue.fromNanoseconds(this.getLengthInNanoseconds() - ((DayTimeDurationValue)comparable).getLengthInNanoseconds());
        }
        XPathException xPathException = new XPathException("Cannot subtract two durations of different type");
        xPathException.setErrorCode("XPTY0004");
        throw xPathException;
    }

    @Override
    public final DurationValue negate() {
        DayTimeDurationValue dayTimeDurationValue = new DayTimeDurationValue();
        dayTimeDurationValue.setTypeLabel(this.typeLabel);
        dayTimeDurationValue.seconds = this.seconds;
        dayTimeDurationValue.nanoseconds = this.nanoseconds;
        dayTimeDurationValue.negative = !this.negative;
        return dayTimeDurationValue;
    }

    @Override
    public final int compareTo(DayTimeDurationValue dayTimeDurationValue) {
        if (dayTimeDurationValue instanceof DayTimeDurationValue) {
            if (this.negative != dayTimeDurationValue.negative) {
                if (this.negative) {
                    return -1;
                }
                return 1;
            }
            if (this.seconds != dayTimeDurationValue.seconds) {
                return Long.compare(this.seconds, dayTimeDurationValue.seconds) * (this.negative ? -1 : 1);
            }
            return Integer.compare(this.nanoseconds, dayTimeDurationValue.nanoseconds) * (this.negative ? -1 : 1);
        }
        throw new ClassCastException("Cannot compare a dayTimeDuration to an object of class " + dayTimeDurationValue.getClass());
    }

    @Override
    public final AtomicMatchKey getXPathComparable(boolean bl2, StringCollator stringCollator, int n2) {
        return this;
    }
}

