/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.math.RoundingMode;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.AtomicSortComparer;
import net.sf.saxon.expr.sort.DoubleSortComparer;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.FloatingPointConverter;
import net.sf.saxon.value.NumericValue;

public final class DoubleValue
extends NumericValue {
    public static final DoubleValue ZERO = new DoubleValue(0.0);
    public static final DoubleValue NEGATIVE_ZERO = new DoubleValue(-0.0);
    public static final DoubleValue ONE = new DoubleValue(1.0);
    public static final DoubleValue NaN = new DoubleValue(Double.NaN);
    private double a;

    public DoubleValue(double d2) {
        this.a = d2;
        this.typeLabel = BuiltInAtomicType.DOUBLE;
    }

    public DoubleValue(double d2, AtomicType atomicType) {
        this.a = d2;
        this.typeLabel = atomicType;
    }

    public static DoubleValue makeDoubleValue(double d2) {
        return new DoubleValue(d2);
    }

    @Override
    public final AtomicValue copyAsSubType(AtomicType atomicType) {
        DoubleValue doubleValue = new DoubleValue(this.a);
        new DoubleValue(this.a).typeLabel = atomicType;
        return doubleValue;
    }

    @Override
    public final BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.DOUBLE;
    }

    @Override
    public final double getDoubleValue() {
        return this.a;
    }

    @Override
    public final float getFloatValue() {
        return (float)this.a;
    }

    @Override
    public final BigDecimal getDecimalValue() {
        try {
            return new BigDecimal(this.a);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ValidationException(numberFormatException);
        }
    }

    @Override
    public final long longValue() {
        return (long)this.a;
    }

    @Override
    public final int hashCode() {
        if (this.a > -2.147483648E9 && this.a < 2.147483647E9) {
            return (int)this.a;
        }
        return Double.valueOf(this.a).hashCode();
    }

    @Override
    public final boolean isNaN() {
        return Double.isNaN(this.a);
    }

    @Override
    public final boolean effectiveBooleanValue() {
        return this.a != 0.0 && !Double.isNaN(this.a);
    }

    @Override
    public final CharSequence getPrimitiveStringValue() {
        return DoubleValue.doubleToString(this.a);
    }

    @Override
    public final CharSequence getCanonicalLexicalRepresentation() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(16);
        return FloatingPointConverter.appendDouble(fastStringBuffer, this.a, true);
    }

    public static CharSequence doubleToString(double d2) {
        return FloatingPointConverter.appendDouble(new FastStringBuffer(16), d2, false);
    }

    @Override
    public final NumericValue negate() {
        return new DoubleValue(-this.a);
    }

    @Override
    public final NumericValue floor() {
        return new DoubleValue(Math.floor(this.a));
    }

    @Override
    public final NumericValue ceiling() {
        return new DoubleValue(Math.ceil(this.a));
    }

    @Override
    public final NumericValue round(int n2) {
        double d2;
        if (Double.isNaN(this.a)) {
            return this;
        }
        if (Double.isInfinite(this.a)) {
            return this;
        }
        if (this.a == 0.0) {
            return this;
        }
        if (n2 == 0 && this.a > -9.223372036854776E18 && this.a < 9.223372036854776E18) {
            if (this.a >= -0.5 && this.a < 0.0) {
                return new DoubleValue(-0.0);
            }
            return new DoubleValue(Math.round(this.a));
        }
        double d3 = Math.pow(10.0, n2 + 1);
        double d4 = Math.abs(this.a * d3);
        if (Double.isInfinite(d4)) {
            BigDecimal bigDecimal = new BigDecimal(this.a);
            bigDecimal = bigDecimal.setScale(n2, RoundingMode.HALF_UP);
            return new DoubleValue(bigDecimal.doubleValue());
        }
        double d5 = d4 % 10.0;
        if (d2 >= 5.0) {
            d4 += 10.0 - d5;
        } else if (d5 < 5.0) {
            d4 -= d5;
        }
        d4 /= d3;
        if (this.a < 0.0) {
            d4 = -d4;
        }
        return new DoubleValue(d4);
    }

    @Override
    public final NumericValue roundHalfToEven(int n2) {
        double d2;
        if (Double.isNaN(this.a)) {
            return this;
        }
        if (Double.isInfinite(this.a)) {
            return this;
        }
        if (this.a == 0.0) {
            return this;
        }
        double d3 = Math.pow(10.0, n2 + 1);
        double d4 = Math.abs(this.a * d3);
        if (Double.isInfinite(d4)) {
            BigDecimal bigDecimal = new BigDecimal(this.a);
            bigDecimal = bigDecimal.setScale(n2, RoundingMode.HALF_EVEN);
            return new DoubleValue(bigDecimal.doubleValue());
        }
        double d5 = d4 % 10.0;
        d4 = d2 > 5.0 ? (d4 += 10.0 - d5) : (d5 < 5.0 ? (d4 -= d5) : (d4 % 20.0 == 15.0 ? (d4 += 5.0) : (d4 -= 5.0)));
        d4 /= d3;
        if (this.a < 0.0) {
            d4 = -d4;
        }
        return new DoubleValue(d4);
    }

    @Override
    public final int signum() {
        if (Double.isNaN(this.a)) {
            return 0;
        }
        if (this.a > 0.0) {
            return 1;
        }
        if (this.a == 0.0) {
            return 0;
        }
        return -1;
    }

    @Override
    public final boolean isNegativeZero() {
        return this.a == 0.0 && (Double.doubleToLongBits(this.a) & Long.MIN_VALUE) != 0L;
    }

    @Override
    public final boolean isWholeNumber() {
        return this.a == Math.floor(this.a) && !Double.isInfinite(this.a);
    }

    @Override
    public final int asSubscript() {
        if (((NumericValue)this).isWholeNumber() && this.a > 0.0 && this.a <= 2.147483647E9) {
            return (int)this.a;
        }
        return -1;
    }

    @Override
    public final NumericValue abs() {
        if (this.a > 0.0) {
            return this;
        }
        return new DoubleValue(Math.abs(this.a));
    }

    @Override
    public final int compareTo(long l2) {
        double d2 = l2;
        if (this.a == d2) {
            return 0;
        }
        if (this.a < d2) {
            return -1;
        }
        return 1;
    }

    @Override
    public final Comparable getSchemaComparable() {
        return Double.valueOf(this.a == 0.0 ? 0.0 : this.a);
    }

    @Override
    public final AtomicMatchKey asMapKey() {
        if (((AtomicValue)this).isNaN()) {
            return AtomicSortComparer.COLLATION_KEY_NaN;
        }
        if (Double.isInfinite(this.a)) {
            return this;
        }
        try {
            return new BigDecimalValue(this.a);
        }
        catch (ValidationException validationException) {
            throw new AssertionError((Object)validationException);
        }
    }

    @Override
    public final boolean isIdentical(AtomicValue atomicValue) {
        return atomicValue instanceof DoubleValue && DoubleSortComparer.getInstance().comparesEqual(this, atomicValue);
    }
}

