/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.StringTokenizer;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.functions.AccessorFn;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.Whitespace;

public class DurationValue
extends AtomicValue
implements AtomicMatchKey {
    protected boolean negative = false;
    protected int months = 0;
    protected long seconds = 0L;
    protected int nanoseconds = 0;

    protected DurationValue() {
    }

    public DurationValue(boolean bl2, int n2, int n3, int n4, int n5, int n6, long l2, int n7) {
        this(bl2, n2, n3, n4, n5, n6, l2, n7, BuiltInAtomicType.DURATION);
    }

    public DurationValue(boolean bl2, int n2, int n3, int n4, int n5, int n6, long l2, int n7, AtomicType atomicType) {
        boolean bl3 = this.negative = !bl2;
        if (n2 < 0 || n3 < 0 || n4 < 0 || n5 < 0 || n6 < 0 || l2 < 0L || n7 < 0) {
            throw new IllegalArgumentException("Negative component value");
        }
        if ((double)n2 * 12.0 + (double)n3 > 2.147483647E9) {
            throw new IllegalArgumentException("Duration months limit exceeded");
        }
        if ((double)n4 * 86400.0 + (double)n5 * 3600.0 + (double)n6 * 60.0 + (double)l2 > 9.223372036854776E18) {
            throw new IllegalArgumentException("Duration seconds limit exceeded");
        }
        this.months = n2 * 12 + n3;
        long l3 = (long)n4 * 24L + (long)n5;
        long l4 = l3 * 60L + (long)n6;
        this.seconds = l4 * 60L + l2;
        this.nanoseconds = n7 * 1000;
        this.normalizeZeroDuration();
        this.typeLabel = atomicType;
    }

    public DurationValue(int n2, int n3, int n4, int n5, int n6, long l2, int n7, AtomicType atomicType) {
        boolean bl2;
        boolean bl3 = n2 > 0 || n3 > 0 || n4 > 0 || n5 > 0 || n6 > 0 || l2 > 0L || n7 > 0;
        boolean bl4 = bl2 = n2 < 0 || n3 < 0 || n4 < 0 || n5 < 0 || n6 < 0 || l2 < 0L || n7 < 0;
        if (bl3 && bl2) {
            throw new IllegalArgumentException("Some component values are positive and some negative");
        }
        if (bl2) {
            n2 = -n2;
            n3 = -n3;
            n4 = -n4;
            n5 = -n5;
            n6 = -n6;
            l2 = -l2;
            n7 = -n7;
        }
        if ((double)n2 * 12.0 + (double)n3 > 2.147483647E9) {
            throw new IllegalArgumentException("Duration months limit exceeded");
        }
        if ((double)n4 * 86400.0 + (double)n5 * 3600.0 + (double)n6 * 60.0 + (double)l2 > 9.223372036854776E18) {
            throw new IllegalArgumentException("Duration seconds limit exceeded");
        }
        this.months = n2 * 12 + n3;
        long l3 = (long)n4 * 24L + (long)n5;
        long l4 = l3 * 60L + (long)n6;
        this.seconds = l4 * 60L + l2;
        this.nanoseconds = n7;
        this.negative = bl2;
        this.normalizeZeroDuration();
        this.typeLabel = atomicType;
    }

    protected void normalizeZeroDuration() {
        if (this.months == 0 && this.seconds == 0L && this.nanoseconds == 0) {
            this.negative = false;
        }
    }

    public static ConversionResult makeDuration(CharSequence charSequence) {
        return DurationValue.makeDuration(charSequence, true, true);
    }

    protected static ConversionResult makeDuration(CharSequence charSequence, boolean bl2, boolean bl3) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        boolean bl4 = false;
        StringTokenizer stringTokenizer = new StringTokenizer(Whitespace.trimWhitespace(charSequence).toString(), "-+.PYMDTHS", true);
        int n9 = 0;
        if (!stringTokenizer.hasMoreElements()) {
            return DurationValue.badDuration("empty string", charSequence);
        }
        String string = (String)stringTokenizer.nextElement();
        if ("+".equals(string)) {
            return DurationValue.badDuration("+ sign not allowed in a duration", charSequence);
        }
        if ("-".equals(string)) {
            bl4 = true;
            string = (String)stringTokenizer.nextElement();
        }
        if (!"P".equals(string)) {
            return DurationValue.badDuration("missing 'P'", charSequence);
        }
        int n10 = 0;
        block10: while (stringTokenizer.hasMoreElements()) {
            int n11;
            string = (String)stringTokenizer.nextElement();
            if ("T".equals(string)) {
                n10 = 4;
                if (!stringTokenizer.hasMoreElements()) {
                    return DurationValue.badDuration("T must be followed by time components", charSequence);
                }
                string = (String)stringTokenizer.nextElement();
            }
            if ((n11 = DurationValue.simpleInteger(string)) < 0) {
                if (n11 == -2) {
                    return DurationValue.badDuration("component of duration exceeds Saxon limits", charSequence, "FODT0002");
                }
                return DurationValue.badDuration("invalid or non-numeric component", charSequence);
            }
            if (!stringTokenizer.hasMoreElements()) {
                return DurationValue.badDuration("missing unit letter at end", charSequence);
            }
            char c2 = ((String)stringTokenizer.nextElement()).charAt(0);
            switch (c2) {
                case 'Y': {
                    if (n10 > 0) {
                        return DurationValue.badDuration("Y is out of sequence", charSequence);
                    }
                    if (!bl2) {
                        return DurationValue.badDuration("Year component is not allowed in dayTimeDuration", charSequence);
                    }
                    n2 = n11;
                    n10 = 1;
                    ++n9;
                    continue block10;
                }
                case 'M': {
                    if (n10 == 4 || n10 == 5) {
                        if (!bl3) {
                            return DurationValue.badDuration("Minute component is not allowed in yearMonthDuration", charSequence);
                        }
                        n6 = n11;
                        n10 = 6;
                        ++n9;
                        continue block10;
                    }
                    if (n10 == 0 || n10 == 1) {
                        if (!bl2) {
                            return DurationValue.badDuration("Month component is not allowed in dayTimeDuration", charSequence);
                        }
                        n3 = n11;
                        n10 = 2;
                        ++n9;
                        continue block10;
                    }
                    return DurationValue.badDuration("M is out of sequence", charSequence);
                }
                case 'D': {
                    if (n10 > 2) {
                        return DurationValue.badDuration("D is out of sequence", charSequence);
                    }
                    if (!bl3) {
                        return DurationValue.badDuration("Day component is not allowed in yearMonthDuration", charSequence);
                    }
                    n4 = n11;
                    n10 = 3;
                    ++n9;
                    continue block10;
                }
                case 'H': {
                    if (n10 != 4) {
                        return DurationValue.badDuration("H is out of sequence", charSequence);
                    }
                    if (!bl3) {
                        return DurationValue.badDuration("Hour component is not allowed in yearMonthDuration", charSequence);
                    }
                    n5 = n11;
                    n10 = 5;
                    ++n9;
                    continue block10;
                }
                case '.': {
                    if (n10 < 4 || n10 > 6) {
                        return DurationValue.badDuration("misplaced decimal point", charSequence);
                    }
                    n7 = n11;
                    n10 = 7;
                    continue block10;
                }
                case 'S': {
                    if (n10 < 4 || n10 > 7) {
                        return DurationValue.badDuration("S is out of sequence", charSequence);
                    }
                    if (!bl3) {
                        return DurationValue.badDuration("Seconds component is not allowed in yearMonthDuration", charSequence);
                    }
                    if (n10 == 7) {
                        StringBuilder stringBuilder = new StringBuilder(string);
                        while (stringBuilder.length() < 9) {
                            stringBuilder.append("0");
                        }
                        string = stringBuilder.toString();
                        if (string.length() > 9) {
                            string = string.substring(0, 9);
                        }
                        if ((n11 = DurationValue.simpleInteger(string)) < 0) {
                            return DurationValue.badDuration("non-numeric fractional seconds", charSequence);
                        }
                        n8 = n11;
                    } else {
                        n7 = n11;
                    }
                    n10 = 8;
                    ++n9;
                    continue block10;
                }
            }
            return DurationValue.badDuration("misplaced " + c2, charSequence);
        }
        if (n9 == 0) {
            return DurationValue.badDuration("Duration specifies no components", charSequence);
        }
        if (bl4) {
            n2 = -n2;
            n3 = -n3;
            n4 = -n4;
            n5 = -n5;
            n6 = -n6;
            n7 = -n7;
            n8 = -n8;
        }
        try {
            return new DurationValue(n2, n3, n4, n5, n6, (long)n7, n8, BuiltInAtomicType.DURATION);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new ValidationFailure(illegalArgumentException.getMessage());
        }
    }

    protected static ValidationFailure badDuration(String object, CharSequence charSequence) {
        object = new ValidationFailure("Invalid duration value '" + charSequence + "' (" + (String)object + ')');
        ((ValidationFailure)object).setErrorCode("FORG0001");
        return object;
    }

    protected static ValidationFailure badDuration(String object, CharSequence charSequence, String string) {
        object = new ValidationFailure("Invalid duration value '" + charSequence + "' (" + (String)object + ')');
        ((ValidationFailure)object).setErrorCode(string);
        return object;
    }

    protected static int simpleInteger(String string) {
        long l2 = 0L;
        int n2 = string.length();
        if (n2 == 0) {
            return -1;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= '0' && c2 <= '9') {
                if ((l2 = l2 * 10L + (long)(c2 - 48)) <= Integer.MAX_VALUE) continue;
                return -2;
            }
            return -1;
        }
        return (int)l2;
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType atomicType) {
        if (this.negative) {
            return new DurationValue(0, -this.months, 0, 0, 0, -this.seconds, -this.nanoseconds, atomicType);
        }
        return new DurationValue(0, this.months, 0, 0, 0, this.seconds, this.nanoseconds, atomicType);
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.DURATION;
    }

    public int signum() {
        if (this.negative) {
            return -1;
        }
        if (this.months == 0 && this.seconds == 0L && this.nanoseconds == 0) {
            return 0;
        }
        return 1;
    }

    public int getYears() {
        return this.months / 12;
    }

    public int getMonths() {
        return this.months % 12;
    }

    public int getDays() {
        return (int)(this.seconds / 86400L);
    }

    public int getHours() {
        return (int)(this.seconds % 86400L / 3600L);
    }

    public int getMinutes() {
        return (int)(this.seconds % 3600L / 60L);
    }

    public int getSeconds() {
        return (int)(this.seconds % 60L);
    }

    public int getMicroseconds() {
        return this.nanoseconds / 1000;
    }

    public int getNanoseconds() {
        return this.nanoseconds;
    }

    public int getTotalMonths() {
        if (this.negative) {
            return -this.months;
        }
        return this.months;
    }

    public BigDecimal getTotalSeconds() {
        BigDecimal bigDecimal = new BigDecimal(this.negative ? -this.seconds : this.seconds);
        if (this.nanoseconds != 0) {
            bigDecimal = bigDecimal.add(new BigDecimal(BigInteger.valueOf(this.negative ? (long)(-this.nanoseconds) : (long)this.nanoseconds), 9));
        }
        return bigDecimal;
    }

    @Override
    public CharSequence getPrimitiveStringValue() {
        if (this.months == 0 && this.seconds == 0L && this.nanoseconds == 0) {
            return "PT0S";
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer(32);
        if (this.negative) {
            fastStringBuffer.append('-');
        }
        int n2 = this.getYears();
        int n3 = this.getMonths();
        int n4 = this.getDays();
        int n5 = this.getHours();
        int n6 = this.getMinutes();
        int n7 = this.getSeconds();
        fastStringBuffer.append("P");
        if (n2 != 0) {
            fastStringBuffer.append(n2 + "Y");
        }
        if (n3 != 0) {
            fastStringBuffer.append(n3 + "M");
        }
        if (n4 != 0) {
            fastStringBuffer.append(n4 + "D");
        }
        if (n5 != 0 || n6 != 0 || n7 != 0 || this.nanoseconds != 0) {
            fastStringBuffer.append("T");
        }
        if (n5 != 0) {
            fastStringBuffer.append(n5 + "H");
        }
        if (n6 != 0) {
            fastStringBuffer.append(n6 + "M");
        }
        if (n7 != 0 || this.nanoseconds != 0) {
            if (n7 != 0 && this.nanoseconds == 0) {
                fastStringBuffer.append(n7 + "S");
            } else {
                long l2 = (long)n7 * 1000000000L + (long)this.nanoseconds;
                String string = "" + l2;
                if (n7 == 0) {
                    string = "0000000000" + string;
                    string = string.substring(string.length() - 10);
                }
                fastStringBuffer.append(string.substring(0, string.length() - 9));
                fastStringBuffer.append('.');
                n3 = string.length() - 1;
                while (string.charAt(n3) == '0') {
                    --n3;
                }
                String string2 = string;
                fastStringBuffer.append(string2.substring(string2.length() - 9, n3 + 1));
                fastStringBuffer.append('S');
            }
        }
        return fastStringBuffer;
    }

    public double getLengthInSeconds() {
        double d2 = (double)this.months * 30.43684991666667 * 24.0 * 60.0 * 60.0 + (double)this.seconds + (double)this.nanoseconds / 1.0E9;
        if (this.negative) {
            return -d2;
        }
        return d2;
    }

    @Override
    public AtomicValue getComponent(AccessorFn.Component object) {
        switch (1.a[((Enum)object).ordinal()]) {
            case 1: {
                return Int64Value.makeIntegerValue(this.negative ? (long)(-this.getYears()) : (long)this.getYears());
            }
            case 2: {
                return Int64Value.makeIntegerValue(this.negative ? (long)(-this.getMonths()) : (long)this.getMonths());
            }
            case 3: {
                return Int64Value.makeIntegerValue(this.negative ? (long)(-this.getDays()) : (long)this.getDays());
            }
            case 4: {
                return Int64Value.makeIntegerValue(this.negative ? (long)(-this.getHours()) : (long)this.getHours());
            }
            case 5: {
                return Int64Value.makeIntegerValue(this.negative ? (long)(-this.getMinutes()) : (long)this.getMinutes());
            }
            case 6: {
                object = new FastStringBuffer(16);
                String string = "000000000" + this.nanoseconds;
                string = string.substring(string.length() - 9);
                ((FastStringBuffer)object).append((this.negative ? "-" : "") + this.getSeconds() + '.' + string);
                return BigDecimalValue.parse((CharSequence)object);
            }
            case 7: {
                return Int64Value.makeIntegerValue(this.negative ? -this.seconds : this.seconds);
            }
            case 8: {
                return new Int64Value((this.negative ? -this.nanoseconds : this.nanoseconds) / 1000);
            }
            case 9: {
                return new Int64Value(this.negative ? (long)(-this.nanoseconds) : (long)this.nanoseconds);
            }
        }
        throw new IllegalArgumentException("Unknown component for duration: " + object);
    }

    @Override
    public AtomicMatchKey getXPathComparable(boolean bl2, StringCollator stringCollator, int n2) {
        if (bl2) {
            return null;
        }
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof DurationValue) {
            DurationValue durationValue = this;
            object = (DurationValue)object;
            return durationValue.negative == ((DurationValue)object).negative && durationValue.months == ((DurationValue)object).months && durationValue.seconds == ((DurationValue)object).seconds && durationValue.nanoseconds == ((DurationValue)object).nanoseconds;
        }
        return false;
    }

    public int hashCode() {
        return Double.valueOf(this.getLengthInSeconds()).hashCode();
    }

    public DurationValue add(DurationValue object) {
        object = new XPathException("Only subtypes of xs:duration can be added");
        ((XPathException)object).setErrorCode("XPTY0004");
        ((XPathException)object).setIsTypeError(true);
        throw object;
    }

    public DurationValue subtract(DurationValue object) {
        object = new XPathException("Only subtypes of xs:duration can be subtracted");
        ((XPathException)object).setErrorCode("XPTY0004");
        ((XPathException)object).setIsTypeError(true);
        throw object;
    }

    public DurationValue negate() {
        if (this.negative) {
            return new DurationValue(0, this.months, 0, 0, 0, this.seconds, this.nanoseconds, this.typeLabel);
        }
        return new DurationValue(0, -this.months, 0, 0, 0, -this.seconds, -this.nanoseconds, this.typeLabel);
    }

    public DurationValue multiply(long l2) {
        return this.multiply((double)l2);
    }

    public DurationValue multiply(double d2) {
        XPathException xPathException = new XPathException("Only subtypes of xs:duration can be multiplied by a number");
        xPathException.setErrorCode("XPTY0004");
        xPathException.setIsTypeError(true);
        throw xPathException;
    }

    public DurationValue divide(double d2) {
        XPathException xPathException = new XPathException("Only subtypes of xs:duration can be divided by a number");
        xPathException.setErrorCode("XPTY0004");
        xPathException.setIsTypeError(true);
        throw xPathException;
    }

    public BigDecimalValue divide(DurationValue object) {
        object = new XPathException("Only subtypes of xs:duration can be divided by another duration");
        ((XPathException)object).setErrorCode("XPTY0004");
        ((XPathException)object).setIsTypeError(true);
        throw object;
    }

    @Override
    public Comparable getSchemaComparable() {
        return DurationValue.getSchemaComparable(this);
    }

    public static Comparable getSchemaComparable(DurationValue durationValue) {
        int n2 = durationValue.months;
        long l2 = durationValue.seconds;
        int n3 = durationValue.nanoseconds;
        if (durationValue.negative) {
            l2 = -l2;
            n2 = -n2;
            n3 = -n3;
        }
        return new a(n2, l2, n3);
    }

    private static final class a
    implements Comparable<a> {
        private int a;
        private long b;
        private int c;

        public a(int n2, long l2, int n3) {
            this.a = n2;
            this.b = l2;
            this.c = n3;
        }

        private int a(a a2) {
            if (this.a == a2.a) {
                if (this.b == a2.b) {
                    return Integer.compare(this.c, a2.c);
                }
                return Long.compare(this.b, a2.b);
            }
            a a3 = this;
            double d2 = (double)a3.a(a3.a) * 86400.0 + (double)this.b;
            a a4 = this;
            double d3 = (double)a4.b(a4.a) * 86400.0 + (double)this.b;
            double d4 = (double)this.a(a2.a) * 86400.0 + (double)a2.b;
            double d5 = (double)this.b(a2.a) * 86400.0 + (double)a2.b;
            if (d3 < d4) {
                return -1;
            }
            if (d2 > d5) {
                return 1;
            }
            return Integer.MIN_VALUE;
        }

        public final boolean equals(Object object) {
            return object instanceof a && this.a((a)object) == 0;
        }

        public final int hashCode() {
            return this.a ^ (int)this.b;
        }

        private int a(int n2) {
            if (n2 < 0) {
                return -this.b(-n2);
            }
            if (n2 < 12) {
                int[] nArray = new int[]{0, 28, 59, 89, 120, 150, 181, 212, 242, 273, 303, 334};
                return nArray[n2];
            }
            int n3 = n2 / 12;
            n3 = n3 * 365 + n3 % 4 - n3 % 100 + n3 % 400 - 1;
            return n3 + this.a(n2 %= 12);
        }

        private int b(int n2) {
            if (n2 < 0) {
                return -this.a(-n2);
            }
            if (n2 < 12) {
                int[] nArray = new int[]{0, 31, 62, 92, 123, 153, 184, 215, 245, 276, 306, 337};
                return nArray[n2];
            }
            int n3 = n2 / 12;
            n3 = n3 * 365 + n3 % 4 - n3 % 100 + n3 % 400 + 1;
            return n3 + this.b(n2 %= 12);
        }

        @Override
        public final /* synthetic */ int compareTo(Object object) {
            return this.a((a)object);
        }
    }
}

