/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.AtomicSortComparer;
import net.sf.saxon.expr.sort.DoubleSortComparer;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatingPointConverter;
import net.sf.saxon.value.NumericValue;

public final class FloatValue
extends NumericValue {
    public static final FloatValue ZERO = new FloatValue(0.0f);
    public static final FloatValue NEGATIVE_ZERO = new FloatValue(-0.0f);
    public static final FloatValue ONE = new FloatValue(1.0f);
    public static final FloatValue NaN = new FloatValue(Float.NaN);
    private float a;

    public FloatValue(float f2) {
        this.a = f2;
        this.typeLabel = BuiltInAtomicType.FLOAT;
    }

    public static FloatValue makeFloatValue(float f2) {
        return new FloatValue(f2);
    }

    public FloatValue(float f2, AtomicType atomicType) {
        this.a = f2;
        this.typeLabel = atomicType;
    }

    @Override
    public final AtomicValue copyAsSubType(AtomicType atomicType) {
        FloatValue floatValue = new FloatValue(this.a);
        new FloatValue(this.a).typeLabel = atomicType;
        return floatValue;
    }

    @Override
    public final BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.FLOAT;
    }

    @Override
    public final float getFloatValue() {
        return this.a;
    }

    @Override
    public final double getDoubleValue() {
        return this.a;
    }

    @Override
    public final BigDecimal getDecimalValue() {
        return new BigDecimal(this.a);
    }

    @Override
    public final long longValue() {
        return (long)this.a;
    }

    @Override
    public final int hashCode() {
        if (this.a > -2.1474836E9f && this.a < 2.1474836E9f) {
            return (int)this.a;
        }
        return Double.valueOf(((NumericValue)this).getDoubleValue()).hashCode();
    }

    @Override
    public final boolean isNaN() {
        return Float.isNaN(this.a);
    }

    @Override
    public final boolean effectiveBooleanValue() {
        return (double)this.a != 0.0 && !Float.isNaN(this.a);
    }

    @Override
    public final CharSequence getPrimitiveStringValue() {
        return FloatValue.floatToString(this.a);
    }

    @Override
    public final CharSequence getCanonicalLexicalRepresentation() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(16);
        return FloatingPointConverter.appendFloat(fastStringBuffer, this.a, true);
    }

    public static CharSequence floatToString(float f2) {
        return FloatingPointConverter.appendFloat(new FastStringBuffer(16), f2, false);
    }

    @Override
    public final NumericValue negate() {
        return new FloatValue(-this.a);
    }

    @Override
    public final NumericValue floor() {
        return new FloatValue((float)Math.floor(this.a));
    }

    @Override
    public final NumericValue ceiling() {
        return new FloatValue((float)Math.ceil(this.a));
    }

    @Override
    public final NumericValue round(int n2) {
        if (Float.isNaN(this.a)) {
            return this;
        }
        if (Float.isInfinite(this.a)) {
            return this;
        }
        if ((double)this.a == 0.0) {
            return this;
        }
        if (n2 == 0 && this.a > -2.1474836E9f && this.a < 2.1474836E9f) {
            if ((double)this.a >= -0.5 && (double)this.a < 0.0) {
                return new FloatValue(-0.0f);
            }
            return new FloatValue(Math.round(this.a));
        }
        DoubleValue doubleValue = new DoubleValue(((NumericValue)this).getDoubleValue());
        doubleValue = (DoubleValue)((NumericValue)doubleValue).round(n2);
        return new FloatValue(((NumericValue)doubleValue).getFloatValue());
    }

    @Override
    public final NumericValue roundHalfToEven(int n2) {
        DoubleValue doubleValue = new DoubleValue(((NumericValue)this).getDoubleValue());
        doubleValue = (DoubleValue)((NumericValue)doubleValue).roundHalfToEven(n2);
        return new FloatValue(((NumericValue)doubleValue).getFloatValue());
    }

    @Override
    public final int signum() {
        if (Float.isNaN(this.a)) {
            return 0;
        }
        return ((NumericValue)this).compareTo(0L);
    }

    @Override
    public final boolean isNegativeZero() {
        return (double)this.a == 0.0 && (Float.floatToIntBits(this.a) & Integer.MIN_VALUE) != 0;
    }

    @Override
    public final boolean isWholeNumber() {
        return (double)this.a == Math.floor(this.a) && !Float.isInfinite(this.a);
    }

    @Override
    public final int asSubscript() {
        if (((NumericValue)this).isWholeNumber() && this.a > 0.0f && this.a <= 2.1474836E9f) {
            return (int)this.a;
        }
        return -1;
    }

    @Override
    public final NumericValue abs() {
        if ((double)this.a > 0.0) {
            return this;
        }
        return new FloatValue(Math.abs(this.a));
    }

    @Override
    public final int compareTo(NumericValue numericValue) {
        while (true) {
            if (numericValue instanceof FloatValue) {
                float f2 = ((FloatValue)numericValue).a;
                if (this.a == f2) {
                    return 0;
                }
                if (this.a < f2) {
                    return -1;
                }
                return 1;
            }
            if (numericValue instanceof DoubleValue) {
                return super.compareTo(numericValue);
            }
            numericValue = Converter.NumericToFloat.INSTANCE.convert(numericValue);
        }
    }

    @Override
    public final int compareTo(long l2) {
        float f2 = l2;
        if (this.a == f2) {
            return 0;
        }
        if (this.a < f2) {
            return -1;
        }
        return 1;
    }

    @Override
    public final Comparable getSchemaComparable() {
        return Float.valueOf(this.a == 0.0f ? 0.0f : this.a);
    }

    @Override
    public final AtomicMatchKey asMapKey() {
        if (((AtomicValue)this).isNaN()) {
            return AtomicSortComparer.COLLATION_KEY_NaN;
        }
        if (Double.isInfinite(this.a)) {
            return new DoubleValue(this.a);
        }
        try {
            return new BigDecimalValue(this.a);
        }
        catch (ValidationException validationException) {
            throw new AssertionError((Object)validationException);
        }
    }

    @Override
    public final boolean isIdentical(AtomicValue atomicValue) {
        return atomicValue instanceof FloatValue && DoubleSortComparer.getInstance().comparesEqual(this, (FloatValue)atomicValue);
    }

    @Override
    public final FloatValue asAtomic() {
        return this;
    }
}

