/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.TimeZone;
import net.sf.saxon.functions.AccessorFn;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.Whitespace;

public abstract class GDateValue
extends CalendarValue {
    protected int year;
    protected byte month;
    protected byte day;
    protected boolean hasNoYearZero;
    protected static byte[] daysPerMonth = new byte[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    protected static final short[] monthData = new short[]{306, 337, 0, 31, 61, 92, 122, 153, 184, 214, 245, 275};

    public int getYear() {
        return this.year;
    }

    public byte getMonth() {
        return this.month;
    }

    public byte getDay() {
        return this.day;
    }

    @Override
    public GregorianCalendar getCalendar() {
        int n2 = this.hasTimezone() ? this.getTimezoneInMinutes() * 60000 : 0;
        Cloneable cloneable = new SimpleTimeZone(n2, "LLL");
        cloneable = new GregorianCalendar((TimeZone)cloneable);
        ((GregorianCalendar)cloneable).setGregorianChange(new Date(Long.MIN_VALUE));
        if (n2 < ((GregorianCalendar)cloneable).getMinimum(15) || n2 > ((GregorianCalendar)cloneable).getMaximum(15)) {
            return this.adjustTimezone(0).getCalendar();
        }
        ((Calendar)cloneable).clear();
        ((Calendar)cloneable).setLenient(false);
        int n3 = this.year;
        if (this.year <= 0) {
            n3 = this.hasNoYearZero ? 1 - this.year : 0 - this.year;
            ((Calendar)cloneable).set(0, 0);
        }
        ((Calendar)cloneable).set(n3, this.month - 1, this.day);
        ((Calendar)cloneable).set(15, n2);
        ((Calendar)cloneable).set(16, 0);
        ((Calendar)cloneable).getTime();
        return cloneable;
    }

    protected static ConversionResult setLexicalValue(GDateValue object, CharSequence charSequence, boolean n2) {
        ((GDateValue)object).hasNoYearZero = n2 == 0;
        Object object2 = new StringTokenizer(Whitespace.trimWhitespace(charSequence).toString(), "-:+TZ", true);
        try {
            if (!((StringTokenizer)object2).hasMoreElements()) {
                return GDateValue.a("Too short", charSequence);
            }
            String string = (String)((StringTokenizer)object2).nextElement();
            int n3 = 1;
            if ("+".equals(string)) {
                return GDateValue.a("Date must not start with '+' sign", charSequence);
            }
            if ("-".equals(string)) {
                n3 = -1;
                if (!((StringTokenizer)object2).hasMoreElements()) {
                    return GDateValue.a("No year after '-'", charSequence);
                }
                string = (String)((StringTokenizer)object2).nextElement();
            }
            if (string.length() < 4) {
                return GDateValue.a("Year is less than four digits", charSequence);
            }
            if (string.length() > 4 && string.charAt(0) == '0') {
                return GDateValue.a("When year exceeds 4 digits, leading zeroes are not allowed", charSequence);
            }
            int n4 = DurationValue.simpleInteger(string);
            if (n4 < 0) {
                if (n4 == -1) {
                    return GDateValue.a("Non-numeric year component", charSequence);
                }
                object2 = "FODT0001";
                CharSequence charSequence2 = charSequence;
                object = "Year is outside the range that Saxon can handle";
                object = new ValidationFailure("Invalid date " + Err.wrap(charSequence2, 4) + " (" + (String)object + ")");
                ((ValidationFailure)object).setErrorCode((String)object2);
                return object;
            }
            ((GDateValue)object).year = n4 * n3;
            if (((GDateValue)object).year == 0 && n2 == 0) {
                return GDateValue.a("Year zero is not allowed", charSequence);
            }
            if (n3 < 0 && n2 == 0) {
                ++((GDateValue)object).year;
            }
            if (!((StringTokenizer)object2).hasMoreElements()) {
                return GDateValue.a("Too short", charSequence);
            }
            if (!"-".equals(((StringTokenizer)object2).nextElement())) {
                return GDateValue.a("Wrong delimiter after year", charSequence);
            }
            if (!((StringTokenizer)object2).hasMoreElements()) {
                return GDateValue.a("Too short", charSequence);
            }
            string = (String)((StringTokenizer)object2).nextElement();
            if (string.length() != 2) {
                return GDateValue.a("Month must be two digits", charSequence);
            }
            n4 = DurationValue.simpleInteger(string);
            if (n4 < 0) {
                return GDateValue.a("Non-numeric month component", charSequence);
            }
            ((GDateValue)object).month = (byte)n4;
            if (((GDateValue)object).month <= 0 || ((GDateValue)object).month > 12) {
                return GDateValue.a("Month is out of range", charSequence);
            }
            if (!((StringTokenizer)object2).hasMoreElements()) {
                return GDateValue.a("Too short", charSequence);
            }
            if (!"-".equals(((StringTokenizer)object2).nextElement())) {
                return GDateValue.a("Wrong delimiter after month", charSequence);
            }
            if (!((StringTokenizer)object2).hasMoreElements()) {
                return GDateValue.a("Too short", charSequence);
            }
            string = (String)((StringTokenizer)object2).nextElement();
            if (string.length() != 2) {
                return GDateValue.a("Day must be two digits", charSequence);
            }
            n4 = DurationValue.simpleInteger(string);
            if (n4 < 0) {
                return GDateValue.a("Non-numeric day component", charSequence);
            }
            ((GDateValue)object).day = (byte)n4;
            if (((GDateValue)object).day <= 0 || ((GDateValue)object).day > 31) {
                return GDateValue.a("Day is out of range", charSequence);
            }
            if (((StringTokenizer)object2).hasMoreElements()) {
                String string2 = (String)((StringTokenizer)object2).nextElement();
                if ("T".equals(string2)) {
                    return GDateValue.a("Value includes time", charSequence);
                }
                if ("Z".equals(string2)) {
                    if (((StringTokenizer)object2).hasMoreElements()) {
                        return GDateValue.a("Continues after 'Z'", charSequence);
                    }
                    ((CalendarValue)object).setTimezoneInMinutes(0);
                } else if ("+".equals(string2) || "-".equals(string2)) {
                    if (!((StringTokenizer)object2).hasMoreElements()) {
                        return GDateValue.a("Missing timezone", charSequence);
                    }
                    string = (String)((StringTokenizer)object2).nextElement();
                    n4 = DurationValue.simpleInteger(string);
                    if (n4 < 0) {
                        return GDateValue.a("Non-numeric timezone hour component", charSequence);
                    }
                    n2 = n4;
                    if (string.length() != 2) {
                        return GDateValue.a("Timezone hour must be two digits", charSequence);
                    }
                    if (n2 > 14) {
                        return GDateValue.a("Timezone hour is out of range", charSequence);
                    }
                    if (!((StringTokenizer)object2).hasMoreElements()) {
                        return GDateValue.a("No minutes in timezone", charSequence);
                    }
                    if (!":".equals(((StringTokenizer)object2).nextElement())) {
                        return GDateValue.a("Wrong delimiter after timezone hour", charSequence);
                    }
                    if (!((StringTokenizer)object2).hasMoreElements()) {
                        return GDateValue.a("No minutes in timezone", charSequence);
                    }
                    string = (String)((StringTokenizer)object2).nextElement();
                    n4 = DurationValue.simpleInteger(string);
                    if (n4 < 0) {
                        return GDateValue.a("Non-numeric timezone minute component", charSequence);
                    }
                    if (string.length() != 2) {
                        return GDateValue.a("Timezone minute must be two digits", charSequence);
                    }
                    if (n4 > 59) {
                        return GDateValue.a("Timezone minute is out of range", charSequence);
                    }
                    if (((StringTokenizer)object2).hasMoreElements()) {
                        return GDateValue.a("Continues after timezone", charSequence);
                    }
                    n2 = n2 * 60 + n4;
                    if ("-".equals(string2)) {
                        n2 = -n2;
                    }
                    ((CalendarValue)object).setTimezoneInMinutes(n2);
                } else {
                    return GDateValue.a("Timezone format is incorrect", charSequence);
                }
            }
            if (!GDateValue.isValidDate(((GDateValue)object).year, ((GDateValue)object).month, ((GDateValue)object).day)) {
                return GDateValue.a("Non-existent date", charSequence);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return GDateValue.a("Non-numeric component", charSequence);
        }
        return object;
    }

    private static ValidationFailure a(String object, CharSequence charSequence) {
        object = new ValidationFailure("Invalid date " + Err.wrap(charSequence, 4) + " (" + (String)object + ")");
        ((ValidationFailure)object).setErrorCode("FORG0001");
        return object;
    }

    public static boolean isValidDate(int n2, int n3, int n4) {
        return n3 > 0 && n3 <= 12 && n4 > 0 && n4 <= daysPerMonth[n3 - 1] || n3 == 2 && n4 == 29 && GDateValue.isLeapYear(n2);
    }

    public static boolean isLeapYear(int n2) {
        return n2 % 4 == 0 && (n2 % 100 != 0 || n2 % 400 == 0);
    }

    @Override
    public void checkValidInJavascript() {
        if (this.year <= 0 || this.year > 9999) {
            throw new XPathException("Year out of range for Saxon-JS", "FODT0001");
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof GDateValue) {
            object = (GDateValue)object;
            return this.getPrimitiveType() == ((AtomicValue)object).getPrimitiveType() && ((AtomicValue)((CalendarValue)this).toDateTime()).equals(((CalendarValue)object).toDateTime());
        }
        return false;
    }

    public int hashCode() {
        return DateTimeValue.a(this.year, this.month, this.day, (byte)12, (byte)0, (byte)0, 0, this.getTimezoneInMinutes());
    }

    @Override
    public int compareTo(CalendarValue calendarValue, int n2) {
        if (this.getPrimitiveType() != calendarValue.getPrimitiveType()) {
            throw new ClassCastException("Cannot compare dates of different types");
        }
        GDateValue gDateValue = (GDateValue)calendarValue;
        if (this.getTimezoneInMinutes() == calendarValue.getTimezoneInMinutes()) {
            if (this.year != gDateValue.year) {
                return IntegerValue.signum(this.year - gDateValue.year);
            }
            if (this.month != gDateValue.month) {
                return IntegerValue.signum(this.month - gDateValue.month);
            }
            if (this.day != gDateValue.day) {
                return IntegerValue.signum(this.day - gDateValue.day);
            }
            return 0;
        }
        return ((CalendarValue)((CalendarValue)this).toDateTime()).compareTo(calendarValue.toDateTime(), n2);
    }

    @Override
    public DateTimeValue toDateTime() {
        return new DateTimeValue(this.year, this.month, this.day, 0, 0, 0, 0, this.getTimezoneInMinutes(), this.hasNoYearZero);
    }

    @Override
    public Comparable getSchemaComparable() {
        return new a(this, 0);
    }

    @Override
    public AtomicValue getComponent(AccessorFn.Component component) {
        switch (component) {
            case YEAR_ALLOWING_ZERO: {
                return Int64Value.makeIntegerValue(this.year);
            }
            case YEAR: {
                return Int64Value.makeIntegerValue(this.year > 0 || !this.hasNoYearZero ? (long)this.year : (long)(this.year - 1));
            }
            case MONTH: {
                return Int64Value.makeIntegerValue(this.month);
            }
            case DAY: {
                return Int64Value.makeIntegerValue(this.day);
            }
            case TIMEZONE: {
                if (this.hasTimezone()) {
                    return DayTimeDurationValue.fromMilliseconds(60000L * (long)this.getTimezoneInMinutes());
                }
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown component for date: " + (Object)((Object)component));
    }

    private final class a
    implements Comparable {
        private /* synthetic */ GDateValue a;

        private a(GDateValue gDateValue) {
            this.a = gDateValue;
        }

        public final int compareTo(Object object) {
            if (object instanceof a) {
                a a2 = this;
                a a3 = a2;
                a3 = (a)object;
                if (a2.a.getPrimitiveType() != a3.a.getPrimitiveType()) {
                    return Integer.MIN_VALUE;
                }
                DateTimeValue dateTimeValue = ((CalendarValue)this.a).toDateTime();
                a3 = (a)object;
                object = ((CalendarValue)a3.a).toDateTime();
                return ((AtomicValue)dateTimeValue).getSchemaComparable().compareTo(((AtomicValue)object).getSchemaComparable());
            }
            return Integer.MIN_VALUE;
        }

        public final boolean equals(Object object) {
            return this.compareTo(object) == 0;
        }

        public final int hashCode() {
            return ((AtomicValue)((CalendarValue)this.a).toDateTime()).getSchemaComparable().hashCode();
        }

        /* synthetic */ a(GDateValue gDateValue, byte by) {
            this(gDateValue);
        }
    }
}

