/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.GDateValue;
import net.sf.saxon.value.Whitespace;

public class GDayValue
extends GDateValue {
    private static Pattern a = Pattern.compile("---([0-9][0-9])(Z|[+-][0-9][0-9]:[0-9][0-9])?");

    private GDayValue() {
    }

    public static ConversionResult makeGDayValue(CharSequence object) {
        Object object2 = a.matcher(Whitespace.trimWhitespace((CharSequence)object));
        if (!((Matcher)object2).matches()) {
            return new ValidationFailure("Cannot convert '" + object + "' to a gDay");
        }
        object = new GDayValue();
        String string = ((Matcher)object2).group(1);
        object2 = ((Matcher)object2).group(2);
        object2 = "2000-01-" + string + (String)(object2 == null ? "" : object2);
        ((AtomicValue)object).typeLabel = BuiltInAtomicType.G_DAY;
        return GDayValue.setLexicalValue((GDateValue)object, (CharSequence)object2, true);
    }

    public GDayValue(byte by, int n2) {
        this(by, n2, BuiltInAtomicType.G_DAY);
    }

    public GDayValue(byte by, int n2, AtomicType atomicType) {
        this.year = 2000;
        this.month = 1;
        this.day = by;
        this.setTimezoneInMinutes(n2);
        this.typeLabel = atomicType;
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType atomicType) {
        GDayValue gDayValue = new GDayValue(this.day, this.getTimezoneInMinutes());
        new GDayValue(this.day, this.getTimezoneInMinutes()).typeLabel = atomicType;
        return gDayValue;
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.G_DAY;
    }

    @Override
    public CharSequence getPrimitiveStringValue() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(16);
        fastStringBuffer.append("---");
        GDayValue.a(fastStringBuffer, this.day);
        if (this.hasTimezone()) {
            this.appendTimezone(fastStringBuffer);
        }
        return fastStringBuffer;
    }

    @Override
    public CalendarValue add(DurationValue object) {
        object = new XPathException("Cannot add a duration to an xs:gDay");
        ((XPathException)object).setErrorCode("XPTY0004");
        throw object;
    }

    @Override
    public CalendarValue adjustTimezone(int n2) {
        DateTimeValue dateTimeValue = ((CalendarValue)this).toDateTime().adjustTimezone(n2);
        return new GDayValue(dateTimeValue.getDay(), dateTimeValue.getTimezoneInMinutes());
    }
}

