/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.GDateValue;
import net.sf.saxon.value.Whitespace;

public class GMonthDayValue
extends GDateValue {
    private static Pattern a = Pattern.compile("--([0-9][0-9]-[0-9][0-9])(Z|[+-][0-9][0-9]:[0-9][0-9])?");

    private GMonthDayValue() {
    }

    public static ConversionResult makeGMonthDayValue(CharSequence object) {
        Object object2 = a.matcher(Whitespace.trimWhitespace((CharSequence)object));
        if (!((Matcher)object2).matches()) {
            return new ValidationFailure("Cannot convert '" + object + "' to a gMonthDay");
        }
        object = new GMonthDayValue();
        String string = ((Matcher)object2).group(1);
        object2 = ((Matcher)object2).group(2);
        object2 = "2000-" + string + (String)(object2 == null ? "" : object2);
        ((AtomicValue)object).typeLabel = BuiltInAtomicType.G_MONTH_DAY;
        return GMonthDayValue.setLexicalValue((GDateValue)object, (CharSequence)object2, true);
    }

    public GMonthDayValue(byte by, byte by2, int n2) {
        this(by, by2, n2, BuiltInAtomicType.G_MONTH_DAY);
    }

    public GMonthDayValue(byte by, byte by2, int n2, AtomicType atomicType) {
        this.year = 2000;
        this.month = by;
        this.day = by2;
        this.setTimezoneInMinutes(n2);
        this.typeLabel = atomicType;
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType atomicType) {
        GMonthDayValue gMonthDayValue = new GMonthDayValue(this.month, this.day, this.getTimezoneInMinutes());
        new GMonthDayValue(this.month, this.day, this.getTimezoneInMinutes()).typeLabel = atomicType;
        return gMonthDayValue;
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.G_MONTH_DAY;
    }

    @Override
    public CharSequence getPrimitiveStringValue() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(16);
        fastStringBuffer.append("--");
        GMonthDayValue.a(fastStringBuffer, this.month);
        fastStringBuffer.append('-');
        GMonthDayValue.a(fastStringBuffer, this.day);
        if (this.hasTimezone()) {
            this.appendTimezone(fastStringBuffer);
        }
        return fastStringBuffer;
    }

    @Override
    public CalendarValue add(DurationValue object) {
        object = new XPathException("Cannot add a duration to an xs:gMonthDay");
        ((XPathException)object).setErrorCode("XPTY0004");
        throw object;
    }

    @Override
    public CalendarValue adjustTimezone(int n2) {
        DateTimeValue dateTimeValue = ((CalendarValue)this).toDateTime().adjustTimezone(n2);
        return new GMonthDayValue(dateTimeValue.getMonth(), dateTimeValue.getDay(), dateTimeValue.getTimezoneInMinutes());
    }
}

