/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.GDateValue;
import net.sf.saxon.value.Whitespace;

public class GMonthValue
extends GDateValue {
    private static Pattern a = Pattern.compile("--([0-9][0-9])(Z|[+-][0-9][0-9]:[0-9][0-9])?");

    private GMonthValue() {
    }

    public static ConversionResult makeGMonthValue(CharSequence charSequence) {
        GMonthValue gMonthValue = new GMonthValue();
        Object object = a.matcher(Whitespace.trimWhitespace(charSequence));
        if (!((Matcher)object).matches()) {
            return new ValidationFailure("Cannot convert '" + charSequence + "' to a gMonth");
        }
        charSequence = ((Matcher)object).group(1);
        object = ((Matcher)object).group(2);
        charSequence = "2000-" + (String)charSequence + "-01" + (String)(object == null ? "" : object);
        gMonthValue.typeLabel = BuiltInAtomicType.G_MONTH;
        return GMonthValue.setLexicalValue(gMonthValue, charSequence, true);
    }

    public GMonthValue(byte by, int n2) {
        this(by, n2, BuiltInAtomicType.G_MONTH);
    }

    public GMonthValue(byte by, int n2, AtomicType atomicType) {
        this.year = 2000;
        this.month = by;
        this.day = 1;
        this.setTimezoneInMinutes(n2);
        this.typeLabel = atomicType;
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType atomicType) {
        GMonthValue gMonthValue = new GMonthValue(this.month, this.getTimezoneInMinutes());
        new GMonthValue(this.month, this.getTimezoneInMinutes()).typeLabel = atomicType;
        return gMonthValue;
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.G_MONTH;
    }

    @Override
    public CharSequence getPrimitiveStringValue() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(16);
        fastStringBuffer.append("--");
        GMonthValue.a(fastStringBuffer, this.month);
        if (this.hasTimezone()) {
            this.appendTimezone(fastStringBuffer);
        }
        return fastStringBuffer;
    }

    @Override
    public CalendarValue add(DurationValue object) {
        object = new XPathException("Cannot add a duration to an xs:gMonth");
        ((XPathException)object).setErrorCode("XPTY0004");
        throw object;
    }

    @Override
    public CalendarValue adjustTimezone(int n2) {
        DateTimeValue dateTimeValue = ((CalendarValue)this).toDateTime().adjustTimezone(n2);
        return new GMonthValue(dateTimeValue.getMonth(), dateTimeValue.getTimezoneInMinutes());
    }
}

