/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.GDateValue;
import net.sf.saxon.value.Whitespace;

public class GYearMonthValue
extends GDateValue {
    private static Pattern a = Pattern.compile("(-?[0-9]+-[0-9][0-9])(Z|[+-][0-9][0-9]:[0-9][0-9])?");

    private GYearMonthValue() {
    }

    public static ConversionResult makeGYearMonthValue(CharSequence object, ConversionRules conversionRules) {
        Object object2 = a.matcher(Whitespace.trimWhitespace((CharSequence)object));
        if (!((Matcher)object2).matches()) {
            return new ValidationFailure("Cannot convert '" + object + "' to a gYearMonth");
        }
        object = new GYearMonthValue();
        String string = ((Matcher)object2).group(1);
        object2 = ((Matcher)object2).group(2);
        object2 = string + "-01" + (String)(object2 == null ? "" : object2);
        ((AtomicValue)object).typeLabel = BuiltInAtomicType.G_YEAR_MONTH;
        return GYearMonthValue.setLexicalValue((GDateValue)object, (CharSequence)object2, conversionRules.isAllowYearZero());
    }

    public GYearMonthValue(int n2, byte by, int n3, boolean bl2) {
        this(n2, by, n3, BuiltInAtomicType.G_YEAR_MONTH);
        this.hasNoYearZero = bl2;
    }

    public GYearMonthValue(int n2, byte by, int n3, AtomicType atomicType) {
        this.year = n2;
        this.month = by;
        this.day = 1;
        this.setTimezoneInMinutes(n3);
        this.typeLabel = atomicType;
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType atomicType) {
        GYearMonthValue gYearMonthValue = new GYearMonthValue(this.year, this.month, this.getTimezoneInMinutes(), this.hasNoYearZero);
        new GYearMonthValue(this.year, this.month, this.getTimezoneInMinutes(), this.hasNoYearZero).typeLabel = atomicType;
        return gYearMonthValue;
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.G_YEAR_MONTH;
    }

    @Override
    public CharSequence getPrimitiveStringValue() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(16);
        int n2 = this.year;
        if (this.year <= 0 && (n2 = -n2 + (this.hasNoYearZero ? 1 : 0)) != 0) {
            fastStringBuffer.append('-');
        }
        int n3 = n2;
        GYearMonthValue.a(fastStringBuffer, n3, n3 > 9999 ? ("" + n2).length() : 4);
        fastStringBuffer.append('-');
        GYearMonthValue.a(fastStringBuffer, this.month);
        if (this.hasTimezone()) {
            this.appendTimezone(fastStringBuffer);
        }
        return fastStringBuffer;
    }

    @Override
    public CalendarValue add(DurationValue object) {
        object = new XPathException("Cannot add a duration to an xs:gYearMonth");
        ((XPathException)object).setErrorCode("XPTY0004");
        throw object;
    }

    @Override
    public CalendarValue adjustTimezone(int n2) {
        DateTimeValue dateTimeValue = ((CalendarValue)this).toDateTime().adjustTimezone(n2);
        return new GYearMonthValue(dateTimeValue.getYear(), dateTimeValue.getMonth(), dateTimeValue.getTimezoneInMinutes(), this.hasNoYearZero);
    }
}

