/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.GDateValue;
import net.sf.saxon.value.Whitespace;

public class GYearValue
extends GDateValue {
    private static Pattern a = Pattern.compile("(-?[0-9]+)(Z|[+-][0-9][0-9]:[0-9][0-9])?");

    private GYearValue() {
    }

    public static ConversionResult makeGYearValue(CharSequence charSequence, ConversionRules conversionRules) {
        GYearValue gYearValue = new GYearValue();
        Object object = a.matcher(Whitespace.trimWhitespace(charSequence));
        if (!((Matcher)object).matches()) {
            return new ValidationFailure("Cannot convert '" + charSequence + "' to a gYear");
        }
        charSequence = ((Matcher)object).group(1);
        object = ((Matcher)object).group(2);
        charSequence = (String)charSequence + "-01-01" + (String)(object == null ? "" : object);
        gYearValue.typeLabel = BuiltInAtomicType.G_YEAR;
        return GYearValue.setLexicalValue(gYearValue, charSequence, conversionRules.isAllowYearZero());
    }

    public GYearValue(int n2, int n3, boolean bl2) {
        this(n2, n3, BuiltInAtomicType.G_YEAR);
        this.hasNoYearZero = bl2;
    }

    public GYearValue(int n2, int n3, AtomicType atomicType) {
        this.year = n2;
        this.month = 1;
        this.day = 1;
        this.setTimezoneInMinutes(n3);
        this.typeLabel = atomicType;
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType atomicType) {
        GYearValue gYearValue = new GYearValue(this.year, this.getTimezoneInMinutes(), true);
        new GYearValue(this.year, this.getTimezoneInMinutes(), true).typeLabel = atomicType;
        return gYearValue;
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.G_YEAR;
    }

    @Override
    public CharSequence getPrimitiveStringValue() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(16);
        int n2 = this.year;
        if (this.year <= 0 && (n2 = -n2 + (this.hasNoYearZero ? 1 : 0)) != 0) {
            fastStringBuffer.append('-');
        }
        int n3 = n2;
        GYearValue.a(fastStringBuffer, n3, n3 > 9999 ? ("" + n2).length() : 4);
        if (this.hasTimezone()) {
            this.appendTimezone(fastStringBuffer);
        }
        return fastStringBuffer;
    }

    @Override
    public CalendarValue add(DurationValue object) {
        object = new XPathException("Cannot add a duration to an xs:gYear");
        ((XPathException)object).setErrorCode("XPTY0004");
        throw object;
    }

    @Override
    public CalendarValue adjustTimezone(int n2) {
        DateTimeValue dateTimeValue = ((CalendarValue)this).toDateTime().adjustTimezone(n2);
        return new GYearValue(dateTimeValue.getYear(), dateTimeValue.getTimezoneInMinutes(), this.hasNoYearZero);
    }
}

