/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.Arrays;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.Whitespace;

public class HexBinaryValue
extends AtomicValue
implements Comparable,
AtomicMatchKey {
    private byte[] a;

    public HexBinaryValue(CharSequence charSequence) {
        charSequence = Whitespace.trimWhitespace(charSequence);
        if ((charSequence.length() & 1) != 0) {
            XPathException xPathException = new XPathException("A hexBinary value must contain an even number of characters");
            xPathException.setErrorCode("FORG0001");
            throw xPathException;
        }
        this.a = new byte[charSequence.length() / 2];
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            this.a[i2] = (byte)((HexBinaryValue.a(charSequence.charAt(2 * i2)) << 4) + HexBinaryValue.a(charSequence.charAt(2 * i2 + 1)));
        }
        this.typeLabel = BuiltInAtomicType.HEX_BINARY;
    }

    public HexBinaryValue(CharSequence charSequence, AtomicType atomicType) {
        if ((charSequence.length() & 1) != 0) {
            throw new IllegalArgumentException("A hexBinary value must contain an even number of characters");
        }
        this.a = new byte[charSequence.length() / 2];
        try {
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                this.a[i2] = (byte)((HexBinaryValue.a(charSequence.charAt(2 * i2)) << 4) + HexBinaryValue.a(charSequence.charAt(2 * i2 + 1)));
            }
        }
        catch (XPathException xPathException) {
            throw new IllegalArgumentException(xPathException.getMessage());
        }
        this.typeLabel = atomicType;
    }

    public HexBinaryValue(byte[] byArray) {
        this.a = byArray;
        this.typeLabel = BuiltInAtomicType.HEX_BINARY;
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType atomicType) {
        HexBinaryValue hexBinaryValue = new HexBinaryValue(this.a);
        new HexBinaryValue(this.a).typeLabel = atomicType;
        return hexBinaryValue;
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.HEX_BINARY;
    }

    public byte[] getBinaryValue() {
        return this.a;
    }

    private static int a(char c2) {
        int n2 = "0123456789ABCDEFabcdef".indexOf(c2);
        if (n2 > 15) {
            n2 -= 6;
        }
        if (n2 < 0) {
            XPathException xPathException = new XPathException("Invalid hexadecimal digit '" + c2 + "'");
            xPathException.setErrorCode("FORG0001");
            throw xPathException;
        }
        return n2;
    }

    @Override
    public CharSequence getPrimitiveStringValue() {
        String string = "0123456789ABCDEF";
        FastStringBuffer fastStringBuffer = new FastStringBuffer(this.a.length << 1);
        byte[] byArray = this.a;
        int n2 = this.a.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            byte by = byArray[i2];
            fastStringBuffer.append(string.charAt(by >> 4 & 0xF));
            fastStringBuffer.append(string.charAt(by & 0xF));
        }
        return fastStringBuffer;
    }

    public int getLengthInOctets() {
        return this.a.length;
    }

    @Override
    public Comparable<a> getSchemaComparable() {
        return new a(this, 0);
    }

    @Override
    public AtomicMatchKey getXPathComparable(boolean bl2, StringCollator stringCollator, int n2) {
        return this;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof HexBinaryValue && Arrays.equals(this.a, ((HexBinaryValue)object).a);
    }

    public int hashCode() {
        return Base64BinaryValue.byteArrayHashCode(this.a);
    }

    public int compareTo(Object object) {
        object = ((HexBinaryValue)object).a;
        int n2 = this.a.length;
        int n3 = ((Object)object).length;
        int n4 = Math.min(n2, n3);
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = this.a[i2] & 0xFF;
            int n6 = object[i2] & 0xFF;
            if (n5 == n6) continue;
            if (n5 < n6) {
                return -1;
            }
            return 1;
        }
        return Integer.signum(n2 - n3);
    }

    private final class a
    implements Comparable<a> {
        private /* synthetic */ HexBinaryValue a;

        private a(HexBinaryValue hexBinaryValue) {
            this.a = hexBinaryValue;
        }

        private int a(a a2) {
            a a3;
            a a4 = this;
            a4 = a2;
            if (Arrays.equals(a3.a.a, a4.a.a)) {
                return 0;
            }
            return Integer.MIN_VALUE;
        }

        public final boolean equals(Object object) {
            return object instanceof a && this.a((a)object) == 0;
        }

        public final int hashCode() {
            return this.a.hashCode();
        }

        @Override
        public final /* synthetic */ int compareTo(Object object) {
            return this.a((a)object);
        }

        /* synthetic */ a(HexBinaryValue hexBinaryValue, byte by) {
            this(hexBinaryValue);
        }
    }
}

