/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.sf.saxon.expr.Calculator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;

public final class Int64Value
extends IntegerValue {
    public static final Int64Value MINUS_ONE = new Int64Value(-1L);
    public static final Int64Value ZERO = new Int64Value(0L);
    public static final Int64Value PLUS_ONE = new Int64Value(1L);
    public static final Int64Value MAX_LONG = new Int64Value(Long.MAX_VALUE);
    public static final Int64Value MIN_LONG = new Int64Value(Long.MIN_VALUE);
    private long a;
    private static final Int64Value[] b = new Int64Value[]{new Int64Value(0L), new Int64Value(1L), new Int64Value(2L), new Int64Value(3L), new Int64Value(4L), new Int64Value(5L), new Int64Value(6L), new Int64Value(7L), new Int64Value(8L), new Int64Value(9L), new Int64Value(10L), new Int64Value(11L), new Int64Value(12L), new Int64Value(13L), new Int64Value(14L), new Int64Value(15L), new Int64Value(16L), new Int64Value(17L), new Int64Value(18L), new Int64Value(19L), new Int64Value(20L)};

    public Int64Value(long l2) {
        this.a = l2;
        this.typeLabel = BuiltInAtomicType.INTEGER;
    }

    public Int64Value(long l2, BuiltInAtomicType builtInAtomicType, boolean bl2) {
        this.a = l2;
        this.typeLabel = builtInAtomicType;
        if (bl2 && !Int64Value.checkRange(this.a, builtInAtomicType)) {
            XPathException xPathException = new XPathException("Integer value " + l2 + " is out of range for the requested type " + builtInAtomicType.getDescription());
            xPathException.setErrorCode("XPTY0004");
            xPathException.setIsTypeError(true);
            throw xPathException;
        }
    }

    public static Int64Value makeIntegerValue(long l2) {
        if (l2 <= 20L && l2 >= 0L) {
            return b[(int)l2];
        }
        return new Int64Value(l2);
    }

    public static Int64Value makeDerived(long l2, AtomicType atomicType) {
        Int64Value int64Value = new Int64Value(l2);
        new Int64Value(l2).typeLabel = atomicType;
        return int64Value;
    }

    public static Int64Value signum(long l2) {
        if (l2 == 0L) {
            return ZERO;
        }
        if (l2 < 0L) {
            return MINUS_ONE;
        }
        return PLUS_ONE;
    }

    @Override
    public final int asSubscript() {
        if (this.a > 0L && this.a <= Integer.MAX_VALUE) {
            return (int)this.a;
        }
        return -1;
    }

    @Override
    public final AtomicValue copyAsSubType(AtomicType atomicType) {
        if (atomicType.getPrimitiveType() == 533) {
            Int64Value int64Value = new Int64Value(this.a);
            new Int64Value(this.a).typeLabel = atomicType;
            return int64Value;
        }
        return new BigDecimalValue(this.a);
    }

    @Override
    public final ValidationFailure convertToSubType(BuiltInAtomicType object, boolean bl2) {
        if (!bl2) {
            this.setSubType((AtomicType)object);
            return null;
        }
        if (this.checkRange((BuiltInAtomicType)object)) {
            return null;
        }
        object = new ValidationFailure("String " + this.a + " cannot be converted to integer subtype " + ((BuiltInAtomicType)object).getDescription());
        ((ValidationFailure)object).setErrorCode("FORG0001");
        return object;
    }

    @Override
    public final ValidationFailure validateAgainstSubType(BuiltInAtomicType object) {
        if (Int64Value.checkRange(this.a, (BuiltInAtomicType)object)) {
            return null;
        }
        object = new ValidationFailure("Value " + this.a + " cannot be converted to integer subtype " + ((BuiltInAtomicType)object).getDescription());
        ((ValidationFailure)object).setErrorCode("FORG0001");
        return object;
    }

    public final void setSubType(AtomicType atomicType) {
        this.typeLabel = atomicType;
    }

    public final boolean checkRange(BuiltInAtomicType builtInAtomicType) {
        this.typeLabel = builtInAtomicType;
        return Int64Value.checkRange(this.a, builtInAtomicType);
    }

    @Override
    public final Comparable getSchemaComparable() {
        return new Int64Comparable(this);
    }

    @Override
    public final int hashCode() {
        if (this.a > Integer.MIN_VALUE && this.a < Integer.MAX_VALUE) {
            return (int)this.a;
        }
        return Double.valueOf(((NumericValue)this).getDoubleValue()).hashCode();
    }

    @Override
    public final long longValue() {
        return this.a;
    }

    @Override
    public final boolean effectiveBooleanValue() {
        return this.a != 0L;
    }

    @Override
    public final int compareTo(NumericValue numericValue) {
        if (numericValue instanceof Int64Value) {
            return Long.compare(this.a, ((Int64Value)numericValue).a);
        }
        if (numericValue instanceof BigIntegerValue) {
            return BigInteger.valueOf(this.a).compareTo(((IntegerValue)((BigIntegerValue)numericValue)).asBigInteger());
        }
        if (numericValue instanceof BigDecimalValue) {
            return new BigDecimal(this.a).compareTo(((NumericValue)((BigDecimalValue)numericValue)).getDecimalValue());
        }
        return super.compareTo(numericValue);
    }

    @Override
    public final int compareTo(long l2) {
        if (this.a == l2) {
            return 0;
        }
        if (this.a < l2) {
            return -1;
        }
        return 1;
    }

    @Override
    public final String getPrimitiveStringValue() {
        return Long.toString(this.a);
    }

    @Override
    public final double getDoubleValue() {
        return this.a;
    }

    @Override
    public final float getFloatValue() {
        return this.a;
    }

    @Override
    public final BigDecimal getDecimalValue() {
        return BigDecimal.valueOf(this.a);
    }

    @Override
    public final NumericValue negate() {
        if (this.a == Long.MIN_VALUE) {
            return BigIntegerValue.makeIntegerValue(BigInteger.valueOf(this.a)).negate();
        }
        return new Int64Value(-this.a);
    }

    @Override
    public final NumericValue floor() {
        return this;
    }

    @Override
    public final NumericValue ceiling() {
        return this;
    }

    @Override
    public final NumericValue round(int n2) {
        long l2;
        if (n2 >= 0 || this.a == 0L) {
            return this;
        }
        if (n2 < -15) {
            return ((NumericValue)new BigIntegerValue(this.a)).round(n2);
        }
        long l3 = Math.abs(this.a);
        long l4 = 1L;
        for (l2 = 1L; l2 <= (long)(-n2); ++l2) {
            l4 *= 10L;
        }
        l2 = l3 % l4;
        long l5 = l3 - l2;
        long l6 = l2 << 1;
        if (this.a > 0L) {
            if (l6 >= l4) {
                l5 += l4;
            }
        } else {
            if (l6 > l4) {
                l5 += l4;
            }
            l5 = -l5;
        }
        return new Int64Value(l5);
    }

    @Override
    public final NumericValue roundHalfToEven(int n2) {
        long l2;
        if (n2 >= 0) {
            return this;
        }
        if (n2 < -15) {
            return ((NumericValue)new BigIntegerValue(this.a)).roundHalfToEven(n2);
        }
        long l3 = Math.abs(this.a);
        long l4 = 1L;
        for (l2 = 1L; l2 <= (long)(-n2); ++l2) {
            l4 *= 10L;
        }
        l2 = l3 % l4;
        long l5 = l3 - l2;
        long l6 = l2 << 1;
        if (l6 > l4 || l6 >= l4 && l5 % (2L * l4) != 0L) {
            l5 += l4;
        }
        if (this.a < 0L) {
            l5 = -l5;
        }
        return new Int64Value(l5);
    }

    @Override
    public final int signum() {
        if (this.a > 0L) {
            return 1;
        }
        if (this.a == 0L) {
            return 0;
        }
        return -1;
    }

    @Override
    public final NumericValue abs() {
        if (this.a > 0L) {
            return this;
        }
        if (this.a == Long.MIN_VALUE) {
            return new BigIntegerValue(new BigInteger("9223372036854775808"));
        }
        return Int64Value.makeIntegerValue(-this.a);
    }

    @Override
    public final IntegerValue plus(IntegerValue integerValue) {
        if (integerValue instanceof Int64Value) {
            long l2 = this.a >> 60 & 0xFL;
            if (l2 != 0L && l2 != 15L) {
                return ((IntegerValue)new BigIntegerValue(this.a)).plus(new BigIntegerValue(((Int64Value)integerValue).a));
            }
            long l3 = ((Int64Value)integerValue).a >> 60 & 0xFL;
            if (l3 != 0L && l3 != 15L) {
                return ((IntegerValue)new BigIntegerValue(this.a)).plus(new BigIntegerValue(((Int64Value)integerValue).a));
            }
            return Int64Value.makeIntegerValue(this.a + ((Int64Value)integerValue).a);
        }
        return ((IntegerValue)new BigIntegerValue(this.a)).plus(integerValue);
    }

    @Override
    public final IntegerValue minus(IntegerValue integerValue) {
        if (integerValue instanceof Int64Value) {
            long l2 = this.a >> 60 & 0xFL;
            if (l2 != 0L && l2 != 15L) {
                return ((IntegerValue)new BigIntegerValue(this.a)).minus(new BigIntegerValue(((Int64Value)integerValue).a));
            }
            long l3 = ((Int64Value)integerValue).a >> 60 & 0xFL;
            if (l3 != 0L && l3 != 15L) {
                return ((IntegerValue)new BigIntegerValue(this.a)).minus(new BigIntegerValue(((Int64Value)integerValue).a));
            }
            return Int64Value.makeIntegerValue(this.a - ((Int64Value)integerValue).a);
        }
        return ((IntegerValue)new BigIntegerValue(this.a)).minus(integerValue);
    }

    @Override
    public final IntegerValue times(IntegerValue integerValue) {
        if (integerValue instanceof Int64Value) {
            if (this.a() || ((Int64Value)integerValue).a()) {
                return ((IntegerValue)new BigIntegerValue(this.a)).times(new BigIntegerValue(((Int64Value)integerValue).a));
            }
            return Int64Value.makeIntegerValue(this.a * ((Int64Value)integerValue).a);
        }
        return ((IntegerValue)new BigIntegerValue(this.a)).times(integerValue);
    }

    @Override
    public final NumericValue div(IntegerValue integerValue) {
        if (integerValue instanceof Int64Value) {
            long l2 = ((Int64Value)integerValue).a;
            if (l2 == 0L) {
                throw new XPathException("Integer division by zero", "FOAR0001");
            }
            if (this.a() || ((Int64Value)integerValue).a()) {
                return ((IntegerValue)new BigIntegerValue(this.a)).div(new BigIntegerValue(l2));
            }
            if (this.a % l2 == 0L) {
                return Int64Value.makeIntegerValue(this.a / l2);
            }
            return Calculator.decimalDivide(new BigDecimalValue(this.a), new BigDecimalValue(l2));
        }
        return ((IntegerValue)new BigIntegerValue(this.a)).div(integerValue);
    }

    @Override
    public final IntegerValue mod(IntegerValue integerValue) {
        if (integerValue instanceof Int64Value) {
            long l2 = ((Int64Value)integerValue).a;
            if (l2 == 0L) {
                throw new XPathException("Integer modulo zero", "FOAR0001");
            }
            if (this.a() || ((Int64Value)integerValue).a()) {
                return ((IntegerValue)new BigIntegerValue(this.a)).mod(new BigIntegerValue(((Int64Value)integerValue).a));
            }
            return Int64Value.makeIntegerValue(this.a % l2);
        }
        return ((IntegerValue)new BigIntegerValue(this.a)).mod(integerValue);
    }

    @Override
    public final IntegerValue idiv(IntegerValue integerValue) {
        if (integerValue instanceof Int64Value) {
            if (this.a() || ((Int64Value)integerValue).a()) {
                return ((IntegerValue)new BigIntegerValue(this.a)).idiv(new BigIntegerValue(((Int64Value)integerValue).a));
            }
            try {
                return Int64Value.makeIntegerValue(this.a / ((Int64Value)integerValue).a);
            }
            catch (ArithmeticException arithmeticException) {
                XPathException xPathException = "/ by zero".equals(arithmeticException.getMessage()) ? new XPathException("Integer division by zero", "FOAR0001") : new XPathException("Integer division failure", arithmeticException);
                throw xPathException;
            }
        }
        return ((IntegerValue)new BigIntegerValue(this.a)).idiv(integerValue);
    }

    private boolean a() {
        long l2 = this.a >> 31;
        return l2 != 0L && l2 != 0x1FFFFFFFFL;
    }

    @Override
    public final BigInteger asBigInteger() {
        return BigInteger.valueOf(this.a);
    }

    protected static class Int64Comparable
    implements Comparable {
        protected Int64Value value;

        public Int64Comparable(Int64Value int64Value) {
            this.value = int64Value;
        }

        public long asLong() {
            return ((NumericValue)this.value).longValue();
        }

        public int compareTo(Object object) {
            if (object instanceof Int64Comparable) {
                long l2;
                long l3 = ((NumericValue)this.value).longValue();
                if (l3 <= (l2 = ((NumericValue)((Int64Comparable)object).value).longValue())) {
                    if (l3 == l2) {
                        return 0;
                    }
                    return -1;
                }
                return 1;
            }
            if (object instanceof BigIntegerValue.BigIntegerComparable) {
                return ((IntegerValue)this.value).asBigInteger().compareTo(((BigIntegerValue.BigIntegerComparable)object).asBigInteger());
            }
            if (object instanceof BigDecimalValue.DecimalComparable) {
                return ((NumericValue)this.value).getDecimalValue().compareTo(((BigDecimalValue.DecimalComparable)object).asBigDecimal());
            }
            return Integer.MIN_VALUE;
        }

        public boolean equals(Object object) {
            if (object instanceof Int64Comparable) {
                return this.asLong() == ((Int64Comparable)object).asLong();
            }
            return this.compareTo(object) == 0;
        }

        public int hashCode() {
            return (int)this.asLong();
        }
    }
}

