/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.Iterator;
import net.sf.saxon.expr.RangeIterator;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.AtomicArray;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;

public class IntegerRange
implements AtomicSequence {
    public long start;
    public long end;

    public IntegerRange(long l2, long l3) {
        if (l3 < l2) {
            throw new IllegalArgumentException("end < start in IntegerRange");
        }
        if (l3 - l2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Maximum length of sequence in Saxon is 2147483647");
        }
        this.start = l2;
        this.end = l3;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    @Override
    public AtomicIterator iterate() {
        return new RangeIterator(this.start, this.end);
    }

    @Override
    public IntegerValue itemAt(int n2) {
        if (n2 < 0 || (long)n2 > this.end - this.start) {
            return null;
        }
        return Int64Value.makeIntegerValue(this.start + (long)n2);
    }

    @Override
    public GroundedValue subsequence(int n2, int n3) {
        if (n3 <= 0) {
            return EmptySequence.getInstance();
        }
        long l2 = this.start + (long)(n2 > 0 ? n2 : 0);
        long l3 = l2 + (long)n3 - 1L;
        if (l3 > this.end) {
            l3 = this.end;
        }
        if (l3 >= l2) {
            return new IntegerRange(l2, l3);
        }
        return EmptySequence.getInstance();
    }

    @Override
    public int getLength() {
        return (int)(this.end - this.start + 1L);
    }

    @Override
    public IntegerValue head() {
        return new Int64Value(this.start);
    }

    @Override
    public CharSequence getCanonicalLexicalRepresentation() {
        return this.getStringValueCS();
    }

    @Override
    public Comparable getSchemaComparable() {
        try {
            return new AtomicArray(this.iterate()).getSchemaComparable();
        }
        catch (XPathException xPathException) {
            throw new AssertionError((Object)xPathException);
        }
    }

    @Override
    public CharSequence getStringValueCS() {
        try {
            return SequenceTool.getStringValue(this);
        }
        catch (XPathException xPathException) {
            throw new AssertionError((Object)xPathException);
        }
    }

    @Override
    public String getStringValue() {
        return this.getStringValueCS().toString();
    }

    @Override
    public boolean effectiveBooleanValue() {
        return ExpressionTool.effectiveBooleanValue(this.iterate());
    }

    @Override
    public GroundedValue reduce() {
        if (this.start == this.end) {
            return this.itemAt(0);
        }
        return this;
    }

    public String toString() {
        return "(" + this.start + " to " + this.end + ")";
    }

    @Override
    public Iterator<AtomicValue> iterator() {
        return new Iterator<AtomicValue>(this){
            private long a;
            private /* synthetic */ IntegerRange b;
            {
                this.b = integerRange;
                this.a = this.b.start;
            }

            @Override
            public final boolean hasNext() {
                return this.a <= this.b.end;
            }

            @Override
            public final void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public final /* synthetic */ Object next() {
                1 var1_1 = this;
                return new Int64Value(var1_1.a++);
            }
        };
    }
}

